/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.math.IntMath;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.SystemUtils;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeArray;
import net.minecraft.world.phys.shapes.VoxelShapeBitSet;
import net.minecraft.world.phys.shapes.VoxelShapeCubeMerger;
import net.minecraft.world.phys.shapes.VoxelShapeCubePoint;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;
import net.minecraft.world.phys.shapes.VoxelShapeMerger;
import net.minecraft.world.phys.shapes.VoxelShapeMergerDisjoint;
import net.minecraft.world.phys.shapes.VoxelShapeMergerIdentical;
import net.minecraft.world.phys.shapes.VoxelShapeMergerList;

public final class VoxelShapes {
    public static final double a = 1.0E-7;
    public static final double b = 1.0E-6;
    private static final VoxelShape d = SystemUtils.a(() -> {
        VoxelShapeBitSet shape = new VoxelShapeBitSet(1, 1, 1);
        ((VoxelShapeDiscrete)shape).c(0, 0, 0);
        return new VoxelShapeArray((VoxelShapeDiscrete)shape, (DoubleList)CollisionUtil.ZERO_ONE, (DoubleList)CollisionUtil.ZERO_ONE, (DoubleList)CollisionUtil.ZERO_ONE);
    });
    public static final VoxelShape c = VoxelShapes.a(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private static final VoxelShape e = new VoxelShapeArray((VoxelShapeDiscrete)new VoxelShapeBitSet(0, 0, 0), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}));
    private static final DoubleArrayList[] PARTS_BY_BITS = new DoubleArrayList[]{DoubleArrayList.wrap((double[])VoxelShapes.generateCubeParts(1)), DoubleArrayList.wrap((double[])VoxelShapes.generateCubeParts(2)), DoubleArrayList.wrap((double[])VoxelShapes.generateCubeParts(4)), DoubleArrayList.wrap((double[])VoxelShapes.generateCubeParts(8))};

    public static VoxelShape a() {
        return e;
    }

    public static VoxelShape b() {
        return d;
    }

    private static double[] generateCubeParts(int parts) {
        double inc = 1.0 / (double)parts;
        double[] ret = new double[parts + 1];
        double val = 0.0;
        for (int i2 = 0; i2 <= parts; ++i2) {
            ret[i2] = val;
            val += inc;
        }
        return ret;
    }

    public static VoxelShape a(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (!(minX > maxX || minY > maxY || minZ > maxZ)) {
            return VoxelShapes.b(minX, minY, minZ, maxX, maxY, maxZ);
        }
        throw new IllegalArgumentException("The min values need to be smaller or equals to the max values");
    }

    public static VoxelShape b(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (!(maxX - minX < 1.0E-7 || maxY - minY < 1.0E-7 || maxZ - minZ < 1.0E-7)) {
            int bitsX = VoxelShapes.a(minX, maxX);
            int bitsY = VoxelShapes.a(minY, maxY);
            int bitsZ = VoxelShapes.a(minZ, maxZ);
            if (bitsX >= 0 && bitsY >= 0 && bitsZ >= 0) {
                if (bitsX == 0 && bitsY == 0 && bitsZ == 0) {
                    return d;
                }
                int sizeX = 1 << bitsX;
                int sizeY = 1 << bitsY;
                int sizeZ = 1 << bitsZ;
                VoxelShapeBitSet shape = VoxelShapeBitSet.a(sizeX, sizeY, sizeZ, (int)Math.round(minX * (double)sizeX), (int)Math.round(minY * (double)sizeY), (int)Math.round(minZ * (double)sizeZ), (int)Math.round(maxX * (double)sizeX), (int)Math.round(maxY * (double)sizeY), (int)Math.round(maxZ * (double)sizeZ));
                return new VoxelShapeArray((VoxelShapeDiscrete)shape, (DoubleList)PARTS_BY_BITS[bitsX], (DoubleList)PARTS_BY_BITS[bitsY], (DoubleList)PARTS_BY_BITS[bitsZ]);
            }
            return new VoxelShapeArray(VoxelShapes.d.a, (DoubleList)(minX == 0.0 && maxX == 1.0 ? CollisionUtil.ZERO_ONE : DoubleArrayList.wrap((double[])new double[]{minX, maxX})), (DoubleList)(minY == 0.0 && maxY == 1.0 ? CollisionUtil.ZERO_ONE : DoubleArrayList.wrap((double[])new double[]{minY, maxY})), (DoubleList)(minZ == 0.0 && maxZ == 1.0 ? CollisionUtil.ZERO_ONE : DoubleArrayList.wrap((double[])new double[]{minZ, maxZ})));
        }
        return e;
    }

    public static VoxelShape a(AxisAlignedBB aabb) {
        return VoxelShapes.b(aabb.a, aabb.b, aabb.c, aabb.d, aabb.e, aabb.f);
    }

    @VisibleForTesting
    protected static int a(double minBits, double maxBits) {
        if (!(minBits < -1.0E-7) && !(maxBits > 1.0000001)) {
            for (int i2 = 0; i2 <= 3; ++i2) {
                boolean flag1;
                int i1 = 1 << i2;
                double d2 = minBits * (double)i1;
                double d1 = maxBits * (double)i1;
                boolean flag = Math.abs(d2 - (double)Math.round(d2)) < 1.0E-7 * (double)i1;
                boolean bl = flag1 = Math.abs(d1 - (double)Math.round(d1)) < 1.0E-7 * (double)i1;
                if (!flag || !flag1) continue;
                return i2;
            }
            return -1;
        }
        return -1;
    }

    protected static long a(int aa2, int bb) {
        return (long)aa2 * (long)(bb / IntMath.gcd((int)aa2, (int)bb));
    }

    public static VoxelShape a(VoxelShape shape1, VoxelShape shape2) {
        return VoxelShapes.a(shape1, shape2, OperatorBoolean.o);
    }

    public static VoxelShape a(VoxelShape shape1, VoxelShape ... others) {
        int size = others.length;
        if (size == 0) {
            return shape1;
        }
        VoxelShape[] tmp = Arrays.copyOf(others, ++size);
        tmp[size - 1] = shape1;
        while (size > 1) {
            int newSize = 0;
            for (int i2 = 0; i2 < size; i2 += 2) {
                int next = i2 + 1;
                if (next >= size) {
                    tmp[newSize++] = tmp[i2];
                    break;
                }
                VoxelShape first = tmp[i2];
                VoxelShape second = tmp[next];
                tmp[newSize++] = VoxelShapes.b(first, second, OperatorBoolean.o);
            }
            size = newSize;
        }
        return tmp[0].d();
    }

    public static VoxelShape a(VoxelShape shape1, VoxelShape shape2, OperatorBoolean function) {
        return CollisionUtil.joinOptimized(shape1, shape2, function);
    }

    public static VoxelShape b(VoxelShape shape1, VoxelShape shape2, OperatorBoolean function) {
        return CollisionUtil.joinUnoptimized(shape1, shape2, function);
    }

    public static boolean c(VoxelShape shape1, VoxelShape shape2, OperatorBoolean resultOperator) {
        return CollisionUtil.isJoinNonEmpty(shape1, shape2, resultOperator);
    }

    private static boolean a(VoxelShapeMerger mergerX, VoxelShapeMerger mergerY, VoxelShapeMerger mergerZ, VoxelShapeDiscrete primaryShape, VoxelShapeDiscrete secondaryShape, OperatorBoolean resultOperator) {
        return !mergerX.a((x1, y1, z1) -> mergerY.a((x2, y2, z2) -> mergerZ.a((x3, y3, z3) -> !resultOperator.apply(primaryShape.e(x1, x2, x3), secondaryShape.e(y1, y2, y3)))));
    }

    public static double a(EnumDirection.EnumAxis movementAxis, AxisAlignedBB collisionBox, Iterable<VoxelShape> possibleHits, double desiredOffset) {
        for (VoxelShape voxelShape : possibleHits) {
            if (Math.abs(desiredOffset) < 1.0E-7) {
                return 0.0;
            }
            desiredOffset = voxelShape.a(movementAxis, collisionBox, desiredOffset);
        }
        return desiredOffset;
    }

    public static boolean a(VoxelShape first, VoxelShape second, EnumDirection direction) {
        boolean secondBlock;
        boolean firstBlock = first == d;
        boolean bl = secondBlock = second == d;
        if (firstBlock & secondBlock) {
            return true;
        }
        if (first.c() | second.c()) {
            return false;
        }
        VoxelShape newFirst = first.moonrise$getFaceShapeClamped(direction);
        if (newFirst.c()) {
            return false;
        }
        VoxelShape newSecond = second.moonrise$getFaceShapeClamped(direction.g());
        if (newSecond.c()) {
            return false;
        }
        return !VoxelShapes.c(newFirst, newSecond, OperatorBoolean.e);
    }

    private static boolean mergedMayOccludeBlock(VoxelShape shape1, VoxelShape shape2) {
        AxisAlignedBB bounds1 = shape1.a();
        AxisAlignedBB bounds2 = shape2.a();
        double minX = Math.min(bounds1.a, bounds2.a);
        double minY = Math.min(bounds1.b, bounds2.b);
        double minZ = Math.min(bounds1.c, bounds2.c);
        double maxX = Math.max(bounds1.d, bounds2.d);
        double maxY = Math.max(bounds1.e, bounds2.e);
        double maxZ = Math.max(bounds1.f, bounds2.f);
        return minX <= 1.0E-7 && maxX >= 0.9999999 && minY <= 1.0E-7 && maxY >= 0.9999999 && minZ <= 1.0E-7 && maxZ >= 0.9999999;
    }

    public static boolean b(VoxelShape first, VoxelShape second, EnumDirection direction) {
        boolean secondEmpty;
        if (first.moonrise$occludesFullBlockIfCached() || second.moonrise$occludesFullBlockIfCached()) {
            return true;
        }
        if (first.c() & second.c()) {
            return false;
        }
        VoxelShape newFirst = first.moonrise$getFaceShapeClamped(direction);
        VoxelShape newSecond = second.moonrise$getFaceShapeClamped(direction.g());
        if (newFirst.moonrise$occludesFullBlockIfCached() || newSecond.moonrise$occludesFullBlockIfCached()) {
            return true;
        }
        boolean firstEmpty = newFirst.c();
        if (firstEmpty & (secondEmpty = newSecond.c())) {
            return false;
        }
        if (firstEmpty | secondEmpty) {
            return secondEmpty ? newFirst.moonrise$occludesFullBlock() : newSecond.moonrise$occludesFullBlock();
        }
        if (newFirst == newSecond) {
            return newFirst.moonrise$occludesFullBlock();
        }
        return VoxelShapes.mergedMayOccludeBlock(newFirst, newSecond) && newFirst.moonrise$orUnoptimized(newSecond).moonrise$occludesFullBlock();
    }

    public static boolean b(VoxelShape shape1, VoxelShape shape2) {
        boolean s2Empty;
        if (shape1.moonrise$occludesFullBlockIfCached() || shape2.moonrise$occludesFullBlockIfCached()) {
            return true;
        }
        boolean s1Empty = shape1.c();
        if (s1Empty & (s2Empty = shape2.c())) {
            return false;
        }
        if (s1Empty | s2Empty) {
            return s2Empty ? shape1.moonrise$occludesFullBlock() : shape2.moonrise$occludesFullBlock();
        }
        if (shape1 == shape2) {
            return shape1.moonrise$occludesFullBlock();
        }
        return VoxelShapes.mergedMayOccludeBlock(shape1, shape2) && shape1.moonrise$orUnoptimized(shape2).moonrise$occludesFullBlock();
    }

    @VisibleForTesting
    private static VoxelShapeMerger a(int size, DoubleList list1, DoubleList list2, boolean excludeUpper, boolean excludeLower) {
        if (list1.getDouble(0) == Double.NEGATIVE_INFINITY && list1.getDouble(list1.size() - 1) == Double.POSITIVE_INFINITY) {
            return new VoxelShapeMergerList(list1, list2, excludeUpper, excludeLower);
        }
        return VoxelShapes.lessCommonMerge(size, list1, list2, excludeUpper, excludeLower);
    }

    private static VoxelShapeMerger lessCommonMerge(int size, DoubleList list1, DoubleList list2, boolean excludeUpper, boolean excludeLower) {
        long l2;
        int i2 = list1.size() - 1;
        int i1 = list2.size() - 1;
        if (list1 instanceof VoxelShapeCubePoint && list2 instanceof VoxelShapeCubePoint && (long)size * (l2 = VoxelShapes.a(i2, i1)) <= 256L) {
            return new VoxelShapeCubeMerger(i2, i1);
        }
        if (i2 == i1 && Objects.equals(list1, list2)) {
            if (list1 instanceof VoxelShapeMergerIdentical) {
                return (VoxelShapeMerger)list1;
            }
            if (list2 instanceof VoxelShapeMergerIdentical) {
                return (VoxelShapeMerger)list2;
            }
            return new VoxelShapeMergerIdentical(list1);
        }
        if (list1.getDouble(i2) < list2.getDouble(0) - 1.0E-7) {
            return new VoxelShapeMergerDisjoint(list1, list2, false);
        }
        if (list2.getDouble(i1) < list1.getDouble(0) - 1.0E-7) {
            return new VoxelShapeMergerDisjoint(list2, list1, true);
        }
        return new VoxelShapeMergerList(list1, list2, excludeUpper, excludeLower);
    }

    public static interface a {
        public void consume(double var1, double var3, double var5, double var7, double var9, double var11);
    }
}

