/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import ca.spottedleaf.moonrise.common.util.FlatBitsetUtil;
import ca.spottedleaf.moonrise.common.util.MixinWorkarounds;
import ca.spottedleaf.moonrise.patches.collisions.shape.CachedShapeData;
import java.util.BitSet;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;
import net.minecraft.world.phys.shapes.VoxelShapeMerger;

public final class VoxelShapeBitSet
extends VoxelShapeDiscrete {
    public final BitSet d;
    public int e;
    public int f;
    public int g;
    public int h;
    public int i;
    public int j;

    public VoxelShapeBitSet(int xSize, int ySize, int zSize) {
        super(xSize, ySize, zSize);
        this.d = new BitSet(xSize * ySize * zSize);
        this.e = xSize;
        this.f = ySize;
        this.g = zSize;
    }

    public static VoxelShapeBitSet a(int x2, int y2, int z2, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
        VoxelShapeBitSet bitSetDiscreteVoxelShape = new VoxelShapeBitSet(x2, y2, z2);
        bitSetDiscreteVoxelShape.e = xMin;
        bitSetDiscreteVoxelShape.f = yMin;
        bitSetDiscreteVoxelShape.g = zMin;
        bitSetDiscreteVoxelShape.h = xMax;
        bitSetDiscreteVoxelShape.i = yMax;
        bitSetDiscreteVoxelShape.j = zMax;
        for (int i2 = xMin; i2 < xMax; ++i2) {
            for (int i1 = yMin; i1 < yMax; ++i1) {
                for (int i22 = zMin; i22 < zMax; ++i22) {
                    bitSetDiscreteVoxelShape.a(i2, i1, i22, false);
                }
            }
        }
        return bitSetDiscreteVoxelShape;
    }

    public VoxelShapeBitSet(VoxelShapeDiscrete shape) {
        super(shape.a, shape.b, shape.c);
        if (shape instanceof VoxelShapeBitSet) {
            this.d = (BitSet)((VoxelShapeBitSet)shape).d.clone();
        } else {
            this.d = new BitSet(this.a * this.b * this.c);
            for (int i2 = 0; i2 < this.a; ++i2) {
                for (int i1 = 0; i1 < this.b; ++i1) {
                    for (int i22 = 0; i22 < this.c; ++i22) {
                        if (!shape.b(i2, i1, i22)) continue;
                        this.d.set(this.a(i2, i1, i22));
                    }
                }
            }
        }
        this.e = shape.a(EnumDirection.EnumAxis.a);
        this.f = shape.a(EnumDirection.EnumAxis.b);
        this.g = shape.a(EnumDirection.EnumAxis.c);
        this.h = shape.b(EnumDirection.EnumAxis.a);
        this.i = shape.b(EnumDirection.EnumAxis.b);
        this.j = shape.b(EnumDirection.EnumAxis.c);
    }

    protected int a(int x2, int y2, int z2) {
        return (x2 * this.b + y2) * this.c + z2;
    }

    @Override
    public boolean b(int x2, int y2, int z2) {
        return this.d.get(this.a(x2, y2, z2));
    }

    private void a(int x2, int y2, int z2, boolean update) {
        this.d.set(this.a(x2, y2, z2));
        if (update) {
            this.e = Math.min(this.e, x2);
            this.f = Math.min(this.f, y2);
            this.g = Math.min(this.g, z2);
            this.h = Math.max(this.h, x2 + 1);
            this.i = Math.max(this.i, y2 + 1);
            this.j = Math.max(this.j, z2 + 1);
        }
    }

    @Override
    public void c(int x2, int y2, int z2) {
        this.a(x2, y2, z2, true);
    }

    @Override
    public boolean a() {
        return this.d.isEmpty();
    }

    @Override
    public int a(EnumDirection.EnumAxis axis) {
        return axis.a(this.e, this.f, this.g);
    }

    @Override
    public int b(EnumDirection.EnumAxis axis) {
        return axis.a(this.h, this.i, this.j);
    }

    static VoxelShapeBitSet a(VoxelShapeDiscrete mainShape, VoxelShapeDiscrete secondaryShape, VoxelShapeMerger mergerX, VoxelShapeMerger mergerY, VoxelShapeMerger mergerZ, OperatorBoolean operator) {
        VoxelShapeBitSet bitSetDiscreteVoxelShape = new VoxelShapeBitSet(mergerX.size() - 1, mergerY.size() - 1, mergerZ.size() - 1);
        int[] ints = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
        mergerX.a((int x1, int x2, int x3) -> {
            boolean[] flags = new boolean[]{false};
            mergerY.a((int y1, int y2, int y3) -> {
                boolean[] flags1 = new boolean[]{false};
                mergerZ.a((int z1, int z2, int z3) -> {
                    if (operator.apply(mainShape.e(x1, y1, z1), secondaryShape.e(x2, y2, z2))) {
                        bitSetDiscreteVoxelShape.d.set(bitSetDiscreteVoxelShape.a(x3, y3, z3));
                        ints[2] = Math.min(ints[2], z3);
                        ints[5] = Math.max(ints[5], z3);
                        flags1[0] = true;
                    }
                    return true;
                });
                if (flags1[0]) {
                    ints[1] = Math.min(ints[1], y3);
                    ints[4] = Math.max(ints[4], y3);
                    flags[0] = true;
                }
                return true;
            });
            if (flags[0]) {
                ints[0] = Math.min(ints[0], x3);
                ints[3] = Math.max(ints[3], x3);
            }
            return true;
        });
        bitSetDiscreteVoxelShape.e = ints[0];
        bitSetDiscreteVoxelShape.f = ints[1];
        bitSetDiscreteVoxelShape.g = ints[2];
        bitSetDiscreteVoxelShape.h = ints[3] + 1;
        bitSetDiscreteVoxelShape.i = ints[4] + 1;
        bitSetDiscreteVoxelShape.j = ints[5] + 1;
        return bitSetDiscreteVoxelShape;
    }

    public static void a(VoxelShapeDiscrete shape, VoxelShapeDiscrete.b consumer, boolean mergeAdjacent) {
        CachedShapeData cache = shape.moonrise$getOrCreateCachedShapeData();
        int sizeX = cache.sizeX();
        int sizeY = cache.sizeY();
        int sizeZ = cache.sizeZ();
        int indexY = 0;
        int incY = sizeZ;
        int incX = sizeZ * sizeY;
        long[] bitset = cache.voxelSet();
        if (!mergeAdjacent) {
            int y2 = 0;
            while (y2 < sizeY) {
                int indexX = indexY;
                int x2 = 0;
                while (x2 < sizeX) {
                    int indexZ = indexX;
                    int z2 = 0;
                    while (z2 < sizeZ) {
                        if ((bitset[indexZ >>> 6] & 1L << indexZ) != 0L) {
                            consumer.consume(x2, y2, z2, x2 + 1, y2 + 1, z2 + 1);
                        }
                        ++z2;
                        ++indexZ;
                    }
                    ++x2;
                    indexX += incX;
                }
                ++y2;
                indexY += incY;
            }
        } else {
            bitset = MixinWorkarounds.clone(bitset);
            int y3 = 0;
            while (y3 < sizeY) {
                int indexX = indexY;
                int x3 = 0;
                while (x3 < sizeX) {
                    int firstSetZ;
                    int zIdx = indexX;
                    int endIndex = indexX + sizeZ;
                    while (zIdx < endIndex && (firstSetZ = FlatBitsetUtil.firstSet(bitset, zIdx, endIndex)) != -1) {
                        int lastSetZ = FlatBitsetUtil.firstClear(bitset, firstSetZ, endIndex);
                        if (lastSetZ == -1) {
                            lastSetZ = endIndex;
                        }
                        FlatBitsetUtil.clearRange(bitset, firstSetZ, lastSetZ);
                        int endX = x3 + 1;
                        int neighbourIdxStart = firstSetZ + incX;
                        int neighbourIdxEnd = lastSetZ + incX;
                        while (endX < sizeX && FlatBitsetUtil.isRangeSet(bitset, neighbourIdxStart, neighbourIdxEnd)) {
                            ++endX;
                            FlatBitsetUtil.clearRange(bitset, neighbourIdxStart, neighbourIdxEnd);
                            neighbourIdxStart += incX;
                            neighbourIdxEnd += incX;
                        }
                        int endY = y3 + 1;
                        int firstSetZY = firstSetZ + incY;
                        int lastSetZY = lastSetZ + incY;
                        block7: while (endY < sizeY) {
                            int testX = x3;
                            int start = firstSetZY;
                            int end = lastSetZY;
                            while (testX < endX) {
                                if (!FlatBitsetUtil.isRangeSet(bitset, start, end)) break block7;
                                ++testX;
                                start += incX;
                                end += incX;
                            }
                            ++endY;
                            testX = x3;
                            start = firstSetZY;
                            end = lastSetZY;
                            while (testX < endX) {
                                FlatBitsetUtil.clearRange(bitset, start, end);
                                ++testX;
                                start += incX;
                                end += incX;
                            }
                            firstSetZY += incY;
                            lastSetZY += incY;
                        }
                        consumer.consume(x3, y3, firstSetZ - indexX, endX, endY, lastSetZ - indexX);
                        zIdx = lastSetZ;
                    }
                    ++x3;
                    indexX += incX;
                }
                ++y3;
                indexY += incY;
            }
        }
    }

    private boolean a(int zMin, int zMax, int x2, int y2) {
        return x2 < this.a && y2 < this.b && this.d.nextClearBit(this.a(x2, y2, zMin)) >= this.a(x2, y2, zMax);
    }

    private boolean a(int xMin, int xMax, int zMin, int zMax, int y2) {
        for (int i2 = xMin; i2 < xMax; ++i2) {
            if (this.a(zMin, zMax, i2, y2)) continue;
            return false;
        }
        return true;
    }

    private void b(int zMin, int zMax, int x2, int y2) {
        this.d.clear(this.a(x2, y2, zMin), this.a(x2, y2, zMax));
    }

    public boolean d(int x2, int y2, int z2) {
        boolean flag = x2 > 0 && x2 < this.a - 1 && y2 > 0 && y2 < this.b - 1 && z2 > 0 && z2 < this.c - 1;
        return flag && this.b(x2, y2, z2) && this.b(x2 - 1, y2, z2) && this.b(x2 + 1, y2, z2) && this.b(x2, y2 - 1, z2) && this.b(x2, y2 + 1, z2) && this.b(x2, y2, z2 - 1) && this.b(x2, y2, z2 + 1);
    }
}

