/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import ca.spottedleaf.moonrise.common.util.FlatBitsetUtil;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import ca.spottedleaf.moonrise.patches.collisions.shape.CachedShapeData;
import ca.spottedleaf.moonrise.patches.collisions.shape.CachedToAABBs;
import ca.spottedleaf.moonrise.patches.collisions.shape.CollisionVoxelShape;
import ca.spottedleaf.moonrise.patches.collisions.shape.MergedORCache;
import com.google.common.math.DoubleMath;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumAxisCycle;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.DoubleListOffset;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShapeArray;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;
import net.minecraft.world.phys.shapes.VoxelShapes;

public abstract class VoxelShape
implements CollisionVoxelShape {
    public final VoxelShapeDiscrete a;
    @Nullable
    private VoxelShape[] b;
    private double offsetX;
    private double offsetY;
    private double offsetZ;
    private AxisAlignedBB singleAABBRepresentation;
    private double[] rootCoordinatesX;
    private double[] rootCoordinatesY;
    private double[] rootCoordinatesZ;
    private CachedShapeData cachedShapeData;
    private boolean isEmpty;
    private CachedToAABBs cachedToAABBs;
    private AxisAlignedBB cachedBounds;
    private Boolean isFullBlock;
    private Boolean occludesFullBlock;
    private static final int MERGED_CACHE_SIZE = 16;
    private MergedORCache[] mergedORCache;
    private VoxelShape[] faceShapeClampedCache;

    @Override
    public final double moonrise$offsetX() {
        return this.offsetX;
    }

    @Override
    public final double moonrise$offsetY() {
        return this.offsetY;
    }

    @Override
    public final double moonrise$offsetZ() {
        return this.offsetZ;
    }

    @Override
    public final AxisAlignedBB moonrise$getSingleAABBRepresentation() {
        return this.singleAABBRepresentation;
    }

    @Override
    public final double[] moonrise$rootCoordinatesX() {
        return this.rootCoordinatesX;
    }

    @Override
    public final double[] moonrise$rootCoordinatesY() {
        return this.rootCoordinatesY;
    }

    @Override
    public final double[] moonrise$rootCoordinatesZ() {
        return this.rootCoordinatesZ;
    }

    private static double[] extractRawArray(DoubleList list) {
        if (list instanceof DoubleArrayList) {
            int expected;
            DoubleArrayList rawList = (DoubleArrayList)list;
            double[] raw = rawList.elements();
            if (raw.length == (expected = rawList.size())) {
                return raw;
            }
            return Arrays.copyOf(raw, expected);
        }
        return list.toDoubleArray();
    }

    @Override
    public final void moonrise$initCache() {
        DoubleListOffset offsetDoubleList;
        this.cachedShapeData = this.a.moonrise$getOrCreateCachedShapeData();
        this.isEmpty = this.cachedShapeData.isEmpty();
        DoubleList xList = this.a(EnumDirection.EnumAxis.a);
        DoubleList yList = this.a(EnumDirection.EnumAxis.b);
        DoubleList zList = this.a(EnumDirection.EnumAxis.c);
        if (xList instanceof DoubleListOffset) {
            offsetDoubleList = (DoubleListOffset)xList;
            this.offsetX = offsetDoubleList.b;
            this.rootCoordinatesX = VoxelShape.extractRawArray(offsetDoubleList.a);
        } else {
            this.rootCoordinatesX = VoxelShape.extractRawArray(xList);
        }
        if (yList instanceof DoubleListOffset) {
            offsetDoubleList = (DoubleListOffset)yList;
            this.offsetY = offsetDoubleList.b;
            this.rootCoordinatesY = VoxelShape.extractRawArray(offsetDoubleList.a);
        } else {
            this.rootCoordinatesY = VoxelShape.extractRawArray(yList);
        }
        if (zList instanceof DoubleListOffset) {
            offsetDoubleList = (DoubleListOffset)zList;
            this.offsetZ = offsetDoubleList.b;
            this.rootCoordinatesZ = VoxelShape.extractRawArray(offsetDoubleList.a);
        } else {
            this.rootCoordinatesZ = VoxelShape.extractRawArray(zList);
        }
        if (this.cachedShapeData.hasSingleAABB()) {
            this.cachedBounds = this.singleAABBRepresentation = new AxisAlignedBB(this.rootCoordinatesX[0] + this.offsetX, this.rootCoordinatesY[0] + this.offsetY, this.rootCoordinatesZ[0] + this.offsetZ, this.rootCoordinatesX[1] + this.offsetX, this.rootCoordinatesY[1] + this.offsetY, this.rootCoordinatesZ[1] + this.offsetZ);
        }
    }

    @Override
    public final CachedShapeData moonrise$getCachedVoxelData() {
        return this.cachedShapeData;
    }

    @Override
    public final VoxelShape moonrise$getFaceShapeClamped(EnumDirection direction) {
        VoxelShape ret;
        if (this.isEmpty) {
            return this;
        }
        if (this == VoxelShapes.b()) {
            return this;
        }
        VoxelShape[] cache = this.faceShapeClampedCache;
        if (cache != null && (ret = cache[direction.ordinal()]) != null) {
            return ret;
        }
        if (cache == null) {
            this.faceShapeClampedCache = cache = new VoxelShape[6];
        }
        EnumDirection.EnumAxis axis = direction.o();
        VoxelShape ret2 = direction.f() == EnumDirection.EnumAxisDirection.a ? (DoubleMath.fuzzyEquals((double)this.c(axis), (double)1.0, (double)1.0E-7) ? CollisionUtil.sliceShape(this, axis, this.a.c(axis) - 1) : VoxelShapes.a()) : (DoubleMath.fuzzyEquals((double)this.b(axis), (double)0.0, (double)1.0E-7) ? CollisionUtil.sliceShape(this, axis, 0) : VoxelShapes.a());
        cache[direction.ordinal()] = ret2;
        return ret2;
    }

    private boolean computeOccludesFullBlock() {
        if (this.isEmpty) {
            this.occludesFullBlock = Boolean.FALSE;
            return false;
        }
        if (this.moonrise$isFullBlock()) {
            this.occludesFullBlock = Boolean.TRUE;
            return true;
        }
        AxisAlignedBB singleAABB = this.singleAABBRepresentation;
        if (singleAABB != null) {
            boolean ret = singleAABB.b <= 1.0E-7 && singleAABB.e >= 0.9999999 && singleAABB.a <= 1.0E-7 && singleAABB.d >= 0.9999999 && singleAABB.c <= 1.0E-7 && singleAABB.f >= 0.9999999;
            this.occludesFullBlock = ret;
            return ret;
        }
        boolean ret = !VoxelShapes.c(VoxelShapes.b(), this, OperatorBoolean.e);
        this.occludesFullBlock = ret;
        return ret;
    }

    @Override
    public final boolean moonrise$occludesFullBlock() {
        Boolean ret = this.occludesFullBlock;
        if (ret != null) {
            return ret;
        }
        return this.computeOccludesFullBlock();
    }

    @Override
    public final boolean moonrise$occludesFullBlockIfCached() {
        Boolean ret = this.occludesFullBlock;
        return ret != null ? ret : false;
    }

    private static int hash(VoxelShape key) {
        return HashCommon.mix((int)System.identityHashCode(key));
    }

    @Override
    public final VoxelShape moonrise$orUnoptimized(VoxelShape other) {
        MergedORCache otherCache;
        MergedORCache cached;
        if (this == other) {
            return other;
        }
        if (this.isEmpty) {
            return other;
        }
        if (other.c()) {
            return this;
        }
        int thisCacheKey = VoxelShape.hash(other) & 0xF;
        MergedORCache mergedORCache = cached = this.mergedORCache == null ? null : this.mergedORCache[thisCacheKey];
        if (cached != null && cached.key() == other) {
            return cached.result();
        }
        int otherCacheKey = VoxelShape.hash(this) & 0xF;
        MergedORCache mergedORCache2 = otherCache = other.mergedORCache == null ? null : other.mergedORCache[otherCacheKey];
        if (otherCache != null && otherCache.key() == this) {
            return otherCache.result();
        }
        VoxelShape result = VoxelShapes.b(this, other, OperatorBoolean.o);
        if (cached != null && otherCache == null) {
            if (other.mergedORCache == null) {
                other.mergedORCache = new MergedORCache[16];
            }
            other.mergedORCache[otherCacheKey] = new MergedORCache(this, result);
        } else {
            if (this.mergedORCache == null) {
                this.mergedORCache = new MergedORCache[16];
            }
            this.mergedORCache[thisCacheKey] = new MergedORCache(other, result);
        }
        return result;
    }

    private static DoubleList offsetList(double[] src, double by) {
        DoubleArrayList wrap = DoubleArrayList.wrap((double[])src);
        if (by == 0.0) {
            return wrap;
        }
        return new DoubleListOffset((DoubleList)wrap, by);
    }

    private List<AxisAlignedBB> toAabbsUncached() {
        ArrayList<AxisAlignedBB> ret;
        if (this.singleAABBRepresentation != null) {
            ret = new ArrayList(1);
            ret.add(this.singleAABBRepresentation);
        } else {
            ret = new ArrayList<AxisAlignedBB>();
            double[] coordsX = this.rootCoordinatesX;
            double[] coordsY = this.rootCoordinatesY;
            double[] coordsZ = this.rootCoordinatesZ;
            double offX = this.offsetX;
            double offY = this.offsetY;
            double offZ = this.offsetZ;
            this.a.b((minX, minY, minZ, maxX, maxY, maxZ) -> ret.add(new AxisAlignedBB(coordsX[minX] + offX, coordsY[minY] + offY, coordsZ[minZ] + offZ, coordsX[maxX] + offX, coordsY[maxY] + offY, coordsZ[maxZ] + offZ)), true);
        }
        this.cachedToAABBs = new CachedToAABBs(ret, false, 0.0, 0.0, 0.0);
        return ret;
    }

    private boolean computeFullBlock() {
        Boolean ret;
        block10: {
            if (this.isEmpty) {
                ret = Boolean.FALSE;
            } else if (this == VoxelShapes.b()) {
                ret = Boolean.TRUE;
            } else {
                AxisAlignedBB singleAABB = this.singleAABBRepresentation;
                if (singleAABB == null) {
                    CachedShapeData shapeData = this.cachedShapeData;
                    int sMinX = shapeData.minFullX();
                    int sMinY = shapeData.minFullY();
                    int sMinZ = shapeData.minFullZ();
                    int sMaxX = shapeData.maxFullX();
                    int sMaxY = shapeData.maxFullY();
                    int sMaxZ = shapeData.maxFullZ();
                    if (Math.abs(this.rootCoordinatesX[sMinX] + this.offsetX) <= 1.0E-7 && Math.abs(this.rootCoordinatesY[sMinY] + this.offsetY) <= 1.0E-7 && Math.abs(this.rootCoordinatesZ[sMinZ] + this.offsetZ) <= 1.0E-7 && Math.abs(1.0 - (this.rootCoordinatesX[sMaxX] + this.offsetX)) <= 1.0E-7 && Math.abs(1.0 - (this.rootCoordinatesY[sMaxY] + this.offsetY)) <= 1.0E-7 && Math.abs(1.0 - (this.rootCoordinatesZ[sMaxZ] + this.offsetZ)) <= 1.0E-7) {
                        int sizeY = shapeData.sizeY();
                        int sizeZ = shapeData.sizeZ();
                        long[] bitset = shapeData.voxelSet();
                        ret = Boolean.TRUE;
                        for (int x2 = sMinX; x2 < sMaxX; ++x2) {
                            for (int y2 = sMinY; y2 < sMaxY; ++y2) {
                                int baseIndex = y2 * sizeZ + x2 * (sizeZ * sizeY);
                                if (FlatBitsetUtil.isRangeSet(bitset, baseIndex + sMinZ, baseIndex + sMaxZ)) continue;
                                ret = Boolean.FALSE;
                                break block10;
                            }
                        }
                    } else {
                        ret = Boolean.FALSE;
                    }
                } else {
                    ret = Math.abs(singleAABB.a) <= 1.0E-7 && Math.abs(singleAABB.b) <= 1.0E-7 && Math.abs(singleAABB.c) <= 1.0E-7 && Math.abs(1.0 - singleAABB.d) <= 1.0E-7 && Math.abs(1.0 - singleAABB.e) <= 1.0E-7 && Math.abs(1.0 - singleAABB.f) <= 1.0E-7;
                }
            }
        }
        this.isFullBlock = ret;
        return ret;
    }

    @Override
    public final boolean moonrise$isFullBlock() {
        Boolean ret = this.isFullBlock;
        if (ret != null) {
            return ret;
        }
        return this.computeFullBlock();
    }

    private static MovingObjectPositionBlock clip(AxisAlignedBB aabb, Vec3D from, Vec3D to, BlockPosition offset) {
        double[] minDistanceArr = new double[]{1.0};
        double diffX = to.d - from.d;
        double diffY = to.e - from.e;
        double diffZ = to.f - from.f;
        EnumDirection direction = AxisAlignedBB.a(aabb.a(offset), from, minDistanceArr, null, diffX, diffY, diffZ);
        if (direction == null) {
            return null;
        }
        double minDistance = minDistanceArr[0];
        return new MovingObjectPositionBlock(from.b(minDistance * diffX, minDistance * diffY, minDistance * diffZ), direction, offset, false);
    }

    private VoxelShape calculateFaceDirect(EnumDirection direction, EnumDirection.EnumAxis axis, double[] coords, double offset) {
        if (coords.length == 2 && DoubleMath.fuzzyEquals((double)(coords[0] + offset), (double)0.0, (double)1.0E-7) && DoubleMath.fuzzyEquals((double)(coords[1] + offset), (double)1.0, (double)1.0E-7)) {
            return this;
        }
        boolean positiveDir = direction.f() == EnumDirection.EnumAxisDirection.a;
        int index = CollisionUtil.findFloor(coords, offset, positiveDir ? 0.9999999 : 1.0E-7, 0, coords.length - 1);
        return CollisionUtil.sliceShape(this, axis, index);
    }

    protected VoxelShape(VoxelShapeDiscrete shape) {
        this.a = shape;
    }

    public double b(EnumDirection.EnumAxis axis) {
        CachedShapeData shapeData = this.cachedShapeData;
        switch (axis) {
            case a: {
                int idx = shapeData.minFullX();
                return idx >= shapeData.sizeX() ? Double.POSITIVE_INFINITY : this.rootCoordinatesX[idx] + this.offsetX;
            }
            case b: {
                int idx = shapeData.minFullY();
                return idx >= shapeData.sizeY() ? Double.POSITIVE_INFINITY : this.rootCoordinatesY[idx] + this.offsetY;
            }
            case c: {
                int idx = shapeData.minFullZ();
                return idx >= shapeData.sizeZ() ? Double.POSITIVE_INFINITY : this.rootCoordinatesZ[idx] + this.offsetZ;
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    public double c(EnumDirection.EnumAxis axis) {
        CachedShapeData shapeData = this.cachedShapeData;
        switch (axis) {
            case a: {
                int idx = shapeData.maxFullX();
                return idx <= 0 ? Double.NEGATIVE_INFINITY : this.rootCoordinatesX[idx] + this.offsetX;
            }
            case b: {
                int idx = shapeData.maxFullY();
                return idx <= 0 ? Double.NEGATIVE_INFINITY : this.rootCoordinatesY[idx] + this.offsetY;
            }
            case c: {
                int idx = shapeData.maxFullZ();
                return idx <= 0 ? Double.NEGATIVE_INFINITY : this.rootCoordinatesZ[idx] + this.offsetZ;
            }
        }
        return Double.NEGATIVE_INFINITY;
    }

    public AxisAlignedBB a() {
        if (this.isEmpty) {
            throw SystemUtils.b(new UnsupportedOperationException("No bounds for empty shape."));
        }
        AxisAlignedBB cached = this.cachedBounds;
        if (cached != null) {
            return cached;
        }
        CachedShapeData shapeData = this.cachedShapeData;
        double[] coordsX = this.rootCoordinatesX;
        double[] coordsY = this.rootCoordinatesY;
        double[] coordsZ = this.rootCoordinatesZ;
        double offX = this.offsetX;
        double offY = this.offsetY;
        double offZ = this.offsetZ;
        this.cachedBounds = cached = new AxisAlignedBB(coordsX[shapeData.minFullX()] + offX, coordsY[shapeData.minFullY()] + offY, coordsZ[shapeData.minFullZ()] + offZ, coordsX[shapeData.maxFullX()] + offX, coordsY[shapeData.maxFullY()] + offY, coordsZ[shapeData.maxFullZ()] + offZ);
        return cached;
    }

    public VoxelShape b() {
        if (this.isEmpty) {
            return VoxelShapes.a();
        }
        return VoxelShapes.a(this.a());
    }

    protected double a(EnumDirection.EnumAxis axis, int index) {
        int idx = index;
        switch (axis) {
            case a: {
                return this.rootCoordinatesX[idx] + this.offsetX;
            }
            case b: {
                return this.rootCoordinatesY[idx] + this.offsetY;
            }
            case c: {
                return this.rootCoordinatesZ[idx] + this.offsetZ;
            }
        }
        throw new IllegalStateException("Unknown axis: " + String.valueOf(axis));
    }

    public abstract DoubleList a(EnumDirection.EnumAxis var1);

    public boolean c() {
        return this.isEmpty;
    }

    public VoxelShape a(Vec3D offset) {
        return this.a(offset.d, offset.e, offset.f);
    }

    public VoxelShape a(double xOffset, double yOffset, double zOffset) {
        if (this.isEmpty) {
            return VoxelShapes.a();
        }
        VoxelShapeArray ret = new VoxelShapeArray(this.a, VoxelShape.offsetList(this.rootCoordinatesX, this.offsetX + xOffset), VoxelShape.offsetList(this.rootCoordinatesY, this.offsetY + yOffset), VoxelShape.offsetList(this.rootCoordinatesZ, this.offsetZ + zOffset));
        CachedToAABBs cachedToAABBs = this.cachedToAABBs;
        if (cachedToAABBs != null) {
            ((VoxelShape)ret).cachedToAABBs = CachedToAABBs.offset(cachedToAABBs, xOffset, yOffset, zOffset);
        }
        return ret;
    }

    public VoxelShape d() {
        if (this.isEmpty) {
            return VoxelShapes.a();
        }
        if (this.singleAABBRepresentation != null) {
            return this.moonrise$isFullBlock() ? VoxelShapes.b() : this;
        }
        List<AxisAlignedBB> aabbs = this.e();
        if (aabbs.isEmpty()) {
            return VoxelShapes.a();
        }
        if (aabbs.size() == 1) {
            AxisAlignedBB singleAABB = aabbs.get(0);
            VoxelShape ret = VoxelShapes.a(singleAABB);
            if (ret.cachedToAABBs == null) {
                ret.cachedToAABBs = this.cachedToAABBs;
            }
            return ret;
        }
        VoxelShape[] tmp = new VoxelShape[aabbs.size()];
        int len = aabbs.size();
        for (int i2 = 0; i2 < len; ++i2) {
            tmp[i2] = VoxelShapes.a(aabbs.get(i2));
        }
        int size = aabbs.size();
        while (size > 1) {
            int newSize = 0;
            for (int i3 = 0; i3 < size; i3 += 2) {
                int next = i3 + 1;
                if (next >= size) {
                    tmp[newSize++] = tmp[i3];
                    break;
                }
                VoxelShape first = tmp[i3];
                VoxelShape second = tmp[next];
                tmp[newSize++] = VoxelShapes.b(first, second, OperatorBoolean.o);
            }
            size = newSize;
        }
        VoxelShape ret = tmp[0];
        if (ret.cachedToAABBs == null) {
            ret.cachedToAABBs = this.cachedToAABBs;
        }
        return ret;
    }

    public void a(VoxelShapes.a action) {
        this.a.a((int x1, int y1, int z1, int x2, int y2, int z2) -> action.consume(this.a(EnumDirection.EnumAxis.a, x1), this.a(EnumDirection.EnumAxis.b, y1), this.a(EnumDirection.EnumAxis.c, z1), this.a(EnumDirection.EnumAxis.a, x2), this.a(EnumDirection.EnumAxis.b, y2), this.a(EnumDirection.EnumAxis.c, z2)), true);
    }

    public void b(VoxelShapes.a action) {
        DoubleList coords = this.a(EnumDirection.EnumAxis.a);
        DoubleList coords1 = this.a(EnumDirection.EnumAxis.b);
        DoubleList coords2 = this.a(EnumDirection.EnumAxis.c);
        this.a.b((x1, y1, z1, x2, y2, z2) -> action.consume(coords.getDouble(x1), coords1.getDouble(y1), coords2.getDouble(z1), coords.getDouble(x2), coords1.getDouble(y2), coords2.getDouble(z2)), true);
    }

    public List<AxisAlignedBB> e() {
        CachedToAABBs cachedToAABBs = this.cachedToAABBs;
        if (cachedToAABBs != null) {
            if (!cachedToAABBs.isOffset()) {
                return cachedToAABBs.aabbs();
            }
            this.cachedToAABBs = cachedToAABBs = cachedToAABBs.removeOffset();
            return cachedToAABBs.aabbs();
        }
        return this.toAabbsUncached();
    }

    public double a(EnumDirection.EnumAxis axis, double primaryPosition, double secondaryPosition) {
        int i1;
        EnumDirection.EnumAxis axis1 = EnumAxisCycle.b.a(axis);
        EnumDirection.EnumAxis axis2 = EnumAxisCycle.c.a(axis);
        int i2 = this.a(axis1, primaryPosition);
        int i22 = this.a.a(axis, i2, i1 = this.a(axis2, secondaryPosition));
        return i22 >= this.a.c(axis) ? Double.POSITIVE_INFINITY : this.a(axis, i22);
    }

    public double b(EnumDirection.EnumAxis axis, double primaryPosition, double secondaryPosition) {
        int i1;
        EnumDirection.EnumAxis axis1 = EnumAxisCycle.b.a(axis);
        EnumDirection.EnumAxis axis2 = EnumAxisCycle.c.a(axis);
        int i2 = this.a(axis1, primaryPosition);
        int i22 = this.a.b(axis, i2, i1 = this.a(axis2, secondaryPosition));
        return i22 <= 0 ? Double.NEGATIVE_INFINITY : this.a(axis, i22);
    }

    protected int a(EnumDirection.EnumAxis axis, double position) {
        double value = position;
        switch (axis) {
            case a: {
                double[] values = this.rootCoordinatesX;
                return CollisionUtil.findFloor(values, this.offsetX, value, 0, values.length - 1);
            }
            case b: {
                double[] values = this.rootCoordinatesY;
                return CollisionUtil.findFloor(values, this.offsetY, value, 0, values.length - 1);
            }
            case c: {
                double[] values = this.rootCoordinatesZ;
                return CollisionUtil.findFloor(values, this.offsetZ, value, 0, values.length - 1);
            }
        }
        throw new IllegalStateException("Unknown axis: " + String.valueOf(axis));
    }

    @Nullable
    public MovingObjectPositionBlock a(Vec3D startVec, Vec3D endVec, BlockPosition pos) {
        if (this.isEmpty) {
            return null;
        }
        Vec3D directionOpposite = endVec.d(startVec);
        if (directionOpposite.h() < 1.0E-7) {
            return null;
        }
        Vec3D fromBehind = startVec.e(directionOpposite.c(0.001));
        double fromBehindOffsetX = fromBehind.d - (double)pos.u();
        double fromBehindOffsetY = fromBehind.e - (double)pos.v();
        double fromBehindOffsetZ = fromBehind.f - (double)pos.w();
        AxisAlignedBB singleAABB = this.singleAABBRepresentation;
        if (singleAABB != null) {
            if (singleAABB.e(fromBehindOffsetX, fromBehindOffsetY, fromBehindOffsetZ)) {
                return new MovingObjectPositionBlock(fromBehind, EnumDirection.a(directionOpposite.d, directionOpposite.e, directionOpposite.f).g(), pos, true);
            }
            return VoxelShape.clip(singleAABB, startVec, endVec, pos);
        }
        if (CollisionUtil.strictlyContains(this, fromBehindOffsetX, fromBehindOffsetY, fromBehindOffsetZ)) {
            return new MovingObjectPositionBlock(fromBehind, EnumDirection.a(directionOpposite.d, directionOpposite.e, directionOpposite.f).g(), pos, true);
        }
        return AxisAlignedBB.a(this.e(), startVec, endVec, pos);
    }

    public Optional<Vec3D> b(Vec3D point) {
        if (this.isEmpty) {
            return Optional.empty();
        }
        Vec3D ret = null;
        double retDistance = Double.MAX_VALUE;
        List<AxisAlignedBB> aabbs = this.e();
        int len = aabbs.size();
        for (int i2 = 0; i2 < len; ++i2) {
            double z2;
            double y2;
            AxisAlignedBB aabb = aabbs.get(i2);
            double x2 = MathHelper.a(point.d, aabb.a, aabb.d);
            double dist = point.c(x2, y2 = MathHelper.a(point.e, aabb.b, aabb.e), z2 = MathHelper.a(point.f, aabb.c, aabb.f));
            if (!(dist < retDistance)) continue;
            ret = new Vec3D(x2, y2, z2);
            retDistance = dist;
        }
        return Optional.ofNullable(ret);
    }

    public VoxelShape a(EnumDirection side) {
        if (!this.c() && this != VoxelShapes.b()) {
            VoxelShape voxelShape;
            if (this.b != null) {
                voxelShape = this.b[side.ordinal()];
                if (voxelShape != null) {
                    return voxelShape;
                }
            } else {
                this.b = new VoxelShape[6];
            }
            this.b[side.ordinal()] = voxelShape = this.b(side);
            return voxelShape;
        }
        return this;
    }

    private VoxelShape b(EnumDirection side) {
        EnumDirection.EnumAxis axis = side.o();
        switch (axis) {
            case a: {
                return this.calculateFaceDirect(side, axis, this.rootCoordinatesX, this.offsetX);
            }
            case b: {
                return this.calculateFaceDirect(side, axis, this.rootCoordinatesY, this.offsetY);
            }
            case c: {
                return this.calculateFaceDirect(side, axis, this.rootCoordinatesZ, this.offsetZ);
            }
        }
        throw new IllegalStateException("Unknown axis: " + String.valueOf(axis));
    }

    protected boolean f() {
        for (EnumDirection.EnumAxis axis : EnumDirection.EnumAxis.d) {
            if (this.d(axis)) continue;
            return false;
        }
        return true;
    }

    private boolean d(EnumDirection.EnumAxis axis) {
        DoubleList coords = this.a(axis);
        return coords.size() == 2 && DoubleMath.fuzzyEquals((double)coords.getDouble(0), (double)0.0, (double)1.0E-7) && DoubleMath.fuzzyEquals((double)coords.getDouble(1), (double)1.0, (double)1.0E-7);
    }

    public double a(EnumDirection.EnumAxis axis, AxisAlignedBB source, double source_move) {
        if (this.isEmpty) {
            return source_move;
        }
        if (Math.abs(source_move) < 1.0E-7) {
            return 0.0;
        }
        switch (axis) {
            case a: {
                return CollisionUtil.collideX(this, source, source_move);
            }
            case b: {
                return CollisionUtil.collideY(this, source, source_move);
            }
            case c: {
                return CollisionUtil.collideZ(this, source, source_move);
            }
        }
        throw new RuntimeException("Unknown axis: " + String.valueOf(axis));
    }

    protected double a(EnumAxisCycle movementAxis, AxisAlignedBB collisionBox, double desiredOffset) {
        block11: {
            int min1;
            int min;
            double d1;
            EnumDirection.EnumAxis axis;
            EnumAxisCycle axisCycle;
            block10: {
                if (this.c()) {
                    return desiredOffset;
                }
                if (Math.abs(desiredOffset) < 1.0E-7) {
                    return 0.0;
                }
                axisCycle = movementAxis.a();
                axis = axisCycle.a(EnumDirection.EnumAxis.a);
                EnumDirection.EnumAxis axis1 = axisCycle.a(EnumDirection.EnumAxis.b);
                EnumDirection.EnumAxis axis2 = axisCycle.a(EnumDirection.EnumAxis.c);
                double d2 = collisionBox.b(axis);
                d1 = collisionBox.a(axis);
                int i2 = this.a(axis, d1 + 1.0E-7);
                int i1 = this.a(axis, d2 - 1.0E-7);
                int max = Math.max(0, this.a(axis1, collisionBox.a(axis1) + 1.0E-7));
                min = Math.min(this.a.c(axis1), this.a(axis1, collisionBox.b(axis1) - 1.0E-7) + 1);
                int max1 = Math.max(0, this.a(axis2, collisionBox.a(axis2) + 1.0E-7));
                min1 = Math.min(this.a.c(axis2), this.a(axis2, collisionBox.b(axis2) - 1.0E-7) + 1);
                int size = this.a.c(axis);
                if (!(desiredOffset > 0.0)) break block10;
                for (int i22 = i1 + 1; i22 < size; ++i22) {
                    for (int i3 = max; i3 < min; ++i3) {
                        for (int i4 = max1; i4 < min1; ++i4) {
                            if (!this.a.a(axisCycle, i22, i3, i4)) continue;
                            double d22 = this.a(axis, i22) - d2;
                            if (d22 >= -1.0E-7) {
                                desiredOffset = Math.min(desiredOffset, d22);
                            }
                            return desiredOffset;
                        }
                    }
                }
                break block11;
            }
            if (!(desiredOffset < 0.0)) break block11;
            for (int i2 = i2 - 1; i2 >= 0; --i2) {
                for (int i3 = max; i3 < min; ++i3) {
                    for (int i4x = max1; i4x < min1; ++i4x) {
                        if (!this.a.a(axisCycle, i2, i3, i4x)) continue;
                        double d2 = this.a(axis, i2 + 1) - d1;
                        if (d2 <= 1.0E-7) {
                            desiredOffset = Math.max(desiredOffset, d2);
                        }
                        return desiredOffset;
                    }
                }
            }
        }
        return desiredOffset;
    }

    public String toString() {
        return this.c() ? "EMPTY" : "VoxelShape[" + String.valueOf(this.a()) + "]";
    }
}

