/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec2F;
import org.joml.Vector3f;

public class Vec3D
implements IPosition {
    public static final Codec<Vec3D> a = Codec.DOUBLE.listOf().comapFlatMap(list -> SystemUtils.a(list, 3).map(list1 -> new Vec3D((Double)list1.get(0), (Double)list1.get(1), (Double)list1.get(2))), vec3 -> List.of(Double.valueOf(vec3.a()), Double.valueOf(vec3.b()), Double.valueOf(vec3.c())));
    public static final StreamCodec<ByteBuf, Vec3D> b = new StreamCodec<ByteBuf, Vec3D>(){

        public Vec3D a(ByteBuf buffer) {
            return PacketDataSerializer.f(buffer);
        }

        public void a(ByteBuf buffer, Vec3D value) {
            PacketDataSerializer.a(buffer, value);
        }
    };
    public static final Vec3D c = new Vec3D(0.0, 0.0, 0.0);
    public final double d;
    public final double e;
    public final double f;

    public static Vec3D a(int packed) {
        double d2 = (double)(packed >> 16 & 0xFF) / 255.0;
        double d1 = (double)(packed >> 8 & 0xFF) / 255.0;
        double d22 = (double)(packed & 0xFF) / 255.0;
        return new Vec3D(d2, d1, d22);
    }

    public static Vec3D a(BaseBlockPosition toCopy) {
        return new Vec3D(toCopy.u(), toCopy.v(), toCopy.w());
    }

    public static Vec3D a(BaseBlockPosition toCopy, double offsetX, double offsetY, double offsetZ) {
        return new Vec3D((double)toCopy.u() + offsetX, (double)toCopy.v() + offsetY, (double)toCopy.w() + offsetZ);
    }

    public static Vec3D b(BaseBlockPosition toCopy) {
        return Vec3D.a(toCopy, 0.5, 0.5, 0.5);
    }

    public static Vec3D c(BaseBlockPosition toCopy) {
        return Vec3D.a(toCopy, 0.5, 0.0, 0.5);
    }

    public static Vec3D a(BaseBlockPosition toCopy, double verticalOffset) {
        return Vec3D.a(toCopy, 0.5, verticalOffset, 0.5);
    }

    public Vec3D(double x2, double y2, double z2) {
        this.d = x2;
        this.e = y2;
        this.f = z2;
    }

    public Vec3D(Vector3f vector) {
        this(vector.x(), vector.y(), vector.z());
    }

    public Vec3D(BaseBlockPosition vector) {
        this(vector.u(), vector.v(), vector.w());
    }

    public Vec3D a(Vec3D vec) {
        return new Vec3D(vec.d - this.d, vec.e - this.e, vec.f - this.f);
    }

    public Vec3D d() {
        double squareRoot = Math.sqrt(this.d * this.d + this.e * this.e + this.f * this.f);
        return squareRoot < (double)1.0E-5f ? c : new Vec3D(this.d / squareRoot, this.e / squareRoot, this.f / squareRoot);
    }

    public double b(Vec3D vec) {
        return this.d * vec.d + this.e * vec.e + this.f * vec.f;
    }

    public Vec3D c(Vec3D vec) {
        return new Vec3D(this.e * vec.f - this.f * vec.e, this.f * vec.d - this.d * vec.f, this.d * vec.e - this.e * vec.d);
    }

    public Vec3D d(Vec3D vec) {
        return this.a(vec.d, vec.e, vec.f);
    }

    public Vec3D a(double amount) {
        return this.a(amount, amount, amount);
    }

    public Vec3D a(double x2, double y2, double z2) {
        return this.b(-x2, -y2, -z2);
    }

    public Vec3D b(double amount) {
        return this.b(amount, amount, amount);
    }

    public Vec3D e(Vec3D vec) {
        return this.b(vec.d, vec.e, vec.f);
    }

    public Vec3D b(double x2, double y2, double z2) {
        return new Vec3D(this.d + x2, this.e + y2, this.f + z2);
    }

    public boolean a(IPosition pos, double distance) {
        return this.c(pos.a(), pos.b(), pos.c()) < distance * distance;
    }

    public double f(Vec3D vec) {
        double d2 = vec.d - this.d;
        double d1 = vec.e - this.e;
        double d22 = vec.f - this.f;
        return Math.sqrt(d2 * d2 + d1 * d1 + d22 * d22);
    }

    public double g(Vec3D vec) {
        double d2 = vec.d - this.d;
        double d1 = vec.e - this.e;
        double d22 = vec.f - this.f;
        return d2 * d2 + d1 * d1 + d22 * d22;
    }

    public double c(double x2, double y2, double z2) {
        double d2 = x2 - this.d;
        double d1 = y2 - this.e;
        double d22 = z2 - this.f;
        return d2 * d2 + d1 * d1 + d22 * d22;
    }

    public boolean a(Vec3D pos, double horizontalDistance, double verticalDistance) {
        double d2 = pos.a() - this.d;
        double d1 = pos.b() - this.e;
        double d22 = pos.c() - this.f;
        return MathHelper.e(d2, d22) < MathHelper.k(horizontalDistance) && Math.abs(d1) < verticalDistance;
    }

    public Vec3D c(double factor) {
        return this.d(factor, factor, factor);
    }

    public Vec3D e() {
        return this.c(-1.0);
    }

    public Vec3D h(Vec3D vec) {
        return this.d(vec.d, vec.e, vec.f);
    }

    public Vec3D d(double factorX, double factorY, double factorZ) {
        return new Vec3D(this.d * factorX, this.e * factorY, this.f * factorZ);
    }

    public Vec3D f() {
        return new Vec3D(this.d, 0.0, this.f);
    }

    public Vec3D a(RandomSource random, float factor) {
        return this.b((random.i() - 0.5f) * factor, (random.i() - 0.5f) * factor, (random.i() - 0.5f) * factor);
    }

    public double g() {
        return Math.sqrt(this.d * this.d + this.e * this.e + this.f * this.f);
    }

    public double h() {
        return this.d * this.d + this.e * this.e + this.f * this.f;
    }

    public double i() {
        return Math.sqrt(this.d * this.d + this.f * this.f);
    }

    public double j() {
        return this.d * this.d + this.f * this.f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof Vec3D)) return false;
        Vec3D vec3 = (Vec3D)other;
        if (Double.compare(vec3.d, this.d) != 0) return false;
        if (Double.compare(vec3.e, this.e) != 0) return false;
        if (Double.compare(vec3.f, this.f) != 0) return false;
        return true;
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.d);
        int i2 = (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.e);
        i2 = 31 * i2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.f);
        return 31 * i2 + (int)(l2 ^ l2 >>> 32);
    }

    public String toString() {
        return "(" + this.d + ", " + this.e + ", " + this.f + ")";
    }

    public Vec3D a(Vec3D to, double delta) {
        return new Vec3D(MathHelper.d(delta, this.d, to.d), MathHelper.d(delta, this.e, to.e), MathHelper.d(delta, this.f, to.f));
    }

    public Vec3D a(float pitch) {
        float cos = MathHelper.b(pitch);
        float sin = MathHelper.a(pitch);
        double d2 = this.d;
        double d1 = this.e * (double)cos + this.f * (double)sin;
        double d22 = this.f * (double)cos - this.e * (double)sin;
        return new Vec3D(d2, d1, d22);
    }

    public Vec3D b(float yaw) {
        float cos = MathHelper.b(yaw);
        float sin = MathHelper.a(yaw);
        double d2 = this.d * (double)cos + this.f * (double)sin;
        double d1 = this.e;
        double d22 = this.f * (double)cos - this.d * (double)sin;
        return new Vec3D(d2, d1, d22);
    }

    public Vec3D c(float roll) {
        float cos = MathHelper.b(roll);
        float sin = MathHelper.a(roll);
        double d2 = this.d * (double)cos + this.e * (double)sin;
        double d1 = this.e * (double)cos - this.d * (double)sin;
        double d22 = this.f;
        return new Vec3D(d2, d1, d22);
    }

    public static Vec3D a(Vec2F vec) {
        return Vec3D.a(vec.i, vec.j);
    }

    public static Vec3D a(float pitch, float yaw) {
        float cos = MathHelper.b(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
        float sin = MathHelper.a(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
        float f2 = -MathHelper.b(-pitch * ((float)Math.PI / 180));
        float sin1 = MathHelper.a(-pitch * ((float)Math.PI / 180));
        return new Vec3D(sin * f2, sin1, cos * f2);
    }

    public Vec3D a(EnumSet<EnumDirection.EnumAxis> axes) {
        double d2 = axes.contains(EnumDirection.EnumAxis.a) ? (double)MathHelper.a(this.d) : this.d;
        double d1 = axes.contains(EnumDirection.EnumAxis.b) ? (double)MathHelper.a(this.e) : this.e;
        double d22 = axes.contains(EnumDirection.EnumAxis.c) ? (double)MathHelper.a(this.f) : this.f;
        return new Vec3D(d2, d1, d22);
    }

    public double a(EnumDirection.EnumAxis axis) {
        return axis.a(this.d, this.e, this.f);
    }

    public Vec3D a(EnumDirection.EnumAxis axis, double length) {
        double d2 = axis == EnumDirection.EnumAxis.a ? length : this.d;
        double d1 = axis == EnumDirection.EnumAxis.b ? length : this.e;
        double d22 = axis == EnumDirection.EnumAxis.c ? length : this.f;
        return new Vec3D(d2, d1, d22);
    }

    public Vec3D a(EnumDirection direction, double length) {
        BaseBlockPosition unitVec3i = direction.q();
        return new Vec3D(this.d + length * (double)unitVec3i.u(), this.e + length * (double)unitVec3i.v(), this.f + length * (double)unitVec3i.w());
    }

    @Override
    public final double a() {
        return this.d;
    }

    @Override
    public final double b() {
        return this.e;
    }

    @Override
    public final double c() {
        return this.f;
    }

    public Vector3f k() {
        return new Vector3f((float)this.d, (float)this.e, (float)this.f);
    }

    public Vec3D i(Vec3D vector) {
        return vector.h() == 0.0 ? vector : vector.c(this.b(vector)).c(1.0 / vector.h());
    }
}

