/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.timers;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.primitives.UnsignedLong;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimer;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimers;
import org.slf4j.Logger;

public class CustomFunctionCallbackTimerQueue<T> {
    private static final Logger a = LogUtils.getLogger();
    private static final String b = "Callback";
    private static final String c = "Name";
    private static final String d = "TriggerTime";
    private final CustomFunctionCallbackTimers<T> e;
    private final Queue<a<T>> f = new PriorityQueue<a<T>>(CustomFunctionCallbackTimerQueue.c());
    private UnsignedLong g = UnsignedLong.ZERO;
    private final Table<String, Long, a<T>> h = HashBasedTable.create();

    private static <T> Comparator<a<T>> c() {
        return Comparator.comparingLong(event -> event.a).thenComparing(event -> event.b);
    }

    public CustomFunctionCallbackTimerQueue(CustomFunctionCallbackTimers<T> callbacksRegistry, Stream<? extends Dynamic<?>> scheduledEventsDynamic) {
        this(callbacksRegistry);
        this.f.clear();
        this.h.clear();
        this.g = UnsignedLong.ZERO;
        scheduledEventsDynamic.forEach(scheduledEventDynamic -> {
            NBTBase tag = scheduledEventDynamic.convert(DynamicOpsNBT.a).getValue();
            if (tag instanceof NBTTagCompound) {
                NBTTagCompound compoundTag = (NBTTagCompound)tag;
                this.a(compoundTag);
            } else {
                a.warn("Invalid format of events: {}", (Object)tag);
            }
        });
    }

    public CustomFunctionCallbackTimerQueue(CustomFunctionCallbackTimers<T> callbacksRegistry) {
        this.e = callbacksRegistry;
    }

    public void a(T obj, long gameTime) {
        a<T> event;
        while ((event = this.f.peek()) != null && event.a <= gameTime) {
            this.f.remove();
            this.h.remove((Object)event.c, (Object)gameTime);
            event.d.handle(obj, this, gameTime);
        }
        return;
    }

    public void a(String id, long triggerTime, CustomFunctionCallbackTimer<T> callback) {
        if (!this.h.contains((Object)id, (Object)triggerTime)) {
            this.g = this.g.plus(UnsignedLong.ONE);
            a<T> event = new a<T>(triggerTime, this.g, id, callback);
            this.h.put((Object)id, (Object)triggerTime, event);
            this.f.add(event);
        }
    }

    public int a(String eventId) {
        Collection collection = this.h.row((Object)eventId).values();
        collection.forEach(this.f::remove);
        int size = collection.size();
        collection.clear();
        return size;
    }

    public Set<String> a() {
        return Collections.unmodifiableSet(this.h.rowKeySet());
    }

    private void a(NBTTagCompound tag) {
        NBTTagCompound compound = tag.p(b);
        CustomFunctionCallbackTimer<T> timerCallback = this.e.a(compound);
        if (timerCallback != null) {
            String string = tag.l(c);
            long _long = tag.i(d);
            this.a(string, _long, timerCallback);
        }
    }

    private NBTTagCompound a(a<T> event) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a(c, event.c);
        compoundTag.a(d, event.a);
        compoundTag.a(b, this.e.a(event.d));
        return compoundTag;
    }

    public NBTTagList b() {
        NBTTagList listTag = new NBTTagList();
        this.f.stream().sorted(CustomFunctionCallbackTimerQueue.c()).map(this::a).forEach(listTag::add);
        return listTag;
    }

    public static class a<T> {
        public final long a;
        public final UnsignedLong b;
        public final String c;
        public final CustomFunctionCallbackTimer<T> d;

        a(long triggerTime, UnsignedLong sequentialId, String id, CustomFunctionCallbackTimer<T> callback) {
            this.a = triggerTime;
            this.b = sequentialId;
            this.c = id;
            this.d = callback;
        }
    }
}

