/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.CopyCustomDataFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.FilteredFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionReference;
import net.minecraft.world.level.storage.loot.functions.LootEnchantLevel;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionApplyBonus;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyName;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyState;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionEnchant;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionExplorationMap;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionFillPlayerHead;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionLimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetAttribute;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetContents;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetDamage;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetLore;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetName;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetStewEffect;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSmelt;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.ModifyContainerContents;
import net.minecraft.world.level.storage.loot.functions.SequenceFunction;
import net.minecraft.world.level.storage.loot.functions.SetBannerPatternFunction;
import net.minecraft.world.level.storage.loot.functions.SetBookCoverFunction;
import net.minecraft.world.level.storage.loot.functions.SetComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetCustomDataFunction;
import net.minecraft.world.level.storage.loot.functions.SetCustomModelDataFunction;
import net.minecraft.world.level.storage.loot.functions.SetEnchantmentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetFireworkExplosionFunction;
import net.minecraft.world.level.storage.loot.functions.SetFireworksFunction;
import net.minecraft.world.level.storage.loot.functions.SetInstrumentFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetOminousBottleAmplifierFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;
import net.minecraft.world.level.storage.loot.functions.SetWritableBookPagesFunction;
import net.minecraft.world.level.storage.loot.functions.SetWrittenBookPagesFunction;
import net.minecraft.world.level.storage.loot.functions.ToggleTooltips;

public class LootItemFunctions {
    public static final BiFunction<ItemStack, LootTableInfo, ItemStack> a = (itemStack, context) -> itemStack;
    public static final Codec<LootItemFunction> b = BuiltInRegistries.E.q().dispatch("function", LootItemFunction::b, LootItemFunctionType::a);
    public static final Codec<LootItemFunction> c = Codec.lazyInitialized(() -> Codec.withAlternative(b, SequenceFunction.b));
    public static final Codec<Holder<LootItemFunction>> d = RegistryFileCodec.a(Registries.bh, c);
    public static final LootItemFunctionType<LootItemFunctionSetCount> e = LootItemFunctions.a("set_count", LootItemFunctionSetCount.a);
    public static final LootItemFunctionType<SetItemFunction> f = LootItemFunctions.a("set_item", SetItemFunction.a);
    public static final LootItemFunctionType<LootEnchantLevel> g = LootItemFunctions.a("enchant_with_levels", LootEnchantLevel.a);
    public static final LootItemFunctionType<LootItemFunctionEnchant> h = LootItemFunctions.a("enchant_randomly", LootItemFunctionEnchant.a);
    public static final LootItemFunctionType<SetEnchantmentsFunction> i = LootItemFunctions.a("set_enchantments", SetEnchantmentsFunction.a);
    public static final LootItemFunctionType<SetCustomDataFunction> j = LootItemFunctions.a("set_custom_data", SetCustomDataFunction.a);
    public static final LootItemFunctionType<SetComponentsFunction> k = LootItemFunctions.a("set_components", SetComponentsFunction.a);
    public static final LootItemFunctionType<LootItemFunctionSmelt> l = LootItemFunctions.a("furnace_smelt", LootItemFunctionSmelt.a);
    public static final LootItemFunctionType<EnchantedCountIncreaseFunction> m = LootItemFunctions.a("enchanted_count_increase", EnchantedCountIncreaseFunction.b);
    public static final LootItemFunctionType<LootItemFunctionSetDamage> n = LootItemFunctions.a("set_damage", LootItemFunctionSetDamage.a);
    public static final LootItemFunctionType<LootItemFunctionSetAttribute> o = LootItemFunctions.a("set_attributes", LootItemFunctionSetAttribute.a);
    public static final LootItemFunctionType<LootItemFunctionSetName> p = LootItemFunctions.a("set_name", LootItemFunctionSetName.a);
    public static final LootItemFunctionType<LootItemFunctionExplorationMap> q = LootItemFunctions.a("exploration_map", LootItemFunctionExplorationMap.f);
    public static final LootItemFunctionType<LootItemFunctionSetStewEffect> r = LootItemFunctions.a("set_stew_effect", LootItemFunctionSetStewEffect.a);
    public static final LootItemFunctionType<LootItemFunctionCopyName> s = LootItemFunctions.a("copy_name", LootItemFunctionCopyName.a);
    public static final LootItemFunctionType<LootItemFunctionSetContents> t = LootItemFunctions.a("set_contents", LootItemFunctionSetContents.a);
    public static final LootItemFunctionType<ModifyContainerContents> u = LootItemFunctions.a("modify_contents", ModifyContainerContents.a);
    public static final LootItemFunctionType<FilteredFunction> v = LootItemFunctions.a("filtered", FilteredFunction.a);
    public static final LootItemFunctionType<LootItemFunctionLimitCount> w = LootItemFunctions.a("limit_count", LootItemFunctionLimitCount.a);
    public static final LootItemFunctionType<LootItemFunctionApplyBonus> x = LootItemFunctions.a("apply_bonus", LootItemFunctionApplyBonus.a);
    public static final LootItemFunctionType<LootItemFunctionSetTable> y = LootItemFunctions.a("set_loot_table", LootItemFunctionSetTable.a);
    public static final LootItemFunctionType<LootItemFunctionExplosionDecay> z = LootItemFunctions.a("explosion_decay", LootItemFunctionExplosionDecay.a);
    public static final LootItemFunctionType<LootItemFunctionSetLore> A = LootItemFunctions.a("set_lore", LootItemFunctionSetLore.a);
    public static final LootItemFunctionType<LootItemFunctionFillPlayerHead> B = LootItemFunctions.a("fill_player_head", LootItemFunctionFillPlayerHead.a);
    public static final LootItemFunctionType<CopyCustomDataFunction> C = LootItemFunctions.a("copy_custom_data", CopyCustomDataFunction.a);
    public static final LootItemFunctionType<LootItemFunctionCopyState> D = LootItemFunctions.a("copy_state", LootItemFunctionCopyState.a);
    public static final LootItemFunctionType<SetBannerPatternFunction> E = LootItemFunctions.a("set_banner_pattern", SetBannerPatternFunction.a);
    public static final LootItemFunctionType<SetPotionFunction> F = LootItemFunctions.a("set_potion", SetPotionFunction.a);
    public static final LootItemFunctionType<SetInstrumentFunction> G = LootItemFunctions.a("set_instrument", SetInstrumentFunction.a);
    public static final LootItemFunctionType<FunctionReference> H = LootItemFunctions.a("reference", FunctionReference.a);
    public static final LootItemFunctionType<SequenceFunction> I = LootItemFunctions.a("sequence", SequenceFunction.a);
    public static final LootItemFunctionType<CopyComponentsFunction> J = LootItemFunctions.a("copy_components", CopyComponentsFunction.a);
    public static final LootItemFunctionType<SetFireworksFunction> K = LootItemFunctions.a("set_fireworks", SetFireworksFunction.a);
    public static final LootItemFunctionType<SetFireworkExplosionFunction> L = LootItemFunctions.a("set_firework_explosion", SetFireworkExplosionFunction.a);
    public static final LootItemFunctionType<SetBookCoverFunction> M = LootItemFunctions.a("set_book_cover", SetBookCoverFunction.a);
    public static final LootItemFunctionType<SetWrittenBookPagesFunction> N = LootItemFunctions.a("set_written_book_pages", SetWrittenBookPagesFunction.b);
    public static final LootItemFunctionType<SetWritableBookPagesFunction> O = LootItemFunctions.a("set_writable_book_pages", SetWritableBookPagesFunction.a);
    public static final LootItemFunctionType<ToggleTooltips> P = LootItemFunctions.a("toggle_tooltips", ToggleTooltips.a);
    public static final LootItemFunctionType<SetOminousBottleAmplifierFunction> Q = LootItemFunctions.a("set_ominous_bottle_amplifier", SetOminousBottleAmplifierFunction.a);
    public static final LootItemFunctionType<SetCustomModelDataFunction> R = LootItemFunctions.a("set_custom_model_data", SetCustomModelDataFunction.a);

    private static <T extends LootItemFunction> LootItemFunctionType<T> a(String name, MapCodec<T> codec) {
        return IRegistry.a(BuiltInRegistries.E, MinecraftKey.b(name), new LootItemFunctionType<T>(codec));
    }

    public static BiFunction<ItemStack, LootTableInfo, ItemStack> a(List<? extends BiFunction<ItemStack, LootTableInfo, ItemStack>> functions) {
        List<? extends BiFunction<ItemStack, LootTableInfo, ItemStack>> list = List.copyOf(functions);
        return switch (list.size()) {
            case 0 -> a;
            case 1 -> list.get(0);
            case 2 -> {
                BiFunction<ItemStack, LootTableInfo, ItemStack> biFunction = list.get(0);
                BiFunction<ItemStack, LootTableInfo, ItemStack> biFunction1 = list.get(1);
                yield (itemStack, lootContext) -> (ItemStack)biFunction1.apply((ItemStack)biFunction.apply((ItemStack)itemStack, (LootTableInfo)lootContext), (LootTableInfo)lootContext);
            }
            default -> (itemStack, lootContext) -> {
                for (BiFunction biFunction2 : list) {
                    itemStack = (ItemStack)biFunction2.apply(itemStack, lootContext);
                }
                return itemStack;
            };
        };
    }
}

