/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.util.MathHelper;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import org.slf4j.Logger;

public class LootItemFunctionSetDamage
extends LootItemFunctionConditional {
    private static final Logger b = LogUtils.getLogger();
    public static final MapCodec<LootItemFunctionSetDamage> a = RecordCodecBuilder.mapCodec(instance -> LootItemFunctionSetDamage.a(instance).and(instance.group((App)NumberProviders.a.fieldOf("damage").forGetter(setItemDamageFunction -> setItemDamageFunction.c), (App)Codec.BOOL.fieldOf("add").orElse((Object)false).forGetter(setItemDamageFunction -> setItemDamageFunction.d))).apply((Applicative)instance, LootItemFunctionSetDamage::new));
    private final NumberProvider c;
    private final boolean d;

    private LootItemFunctionSetDamage(List<LootItemCondition> predicates, NumberProvider damage, boolean add) {
        super(predicates);
        this.c = damage;
        this.d = add;
    }

    public LootItemFunctionType<LootItemFunctionSetDamage> b() {
        return LootItemFunctions.n;
    }

    @Override
    public Set<ContextKey<?>> a() {
        return this.c.a();
    }

    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        if (stack.m()) {
            int maxDamage = stack.p();
            float f2 = this.d ? 1.0f - (float)stack.o() / (float)maxDamage : 0.0f;
            float f1 = 1.0f - MathHelper.a(this.c.b(context) + f2, 0.0f, 1.0f);
            stack.b(MathHelper.d(f1 * (float)maxDamage));
        } else {
            b.warn("Couldn't set damage of loot item {}", (Object)stack);
        }
        return stack;
    }

    public static LootItemFunctionConditional.a<?> a(NumberProvider damageValue) {
        return LootItemFunctionSetDamage.a((List<LootItemCondition> list) -> new LootItemFunctionSetDamage((List<LootItemCondition>)list, damageValue, false));
    }

    public static LootItemFunctionConditional.a<?> a(NumberProvider damageValue, boolean add) {
        return LootItemFunctionSetDamage.a((List<LootItemCondition> list) -> new LootItemFunctionSetDamage((List<LootItemCondition>)list, damageValue, add));
    }
}

