/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class EnchantedCountIncreaseFunction
extends LootItemFunctionConditional {
    public static final int a = 0;
    public static final MapCodec<EnchantedCountIncreaseFunction> b = RecordCodecBuilder.mapCodec(instance -> EnchantedCountIncreaseFunction.a(instance).and(instance.group((App)Enchantment.c.fieldOf("enchantment").forGetter(enchantedCountIncreaseFunction -> enchantedCountIncreaseFunction.c), (App)NumberProviders.a.fieldOf("count").forGetter(enchantedCountIncreaseFunction -> enchantedCountIncreaseFunction.d), (App)Codec.INT.optionalFieldOf("limit", (Object)0).forGetter(enchantedCountIncreaseFunction -> enchantedCountIncreaseFunction.e))).apply((Applicative)instance, EnchantedCountIncreaseFunction::new));
    private final Holder<Enchantment> c;
    private final NumberProvider d;
    private final int e;

    EnchantedCountIncreaseFunction(List<LootItemCondition> predicates, Holder<Enchantment> enchantment, NumberProvider value, int limit) {
        super(predicates);
        this.c = enchantment;
        this.d = value;
        this.e = limit;
    }

    public LootItemFunctionType<EnchantedCountIncreaseFunction> b() {
        return LootItemFunctions.m;
    }

    @Override
    public Set<ContextKey<?>> a() {
        return Sets.union((Set)ImmutableSet.of(LootContextParameters.d), this.d.a());
    }

    private boolean c() {
        return this.e > 0;
    }

    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        Entity entity = context.c(LootContextParameters.d);
        if (entity instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            int enchantmentLevel = EnchantmentManager.a(this.c, livingEntity);
            if (enchantmentLevel == 0) {
                return stack;
            }
            float f2 = (float)enchantmentLevel * this.d.b(context);
            stack.g(Math.round(f2));
            if (this.c()) {
                stack.f(this.e);
            }
        }
        return stack;
    }

    public static a a(HolderLookup.a registries, NumberProvider count) {
        HolderLookup.b<Enchantment> registryLookup = registries.d(Registries.aO);
        return new a(registryLookup.b(Enchantments.s), count);
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final Holder<Enchantment> a;
        private final NumberProvider b;
        private int c = 0;

        public a(Holder<Enchantment> enchantment, NumberProvider count) {
            this.a = enchantment;
            this.b = count;
        }

        protected a a() {
            return this;
        }

        public a a(int limit) {
            this.c = limit;
            return this;
        }

        @Override
        public LootItemFunction b() {
            return new EnchantedCountIncreaseFunction(this.g(), this.a, this.b, this.c);
        }
    }
}

