/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.PersistentBase;
import org.slf4j.Logger;

public class WorldPersistentData
implements AutoCloseable {
    private static final Logger a = LogUtils.getLogger();
    public final Map<String, Optional<PersistentBase>> b = new HashMap<String, Optional<PersistentBase>>();
    private final DataFixer c;
    private final HolderLookup.a d;
    private final Path e;
    private CompletableFuture<?> f = CompletableFuture.completedFuture(null);

    public WorldPersistentData(Path dataFolder, DataFixer fixerUpper, HolderLookup.a registries) {
        this.c = fixerUpper;
        this.e = dataFolder;
        this.d = registries;
    }

    private Path a(String filename) {
        return this.e.resolve(filename + ".dat");
    }

    public <T extends PersistentBase> T a(PersistentBase.a<T> factory, String name) {
        T savedData = this.b(factory, name);
        if (savedData != null) {
            return savedData;
        }
        PersistentBase savedData1 = (PersistentBase)factory.a().get();
        this.a(name, savedData1);
        return (T)savedData1;
    }

    @Nullable
    public <T extends PersistentBase> T b(PersistentBase.a<T> factory, String name) {
        Optional<PersistentBase> optional = this.b.get(name);
        if (optional == null) {
            optional = Optional.ofNullable(this.a(factory.b(), factory.c(), name));
            this.b.put(name, optional);
        }
        return (T)((PersistentBase)optional.orElse(null));
    }

    @Nullable
    private <T extends PersistentBase> T a(BiFunction<NBTTagCompound, HolderLookup.a, T> reader, DataFixTypes dataFixType, String filename) {
        try {
            Path dataFile = this.a(filename);
            if (Files.exists(dataFile, new LinkOption[0])) {
                NBTTagCompound tagFromDisk = this.a(filename, dataFixType, SharedConstants.b().d().c());
                return (T)((PersistentBase)reader.apply(tagFromDisk.p("data"), this.d));
            }
        }
        catch (Exception var6) {
            a.error("Error loading saved data: {}", (Object)filename, (Object)var6);
        }
        return null;
    }

    public void a(String name, PersistentBase savedData) {
        this.b.put(name, Optional.of(savedData));
        savedData.c();
    }

    public NBTTagCompound a(String filename, DataFixTypes dataFixType, int version) throws IOException {
        NBTTagCompound var8;
        try (InputStream inputStream = Files.newInputStream(this.a(filename), new OpenOption[0]);
             PushbackInputStream pushbackInputStream = new PushbackInputStream(new FastBufferedInputStream(inputStream), 2);){
            NBTTagCompound compressed;
            if (this.a(pushbackInputStream)) {
                compressed = NBTCompressedStreamTools.a(pushbackInputStream, NBTReadLimiter.a());
            } else {
                try (DataInputStream dataInputStream = new DataInputStream(pushbackInputStream);){
                    compressed = NBTCompressedStreamTools.a(dataInputStream);
                }
            }
            int dataVersion = GameProfileSerializer.b(compressed, 1343);
            var8 = dataFixType.a(this.c, compressed, dataVersion, version);
        }
        return var8;
    }

    private boolean a(PushbackInputStream inputStream) throws IOException {
        int i1;
        byte[] bytes = new byte[2];
        boolean flag = false;
        int i2 = inputStream.read(bytes, 0, 2);
        if (i2 == 2 && (i1 = (bytes[1] & 0xFF) << 8 | bytes[0] & 0xFF) == 35615) {
            flag = true;
        }
        if (i2 != 0) {
            inputStream.unread(bytes, 0, i2);
        }
        return flag;
    }

    public CompletableFuture<?> a() {
        Map<Path, NBTTagCompound> map = this.c();
        if (map.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        int i2 = SystemUtils.g();
        int size = map.size();
        this.f = this.f.thenCompose(object -> CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> CompletableFuture.runAsync(() -> WorldPersistentData.a((Path)entry.getKey(), (NBTTagCompound)entry.getValue()), SystemUtils.DIMENSION_DATA_IO_POOL)).toArray(CompletableFuture[]::new)));
        return this.f;
    }

    private Map<Path, NBTTagCompound> c() {
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        this.b.forEach((arg_0, arg_1) -> this.a((Map)map, arg_0, arg_1));
        return map;
    }

    private static void a(Path path, NBTTagCompound tag) {
        try {
            NBTCompressedStreamTools.a(tag, path);
        }
        catch (IOException var3) {
            a.error("Could not save data to {}", (Object)path.getFileName(), (Object)var3);
        }
    }

    public void b() {
        this.a().join();
    }

    @Override
    public void close() {
        this.b();
    }

    private /* synthetic */ void a(Map map, String string, Optional optional) {
        optional.filter(PersistentBase::d).ifPresent(savedData -> map.put(this.a(string), savedData.a(this.d)));
    }

    private static /* synthetic */ CompletionStage a(int i2, int size, Map map, Object object) {
        ArrayList<CompletableFuture<Void>> list = new ArrayList<CompletableFuture<Void>>(i2);
        int i1 = MathHelper.e(size, i2);
        for (List list1 : Iterables.partition(map.entrySet(), (int)i1)) {
            list.add(CompletableFuture.runAsync(() -> {
                for (Map.Entry entry : list1) {
                    WorldPersistentData.a((Path)entry.getKey(), (NBTTagCompound)entry.getValue());
                }
            }, SystemUtils.i()));
        }
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }
}

