/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.FileUtils;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NbtFormatException;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.nbt.visitors.SkipFields;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.SessionLock;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.storage.FileNameDateFormatter;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldInfo;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import net.minecraft.world.level.validation.PathAllowList;
import org.slf4j.Logger;

public class Convertable {
    static final Logger c = LogUtils.getLogger();
    static final DateTimeFormatter d = FileNameDateFormatter.a();
    public static final String a = "Data";
    private static final PathMatcher e = path -> false;
    public static final String b = "allowed_symlinks.txt";
    private static final int f = 0x6400000;
    private static final int g = 0x4000000;
    public final Path h;
    private final Path i;
    final DataFixer j;
    private final DirectoryValidator k;

    public Convertable(Path baseDir, Path backupDir, DirectoryValidator worldDirValidator, DataFixer fixerUpper) {
        this.j = fixerUpper;
        try {
            FileUtils.c(baseDir);
        }
        catch (IOException var6) {
            throw new UncheckedIOException(var6);
        }
        this.h = baseDir;
        this.i = backupDir;
        this.k = worldDirValidator;
    }

    public static DirectoryValidator a(Path validator) {
        if (Files.exists(validator, new LinkOption[0])) {
            try {
                DirectoryValidator var2;
                try (BufferedReader bufferedReader = Files.newBufferedReader(validator);){
                    var2 = new DirectoryValidator(PathAllowList.a(bufferedReader));
                }
                return var2;
            }
            catch (Exception var6) {
                c.error("Failed to parse {}, disallowing all symbolic links", (Object)b, (Object)var6);
            }
        }
        return new DirectoryValidator(e);
    }

    public static Convertable b(Path savesDir) {
        DirectoryValidator directoryValidator = Convertable.a(savesDir.resolve(b));
        return new Convertable(savesDir, savesDir.resolve("../backups"), directoryValidator, DataConverterRegistry.a());
    }

    public static WorldDataConfiguration a(Dynamic<?> dynamic) {
        return WorldDataConfiguration.b.parse(dynamic).resultOrPartial(arg_0 -> ((Logger)c).error(arg_0)).orElse(WorldDataConfiguration.c);
    }

    public static WorldLoader.d a(Dynamic<?> dynamic, ResourcePackRepository packRepository, boolean safeMode) {
        return new WorldLoader.d(packRepository, Convertable.a(dynamic), safeMode, false);
    }

    public static LevelDataAndDimensions a(Dynamic<?> levelData, WorldDataConfiguration dataConfiguration, IRegistry<WorldDimension> levelStemRegistry, HolderLookup.a registries) {
        Dynamic<?> dynamic = RegistryOps.a(levelData, registries);
        Dynamic dynamic1 = dynamic.get("WorldGenSettings").orElseEmptyMap();
        GeneratorSettings worldGenSettings = (GeneratorSettings)GeneratorSettings.a.parse(dynamic1).getOrThrow();
        WorldSettings levelSettings = WorldSettings.a(dynamic, dataConfiguration);
        WorldDimensions.b complete = worldGenSettings.b().a(levelStemRegistry);
        Lifecycle lifecycle = complete.a().add(registries.d());
        WorldDataServer primaryLevelData = WorldDataServer.a(dynamic, levelSettings, complete.d(), worldGenSettings.a(), lifecycle);
        primaryLevelData.pdc = (NBTBase)dynamic.getElement("BukkitValues", null);
        return new LevelDataAndDimensions(primaryLevelData, complete);
    }

    public String a() {
        return "Anvil";
    }

    public a b() throws LevelStorageException {
        if (!Files.isDirectory(this.h, new LinkOption[0])) {
            throw new LevelStorageException(IChatBaseComponent.c("selectWorld.load_folder_access"));
        }
        try {
            a var3;
            try (Stream<Path> stream = Files.list(this.h);){
                List<b> list = stream.filter(path -> Files.isDirectory(path, new LinkOption[0])).map(b::new).filter(levelDirectory -> Files.isRegularFile(levelDirectory.b(), new LinkOption[0]) || Files.isRegularFile(levelDirectory.c(), new LinkOption[0])).toList();
                var3 = new a(list);
            }
            return var3;
        }
        catch (IOException var6) {
            throw new LevelStorageException(IChatBaseComponent.c("selectWorld.load_folder_access"));
        }
    }

    public CompletableFuture<List<WorldInfo>> a(a candidates) {
        ArrayList<CompletableFuture<WorldInfo>> list = new ArrayList<CompletableFuture<WorldInfo>>(candidates.a.size());
        for (b levelDirectory : candidates.a) {
            list.add(CompletableFuture.supplyAsync(() -> {
                boolean isLocked;
                try {
                    isLocked = SessionLock.b(levelDirectory.f());
                }
                catch (Exception var13) {
                    c.warn("Failed to read {} lock", (Object)levelDirectory.f(), (Object)var13);
                    return null;
                }
                try {
                    return this.a(levelDirectory, isLocked);
                }
                catch (OutOfMemoryError var12) {
                    MemoryReserve.b();
                    String string = "Ran out of memory trying to read summary of world folder \"" + levelDirectory.a() + "\"";
                    c.error(LogUtils.FATAL_MARKER, string);
                    OutOfMemoryError outOfMemoryError1 = new OutOfMemoryError("Ran out of memory reading level data");
                    outOfMemoryError1.initCause(var12);
                    CrashReport crashReport = CrashReport.a(outOfMemoryError1, string);
                    CrashReportSystemDetails crashReportCategory = crashReport.a("World details");
                    crashReportCategory.a("Folder Name", levelDirectory.a());
                    try {
                        long size = Files.size(levelDirectory.b());
                        crashReportCategory.a("level.dat size", size);
                    }
                    catch (IOException var11) {
                        crashReportCategory.a("level.dat size", var11);
                    }
                    throw new ReportedException(crashReport);
                }
            }, SystemUtils.h().a("loadLevelSummaries")));
        }
        return SystemUtils.f(list).thenApply(list1 -> list1.stream().filter(Objects::nonNull).sorted().toList());
    }

    private int f() {
        return 19133;
    }

    static NBTTagCompound c(Path levelPath) throws IOException {
        return NBTCompressedStreamTools.a(levelPath, NBTReadLimiter.a(0x6400000L));
    }

    static Dynamic<?> a(Path levelPath, DataFixer dataFixer) throws IOException {
        NBTTagCompound levelDataTagRaw = Convertable.c(levelPath);
        NBTTagCompound compound = levelDataTagRaw.p(a);
        int dataVersion = GameProfileSerializer.b(compound, -1);
        Dynamic<NBTTagCompound> dynamic = DataFixTypes.a.a(dataFixer, new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, compound), dataVersion);
        dynamic = dynamic.update("Player", dynamic1 -> new Dynamic<NBTTagCompound>(dynamic1.getOps(), MCDataConverter.convertTag(MCTypeRegistry.PLAYER, (NBTTagCompound)dynamic1.getValue(), dataVersion, SharedConstants.b().d().c())));
        return dynamic.update("WorldGenSettings", dynamic1 -> DataFixTypes.r.a(dataFixer, dynamic1, dataVersion));
    }

    private WorldInfo a(b levelDirectory, boolean locked) {
        Path path = levelDirectory.b();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                List<ForbiddenSymlinkInfo> list;
                if (Files.isSymbolicLink(path) && !(list = this.k.a(path)).isEmpty()) {
                    c.warn("{}", (Object)ContentValidationException.a(path, list));
                    return new WorldInfo.c(levelDirectory.a(), levelDirectory.d());
                }
                NBTBase nBTBase = Convertable.e(path);
                if (nBTBase instanceof NBTTagCompound) {
                    NBTTagCompound compoundTag = (NBTTagCompound)nBTBase;
                    NBTTagCompound compound = compoundTag.p(a);
                    int dataVersion = GameProfileSerializer.b(compound, -1);
                    Dynamic<NBTTagCompound> dynamic = DataFixTypes.a.a(this.j, new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, compound), dataVersion);
                    return this.a(dynamic, levelDirectory, locked);
                }
                c.warn("Invalid root tag in {}", (Object)path);
            }
            catch (Exception var9) {
                c.error("Exception reading {}", (Object)path, (Object)var9);
            }
        }
        return new WorldInfo.b(levelDirectory.a(), levelDirectory.d(), Convertable.a(levelDirectory));
    }

    private static long a(b levelDirectory) {
        Instant fileModificationTime = Convertable.d(levelDirectory.b());
        if (fileModificationTime == null) {
            fileModificationTime = Convertable.d(levelDirectory.c());
        }
        return fileModificationTime == null ? -1L : fileModificationTime.toEpochMilli();
    }

    @Nullable
    static Instant d(Path dataFilePath) {
        try {
            return Files.getLastModifiedTime(dataFilePath, new LinkOption[0]).toInstant();
        }
        catch (IOException var2) {
            return null;
        }
    }

    WorldInfo a(Dynamic<?> dynamic, b levelDirectory, boolean locked) {
        LevelVersion levelVersion = LevelVersion.a(dynamic);
        int levelDataVersion = levelVersion.a();
        if (levelDataVersion != 19132 && levelDataVersion != 19133) {
            throw new NbtFormatException("Unknown data version: " + Integer.toHexString(levelDataVersion));
        }
        boolean flag = levelDataVersion != this.f();
        Path path = levelDirectory.d();
        WorldDataConfiguration dataConfig = Convertable.a(dynamic);
        WorldSettings levelSettings = WorldSettings.a(dynamic, dataConfig);
        FeatureFlagSet featureFlagSet = Convertable.b(dynamic);
        boolean isExperimental = FeatureFlags.a(featureFlagSet);
        return new WorldInfo(levelSettings, levelVersion, levelDirectory.a(), flag, locked, isExperimental, path);
    }

    private static FeatureFlagSet b(Dynamic<?> dataDynamic) {
        Set<MinecraftKey> set = dataDynamic.get("enabled_features").asStream().flatMap(dynamic -> dynamic.asString().result().map(MinecraftKey::c).stream()).collect(Collectors.toSet());
        return FeatureFlags.e.a(set, resourceLocation -> {});
    }

    @Nullable
    private static NBTBase e(Path file) throws IOException {
        SkipFields skipFields = new SkipFields(new FieldSelector(a, NBTTagCompound.b, "Player"), new FieldSelector(a, NBTTagCompound.b, "WorldGenSettings"));
        NBTCompressedStreamTools.a(file, (StreamTagVisitor)skipFields, NBTReadLimiter.a(0x6400000L));
        return skipFields.d();
    }

    public boolean a(String saveName) {
        try {
            Path levelPath = this.c(saveName);
            Files.createDirectory(levelPath, new FileAttribute[0]);
            Files.deleteIfExists(levelPath);
            return true;
        }
        catch (IOException var3) {
            return false;
        }
    }

    public boolean b(String saveName) {
        try {
            return Files.isDirectory(this.c(saveName), new LinkOption[0]);
        }
        catch (InvalidPathException var3) {
            return false;
        }
    }

    public Path c(String saveName) {
        return this.h.resolve(saveName);
    }

    public Path c() {
        return this.h;
    }

    public Path d() {
        return this.i;
    }

    public ConversionSession validateAndCreateAccess(String saveName, ResourceKey<WorldDimension> dimensionType) throws IOException, ContentValidationException {
        List<ForbiddenSymlinkInfo> list;
        Path levelPath = this.c(saveName);
        List<ForbiddenSymlinkInfo> list2 = list = Boolean.getBoolean("paper.disableWorldSymlinkValidation") ? List.of() : this.k.a(levelPath, true);
        if (!list.isEmpty()) {
            throw new ContentValidationException(levelPath, list);
        }
        return new ConversionSession(saveName, levelPath, dimensionType);
    }

    public ConversionSession createAccess(String saveName, ResourceKey<WorldDimension> dimensionType) throws IOException {
        Path levelPath = this.c(saveName);
        return new ConversionSession(saveName, levelPath, dimensionType);
    }

    public DirectoryValidator e() {
        return this.k;
    }

    public static Path getStorageFolder(Path path, ResourceKey<WorldDimension> dimensionType) {
        if (dimensionType == WorldDimension.b) {
            return path;
        }
        if (dimensionType == WorldDimension.c) {
            return path.resolve("DIM-1");
        }
        if (dimensionType == WorldDimension.d) {
            return path.resolve("DIM1");
        }
        return path.resolve("dimensions").resolve(dimensionType.a().b()).resolve(dimensionType.a().a());
    }

    public record a(List<b> a) implements Iterable<b>
    {
        private final List<b> a;

        public boolean a() {
            return this.a.isEmpty();
        }

        @Override
        public Iterator<b> iterator() {
            return this.a.iterator();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "levels", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "levels", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "levels", "a"}, this, o2);
        }

        public List<b> b() {
            return this.a;
        }
    }

    public record b(Path a) {
        private final Path a;

        public String a() {
            return this.a.getFileName().toString();
        }

        public Path b() {
            return this.a(SavedFile.e);
        }

        public Path c() {
            return this.a(SavedFile.f);
        }

        public Path a(LocalDateTime dateTime) {
            return this.a.resolve(SavedFile.e.a() + "_corrupted_" + dateTime.format(d));
        }

        public Path b(LocalDateTime dateTime) {
            return this.a.resolve(SavedFile.e.a() + "_raw_" + dateTime.format(d));
        }

        public Path d() {
            return this.a(SavedFile.g);
        }

        public Path e() {
            return this.a(SavedFile.h);
        }

        public Path a(SavedFile resource) {
            return this.a.resolve(resource.a());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "path", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "path", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "path", "a"}, this, o2);
        }

        public Path f() {
            return this.a;
        }
    }

    public class ConversionSession
    implements AutoCloseable {
        final SessionLock b;
        public final b c;
        private final String d;
        private final Map<SavedFile, Path> e = Maps.newHashMap();
        public final ResourceKey<WorldDimension> dimensionType;

        ConversionSession(String levelId, Path levelDir, ResourceKey<WorldDimension> dimensionType) throws IOException {
            this.dimensionType = dimensionType;
            this.d = levelId;
            this.c = new b(levelDir);
            this.b = SessionLock.a(levelDir);
        }

        public long a() {
            try {
                return Files.getFileStore(this.c.a).getUsableSpace();
            }
            catch (Exception var2) {
                return Long.MAX_VALUE;
            }
        }

        public boolean b() {
            return this.a() < 0x4000000L;
        }

        public void c() {
            try {
                this.close();
            }
            catch (IOException var2) {
                c.warn("Failed to unlock access to level {}", (Object)this.f(), (Object)var2);
            }
        }

        public Convertable d() {
            return Convertable.this;
        }

        public b e() {
            return this.c;
        }

        public String f() {
            return this.d;
        }

        public Path a(SavedFile folderName) {
            return this.e.computeIfAbsent(folderName, this.c::a);
        }

        public Path a(ResourceKey<World> dimensionPath) {
            return Convertable.getStorageFolder(this.c.f(), this.dimensionType);
        }

        private void o() {
            if (!this.b.a()) {
                throw new IllegalStateException("Lock is no longer valid");
            }
        }

        public WorldNBTStorage g() {
            this.o();
            return new WorldNBTStorage(this, Convertable.this.j);
        }

        public WorldInfo a(Dynamic<?> dynamic) {
            this.o();
            return Convertable.this.a(dynamic, this.c, false);
        }

        public Dynamic<?> h() throws IOException {
            return this.b(false);
        }

        public Dynamic<?> i() throws IOException {
            return this.b(true);
        }

        private Dynamic<?> b(boolean useFallback) throws IOException {
            this.o();
            return Convertable.a(useFallback ? this.c.c() : this.c.b(), Convertable.this.j);
        }

        public void a(IRegistryCustom registries, SaveData serverConfiguration) {
            this.a(registries, serverConfiguration, null);
        }

        public void a(IRegistryCustom registries, SaveData serverConfiguration, @Nullable NBTTagCompound hostPlayerNBT) {
            NBTTagCompound compoundTag = serverConfiguration.a(registries, hostPlayerNBT);
            NBTTagCompound compoundTag1 = new NBTTagCompound();
            compoundTag1.a(Convertable.a, compoundTag);
            this.a(compoundTag1);
        }

        private void a(NBTTagCompound tag) {
            Path path = this.c.f();
            try {
                Path path1 = Files.createTempFile(path, "level", ".dat", new FileAttribute[0]);
                NBTCompressedStreamTools.a(tag, path1);
                Path path2 = this.c.c();
                Path path3 = this.c.b();
                SystemUtils.a(path3, path1, path2);
            }
            catch (Exception var6) {
                c.error("Failed to save level {}", (Object)path, (Object)var6);
            }
        }

        public Optional<Path> j() {
            return !this.b.a() ? Optional.empty() : Optional.of(this.c.d());
        }

        public void k() throws IOException {
            this.o();
            final Path path = this.c.e();
            c.info("Deleting level {}", (Object)this.d);
            for (int i2 = 1; i2 <= 5; ++i2) {
                c.info("Attempt {}...", (Object)i2);
                try {
                    Files.walkFileTree(this.c.f(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        public FileVisitResult a(Path file, BasicFileAttributes attrs) throws IOException {
                            if (!file.equals(path)) {
                                Convertable.c.debug("Deleting {}", (Object)file);
                                Files.delete(file);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        public FileVisitResult a(Path dir, @Nullable IOException exception) throws IOException {
                            if (exception != null) {
                                throw exception;
                            }
                            if (dir.equals(ConversionSession.this.c.f())) {
                                ConversionSession.this.b.close();
                                Files.deleteIfExists(path);
                            }
                            Files.delete(dir);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    break;
                }
                catch (IOException var6) {
                    if (i2 >= 5) {
                        throw var6;
                    }
                    c.warn("Failed to delete {}", (Object)this.c.f(), (Object)var6);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }

        public void a(String saveName) throws IOException {
            this.a((NBTTagCompound compoundTag) -> compoundTag.a("LevelName", saveName.trim()));
        }

        public void b(String saveName) throws IOException {
            this.a((NBTTagCompound compoundTag) -> {
                compoundTag.a("LevelName", saveName.trim());
                compoundTag.r("Player");
            });
        }

        private void a(Consumer<NBTTagCompound> modifier) throws IOException {
            this.o();
            NBTTagCompound levelDataTagRaw = Convertable.c(this.c.b());
            modifier.accept(levelDataTagRaw.p(Convertable.a));
            this.a(levelDataTagRaw);
        }

        public long l() throws IOException {
            this.o();
            String string = LocalDateTime.now().format(d) + "_" + this.d;
            Path backupPath = Convertable.this.d();
            try {
                FileUtils.c(backupPath);
            }
            catch (IOException var9) {
                throw new RuntimeException(var9);
            }
            Path path = backupPath.resolve(FileUtils.a(backupPath, string, ".zip"));
            try (final ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0])));){
                final Path path1 = Paths.get(this.d, new String[0]);
                Files.walkFileTree(this.c.f(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    public FileVisitResult a(Path file, BasicFileAttributes attrs) throws IOException {
                        if (file.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String string1 = path1.resolve(ConversionSession.this.c.f().relativize(file)).toString().replace('\\', '/');
                        ZipEntry zipEntry = new ZipEntry(string1);
                        zipOutputStream.putNextEntry(zipEntry);
                        com.google.common.io.Files.asByteSource((File)file.toFile()).copyTo((OutputStream)zipOutputStream);
                        zipOutputStream.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            return Files.size(path);
        }

        public boolean m() {
            return Files.exists(this.c.b(), new LinkOption[0]) || Files.exists(this.c.c(), new LinkOption[0]);
        }

        @Override
        public void close() throws IOException {
            this.b.close();
        }

        public boolean n() {
            return SystemUtils.a(this.c.b(), this.c.c(), this.c.a(LocalDateTime.now()), true);
        }

        @Nullable
        public Instant a(boolean useFallback) {
            return Convertable.d(useFallback ? this.c.c() : this.c.b());
        }
    }
}

