/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata.maps;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.papermc.paper.adventure.PaperAdventure;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.item.component.MapItemColor;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.MapIconBanner;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMapFrame;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R3.CraftServer;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R3.map.CraftMapCursor;
import org.bukkit.craftbukkit.v1_21_R3.map.CraftMapRenderer;
import org.bukkit.craftbukkit.v1_21_R3.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R3.map.RenderData;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCursor;
import org.slf4j.Logger;

public class WorldMap
extends PersistentBase {
    private static final Logger i = LogUtils.getLogger();
    private static final int j = 128;
    private static final int k = 64;
    public static final int a = 4;
    public static final int b = 256;
    private static final String l = "frame-";
    public int c;
    public int d;
    public ResourceKey<World> e;
    public boolean m;
    public boolean n;
    public byte f;
    public byte[] g = new byte[16384];
    public boolean h;
    private final RenderData vanillaRender = new RenderData();
    public final List<WorldMapHumanTracker> o = Lists.newArrayList();
    public final Map<EntityHuman, WorldMapHumanTracker> p = Maps.newHashMap();
    private final Map<String, MapIconBanner> q = Maps.newHashMap();
    public final Map<String, MapIcon> r = Maps.newLinkedHashMap();
    private final Map<String, WorldMapFrame> s = Maps.newHashMap();
    private int t;
    public final CraftMapView mapView;
    private final CraftServer server;
    public UUID uniqueId;
    public MapId id;

    public static PersistentBase.a<WorldMap> a() {
        return new PersistentBase.a<WorldMap>(() -> {
            throw new IllegalStateException("Should never create an empty map saved data");
        }, WorldMap::b, DataFixTypes.j);
    }

    private WorldMap(int x2, int z2, byte scale, boolean trackingPosition, boolean unlimitedTracking, boolean locked, ResourceKey<World> dimension) {
        this.f = scale;
        this.c = x2;
        this.d = z2;
        this.e = dimension;
        this.m = trackingPosition;
        this.n = unlimitedTracking;
        this.h = locked;
        this.mapView = new CraftMapView(this);
        this.server = (CraftServer)Bukkit.getServer();
        this.vanillaRender.buffer = this.g;
    }

    public static WorldMap a(double x2, double z2, byte scale, boolean trackingPosition, boolean unlimitedTracking, ResourceKey<World> dimension) {
        int i2 = 128 * (1 << scale);
        int floor = MathHelper.a((x2 + 64.0) / (double)i2);
        int floor1 = MathHelper.a((z2 + 64.0) / (double)i2);
        int i1 = floor * i2 + i2 / 2 - 64;
        int i22 = floor1 * i2 + i2 / 2 - 64;
        return new WorldMap(i1, i22, scale, trackingPosition, unlimitedTracking, false, dimension);
    }

    public static WorldMap a(byte scale, boolean locked, ResourceKey<World> dimension) {
        return new WorldMap(0, 0, scale, false, false, locked, dimension);
    }

    public static WorldMap b(NBTTagCompound tag, HolderLookup.a levelRegistry) {
        NBTNumber numericTag;
        NBTBase dimension = tag.c("dimension");
        if (dimension instanceof NBTNumber && (numericTag = (NBTNumber)dimension).g() >= 10) {
            UUID uuid;
            CraftWorld world;
            long least = tag.i("UUIDLeast");
            long most = tag.i("UUIDMost");
            dimension = least != 0L && most != 0L ? ((world = (CraftWorld)Bukkit.getWorld((UUID)(uuid = new UUID(most, least)))) != null ? NBTTagString.a("minecraft:" + world.getName().toLowerCase(Locale.ENGLISH)) : NBTTagString.a("bukkit:_invalidworld_")) : NBTTagString.a("bukkit:_invalidworld_");
        }
        DataResult<ResourceKey<World>> dataresult = DimensionManager.a(new Dynamic<NBTBase>(DynamicOpsNBT.a, dimension));
        ResourceKey resourceKey = dataresult.resultOrPartial(arg_0 -> ((Logger)i).error(arg_0)).orElseGet(() -> {
            UUID uniqueId;
            CraftWorld world;
            long least = tag.i("UUIDLeast");
            long most = tag.i("UUIDMost");
            if (least != 0L && most != 0L && (world = (CraftWorld)Bukkit.getWorld((UUID)(uniqueId = new UUID(most, least)))) != null) {
                return world.getHandle().ai();
            }
            throw new IllegalArgumentException("Invalid map dimension: " + String.valueOf(tag.c("dimension")));
        });
        int _int = tag.h("xCenter");
        int _int1 = tag.h("zCenter");
        byte b2 = (byte)MathHelper.a((int)tag.f("scale"), 0, 4);
        boolean flag = !tag.b("trackingPosition", 1) || tag.q("trackingPosition");
        boolean _boolean = tag.q("unlimitedTracking");
        boolean _boolean1 = tag.q("locked");
        WorldMap mapItemSavedData = new WorldMap(_int, _int1, b2, flag, _boolean, _boolean1, resourceKey);
        byte[] byteArray = tag.m("colors");
        if (byteArray.length == 16384) {
            mapItemSavedData.g = byteArray;
        }
        mapItemSavedData.vanillaRender.buffer = byteArray;
        RegistryOps<NBTBase> registryOps = levelRegistry.a(DynamicOpsNBT.a);
        for (MapIconBanner mapBanner : MapIconBanner.b.parse(registryOps, (Object)tag.c("banners")).resultOrPartial(string -> i.warn("Failed to parse map banner: '{}'", string)).orElse(List.of())) {
            mapItemSavedData.q.put(mapBanner.b(), mapBanner);
            mapItemSavedData.a(mapBanner.a(), null, mapBanner.b(), mapBanner.c().u(), mapBanner.c().w(), 180.0, mapBanner.e().orElse(null));
        }
        NBTTagList list1 = tag.c("frames", 10);
        for (int i2 = 0; i2 < list1.size(); ++i2) {
            WorldMapFrame mapFrame = WorldMapFrame.a(list1.a(i2));
            if (mapFrame == null) continue;
            mapItemSavedData.s.put(mapFrame.e(), mapFrame);
            mapItemSavedData.a(MapDecorationTypes.b, null, WorldMap.b(mapFrame.d()), mapFrame.b().u(), mapFrame.b().w(), mapFrame.c(), null);
        }
        return mapItemSavedData;
    }

    @Override
    public NBTTagCompound a(NBTTagCompound tag, HolderLookup.a registries) {
        MinecraftKey.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.e.a()).resultOrPartial(arg_0 -> ((Logger)i).error(arg_0)).ifPresent(dimension -> tag.a("dimension", (NBTBase)dimension));
        if (this.uniqueId == null) {
            for (org.bukkit.World world : this.server.getWorlds()) {
                CraftWorld cWorld = (CraftWorld)world;
                if (cWorld.getHandle().ai() != this.e) continue;
                this.uniqueId = cWorld.getUID();
                break;
            }
        }
        if (this.uniqueId != null) {
            tag.a("UUIDLeast", this.uniqueId.getLeastSignificantBits());
            tag.a("UUIDMost", this.uniqueId.getMostSignificantBits());
        }
        tag.a("xCenter", this.c);
        tag.a("zCenter", this.d);
        tag.a("scale", this.f);
        tag.a("colors", this.g);
        tag.a("trackingPosition", this.m);
        tag.a("unlimitedTracking", this.n);
        tag.a("locked", this.h);
        RegistryOps<NBTBase> registryOps = registries.a(DynamicOpsNBT.a);
        tag.a("banners", (NBTBase)MapIconBanner.b.encodeStart(registryOps, List.copyOf(this.q.values())).getOrThrow());
        NBTTagList listTag = new NBTTagList();
        for (WorldMapFrame mapFrame : this.s.values()) {
            listTag.add(mapFrame.a());
        }
        tag.a("frames", listTag);
        return tag;
    }

    public WorldMap b() {
        WorldMap mapItemSavedData = new WorldMap(this.c, this.d, this.f, this.m, this.n, true, this.e);
        mapItemSavedData.q.putAll(this.q);
        mapItemSavedData.r.putAll(this.r);
        mapItemSavedData.t = this.t;
        System.arraycopy(this.g, 0, mapItemSavedData.g, 0, this.g.length);
        return mapItemSavedData;
    }

    public WorldMap e() {
        return WorldMap.a(this.c, this.d, (byte)MathHelper.a(this.f + 1, 0, 4), this.m, this.n, this.e);
    }

    private static Predicate<ItemStack> a(ItemStack stack) {
        MapId mapId = stack.a(DataComponents.L);
        return itemStack -> itemStack == stack || itemStack.a(stack.h()) && Objects.equals(mapId, itemStack.a(DataComponents.L));
    }

    public void a(EntityHuman player, ItemStack mapStack) {
        if (!this.p.containsKey(player)) {
            WorldMapHumanTracker holdingPlayer = new WorldMapHumanTracker(player);
            this.p.put(player, holdingPlayer);
            this.o.add(holdingPlayer);
        }
        Predicate<ItemStack> predicate = WorldMap.a(mapStack);
        if (!player.gi().b(predicate)) {
            this.a(player.al().getString());
        }
        for (int i2 = 0; i2 < this.o.size(); ++i2) {
            WorldMapHumanTracker holdingPlayer1 = this.o.get(i2);
            EntityHuman player1 = holdingPlayer1.a;
            String string = player1.al().getString();
            if (!player1.dQ() && (player1.gi().b(predicate) || mapStack.H())) {
                if (!mapStack.H() && player1.dV().ai() == this.e && this.m) {
                    this.a(MapDecorationTypes.a, player1.dV(), string, player1.dA(), player1.dG(), player1.dL(), null);
                }
            } else {
                this.p.remove(player1);
                this.o.remove(holdingPlayer1);
                this.a(string);
            }
            if (player1.equals(player) || !WorldMap.b(player1)) continue;
            this.a(string);
        }
        if (mapStack.H() && this.m) {
            EntityItemFrame frame = mapStack.I();
            BlockPosition pos = frame.p();
            WorldMapFrame mapFrame = this.s.get(WorldMapFrame.a(pos));
            if (mapFrame != null && frame.ar() != mapFrame.d() && this.s.containsKey(mapFrame.e())) {
                this.a(WorldMap.b(mapFrame.d()));
            }
            WorldMapFrame mapFrame1 = new WorldMapFrame(pos, frame.cO().e() * 90, frame.ar());
            if (this.r.size() < player.dV().paperConfig().maps.itemFrameCursorLimit) {
                this.a(MapDecorationTypes.b, player.dV(), WorldMap.b(frame.ar()), pos.u(), pos.w(), frame.cO().e() * 90, null);
                this.s.put(mapFrame1.e(), mapFrame1);
            }
        }
        MapDecorations mapDecorations = mapStack.a(DataComponents.M, MapDecorations.a);
        if (!this.r.keySet().containsAll(mapDecorations.a().keySet())) {
            mapDecorations.a().forEach((string1, entry) -> {
                if (!this.r.containsKey(string1)) {
                    this.a(entry.a(), player.dV(), (String)string1, entry.b(), entry.c(), entry.d(), null);
                }
            });
        }
    }

    private static boolean b(EntityHuman player) {
        for (EnumItemSlot equipmentSlot : EnumItemSlot.values()) {
            if (equipmentSlot == EnumItemSlot.a || equipmentSlot == EnumItemSlot.b || !player.a(equipmentSlot).a(TagsItem.cp)) continue;
            return true;
        }
        return false;
    }

    private void a(String identifier) {
        MapIcon mapDecoration = this.r.remove(identifier);
        if (mapDecoration != null && mapDecoration.c().a().f()) {
            --this.t;
        }
        if (mapDecoration != null) {
            this.i();
        }
    }

    public static void a(ItemStack stack, BlockPosition pos, String type, Holder<MapDecorationType> mapDecorationType) {
        MapDecorations.a entry = new MapDecorations.a(mapDecorationType, pos.u(), pos.w(), 180.0f);
        stack.a(DataComponents.M, MapDecorations.a, decorations -> decorations.a(type, entry));
        if (mapDecorationType.a().a()) {
            stack.b(DataComponents.K, new MapItemColor(mapDecorationType.a().d()));
        }
    }

    private void a(Holder<MapDecorationType> decorationType, @Nullable GeneratorAccess level, String id, double x2, double z2, double yRot, @Nullable IChatBaseComponent displayName) {
        int i2 = 1 << this.f;
        float f2 = (float)(x2 - (double)this.c) / (float)i2;
        float f1 = (float)(z2 - (double)this.d) / (float)i2;
        b mapDecorationLocation = this.a(decorationType, level, yRot, f2, f1);
        if (mapDecorationLocation == null) {
            this.a(id);
        } else {
            MapIcon mapDecoration1;
            MapIcon mapDecoration = new MapIcon(mapDecorationLocation.a(), mapDecorationLocation.b(), mapDecorationLocation.c(), mapDecorationLocation.d(), Optional.ofNullable(displayName));
            if (!mapDecoration.equals(mapDecoration1 = this.r.put(id, mapDecoration))) {
                if (mapDecoration1 != null && mapDecoration1.c().a().f()) {
                    --this.t;
                }
                if (mapDecorationLocation.a().a().f()) {
                    ++this.t;
                }
                this.i();
            }
        }
    }

    @Nullable
    private b a(Holder<MapDecorationType> decorationType, @Nullable GeneratorAccess level, double yRot, float x2, float z2) {
        byte b2 = WorldMap.a(x2);
        byte b1 = WorldMap.a(z2);
        if (decorationType.a(MapDecorationTypes.a)) {
            Pair<Holder<MapDecorationType>, Byte> pair = this.b(decorationType, level, yRot, x2, z2);
            return pair == null ? null : new b((Holder)pair.getFirst(), b2, b1, (Byte)pair.getSecond());
        }
        return !WorldMap.a(x2, z2) && !this.n ? null : new b(decorationType, b2, b1, this.a(level, yRot));
    }

    @Nullable
    private Pair<Holder<MapDecorationType>, Byte> b(Holder<MapDecorationType> decorationType, @Nullable GeneratorAccess level, double yRot, float x2, float z2) {
        if (WorldMap.a(x2, z2)) {
            return Pair.of(decorationType, (Object)this.a(level, yRot));
        }
        Holder<MapDecorationType> holder = this.b(x2, z2);
        return holder == null ? null : Pair.of(holder, (Object)0);
    }

    private byte a(@Nullable GeneratorAccess level, double yRot) {
        if (this.e == World.j && level != null) {
            int i2 = (int)(level.D_().d() / 10L);
            return (byte)(i2 * i2 * 34187121 + i2 * 121 >> 15 & 0xF);
        }
        double d2 = yRot < 0.0 ? yRot - 8.0 : yRot + 8.0;
        return (byte)(d2 * 16.0 / 360.0);
    }

    private static boolean a(float x2, float z2) {
        int i2 = 63;
        return x2 >= -63.0f && z2 >= -63.0f && x2 <= 63.0f && z2 <= 63.0f;
    }

    @Nullable
    private Holder<MapDecorationType> b(float x2, float z2) {
        boolean flag;
        int i2 = 320;
        boolean bl = flag = Math.abs(x2) < 320.0f && Math.abs(z2) < 320.0f;
        if (flag) {
            return MapDecorationTypes.g;
        }
        return this.n ? MapDecorationTypes.h : null;
    }

    private static byte a(float coord) {
        int i2 = 63;
        if (coord <= -63.0f) {
            return -128;
        }
        return coord >= 63.0f ? (byte)127 : (byte)((double)(coord * 2.0f) + 0.5);
    }

    @Nullable
    public Packet<?> a(MapId mapId, EntityHuman player) {
        WorldMapHumanTracker holdingPlayer = this.p.get(player);
        return holdingPlayer == null ? null : holdingPlayer.a(mapId);
    }

    public void a(int x2, int z2) {
        this.c();
        for (WorldMapHumanTracker holdingPlayer : this.o) {
            holdingPlayer.a(x2, z2);
        }
    }

    public void i() {
        this.c();
        this.o.forEach(WorldMapHumanTracker::b);
    }

    public WorldMapHumanTracker a(EntityHuman player) {
        WorldMapHumanTracker holdingPlayer = this.p.get(player);
        if (holdingPlayer == null) {
            holdingPlayer = new WorldMapHumanTracker(player);
            this.p.put(player, holdingPlayer);
            this.o.add(holdingPlayer);
        }
        return holdingPlayer;
    }

    public boolean a(GeneratorAccess accessor, BlockPosition pos) {
        double d2 = (double)pos.u() + 0.5;
        double d1 = (double)pos.w() + 0.5;
        int i2 = 1 << this.f;
        double d22 = (d2 - (double)this.c) / (double)i2;
        double d3 = (d1 - (double)this.d) / (double)i2;
        int i1 = 63;
        if (d22 >= -63.0 && d3 >= -63.0 && d22 <= 63.0 && d3 <= 63.0) {
            MapIconBanner mapBanner = MapIconBanner.a(accessor, pos);
            if (mapBanner == null) {
                return false;
            }
            if (this.q.remove(mapBanner.b(), mapBanner)) {
                this.a(mapBanner.b());
                return true;
            }
            if (!this.a(((World)accessor).paperConfig().maps.itemFrameCursorLimit)) {
                this.q.put(mapBanner.b(), mapBanner);
                this.a(mapBanner.a(), accessor, mapBanner.b(), d2, d1, 180.0, mapBanner.e().orElse(null));
                return true;
            }
        }
        return false;
    }

    public void a(IBlockAccess reader, int x2, int z2) {
        Iterator<MapIconBanner> iterator = this.q.values().iterator();
        while (iterator.hasNext()) {
            MapIconBanner mapBanner1;
            MapIconBanner mapBanner = iterator.next();
            if (mapBanner.c().u() != x2 || mapBanner.c().w() != z2 || mapBanner.equals(mapBanner1 = MapIconBanner.a(reader, mapBanner.c()))) continue;
            iterator.remove();
            this.a(mapBanner.b());
        }
    }

    public Collection<MapIconBanner> f() {
        return this.q.values();
    }

    public void a(BlockPosition pos, int entityId) {
        this.a(WorldMap.b(entityId));
        this.s.remove(WorldMapFrame.a(pos));
        this.c();
    }

    public boolean a(int x2, int z2, byte color) {
        byte b2 = this.g[x2 + z2 * 128];
        if (b2 != color) {
            this.b(x2, z2, color);
            return true;
        }
        return false;
    }

    public void b(int x2, int z2, byte color) {
        this.g[x2 + z2 * 128] = color;
        this.a(x2, z2);
    }

    public boolean g() {
        for (MapIcon mapDecoration : this.r.values()) {
            if (!mapDecoration.c().a().e()) continue;
            return true;
        }
        return false;
    }

    public void a(List<MapIcon> decorations) {
        this.r.clear();
        this.t = 0;
        for (int i2 = 0; i2 < decorations.size(); ++i2) {
            MapIcon mapDecoration = decorations.get(i2);
            this.r.put("icon-" + i2, mapDecoration);
            if (!mapDecoration.c().a().f()) continue;
            ++this.t;
        }
    }

    public Iterable<MapIcon> h() {
        return this.r.values();
    }

    public boolean a(int trackedCount) {
        return this.t >= trackedCount;
    }

    private static String b(int entityId) {
        return l + entityId;
    }

    public class WorldMapHumanTracker {
        public final EntityHuman a;
        private boolean d = true;
        private int e;
        private int f;
        private int g = 127;
        private int h = 127;
        private boolean i = true;
        private int j;
        public int b;

        WorldMapHumanTracker(EntityHuman player) {
            this.a = player;
        }

        private c createPatch(byte[] buffer) {
            int i2 = this.e;
            int i1 = this.f;
            int i22 = this.g + 1 - this.e;
            int i3 = this.h + 1 - this.f;
            byte[] bytes = new byte[i22 * i3];
            for (int i4 = 0; i4 < i22; ++i4) {
                for (int i5 = 0; i5 < i3; ++i5) {
                    bytes[i4 + i5 * i22] = buffer[i2 + i4 + (i1 + i5) * 128];
                }
            }
            return new c(i2, i1, i22, i3, bytes);
        }

        @Nullable
        Packet<?> a(MapId mapId) {
            ArrayList<MapIcon> collection;
            c mapPatch;
            RenderData render;
            if (!this.d && this.j % 5 != 0) {
                ++this.j;
                return null;
            }
            boolean vanillaMaps = this.shouldUseVanillaMap();
            RenderData renderData = render = !vanillaMaps ? WorldMap.this.mapView.render((CraftPlayer)this.a.getBukkitEntity()) : WorldMap.this.vanillaRender;
            if (this.d) {
                this.d = false;
                mapPatch = this.createPatch(render.buffer);
            } else {
                mapPatch = null;
            }
            if ((!vanillaMaps || this.i) && this.j++ % 5 == 0) {
                this.i = false;
                ArrayList<MapIcon> icons = new ArrayList<MapIcon>();
                if (vanillaMaps) {
                    this.addSeenPlayers(icons);
                }
                for (MapCursor cursor : render.cursors) {
                    if (!cursor.isVisible()) continue;
                    icons.add(new MapIcon(CraftMapCursor.CraftType.bukkitToMinecraftHolder(cursor.getType()), cursor.getX(), cursor.getY(), cursor.getDirection(), Optional.ofNullable(PaperAdventure.asVanilla(cursor.caption()))));
                }
                collection = icons;
            } else {
                collection = null;
            }
            return collection == null && mapPatch == null ? null : new PacketPlayOutMap(mapId, WorldMap.this.f, WorldMap.this.h, collection, mapPatch);
        }

        void a(int x2, int z2) {
            if (this.d) {
                this.e = Math.min(this.e, x2);
                this.f = Math.min(this.f, z2);
                this.g = Math.max(this.g, x2);
                this.h = Math.max(this.h, z2);
            } else {
                this.d = true;
                this.e = x2;
                this.f = z2;
                this.g = x2;
                this.h = z2;
            }
        }

        private void b() {
            this.i = true;
        }

        private void addSeenPlayers(Collection<MapIcon> icons) {
            Player player = (Player)this.a.getBukkitEntity();
            WorldMap.this.r.forEach((name, mapIcon) -> {
                Player other = Bukkit.getPlayerExact((String)name);
                if (other == null || player.canSee(other)) {
                    icons.add((MapIcon)mapIcon);
                }
            });
        }

        private boolean shouldUseVanillaMap() {
            return WorldMap.this.mapView.getRenderers().size() == 1 && WorldMap.this.mapView.getRenderers().getFirst().getClass() == CraftMapRenderer.class;
        }
    }

    record b(Holder<MapDecorationType> a, byte b, byte c, byte d) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "type;x;y;rot", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "type;x;y;rot", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "type;x;y;rot", "a", "b", "c", "d"}, this, o2);
        }
    }

    public static final class c
    extends Record {
        private final int b;
        private final int c;
        private final int d;
        private final int e;
        private final byte[] f;
        public static final StreamCodec<ByteBuf, Optional<c>> a = StreamCodec.a(c::a, c::a);

        public c(int startX, int startY, int width, int height, byte[] mapColors) {
            this.b = startX;
            this.c = startY;
            this.d = width;
            this.e = height;
            this.f = mapColors;
        }

        private static void a(ByteBuf buffer, Optional<c> mapPatch) {
            if (mapPatch.isPresent()) {
                c mapPatch1 = mapPatch.get();
                buffer.writeByte(mapPatch1.d);
                buffer.writeByte(mapPatch1.e);
                buffer.writeByte(mapPatch1.b);
                buffer.writeByte(mapPatch1.c);
                PacketDataSerializer.a(buffer, mapPatch1.f);
            } else {
                buffer.writeByte(0);
            }
        }

        private static Optional<c> a(ByteBuf buffer) {
            short unsignedByte = buffer.readUnsignedByte();
            if (unsignedByte > 0) {
                short unsignedByte1 = buffer.readUnsignedByte();
                short unsignedByte2 = buffer.readUnsignedByte();
                short unsignedByte3 = buffer.readUnsignedByte();
                byte[] byteArray = PacketDataSerializer.a(buffer);
                return Optional.of(new c(unsignedByte2, unsignedByte3, unsignedByte, unsignedByte1, byteArray));
            }
            return Optional.empty();
        }

        public void a(WorldMap savedData) {
            for (int i2 = 0; i2 < this.d; ++i2) {
                for (int i1 = 0; i1 < this.e; ++i1) {
                    savedData.b(this.b + i2, this.c + i1, this.f[i2 + i1 * this.d]);
                }
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "startX;startY;width;height;mapColors", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "startX;startY;width;height;mapColors", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "startX;startY;width;height;mapColors", "b", "c", "d", "e", "f"}, this, o2);
        }

        public int a() {
            return this.b;
        }

        public int b() {
            return this.c;
        }

        public int c() {
            return this.d;
        }

        public int d() {
            return this.e;
        }

        public byte[] e() {
            return this.f;
        }
    }
}

