/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.redstone.Orientation;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.block.data.CraftBlockData;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;

public interface NeighborUpdater {
    public static final EnumDirection[] a = new EnumDirection[]{EnumDirection.e, EnumDirection.f, EnumDirection.a, EnumDirection.b, EnumDirection.c, EnumDirection.d};

    public void a(EnumDirection var1, IBlockData var2, BlockPosition var3, BlockPosition var4, int var5, int var6);

    public void a(BlockPosition var1, Block var2, @Nullable Orientation var3);

    public void a(IBlockData var1, BlockPosition var2, Block var3, @Nullable Orientation var4, boolean var5);

    default public void a(BlockPosition pos, Block block, @Nullable EnumDirection facing, @Nullable Orientation orientation) {
        for (EnumDirection direction : a) {
            if (direction == facing) continue;
            this.a(pos.a(direction), block, null);
        }
    }

    public static void a(GeneratorAccess level, EnumDirection direction, BlockPosition pos, BlockPosition neighborPos, IBlockData neighborState, int flags, int recursionLeft) {
        IBlockData blockState = level.a_(pos);
        if ((flags & 0x80) == 0 || !blockState.a(Blocks.cE)) {
            IBlockData blockState1 = blockState.a(level, level, pos, direction, neighborPos, neighborState, level.H_());
            Block.a(blockState, blockState1, level, pos, flags, recursionLeft);
        }
    }

    public static void a(World level, IBlockData state, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        NeighborUpdater.executeUpdate(level, state, pos, neighborBlock, orientation, movedByPiston, pos);
    }

    public static void executeUpdate(World level, IBlockData state, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston, BlockPosition sourcePos) {
        try {
            CraftWorld cworld = level.getWorld();
            if (cworld != null) {
                BlockPhysicsEvent event = new BlockPhysicsEvent((org.bukkit.block.Block)CraftBlock.at(level, pos), (BlockData)CraftBlockData.fromData(state), (org.bukkit.block.Block)CraftBlock.at(level, sourcePos));
                level.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
            }
            state.a(level, pos, neighborBlock, orientation, movedByPiston);
        }
        catch (StackOverflowError ex) {
            World.lastPhysicsProblem = new BlockPosition(pos);
        }
        catch (Throwable var9) {
            CrashReport crashReport = CrashReport.a(var9, "Exception while updating neighbours");
            CrashReportSystemDetails crashReportCategory = crashReport.a("Block being updated");
            crashReportCategory.a("Source block type", () -> {
                try {
                    return String.format(Locale.ROOT, "ID #%s (%s // %s)", BuiltInRegistries.e.b(neighborBlock), neighborBlock.v(), neighborBlock.getClass().getCanonicalName());
                }
                catch (Throwable var2x) {
                    return "ID #" + String.valueOf(BuiltInRegistries.e.b(neighborBlock));
                }
            });
            CrashReportSystemDetails.a(crashReportCategory, level, pos, state);
            throw new ReportedException(crashReport);
        }
    }
}

