/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockRedstoneWire;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyRedstoneSide;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.redstone.RedstoneWireEvaluator;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class ExperimentalRedstoneWireEvaluator
extends RedstoneWireEvaluator {
    private final Deque<BlockPosition> b = new ArrayDeque<BlockPosition>();
    private final Deque<BlockPosition> c = new ArrayDeque<BlockPosition>();
    private final Object2IntMap<BlockPosition> d = new Object2IntLinkedOpenHashMap();

    public ExperimentalRedstoneWireEvaluator(BlockRedstoneWire wireBlock) {
        super(wireBlock);
    }

    @Override
    public void a(World level, BlockPosition pos, IBlockData state, @Nullable Orientation orientation, boolean updateShape) {
        Orientation initialOrientation = ExperimentalRedstoneWireEvaluator.a(level, orientation);
        this.a(level, pos, initialOrientation);
        ObjectIterator objectIterator = this.d.object2IntEntrySet().iterator();
        boolean flag = true;
        while (objectIterator.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)objectIterator.next();
            BlockPosition blockPos = (BlockPosition)entry.getKey();
            int intValue = entry.getIntValue();
            int i2 = ExperimentalRedstoneWireEvaluator.b(intValue);
            IBlockData blockState = level.a_(blockPos);
            int oldPower = blockState.c(BlockRedstoneWire.f);
            if (oldPower != i2) {
                BlockRedstoneEvent event = new BlockRedstoneEvent((Block)CraftBlock.at(level, blockPos), oldPower, i2);
                level.getCraftServer().getPluginManager().callEvent((Event)event);
                i2 = event.getNewCurrent();
            }
            if (blockState.a(this.a) && oldPower != i2) {
                int i1 = 2;
                if (!updateShape || !flag) {
                    i1 |= 0x80;
                }
                level.a(blockPos, (IBlockData)blockState.b(BlockRedstoneWire.f, i2), i1);
            } else {
                objectIterator.remove();
            }
            flag = false;
        }
        this.a(level);
    }

    private void a(World level) {
        this.d.forEach((blockPos, integer) -> {
            Orientation orientation = ExperimentalRedstoneWireEvaluator.a(integer);
            IBlockData blockState = level.a_((BlockPosition)blockPos);
            for (EnumDirection direction : orientation.f()) {
                if (!ExperimentalRedstoneWireEvaluator.a(blockState, direction)) continue;
                BlockPosition blockPos1 = blockPos.a(direction);
                IBlockData blockState1 = level.a_(blockPos1);
                Orientation orientation1 = orientation.c(direction);
                level.a(blockState1, blockPos1, this.a, orientation1, false);
                if (!blockState1.d(level, blockPos1)) continue;
                for (EnumDirection direction1 : orientation1.f()) {
                    if (direction1 == direction.g()) continue;
                    level.b(blockPos1.a(direction1), this.a, orientation1.c(direction1));
                }
            }
        });
    }

    private static boolean a(IBlockData state, EnumDirection direction) {
        BlockStateEnum<BlockPropertyRedstoneSide> enumProperty = BlockRedstoneWire.g.get(direction);
        return enumProperty == null ? direction == EnumDirection.a : state.c(enumProperty).a();
    }

    private static Orientation a(World level, @Nullable Orientation orientation) {
        Orientation orientation1 = orientation != null ? orientation : Orientation.a(level.A);
        return orientation1.a(EnumDirection.b).a(Orientation.a.a);
    }

    private void a(World level, BlockPosition pos, Orientation orientation) {
        IBlockData blockState = level.a_(pos);
        if (blockState.a(this.a)) {
            this.a(pos, blockState.c(BlockRedstoneWire.f), orientation);
            this.b.add(pos);
        } else {
            this.a(level, pos, 0, orientation, true);
        }
        while (!this.b.isEmpty()) {
            int i1;
            int incomingWireSignal;
            BlockPosition blockPos = this.b.removeFirst();
            int _int = this.d.getInt((Object)blockPos);
            Orientation orientation1 = ExperimentalRedstoneWireEvaluator.a(_int);
            int i2 = ExperimentalRedstoneWireEvaluator.b(_int);
            int blockSignal = this.a(level, blockPos);
            int max = Math.max(blockSignal, incomingWireSignal = this.b(level, blockPos));
            if (max < i2) {
                if (blockSignal > 0 && !this.c.contains(blockPos)) {
                    this.c.add(blockPos);
                }
                i1 = 0;
            } else {
                i1 = max;
            }
            if (i1 != i2) {
                this.a(blockPos, i1, orientation1);
            }
            this.a(level, blockPos, i1, orientation1, i2 > max);
        }
        while (!this.c.isEmpty()) {
            BlockPosition blockPosx = this.c.removeFirst();
            int _intx = this.d.getInt((Object)blockPosx);
            int i2 = ExperimentalRedstoneWireEvaluator.b(_intx);
            int ix = this.a(level, blockPosx);
            int blockSignalx = this.b(level, blockPosx);
            int incomingWireSignalx = Math.max(ix, blockSignalx);
            Orientation orientation2 = ExperimentalRedstoneWireEvaluator.a(_intx);
            if (incomingWireSignalx > i2) {
                this.a(blockPosx, incomingWireSignalx, orientation2);
            } else if (incomingWireSignalx < i2) {
                throw new IllegalStateException("Turning off wire while trying to turn it on. Should not happen.");
            }
            this.a(level, blockPosx, incomingWireSignalx, orientation2, false);
        }
    }

    private static int a(Orientation orientation, int power) {
        return orientation.i() << 4 | power;
    }

    private static Orientation a(int data) {
        return Orientation.a(data >> 4);
    }

    private static int b(int data) {
        return data & 0xF;
    }

    private void a(BlockPosition pos, int power, Orientation orientation) {
        this.d.compute((Object)pos, (blockPos, integer) -> integer == null ? ExperimentalRedstoneWireEvaluator.a(orientation, power) : ExperimentalRedstoneWireEvaluator.a(ExperimentalRedstoneWireEvaluator.a(integer), power));
    }

    private void a(World level, BlockPosition pos, int power, Orientation orientation, boolean canTurnOff) {
        BlockPosition blockPos;
        for (EnumDirection direction : orientation.g()) {
            blockPos = pos.a(direction);
            this.b(level, blockPos, power, orientation.b(direction), canTurnOff);
        }
        for (EnumDirection direction : orientation.h()) {
            blockPos = pos.a(direction);
            boolean isRedstoneConductor = level.a_(blockPos).d(level, blockPos);
            for (EnumDirection direction1 : orientation.g()) {
                BlockPosition blockPos2;
                BlockPosition blockPos1 = pos.a(direction1);
                if (direction == EnumDirection.b && !isRedstoneConductor) {
                    blockPos2 = blockPos.a(direction1);
                    this.b(level, blockPos2, power, orientation.b(direction1), canTurnOff);
                    continue;
                }
                if (direction != EnumDirection.a || level.a_(blockPos1).d(level, blockPos1)) continue;
                blockPos2 = blockPos.a(direction1);
                this.b(level, blockPos2, power, orientation.b(direction1), canTurnOff);
            }
        }
    }

    private void b(World level, BlockPosition pos, int power, Orientation orientation, boolean canTurnOff) {
        IBlockData blockState = level.a_(pos);
        if (blockState.a(this.a)) {
            int wireSignal = this.a(pos, blockState);
            if (wireSignal < power - 1 && !this.c.contains(pos)) {
                this.c.add(pos);
                this.a(pos, wireSignal, orientation);
            }
            if (canTurnOff && wireSignal > power && !this.b.contains(pos)) {
                this.b.add(pos);
                this.a(pos, wireSignal, orientation);
            }
        }
    }

    @Override
    protected int a(BlockPosition pos, IBlockData state) {
        int orDefault = this.d.getOrDefault((Object)pos, -1);
        return orDefault != -1 ? ExperimentalRedstoneWireEvaluator.b(orDefault) : super.a(pos, state);
    }
}

