/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.apache.commons.lang3.mutable.MutableInt;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R3.util.BlockStateListPopulator;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.world.PortalCreateEvent;

public class BlockPortalShape {
    private static final int c = 2;
    public static final int a = 21;
    private static final int d = 3;
    public static final int b = 21;
    private static final BlockBase.f e = (state, level, pos) -> state.a(Blocks.cv);
    private static final float f = 4.0f;
    private static final double g = 1.0;
    private final EnumDirection.EnumAxis h;
    private final EnumDirection i;
    private final int j;
    private final BlockPosition k;
    private final int l;
    private final int m;
    private final BlockStateListPopulator blocks;

    private BlockPortalShape(EnumDirection.EnumAxis axis, int numPortalBlocks, EnumDirection rightDir, BlockPosition bottomLeft, int width, int height, BlockStateListPopulator blocks) {
        this.blocks = blocks;
        this.h = axis;
        this.j = numPortalBlocks;
        this.i = rightDir;
        this.k = bottomLeft;
        this.m = width;
        this.l = height;
    }

    public static Optional<BlockPortalShape> a(GeneratorAccess level, BlockPosition bottomLeft, EnumDirection.EnumAxis axis) {
        return BlockPortalShape.a(level, bottomLeft, (BlockPortalShape shape) -> shape.a() && shape.j == 0, axis);
    }

    public static Optional<BlockPortalShape> a(GeneratorAccess level, BlockPosition bottomLeft, Predicate<BlockPortalShape> predicate, EnumDirection.EnumAxis axis) {
        Optional<BlockPortalShape> optional = Optional.of(BlockPortalShape.a((IBlockAccess)level, bottomLeft, axis)).filter(predicate);
        if (optional.isPresent()) {
            return optional;
        }
        EnumDirection.EnumAxis axis1 = axis == EnumDirection.EnumAxis.a ? EnumDirection.EnumAxis.c : EnumDirection.EnumAxis.a;
        return Optional.of(BlockPortalShape.a((IBlockAccess)level, bottomLeft, axis1)).filter(predicate);
    }

    public static BlockPortalShape a(IBlockAccess level, BlockPosition bottomLeft, EnumDirection.EnumAxis axis) {
        BlockStateListPopulator blocks;
        EnumDirection direction = axis == EnumDirection.EnumAxis.a ? EnumDirection.e : EnumDirection.d;
        BlockPosition blockPos = BlockPortalShape.calculateBottomLeft(level, direction, bottomLeft, blocks = new BlockStateListPopulator(((GeneratorAccess)level).getMinecraftWorld()));
        if (blockPos == null) {
            return new BlockPortalShape(axis, 0, direction, bottomLeft, 0, 0, blocks);
        }
        int i2 = BlockPortalShape.calculateWidth(level, blockPos, direction, blocks);
        if (i2 == 0) {
            return new BlockPortalShape(axis, 0, direction, blockPos, 0, 0, blocks);
        }
        MutableInt mutableInt = new MutableInt();
        int i1 = BlockPortalShape.calculateHeight(level, blockPos, direction, i2, mutableInt, blocks);
        return new BlockPortalShape(axis, mutableInt.getValue(), direction, blockPos, i2, i1, blocks);
    }

    @Nullable
    private static BlockPosition calculateBottomLeft(IBlockAccess level, EnumDirection direction, BlockPosition pos, BlockStateListPopulator blocks) {
        int max = Math.max(level.L_(), pos.v() - 21);
        while (pos.v() > max && BlockPortalShape.a(level.a_(pos.e()))) {
            pos = pos.e();
        }
        EnumDirection opposite = direction.g();
        int i2 = BlockPortalShape.getDistanceUntilEdgeAboveFrame(level, pos, opposite, blocks) - 1;
        return i2 < 0 ? null : pos.a(opposite, i2);
    }

    private static int calculateWidth(IBlockAccess level, BlockPosition bottomLeft, EnumDirection direction, BlockStateListPopulator blocks) {
        int distanceUntilEdgeAboveFrame = BlockPortalShape.getDistanceUntilEdgeAboveFrame(level, bottomLeft, direction, blocks);
        return distanceUntilEdgeAboveFrame >= 2 && distanceUntilEdgeAboveFrame <= 21 ? distanceUntilEdgeAboveFrame : 0;
    }

    private static int getDistanceUntilEdgeAboveFrame(IBlockAccess level, BlockPosition pos, EnumDirection direction, BlockStateListPopulator blocks) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i2 = 0; i2 <= 21; ++i2) {
            mutableBlockPos.g(pos).c(direction, i2);
            IBlockData blockState = level.a_(mutableBlockPos);
            if (!BlockPortalShape.a(blockState)) {
                if (!e.test(blockState, level, mutableBlockPos)) break;
                blocks.a((BlockPosition)mutableBlockPos, blockState, 18);
                return i2;
            }
            IBlockData blockState1 = level.a_(mutableBlockPos.c(EnumDirection.a));
            if (!e.test(blockState1, level, mutableBlockPos)) break;
            blocks.a((BlockPosition)mutableBlockPos, blockState1, 18);
        }
        return 0;
    }

    private static int calculateHeight(IBlockAccess level, BlockPosition pos, EnumDirection direction, int width, MutableInt portalBlocks, BlockStateListPopulator blocks) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        int distanceUntilTop = BlockPortalShape.getDistanceUntilTop(level, pos, direction, mutableBlockPos, width, portalBlocks, blocks);
        return distanceUntilTop >= 3 && distanceUntilTop <= 21 && BlockPortalShape.hasTopFrame(level, pos, direction, mutableBlockPos, width, distanceUntilTop, blocks) ? distanceUntilTop : 0;
    }

    private static boolean hasTopFrame(IBlockAccess level, BlockPosition pos, EnumDirection direction, BlockPosition.MutableBlockPosition checkPos, int width, int distanceUntilTop, BlockStateListPopulator blocks) {
        for (int i2 = 0; i2 < width; ++i2) {
            BlockPosition.MutableBlockPosition mutableBlockPos = checkPos.g(pos).c(EnumDirection.b, distanceUntilTop).c(direction, i2);
            if (!e.test(level.a_(mutableBlockPos), level, mutableBlockPos)) {
                return false;
            }
            blocks.a((BlockPosition)mutableBlockPos, level.a_(mutableBlockPos), 18);
        }
        return true;
    }

    private static int getDistanceUntilTop(IBlockAccess level, BlockPosition pos, EnumDirection direction, BlockPosition.MutableBlockPosition checkPos, int width, MutableInt portalBlocks, BlockStateListPopulator blocks) {
        for (int i2 = 0; i2 < 21; ++i2) {
            checkPos.g(pos).c(EnumDirection.b, i2).c(direction, -1);
            if (!e.test(level.a_(checkPos), level, checkPos)) {
                return i2;
            }
            checkPos.g(pos).c(EnumDirection.b, i2).c(direction, width);
            if (!e.test(level.a_(checkPos), level, checkPos)) {
                return i2;
            }
            for (int i1 = 0; i1 < width; ++i1) {
                checkPos.g(pos).c(EnumDirection.b, i2).c(direction, i1);
                IBlockData blockState = level.a_(checkPos);
                if (!BlockPortalShape.a(blockState)) {
                    return i2;
                }
                if (!blockState.a(Blocks.eq)) continue;
                portalBlocks.increment();
            }
            blocks.a((BlockPosition)checkPos.g(pos).c(EnumDirection.b, i2).c(direction, -1), level.a_(checkPos), 18);
            blocks.a((BlockPosition)checkPos.g(pos).c(EnumDirection.b, i2).c(direction, i2), level.a_(checkPos), 18);
        }
        return 21;
    }

    private static boolean a(IBlockData state) {
        return state.l() || state.a(TagsBlock.aN) || state.a(Blocks.eq);
    }

    public boolean a() {
        return this.m >= 2 && this.m <= 21 && this.l >= 3 && this.l <= 21;
    }

    public boolean createPortalBlocks(GeneratorAccess level, net.minecraft.world.entity.Entity entity) {
        CraftWorld bworld = level.getMinecraftWorld().getWorld();
        IBlockData blockState = (IBlockData)Blocks.eq.m().b(BlockPortal.b, this.h);
        BlockPosition.c(this.k, this.k.a(EnumDirection.b, this.l - 1).a(this.i, this.m - 1)).forEach(pos -> this.blocks.a((BlockPosition)pos, blockState, 18));
        PortalCreateEvent event = new PortalCreateEvent(this.blocks.getList(), (World)bworld, (Entity)(entity == null ? null : entity.getBukkitEntity()), PortalCreateEvent.CreateReason.FIRE);
        level.getMinecraftWorld().p().server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        BlockPosition.c(this.k, this.k.a(EnumDirection.b, this.l - 1).a(this.i, this.m - 1)).forEach(pos -> level.a((BlockPosition)pos, blockState, 18));
        return true;
    }

    public boolean b() {
        return this.a() && this.j == this.m * this.l;
    }

    public static Vec3D a(BlockUtil.Rectangle foundRectangle, EnumDirection.EnumAxis axis, Vec3D pos, EntitySize entityDimensions) {
        EnumDirection.EnumAxis axis1;
        double d3;
        double d2;
        double d4 = (double)foundRectangle.b - (double)entityDimensions.a();
        double d1 = (double)foundRectangle.c - (double)entityDimensions.b();
        BlockPosition blockPos = foundRectangle.a;
        if (d4 > 0.0) {
            d2 = (double)blockPos.a(axis) + (double)entityDimensions.a() / 2.0;
            d3 = MathHelper.a(MathHelper.c(pos.a(axis) - d2, 0.0, d4), 0.0, 1.0);
        } else {
            d3 = 0.5;
        }
        if (d1 > 0.0) {
            axis1 = EnumDirection.EnumAxis.b;
            d2 = MathHelper.a(MathHelper.c(pos.a(axis1) - (double)blockPos.a(axis1), 0.0, d1), 0.0, 1.0);
        } else {
            d2 = 0.0;
        }
        axis1 = axis == EnumDirection.EnumAxis.a ? EnumDirection.EnumAxis.c : EnumDirection.EnumAxis.a;
        double d42 = pos.a(axis1) - ((double)blockPos.a(axis1) + 0.5);
        return new Vec3D(d3, d2, d42);
    }

    public static Vec3D a(Vec3D pos, WorldServer level, net.minecraft.world.entity.Entity entity, EntitySize dimensions) {
        if (!(dimensions.a() > 4.0f) && !(dimensions.b() > 4.0f)) {
            double d2 = (double)dimensions.b() / 2.0;
            Vec3D vec3 = pos.b(0.0, d2, 0.0);
            VoxelShape voxelShape = VoxelShapes.a(AxisAlignedBB.a(vec3, dimensions.a(), 0.0, dimensions.a()).b(0.0, 1.0, 0.0).g(1.0E-6));
            Optional<Vec3D> optional = level.a(entity, voxelShape, vec3, (double)dimensions.a(), (double)dimensions.b(), (double)dimensions.a());
            Optional<Vec3D> optional1 = optional.map(freePos -> freePos.a(0.0, d2, 0.0));
            return optional1.orElse(pos);
        }
        return pos;
    }
}

