/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.phys.Vec3D;

public class PathEntity {
    public final List<PathPoint> a;
    @Nullable
    private a b;
    private int c;
    private final BlockPosition d;
    private final float e;
    private final boolean f;

    public PathEntity(List<PathPoint> nodes, BlockPosition target, boolean reached) {
        this.a = nodes;
        this.d = target;
        this.e = nodes.isEmpty() ? Float.MAX_VALUE : this.a.get(this.a.size() - 1).c(this.d);
        this.f = reached;
    }

    public void a() {
        ++this.c;
    }

    public boolean b() {
        return this.c <= 0;
    }

    public boolean c() {
        return this.c >= this.a.size();
    }

    @Nullable
    public PathPoint d() {
        return !this.a.isEmpty() ? this.a.get(this.a.size() - 1) : null;
    }

    public PathPoint a(int index) {
        return this.a.get(index);
    }

    public void b(int length) {
        if (this.a.size() > length) {
            this.a.subList(length, this.a.size()).clear();
        }
    }

    public void a(int index, PathPoint point) {
        this.a.set(index, point);
    }

    public int e() {
        return this.a.size();
    }

    public int f() {
        return this.c;
    }

    public void c(int currentPathIndex) {
        this.c = currentPathIndex;
    }

    public Vec3D a(Entity entity, int index) {
        PathPoint node = this.a.get(index);
        double d2 = (double)node.a + (double)((int)(entity.dq() + 1.0f)) * 0.5;
        double d1 = node.b;
        double d22 = (double)node.c + (double)((int)(entity.dq() + 1.0f)) * 0.5;
        return new Vec3D(d2, d1, d22);
    }

    public BlockPosition d(int index) {
        return this.a.get(index).a();
    }

    public Vec3D a(Entity entity) {
        return this.a(entity, this.c);
    }

    public BlockPosition g() {
        return this.a.get(this.c).a();
    }

    public PathPoint h() {
        return this.a.get(this.c);
    }

    @Nullable
    public PathPoint i() {
        return this.c > 0 ? this.a.get(this.c - 1) : null;
    }

    public boolean a(@Nullable PathEntity pathentity) {
        if (pathentity == null) {
            return false;
        }
        if (pathentity.a.size() != this.a.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            PathPoint node = this.a.get(i2);
            PathPoint node1 = pathentity.a.get(i2);
            if (node.a == node1.a && node.b == node1.b && node.c == node1.c) continue;
            return false;
        }
        return true;
    }

    public boolean j() {
        return this.f;
    }

    @VisibleForDebug
    void a(PathPoint[] openSet, PathPoint[] closedSet, Set<PathDestination> targetNodes) {
        this.b = new a(openSet, closedSet, targetNodes);
    }

    @Nullable
    public a k() {
        return this.b;
    }

    public void a(PacketDataSerializer buffer) {
        if (this.b != null && !this.b.c.isEmpty()) {
            buffer.a(this.f);
            buffer.q(this.c);
            buffer.a(this.d);
            buffer.a(this.a, (? super PacketDataSerializer buffer1, T value) -> value.a((PacketDataSerializer)((Object)buffer1)));
            this.b.a(buffer);
        }
    }

    public static PathEntity b(PacketDataSerializer buf) {
        boolean _boolean = buf.readBoolean();
        int _int = buf.readInt();
        BlockPosition blockPos = buf.e();
        List<PathPoint> list = buf.a(PathPoint::b);
        a debugData = net.minecraft.world.level.pathfinder.PathEntity$a.b(buf);
        PathEntity path = new PathEntity(list, blockPos, _boolean);
        path.b = debugData;
        path.c = _int;
        return path;
    }

    public String toString() {
        return "Path(length=" + this.a.size() + ")";
    }

    public BlockPosition l() {
        return this.d;
    }

    public float m() {
        return this.e;
    }

    static PathPoint[] c(PacketDataSerializer buffer) {
        PathPoint[] nodes = new PathPoint[buffer.l()];
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            nodes[i2] = PathPoint.b(buffer);
        }
        return nodes;
    }

    static void a(PacketDataSerializer buffer, PathPoint[] nodeArray) {
        buffer.c(nodeArray.length);
        for (PathPoint node : nodeArray) {
            node.a(buffer);
        }
    }

    public PathEntity n() {
        PathEntity path = new PathEntity(this.a, this.d, this.f);
        path.b = this.b;
        path.c = this.c;
        return path;
    }

    public record a(PathPoint[] a, PathPoint[] b, Set<PathDestination> c) {
        public void a(PacketDataSerializer buffer) {
            buffer.a(this.c, (buffer1, value) -> value.a((PacketDataSerializer)((Object)buffer1)));
            PathEntity.a(buffer, this.a);
            PathEntity.a(buffer, this.b);
        }

        public static a b(PacketDataSerializer buffer) {
            HashSet set = (HashSet)((Object)buffer.a(HashSet::new, PathDestination::c));
            PathPoint[] nodeArray = PathEntity.c(buffer);
            PathPoint[] nodeArray1 = PathEntity.c(buffer);
            return new a(nodeArray, nodeArray1, set);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "openSet;closedSet;targetNodes", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "openSet;closedSet;targetNodes", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "openSet;closedSet;targetNodes", "a", "b", "c"}, this, o2);
        }
    }
}

