/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypeFlowing;
import net.minecraft.world.level.material.FluidTypes;

public abstract class FluidTypeWater
extends FluidTypeFlowing {
    @Override
    public FluidType d() {
        return FluidTypes.b;
    }

    @Override
    public FluidType e() {
        return FluidTypes.c;
    }

    @Override
    public Item a() {
        return Items.rg;
    }

    @Override
    public void a(World level, BlockPosition pos, Fluid state, RandomSource random) {
        if (!state.b() && !state.c(FluidTypeFlowing.a).booleanValue()) {
            if (random.a(64) == 0) {
                level.a((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, SoundEffects.CQ, SoundCategory.e, random.i() * 0.25f + 0.75f, random.i() + 0.5f, false);
            }
        } else if (random.a(10) == 0) {
            level.a(Particles.an, (double)pos.u() + random.j(), (double)pos.v() + random.j(), (double)pos.w() + random.j(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    @Nullable
    public ParticleParam h() {
        return Particles.l;
    }

    @Override
    protected boolean a(WorldServer level) {
        return level.O().b(GameRules.V);
    }

    @Override
    protected void beforeDestroyingBlock(GeneratorAccess level, BlockPosition pos, IBlockData state, BlockPosition source) {
        TileEntity tileentity = state.x() ? level.c_(pos) : null;
        Block.dropResources(state, level, pos, tileentity, source);
    }

    @Override
    protected void a(GeneratorAccess level, BlockPosition pos, IBlockData state) {
        TileEntity blockEntity = state.x() ? level.c_(pos) : null;
        Block.a(state, level, pos, blockEntity);
    }

    @Override
    public int b(IWorldReader level) {
        return 4;
    }

    @Override
    public IBlockData b(Fluid state) {
        return (IBlockData)Blocks.J.m().b(BlockFluids.b, FluidTypeWater.e(state));
    }

    @Override
    public boolean a(FluidType fluid) {
        return fluid == FluidTypes.c || fluid == FluidTypes.b;
    }

    @Override
    public int c(IWorldReader level) {
        return 1;
    }

    @Override
    public int a(IWorldReader level) {
        return 5;
    }

    @Override
    public boolean a(Fluid fluidState, IBlockAccess blockReader, BlockPosition pos, FluidType fluid, EnumDirection direction) {
        return direction == EnumDirection.a && !fluid.a(TagsFluid.a);
    }

    @Override
    protected float c() {
        return Blocks.J.e();
    }

    @Override
    public Optional<SoundEffect> j() {
        return Optional.of(SoundEffects.dj);
    }

    public static class b
    extends FluidTypeWater {
        @Override
        public int d(Fluid state) {
            return 8;
        }

        @Override
        public boolean c(Fluid state) {
            return true;
        }
    }

    public static class a
    extends FluidTypeWater {
        @Override
        protected void a(BlockStateList.a<FluidType, Fluid> builder) {
            super.a(builder);
            builder.a(new IBlockState[]{FluidTypeFlowing.b});
        }

        @Override
        public int d(Fluid state) {
            return state.c(FluidTypeFlowing.b);
        }

        @Override
        public boolean c(Fluid state) {
            return false;
        }
    }
}

