/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import ca.spottedleaf.moonrise.patches.collisions.util.CollisionDirection;
import ca.spottedleaf.moonrise.patches.collisions.util.FluidOcclusionCacheKey;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockIce;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IFluidContainer;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.FluidLevelChangeEvent;

public abstract class FluidTypeFlowing
extends FluidType {
    public static final BlockStateBoolean a = BlockProperties.m;
    public static final BlockStateInteger b = BlockProperties.aP;
    private static final int e = 200;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<a>> f = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<a> map = new Object2ByteLinkedOpenHashMap<a>(200){

            protected void rehash(int newSize) {
            }
        };
        map.defaultReturnValue((byte)127);
        return map;
    });
    private final Map<Fluid, VoxelShape> g = Maps.newIdentityHashMap();
    private Fluid sourceFalling;
    private Fluid sourceNotFalling;
    private static final int TOTAL_FLOWING_STATES = a.a().size() * b.a().size();
    private static final int MIN_LEVEL = (Integer)b.a().stream().sorted().findFirst().get();
    private Fluid[] flowingLookUp;
    private volatile boolean init;
    private static final int COLLISION_OCCLUSION_CACHE_SIZE = 2048;
    private static final ThreadLocal<FluidOcclusionCacheKey[]> COLLISION_OCCLUSION_CACHE = ThreadLocal.withInitial(() -> new FluidOcclusionCacheKey[2048]);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        FluidTypeFlowing fluidTypeFlowing = this;
        synchronized (fluidTypeFlowing) {
            if (this.init) {
                return;
            }
            this.flowingLookUp = new Fluid[TOTAL_FLOWING_STATES];
            Fluid defaultFlowState = this.d().g();
            for (int i2 = 0; i2 < TOTAL_FLOWING_STATES; ++i2) {
                int falling = i2 & 1;
                int level = (i2 >>> 1) + MIN_LEVEL;
                this.flowingLookUp[i2] = (Fluid)((Fluid)defaultFlowState.b(a, falling == 1 ? Boolean.TRUE : Boolean.FALSE)).b(b, level);
            }
            Fluid defaultFallState = this.e().g();
            this.sourceFalling = (Fluid)defaultFallState.b(a, Boolean.TRUE);
            this.sourceNotFalling = (Fluid)defaultFallState.b(a, Boolean.FALSE);
            this.init = true;
        }
    }

    @Override
    protected void a(BlockStateList.a<FluidType, Fluid> builder) {
        builder.a(new IBlockState[]{a});
    }

    @Override
    public Vec3D a(IBlockAccess blockReader, BlockPosition pos, Fluid fluidState) {
        double d2 = 0.0;
        double d1 = 0.0;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            mutableBlockPos.a((BaseBlockPosition)pos, direction);
            Fluid fluidState1 = blockReader.b_(mutableBlockPos);
            if (!this.g(fluidState1)) continue;
            float ownHeight = fluidState1.d();
            float f2 = 0.0f;
            if (ownHeight == 0.0f) {
                BlockPosition blockPos;
                Fluid fluidState2;
                if (!blockReader.a_(mutableBlockPos).d() && this.g(fluidState2 = blockReader.b_(blockPos = mutableBlockPos.e())) && (ownHeight = fluidState2.d()) > 0.0f) {
                    f2 = fluidState.d() - (ownHeight - 0.8888889f);
                }
            } else if (ownHeight > 0.0f) {
                f2 = fluidState.d() - ownHeight;
            }
            if (f2 == 0.0f) continue;
            d2 += (double)((float)direction.j() * f2);
            d1 += (double)((float)direction.l() * f2);
        }
        Vec3D vec3 = new Vec3D(d2, 0.0, d1);
        if (fluidState.c(a).booleanValue()) {
            for (EnumDirection direction1 : EnumDirection.EnumDirectionLimit.a) {
                mutableBlockPos.a((BaseBlockPosition)pos, direction1);
                if (!this.a(blockReader, (BlockPosition)mutableBlockPos, direction1) && !this.a(blockReader, mutableBlockPos.d(), direction1)) continue;
                vec3 = vec3.d().b(0.0, -6.0, 0.0);
                break;
            }
        }
        return vec3.d();
    }

    private boolean g(Fluid state) {
        return state.c() || state.a().a(this);
    }

    protected boolean a(IBlockAccess level, BlockPosition neighborPos, EnumDirection side) {
        IBlockData blockState = level.a_(neighborPos);
        Fluid fluidState = level.b_(neighborPos);
        return !fluidState.a().a(this) && (side == EnumDirection.b || !(blockState.b() instanceof BlockIce) && blockState.c(level, neighborPos, side));
    }

    protected void a(WorldServer level, BlockPosition pos, IBlockData blockState, Fluid fluidState) {
        if (!fluidState.c()) {
            Fluid newLiquid;
            FluidType type;
            Fluid fluidState1;
            IBlockData blockState1;
            BlockPosition blockPos = pos.e();
            if (this.a(level, pos, blockState, EnumDirection.a, blockPos, blockState1 = level.a_(blockPos), fluidState1 = blockState1.y()) && fluidState1.a(level, blockPos, type = (newLiquid = this.a(level, blockPos, blockState1)).a(), EnumDirection.a) && FluidTypeFlowing.b(level, blockPos, blockState1, type)) {
                CraftBlock source = CraftBlock.at(level, pos);
                BlockFromToEvent event = new BlockFromToEvent((org.bukkit.block.Block)source, BlockFace.DOWN);
                level.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                this.a(level, blockPos, blockState1, EnumDirection.a, newLiquid);
                if (this.a(level, pos) >= 3) {
                    this.a(level, pos, fluidState, blockState);
                }
                return;
            }
            if (fluidState.b() || !this.a((IBlockAccess)level, pos, blockState, blockPos, blockState1)) {
                this.a(level, pos, fluidState, blockState);
            }
        }
    }

    private void a(WorldServer level, BlockPosition pos, Fluid fluidState, IBlockData blockState) {
        int i2 = fluidState.e() - this.c(level);
        if (fluidState.c(a).booleanValue()) {
            i2 = 7;
        }
        if (i2 > 0) {
            Map<EnumDirection, Fluid> spread = this.b(level, pos, blockState);
            for (Map.Entry<EnumDirection, Fluid> entry : spread.entrySet()) {
                EnumDirection direction = entry.getKey();
                Fluid fluidState1 = entry.getValue();
                BlockPosition blockPos = pos.a(direction);
                IBlockData blockStateIfLoaded = level.getBlockStateIfLoaded(blockPos);
                if (blockStateIfLoaded == null) continue;
                CraftBlock source = CraftBlock.at(level, pos);
                BlockFromToEvent event = new BlockFromToEvent((org.bukkit.block.Block)source, CraftBlock.notchToBlockFace(direction));
                level.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                this.a(level, blockPos, blockStateIfLoaded, direction, fluidState1);
            }
        }
    }

    protected Fluid a(WorldServer level, BlockPosition pos, IBlockData state) {
        BlockPosition.MutableBlockPosition blockPos1;
        IBlockData blockState2;
        Fluid fluidState2;
        int i2 = 0;
        int i1 = 0;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            Fluid fluidState;
            BlockPosition.MutableBlockPosition blockPos = mutableBlockPos.a((BaseBlockPosition)pos, direction);
            IBlockData blockState = level.getBlockStateIfLoaded(blockPos);
            if (blockState == null || !(fluidState = blockState.y()).a().a(this) || !FluidTypeFlowing.a(direction, level, pos, state, blockPos, blockState)) continue;
            if (fluidState.b()) {
                ++i1;
            }
            i2 = Math.max(i2, fluidState.e());
        }
        if (i1 >= 2 && this.a(level)) {
            IBlockData blockState1 = level.a_(mutableBlockPos.a((BaseBlockPosition)pos, EnumDirection.a));
            Fluid fluidState1 = blockState1.y();
            if (blockState1.e() || this.h(fluidState1)) {
                return this.a(false);
            }
        }
        if (!(fluidState2 = (blockState2 = level.a_(blockPos1 = mutableBlockPos.a((BaseBlockPosition)pos, EnumDirection.b))).y()).c() && fluidState2.a().a(this) && FluidTypeFlowing.a(EnumDirection.b, level, pos, state, blockPos1, blockState2)) {
            return this.a(8, true);
        }
        int i22 = i2 - this.c(level);
        return i22 <= 0 ? FluidTypes.a.g() : this.a(i22, false);
    }

    private static boolean a(EnumDirection direction, IBlockAccess level, BlockPosition fromPos, IBlockData fromState, BlockPosition toPos, IBlockData toState) {
        VoxelShape shape2;
        boolean result;
        FluidOcclusionCacheKey cached;
        if (fromState.moonrise$emptyCollisionShape() & toState.moonrise$emptyCollisionShape()) {
            return true;
        }
        if (fromState.moonrise$occludesFullBlock() | toState.moonrise$occludesFullBlock()) {
            return false;
        }
        FluidOcclusionCacheKey[] cache = fromState.moonrise$hasCache() & toState.moonrise$hasCache() ? COLLISION_OCCLUSION_CACHE.get() : null;
        int keyIndex = (fromState.moonrise$uniqueId1() ^ toState.moonrise$uniqueId2() ^ ((CollisionDirection)direction).moonrise$uniqueId()) & 0x7FF;
        if (cache != null && (cached = cache[keyIndex]) != null && cached.first() == fromState && cached.second() == toState && cached.direction() == direction) {
            return cached.result();
        }
        VoxelShape shape1 = fromState.g(level, fromPos);
        boolean bl = result = !VoxelShapes.b(shape1, shape2 = toState.g(level, toPos), direction);
        if (cache != null) {
            cache[keyIndex] = new FluidOcclusionCacheKey(fromState, toState, direction, result);
        }
        return result;
    }

    public abstract FluidType d();

    public Fluid a(int level, boolean falling) {
        int amount = level;
        if (!this.init) {
            this.init();
        }
        int index = (falling ? 1 : 0) | amount - MIN_LEVEL << 1;
        return this.flowingLookUp[index];
    }

    public abstract FluidType e();

    public Fluid a(boolean falling) {
        if (!this.init) {
            this.init();
        }
        return falling ? this.sourceFalling : this.sourceNotFalling;
    }

    protected abstract boolean a(WorldServer var1);

    protected void a(GeneratorAccess level, BlockPosition pos, IBlockData blockState, EnumDirection direction, Fluid fluidState) {
        Block block = blockState.b();
        if (block instanceof IFluidContainer) {
            IFluidContainer liquidBlockContainer = (IFluidContainer)((Object)block);
            liquidBlockContainer.a(level, pos, blockState, fluidState);
        } else {
            if (!blockState.l()) {
                this.beforeDestroyingBlock(level, pos, blockState, pos.a(direction.g()));
            }
            level.a(pos, fluidState.g(), 3);
        }
    }

    protected void beforeDestroyingBlock(GeneratorAccess level, BlockPosition pos, IBlockData state, BlockPosition source) {
        this.a(level, pos, state);
    }

    protected abstract void a(GeneratorAccess var1, BlockPosition var2, IBlockData var3);

    protected int a(IWorldReader level, BlockPosition pos, int depth, EnumDirection direction, IBlockData state, b spreadContext) {
        int i2 = 1000;
        for (EnumDirection direction1 : EnumDirection.EnumDirectionLimit.a) {
            int slopeDistance;
            BlockPosition blockPos;
            IBlockData blockState;
            if (direction1 == direction || (blockState = spreadContext.getBlockStateIfLoaded(blockPos = pos.a(direction1))) == null) continue;
            Fluid fluidState = blockState.y();
            if (!this.a(level, this.d(), pos, state, direction1, blockPos, blockState, fluidState)) continue;
            if (spreadContext.b(blockPos)) {
                return depth;
            }
            if (depth >= this.b(level) || (slopeDistance = this.a(level, blockPos, depth + 1, direction1.g(), blockState, spreadContext)) >= i2) continue;
            i2 = slopeDistance;
        }
        return i2;
    }

    boolean a(IBlockAccess level, BlockPosition pos, IBlockData state, BlockPosition belowPos, IBlockData belowState) {
        return FluidTypeFlowing.a(EnumDirection.a, level, pos, state, belowPos, belowState) && (belowState.y().a().a(this) || FluidTypeFlowing.a(level, belowPos, belowState, this.d()));
    }

    private boolean a(IBlockAccess level, FluidType fluid, BlockPosition pos, IBlockData state, EnumDirection direction, BlockPosition spreadPos, IBlockData spreadState, Fluid fluidState) {
        return this.a(level, pos, state, direction, spreadPos, spreadState, fluidState) && FluidTypeFlowing.b(level, spreadPos, spreadState, fluid);
    }

    private boolean a(IBlockAccess level, BlockPosition pos, IBlockData state, EnumDirection direction, BlockPosition spreadPos, IBlockData spreadState, Fluid fluidState) {
        return !this.h(fluidState) && FluidTypeFlowing.a(spreadState) && FluidTypeFlowing.a(direction, level, pos, state, spreadPos, spreadState);
    }

    private boolean h(Fluid state) {
        return state.a().a(this) && state.b();
    }

    protected abstract int b(IWorldReader var1);

    private int a(IWorldReader level, BlockPosition pos) {
        int i2 = 0;
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            BlockPosition blockPos = pos.a(direction);
            Fluid fluidState = level.b_(blockPos);
            if (!this.h(fluidState)) continue;
            ++i2;
        }
        return i2;
    }

    protected Map<EnumDirection, Fluid> b(WorldServer level, BlockPosition pos, IBlockData state) {
        int i2 = 1000;
        EnumMap map = Maps.newEnumMap(EnumDirection.class);
        b spreadContext = null;
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            int i1;
            Fluid newLiquid;
            Fluid fluidState;
            BlockPosition blockPos = pos.a(direction);
            IBlockData blockState = level.getBlockStateIfLoaded(blockPos);
            if (blockState == null || !this.a(level, pos, state, direction, blockPos, blockState, fluidState = blockState.y()) || !FluidTypeFlowing.b(level, blockPos, blockState, (newLiquid = this.a(level, blockPos, blockState)).a())) continue;
            if (spreadContext == null) {
                spreadContext = new b(level, pos);
            }
            if ((i1 = spreadContext.b(blockPos) ? 0 : this.a(level, blockPos, 1, direction.g(), blockState, spreadContext)) < i2) {
                map.clear();
            }
            if (i1 > i2) continue;
            if (fluidState.a(level, blockPos, newLiquid.a(), direction)) {
                map.put(direction, newLiquid);
            }
            i2 = i1;
        }
        return map;
    }

    private static boolean a(IBlockData state) {
        Block block = state.b();
        return block instanceof IFluidContainer || !state.d() && !(block instanceof BlockDoor) && !state.a(TagsBlock.aA) && !state.a(Blocks.cX) && !state.a(Blocks.ef) && !state.a(Blocks.nF) && !state.a(Blocks.eq) && !state.a(Blocks.fS) && !state.a(Blocks.lh) && !state.a(Blocks.lp);
    }

    private static boolean a(IBlockAccess level, BlockPosition pos, IBlockData state, FluidType fluid) {
        return FluidTypeFlowing.a(state) && FluidTypeFlowing.b(level, pos, state, fluid);
    }

    private static boolean b(IBlockAccess level, BlockPosition pos, IBlockData state, FluidType fluid) {
        IFluidContainer liquidBlockContainer;
        Block block = state.b();
        return !(block instanceof IFluidContainer) || (liquidBlockContainer = (IFluidContainer)((Object)block)).a(null, level, pos, state, fluid);
    }

    protected abstract int c(IWorldReader var1);

    protected int a(World level, BlockPosition pos, Fluid currentState, Fluid newState) {
        return this.a(level);
    }

    @Override
    public void b(WorldServer level, BlockPosition pos, IBlockData blockState, Fluid fluidState) {
        if (!fluidState.b()) {
            Fluid newLiquid = this.a(level, pos, level.a_(pos));
            int spreadDelay = this.a((World)level, pos, fluidState, newLiquid);
            if (newLiquid.c()) {
                fluidState = newLiquid;
                blockState = Blocks.a.m();
                FluidLevelChangeEvent event = CraftEventFactory.callFluidLevelChangeEvent(level, pos, blockState);
                if (event.isCancelled()) {
                    return;
                }
                blockState = ((CraftBlockData)event.getNewData()).getState();
                level.a(pos, blockState, 3);
            } else if (!newLiquid.equals(fluidState)) {
                fluidState = newLiquid;
                blockState = newLiquid.g();
                FluidLevelChangeEvent event = CraftEventFactory.callFluidLevelChangeEvent(level, pos, blockState);
                if (event.isCancelled()) {
                    return;
                }
                blockState = ((CraftBlockData)event.getNewData()).getState();
                level.a(pos, blockState, 3);
                level.a(pos, newLiquid.a(), spreadDelay);
            }
        }
        this.a(level, pos, blockState, fluidState);
    }

    protected static int e(Fluid state) {
        return state.b() ? 0 : 8 - Math.min(state.e(), 8) + (state.c(a) != false ? 8 : 0);
    }

    private static boolean c(Fluid fluidState, IBlockAccess level, BlockPosition pos) {
        return fluidState.a().a(level.b_(pos.d()).a());
    }

    @Override
    public float a(Fluid state, IBlockAccess level, BlockPosition pos) {
        return FluidTypeFlowing.c(state, level, pos) ? 1.0f : state.d();
    }

    @Override
    public float a(Fluid state) {
        return (float)state.e() / 9.0f;
    }

    @Override
    public abstract int d(Fluid var1);

    @Override
    public VoxelShape b(Fluid state, IBlockAccess level, BlockPosition pos) {
        return state.e() == 9 && FluidTypeFlowing.c(state, level, pos) ? VoxelShapes.b() : this.g.computeIfAbsent(state, fluidState -> VoxelShapes.a(0.0, 0.0, 0.0, 1.0, fluidState.a(level, pos), 1.0));
    }

    protected class b {
        private final IBlockAccess b;
        private final BlockPosition c;
        private final Short2ObjectMap<IBlockData> d = new Short2ObjectOpenHashMap();
        private final Short2BooleanMap e = new Short2BooleanOpenHashMap();

        b(IBlockAccess level, BlockPosition origin) {
            this.b = level;
            this.c = origin;
        }

        public IBlockData a(BlockPosition pos) {
            return this.a(pos, this.c(pos));
        }

        @Nullable
        public IBlockData getBlockStateIfLoaded(BlockPosition pos) {
            return this.getBlockState(pos, this.c(pos), false);
        }

        private IBlockData a(BlockPosition pos, short cacheKey) {
            return this.getBlockState(pos, cacheKey, true);
        }

        @Nullable
        private IBlockData getBlockState(BlockPosition pos, short packed, boolean load) {
            IBlockData blockState = (IBlockData)this.d.get(packed);
            if (blockState == null) {
                IBlockData iBlockData = blockState = load ? this.b.a_(pos) : this.b.getBlockStateIfLoaded(pos);
                if (blockState != null) {
                    this.d.put(packed, (Object)blockState);
                }
            }
            return blockState;
        }

        public boolean b(BlockPosition pos) {
            return this.e.computeIfAbsent(this.c(pos), s2 -> {
                IBlockData blockState = this.a(pos, s2);
                BlockPosition blockPos = pos.e();
                IBlockData blockState1 = this.b.a_(blockPos);
                return FluidTypeFlowing.this.a(this.b, pos, blockState, blockPos, blockState1);
            });
        }

        private short c(BlockPosition pos) {
            int i2 = pos.u() - this.c.u();
            int i1 = pos.w() - this.c.w();
            return (short)((i2 + 128 & 0xFF) << 8 | i1 + 128 & 0xFF);
        }
    }

    record a(IBlockData a, IBlockData b, EnumDirection c) {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            if (!(object instanceof a)) return false;
            a blockStatePairKey = (a)object;
            if (this.a != blockStatePairKey.a) return false;
            if (this.b != blockStatePairKey.b) return false;
            if (this.c != blockStatePairKey.c) return false;
            return true;
        }

        @Override
        public int hashCode() {
            int i2 = System.identityHashCode(this.a);
            i2 = 31 * i2 + System.identityHashCode(this.b);
            return 31 * i2 + this.c.hashCode();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "first;second;direction", "a", "b", "c"}, this);
        }
    }
}

