/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.lighting.LightEngineStorageArray;

public abstract class LightEngineStorage<M extends LightEngineStorageArray<M>> {
    private final EnumSkyBlock i;
    protected final ILightAccess a;
    protected final Long2ByteMap b = new Long2ByteOpenHashMap();
    private final LongSet j = new LongOpenHashSet();
    protected volatile M c;
    protected final M d;
    protected final LongSet e = new LongOpenHashSet();
    protected final LongSet f = new LongOpenHashSet();
    protected final Long2ObjectMap<NibbleArray> g = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());
    private final LongSet k = new LongOpenHashSet();
    private final LongSet l = new LongOpenHashSet();
    protected volatile boolean h;

    protected LightEngineStorage(EnumSkyBlock layer, ILightAccess chunkSource, M updatingSectionData) {
        this.i = layer;
        this.a = chunkSource;
        this.d = updatingSectionData;
        this.c = ((LightEngineStorageArray)updatingSectionData).b();
        ((LightEngineStorageArray)this.c).d();
        this.b.defaultReturnValue((byte)0);
    }

    protected boolean b(long sectionPos) {
        return this.a(sectionPos, true) != null;
    }

    @Nullable
    protected NibbleArray a(long sectionPos, boolean cached) {
        return this.a(cached ? this.d : this.c, sectionPos);
    }

    @Nullable
    protected NibbleArray a(M map, long sectionPos) {
        return ((LightEngineStorageArray)map).c(sectionPos);
    }

    @Nullable
    protected NibbleArray c(long sectionPos) {
        NibbleArray layer = ((LightEngineStorageArray)this.d).c(sectionPos);
        if (layer == null) {
            return null;
        }
        if (this.e.add(sectionPos)) {
            layer = layer.b();
            ((LightEngineStorageArray)this.d).a(sectionPos, layer);
            ((LightEngineStorageArray)this.d).c();
        }
        return layer;
    }

    @Nullable
    public NibbleArray d(long sectionPos) {
        NibbleArray dataLayer = (NibbleArray)this.g.get(sectionPos);
        return dataLayer != null ? dataLayer : this.a(sectionPos, false);
    }

    protected abstract int a(long var1);

    protected int e(long levelPos) {
        long packedSectionPos = SectionPosition.e(levelPos);
        NibbleArray dataLayer = this.a(packedSectionPos, true);
        return dataLayer.a(SectionPosition.b(BlockPosition.a(levelPos)), SectionPosition.b(BlockPosition.b(levelPos)), SectionPosition.b(BlockPosition.c(levelPos)));
    }

    protected void a(long levelPos, int lightLevel) {
        long packedSectionPos = SectionPosition.e(levelPos);
        NibbleArray dataLayer = this.e.add(packedSectionPos) ? ((LightEngineStorageArray)this.d).a(packedSectionPos) : this.a(packedSectionPos, true);
        dataLayer.a(SectionPosition.b(BlockPosition.a(levelPos)), SectionPosition.b(BlockPosition.b(levelPos)), SectionPosition.b(BlockPosition.c(levelPos)), lightLevel);
        SectionPosition.a(levelPos, arg_0 -> ((LongSet)this.f).add(arg_0));
    }

    protected void f(long sectionPos) {
        int sectionX = SectionPosition.b(sectionPos);
        int sectionY = SectionPosition.c(sectionPos);
        int sectionZ = SectionPosition.d(sectionPos);
        for (int i2 = -1; i2 <= 1; ++i2) {
            for (int i1 = -1; i1 <= 1; ++i1) {
                for (int i22 = -1; i22 <= 1; ++i22) {
                    this.f.add(SectionPosition.b(sectionX + i1, sectionY + i22, sectionZ + i2));
                }
            }
        }
    }

    protected NibbleArray g(long sectionPos) {
        NibbleArray dataLayer = (NibbleArray)this.g.get(sectionPos);
        return dataLayer != null ? dataLayer : new NibbleArray();
    }

    protected boolean a() {
        return this.h;
    }

    protected void a(LightEngine<M, ?> lightEngine) {
        if (this.h) {
            NibbleArray dataLayer1;
            this.h = false;
            LongIterator longIterator = this.l.iterator();
            while (longIterator.hasNext()) {
                long l2 = (Long)longIterator.next();
                NibbleArray dataLayer = (NibbleArray)this.g.remove(l2);
                dataLayer1 = ((LightEngineStorageArray)this.d).d(l2);
                if (!this.k.contains(SectionPosition.f(l2))) continue;
                if (dataLayer != null) {
                    this.g.put(l2, (Object)dataLayer);
                    continue;
                }
                if (dataLayer1 == null) continue;
                this.g.put(l2, (Object)dataLayer1);
            }
            ((LightEngineStorageArray)this.d).c();
            longIterator = this.l.iterator();
            while (longIterator.hasNext()) {
                long lx = (Long)longIterator.next();
                this.i(lx);
                this.e.add(lx);
            }
            this.l.clear();
            ObjectIterator objectIterator = Long2ObjectMaps.fastIterator(this.g);
            while (objectIterator.hasNext()) {
                Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectIterator.next();
                long longKey = entry.getLongKey();
                if (!this.b(longKey)) continue;
                dataLayer1 = (NibbleArray)entry.getValue();
                if (((LightEngineStorageArray)this.d).c(longKey) != dataLayer1) {
                    ((LightEngineStorageArray)this.d).a(longKey, dataLayer1);
                    this.e.add(longKey);
                }
                objectIterator.remove();
            }
            ((LightEngineStorageArray)this.d).c();
        }
    }

    protected void h(long sectionPos) {
    }

    protected void i(long sectionPos) {
    }

    protected void b(long sectionPos, boolean lightEnabled) {
        if (lightEnabled) {
            this.j.add(sectionPos);
        } else {
            this.j.remove(sectionPos);
        }
    }

    protected boolean j(long sectionPos) {
        long zeroNode = SectionPosition.f(sectionPos);
        return this.j.contains(zeroNode);
    }

    protected boolean k(long columnPos) {
        return this.j.contains(columnPos);
    }

    public void c(long sectionColumnPos, boolean retain) {
        if (retain) {
            this.k.add(sectionColumnPos);
        } else {
            this.k.remove(sectionColumnPos);
        }
    }

    protected void a(long sectionPos, @Nullable NibbleArray data) {
        if (data != null) {
            this.g.put(sectionPos, (Object)data);
            this.h = true;
        } else {
            this.g.remove(sectionPos);
        }
    }

    protected void d(long sectionPos, boolean isEmpty) {
        byte b1;
        byte b2 = this.b.get(sectionPos);
        if (b2 != (b1 = net.minecraft.world.level.lighting.LightEngineStorage$a.a(b2, !isEmpty))) {
            this.a(sectionPos, b1);
            int i2 = isEmpty ? -1 : 1;
            for (int i1 = -1; i1 <= 1; ++i1) {
                for (int i22 = -1; i22 <= 1; ++i22) {
                    for (int i3 = -1; i3 <= 1; ++i3) {
                        if (i1 == 0 && i22 == 0 && i3 == 0) continue;
                        long l2 = SectionPosition.a(sectionPos, i1, i22, i3);
                        byte b22 = this.b.get(l2);
                        this.a(l2, net.minecraft.world.level.lighting.LightEngineStorage$a.a(b22, net.minecraft.world.level.lighting.LightEngineStorage$a.b(b22) + i2));
                    }
                }
            }
        }
    }

    protected void a(long sectionPos, byte sectionState) {
        if (sectionState != 0) {
            if (this.b.put(sectionPos, sectionState) == 0) {
                this.m(sectionPos);
            }
        } else if (this.b.remove(sectionPos) != 0) {
            this.n(sectionPos);
        }
    }

    private void m(long sectionPos) {
        if (!this.l.remove(sectionPos)) {
            ((LightEngineStorageArray)this.d).a(sectionPos, this.g(sectionPos));
            this.e.add(sectionPos);
            this.h(sectionPos);
            this.f(sectionPos);
            this.h = true;
        }
    }

    private void n(long sectionPos) {
        this.l.add(sectionPos);
        this.h = true;
    }

    protected void b() {
        if (!this.e.isEmpty()) {
            Object dataLayerStorageMap = ((LightEngineStorageArray)this.d).b();
            ((LightEngineStorageArray)dataLayerStorageMap).d();
            this.c = dataLayerStorageMap;
            this.e.clear();
        }
        if (!this.f.isEmpty()) {
            LongIterator longIterator = this.f.iterator();
            while (longIterator.hasNext()) {
                long l2 = longIterator.nextLong();
                this.a.a(this.i, SectionPosition.a(l2));
            }
            this.f.clear();
        }
    }

    public b l(long sectionPos) {
        return net.minecraft.world.level.lighting.LightEngineStorage$a.c(this.b.get(sectionPos));
    }

    protected static class a {
        public static final byte a = 0;
        private static final int b = 0;
        private static final int c = 26;
        private static final byte d = 32;
        private static final byte e = 31;

        protected a() {
        }

        public static byte a(byte sectionState, boolean hasData) {
            return (byte)(hasData ? sectionState | 0x20 : sectionState & 0xFFFFFFDF);
        }

        public static byte a(byte sectionState, int neighborCount) {
            if (neighborCount >= 0 && neighborCount <= 26) {
                return (byte)(sectionState & 0xFFFFFFE0 | neighborCount & 0x1F);
            }
            throw new IllegalArgumentException("Neighbor count was not within range [0; 26]");
        }

        public static boolean a(byte sectionState) {
            return (sectionState & 0x20) != 0;
        }

        public static int b(byte sectionState) {
            return sectionState & 0x1F;
        }

        public static b c(byte sectionState) {
            if (sectionState == 0) {
                return net.minecraft.world.level.lighting.LightEngineStorage$b.a;
            }
            return net.minecraft.world.level.lighting.LightEngineStorage$a.a(sectionState) ? net.minecraft.world.level.lighting.LightEngineStorage$b.c : net.minecraft.world.level.lighting.LightEngineStorage$b.b;
        }
    }

    public static final class b
    extends Enum<b> {
        public static final /* enum */ b a = new b("2");
        public static final /* enum */ b b = new b("1");
        public static final /* enum */ b c = new b("0");
        private final String d;
        private static final /* synthetic */ b[] e;

        public static b[] values() {
            return (b[])e.clone();
        }

        public static b valueOf(String name) {
            return Enum.valueOf(b.class, name);
        }

        private b(String display) {
            this.d = display;
        }

        public String a() {
            return this.d;
        }

        private static /* synthetic */ b[] b() {
            return new b[]{a, b, c};
        }

        static {
            e = net.minecraft.world.level.lighting.LightEngineStorage$b.b();
        }
    }
}

