/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.ChunkSkyLightSources;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.lighting.LightEngineStorageSky;
import org.jetbrains.annotations.VisibleForTesting;

public final class LightEngineSky
extends LightEngine<LightEngineStorageSky.a, LightEngineStorageSky> {
    private static final long g = LightEngine.a.a(15);
    private static final long h = LightEngine.a.a(15, EnumDirection.b);
    private static final long i = LightEngine.a.a(15, false, EnumDirection.b);
    private final BlockPosition.MutableBlockPosition j = new BlockPosition.MutableBlockPosition();
    private final ChunkSkyLightSources k;

    public LightEngineSky(ILightAccess chunkSource) {
        this(chunkSource, new LightEngineStorageSky(chunkSource));
    }

    @VisibleForTesting
    protected LightEngineSky(ILightAccess chunkSource, LightEngineStorageSky sectionStorage) {
        super(chunkSource, sectionStorage);
        this.k = new ChunkSkyLightSources(chunkSource.q());
    }

    private static boolean a(int level) {
        return level == 15;
    }

    private int a(int x2, int z2, int defaultReturnValue) {
        ChunkSkyLightSources chunkSources = this.b(SectionPosition.a(x2), SectionPosition.a(z2));
        return chunkSources == null ? defaultReturnValue : chunkSources.a(SectionPosition.b(x2), SectionPosition.b(z2));
    }

    @Nullable
    private ChunkSkyLightSources b(int chunkX, int chunkZ) {
        LightChunk chunkForLighting = this.e.c(chunkX, chunkZ);
        return chunkForLighting != null ? chunkForLighting.D() : null;
    }

    @Override
    protected void a(long levelPos) {
        int i2;
        int x2 = BlockPosition.a(levelPos);
        int y2 = BlockPosition.b(levelPos);
        int z2 = BlockPosition.c(levelPos);
        long packedSectionPos = SectionPosition.e(levelPos);
        int n2 = i2 = ((LightEngineStorageSky)this.f).j(packedSectionPos) ? this.a(x2, z2, Integer.MAX_VALUE) : Integer.MAX_VALUE;
        if (i2 != Integer.MAX_VALUE) {
            this.b(x2, z2, i2);
        }
        if (((LightEngineStorageSky)this.f).b(packedSectionPos)) {
            boolean flag;
            boolean bl = flag = y2 >= i2;
            if (flag) {
                this.b(levelPos, h);
                this.c(levelPos, i);
            } else {
                int storedLevel = ((LightEngineStorageSky)this.f).e(levelPos);
                if (storedLevel > 0) {
                    ((LightEngineStorageSky)this.f).a(levelPos, 0);
                    this.b(levelPos, LightEngine.a.a(storedLevel));
                } else {
                    this.b(levelPos, LightEngine.c);
                }
            }
        }
    }

    private void b(int x2, int z2, int lowestY) {
        int blockPosCoord = SectionPosition.c(((LightEngineStorageSky)this.f).c());
        this.a(x2, z2, lowestY, blockPosCoord);
        this.b(x2, z2, lowestY, blockPosCoord);
    }

    private void a(int x2, int z2, int minY, int bottomSectionY) {
        if (minY > bottomSectionY) {
            int sectionPosX = SectionPosition.a(x2);
            int sectionPosZ = SectionPosition.a(z2);
            int i2 = minY - 1;
            int sectionPosCoord = SectionPosition.a(i2);
            while (((LightEngineStorageSky)this.f).a(sectionPosCoord)) {
                if (((LightEngineStorageSky)this.f).b(SectionPosition.b(sectionPosX, sectionPosCoord, sectionPosZ))) {
                    int blockPosCoord = SectionPosition.c(sectionPosCoord);
                    int i1 = blockPosCoord + 15;
                    for (int min = Math.min(i1, i2); min >= blockPosCoord; --min) {
                        long packedBlockPos = BlockPosition.a(x2, min, z2);
                        if (!LightEngineSky.a(((LightEngineStorageSky)this.f).e(packedBlockPos))) {
                            return;
                        }
                        ((LightEngineStorageSky)this.f).a(packedBlockPos, 0);
                        this.b(packedBlockPos, min == minY - 1 ? g : h);
                    }
                }
                --sectionPosCoord;
            }
        }
    }

    private void b(int x2, int z2, int maxY, int bottomSectionY) {
        int sectionPosX = SectionPosition.a(x2);
        int sectionPosZ = SectionPosition.a(z2);
        int max = Math.max(Math.max(this.a(x2 - 1, z2, Integer.MIN_VALUE), this.a(x2 + 1, z2, Integer.MIN_VALUE)), Math.max(this.a(x2, z2 - 1, Integer.MIN_VALUE), this.a(x2, z2 + 1, Integer.MIN_VALUE)));
        int max1 = Math.max(maxY, bottomSectionY);
        long packedSectionPos = SectionPosition.b(sectionPosX, SectionPosition.a(max1), sectionPosZ);
        while (!((LightEngineStorageSky)this.f).m(packedSectionPos)) {
            if (((LightEngineStorageSky)this.f).b(packedSectionPos)) {
                int blockPosY = SectionPosition.c(SectionPosition.c(packedSectionPos));
                int i2 = blockPosY + 15;
                for (int max2 = Math.max(blockPosY, max1); max2 <= i2; ++max2) {
                    long packedBlockPos = BlockPosition.a(x2, max2, z2);
                    if (LightEngineSky.a(((LightEngineStorageSky)this.f).e(packedBlockPos))) {
                        return;
                    }
                    ((LightEngineStorageSky)this.f).a(packedBlockPos, 15);
                    if (max2 >= max && max2 != maxY) continue;
                    this.c(packedBlockPos, i);
                }
            }
            packedSectionPos = SectionPosition.a(packedSectionPos, EnumDirection.b);
        }
    }

    @Override
    protected void a(long packedPos, long queueEntry, int lightLevel) {
        IBlockData blockState = null;
        int i2 = this.d(packedPos);
        for (EnumDirection direction : LightEngine.d) {
            int storedLevel;
            int i1;
            long offsetPackedBlockPos;
            if (!LightEngine.a.a(queueEntry, direction) || !((LightEngineStorageSky)this.f).b(SectionPosition.e(offsetPackedBlockPos = BlockPosition.a(packedPos, direction))) || (i1 = lightLevel - 1) <= (storedLevel = ((LightEngineStorageSky)this.f).e(offsetPackedBlockPos))) continue;
            this.j.f(offsetPackedBlockPos);
            IBlockData state = this.c(this.j);
            int i22 = lightLevel - this.b(state);
            if (i22 <= storedLevel) continue;
            if (blockState == null) {
                IBlockData iBlockData = blockState = LightEngine.a.b(queueEntry) ? Blocks.a.m() : this.c(this.j.f(packedPos));
            }
            if (this.a(blockState, state, direction)) continue;
            ((LightEngineStorageSky)this.f).a(offsetPackedBlockPos, i22);
            if (i22 > 1) {
                this.c(offsetPackedBlockPos, LightEngine.a.a(i22, LightEngineSky.a(state), direction.g()));
            }
            this.a(offsetPackedBlockPos, direction, i22, true, i2);
        }
    }

    @Override
    protected void a(long packedPos, long lightLevel) {
        int i2 = this.d(packedPos);
        int fromLevel = LightEngine.a.a(lightLevel);
        for (EnumDirection direction : LightEngine.d) {
            int storedLevel;
            long offsetPackedBlockPos;
            if (!LightEngine.a.a(lightLevel, direction) || !((LightEngineStorageSky)this.f).b(SectionPosition.e(offsetPackedBlockPos = BlockPosition.a(packedPos, direction))) || (storedLevel = ((LightEngineStorageSky)this.f).e(offsetPackedBlockPos)) == 0) continue;
            if (storedLevel <= fromLevel - 1) {
                ((LightEngineStorageSky)this.f).a(offsetPackedBlockPos, 0);
                this.b(offsetPackedBlockPos, LightEngine.a.a(storedLevel, direction.g()));
                this.a(offsetPackedBlockPos, direction, storedLevel, false, i2);
                continue;
            }
            this.c(offsetPackedBlockPos, LightEngine.a.b(storedLevel, false, direction.g()));
        }
    }

    private int d(long packedPos) {
        int y2 = BlockPosition.b(packedPos);
        int relativeBlockPosY = SectionPosition.b(y2);
        if (relativeBlockPosY != 0) {
            return 0;
        }
        int x2 = BlockPosition.a(packedPos);
        int z2 = BlockPosition.c(packedPos);
        int relativeBlockPosX = SectionPosition.b(x2);
        int relativeBlockPosZ = SectionPosition.b(z2);
        if (relativeBlockPosX != 0 && relativeBlockPosX != 15 && relativeBlockPosZ != 0 && relativeBlockPosZ != 15) {
            return 0;
        }
        int sectionPosX = SectionPosition.a(x2);
        int sectionPosY = SectionPosition.a(y2);
        int sectionPosZ = SectionPosition.a(z2);
        int i2 = 0;
        while (!((LightEngineStorageSky)this.f).b(SectionPosition.b(sectionPosX, sectionPosY - i2 - 1, sectionPosZ)) && ((LightEngineStorageSky)this.f).a(sectionPosY - i2 - 1)) {
            ++i2;
        }
        return i2;
    }

    private void a(long packedPos, EnumDirection direction, int level, boolean shouldIncrease, int emptySections) {
        if (emptySections != 0) {
            int x2 = BlockPosition.a(packedPos);
            int z2 = BlockPosition.c(packedPos);
            if (LightEngineSky.a(direction, SectionPosition.b(x2), SectionPosition.b(z2))) {
                int y2 = BlockPosition.b(packedPos);
                int sectionPosX = SectionPosition.a(x2);
                int sectionPosZ = SectionPosition.a(z2);
                int i2 = SectionPosition.a(y2) - 1;
                int i1 = i2 - emptySections + 1;
                while (i2 >= i1) {
                    if (!((LightEngineStorageSky)this.f).b(SectionPosition.b(sectionPosX, i2, sectionPosZ))) {
                        --i2;
                        continue;
                    }
                    int blockPosCoord = SectionPosition.c(i2);
                    for (int i22 = 15; i22 >= 0; --i22) {
                        long packedBlockPos = BlockPosition.a(x2, blockPosCoord + i22, z2);
                        if (shouldIncrease) {
                            ((LightEngineStorageSky)this.f).a(packedBlockPos, level);
                            if (level <= 1) continue;
                            this.c(packedBlockPos, LightEngine.a.a(level, true, direction.g()));
                            continue;
                        }
                        ((LightEngineStorageSky)this.f).a(packedBlockPos, 0);
                        this.b(packedBlockPos, LightEngine.a.a(level, direction.g()));
                    }
                    --i2;
                }
            }
        }
    }

    private static boolean a(EnumDirection direction, int x2, int z2) {
        return switch (direction) {
            case EnumDirection.c -> {
                if (z2 == 15) {
                    yield true;
                }
                yield false;
            }
            case EnumDirection.d -> {
                if (z2 == 0) {
                    yield true;
                }
                yield false;
            }
            case EnumDirection.e -> {
                if (x2 == 15) {
                    yield true;
                }
                yield false;
            }
            case EnumDirection.f -> {
                if (x2 == 0) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    public void a(ChunkCoordIntPair chunkPos, boolean lightEnabled) {
        super.a(chunkPos, lightEnabled);
        if (lightEnabled) {
            ChunkSkyLightSources chunkSkyLightSources = Objects.requireNonNullElse(this.b(chunkPos.h, chunkPos.i), this.k);
            int i2 = chunkSkyLightSources.a() - 1;
            int i1 = SectionPosition.a(i2) + 1;
            long zeroNode = SectionPosition.b(chunkPos.h, chunkPos.i);
            int topSectionY = ((LightEngineStorageSky)this.f).n(zeroNode);
            int max = Math.max(((LightEngineStorageSky)this.f).c(), i1);
            for (int i22 = topSectionY - 1; i22 >= max; --i22) {
                NibbleArray dataLayerToWrite = ((LightEngineStorageSky)this.f).c(SectionPosition.b(chunkPos.h, i22, chunkPos.i));
                if (dataLayerToWrite == null || !dataLayerToWrite.d()) continue;
                dataLayerToWrite.a(15);
            }
        }
    }

    @Override
    public void b(ChunkCoordIntPair chunkPos) {
        long zeroNode = SectionPosition.b(chunkPos.h, chunkPos.i);
        ((LightEngineStorageSky)this.f).b(zeroNode, true);
        ChunkSkyLightSources chunkSkyLightSources = Objects.requireNonNullElse(this.b(chunkPos.h, chunkPos.i), this.k);
        ChunkSkyLightSources chunkSkyLightSources1 = Objects.requireNonNullElse(this.b(chunkPos.h, chunkPos.i - 1), this.k);
        ChunkSkyLightSources chunkSkyLightSources2 = Objects.requireNonNullElse(this.b(chunkPos.h, chunkPos.i + 1), this.k);
        ChunkSkyLightSources chunkSkyLightSources3 = Objects.requireNonNullElse(this.b(chunkPos.h - 1, chunkPos.i), this.k);
        ChunkSkyLightSources chunkSkyLightSources4 = Objects.requireNonNullElse(this.b(chunkPos.h + 1, chunkPos.i), this.k);
        int topSectionY = ((LightEngineStorageSky)this.f).n(zeroNode);
        int bottomSectionY = ((LightEngineStorageSky)this.f).c();
        int blockPosX = SectionPosition.c(chunkPos.h);
        int blockPosZ = SectionPosition.c(chunkPos.i);
        for (int i2 = topSectionY - 1; i2 >= bottomSectionY; --i2) {
            long packedSectionPos = SectionPosition.b(chunkPos.h, i2, chunkPos.i);
            NibbleArray dataLayerToWrite = ((LightEngineStorageSky)this.f).c(packedSectionPos);
            if (dataLayerToWrite == null) continue;
            int blockPosCoord = SectionPosition.c(i2);
            int i1 = blockPosCoord + 15;
            boolean flag = false;
            for (int i22 = 0; i22 < 16; ++i22) {
                for (int i3 = 0; i3 < 16; ++i3) {
                    int lowestSourceY = chunkSkyLightSources.a(i3, i22);
                    if (lowestSourceY > i1) continue;
                    int i4 = i22 == 0 ? chunkSkyLightSources1.a(i3, 15) : chunkSkyLightSources.a(i3, i22 - 1);
                    int i5 = i22 == 15 ? chunkSkyLightSources2.a(i3, 0) : chunkSkyLightSources.a(i3, i22 + 1);
                    int i6 = i3 == 0 ? chunkSkyLightSources3.a(15, i22) : chunkSkyLightSources.a(i3 - 1, i22);
                    int i7 = i3 == 15 ? chunkSkyLightSources4.a(0, i22) : chunkSkyLightSources.a(i3 + 1, i22);
                    int max = Math.max(Math.max(i4, i5), Math.max(i6, i7));
                    for (int i8 = i1; i8 >= Math.max(blockPosCoord, lowestSourceY); --i8) {
                        dataLayerToWrite.a(i3, SectionPosition.b(i8), i22, 15);
                        if (i8 != lowestSourceY && i8 >= max) continue;
                        long packedBlockPos = BlockPosition.a(blockPosX + i3, i8, blockPosZ + i22);
                        this.c(packedBlockPos, LightEngine.a.a(i8 == lowestSourceY, i8 < i4, i8 < i5, i8 < i6, i8 < i7));
                    }
                    if (lowestSourceY >= blockPosCoord) continue;
                    flag = true;
                }
            }
            if (!flag) break;
        }
    }
}

