/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.lighting.LightEngineStorageBlock;

public final class LightEngineBlock
extends LightEngine<LightEngineStorageBlock.a, LightEngineStorageBlock> {
    private final BlockPosition.MutableBlockPosition g = new BlockPosition.MutableBlockPosition();

    public LightEngineBlock(ILightAccess chunkSource) {
        this(chunkSource, new LightEngineStorageBlock(chunkSource));
    }

    @VisibleForTesting
    public LightEngineBlock(ILightAccess chunkSource, LightEngineStorageBlock storage) {
        super(chunkSource, storage);
    }

    @Override
    protected void a(long packedPos) {
        long packedSectionPos = SectionPosition.e(packedPos);
        if (((LightEngineStorageBlock)this.f).b(packedSectionPos)) {
            int storedLevel;
            IBlockData state = this.c(this.g.f(packedPos));
            int emission = this.a(packedPos, state);
            if (emission < (storedLevel = ((LightEngineStorageBlock)this.f).e(packedPos))) {
                ((LightEngineStorageBlock)this.f).a(packedPos, 0);
                this.b(packedPos, LightEngine.a.a(storedLevel));
            } else {
                this.b(packedPos, LightEngine.c);
            }
            if (emission > 0) {
                this.c(packedPos, LightEngine.a.a(emission, LightEngineBlock.a(state)));
            }
        }
    }

    @Override
    protected void a(long packedPos, long queueEntry, int lightLevel) {
        IBlockData blockState = null;
        for (EnumDirection direction : LightEngine.d) {
            int storedLevel;
            int i2;
            long offsetPackedBlockPos;
            if (!LightEngine.a.a(queueEntry, direction) || !((LightEngineStorageBlock)this.f).b(SectionPosition.e(offsetPackedBlockPos = BlockPosition.a(packedPos, direction))) || (i2 = lightLevel - 1) <= (storedLevel = ((LightEngineStorageBlock)this.f).e(offsetPackedBlockPos))) continue;
            this.g.f(offsetPackedBlockPos);
            IBlockData state = this.c(this.g);
            int i1 = lightLevel - this.b(state);
            if (i1 <= storedLevel) continue;
            if (blockState == null) {
                IBlockData iBlockData = blockState = LightEngine.a.b(queueEntry) ? Blocks.a.m() : this.c(this.g.f(packedPos));
            }
            if (this.a(blockState, state, direction)) continue;
            ((LightEngineStorageBlock)this.f).a(offsetPackedBlockPos, i1);
            if (i1 <= 1) continue;
            this.c(offsetPackedBlockPos, LightEngine.a.a(i1, LightEngineBlock.a(state), direction.g()));
        }
    }

    @Override
    protected void a(long packedPos, long lightLevel) {
        int fromLevel = LightEngine.a.a(lightLevel);
        for (EnumDirection direction : LightEngine.d) {
            int storedLevel;
            long offsetPackedBlockPos;
            if (!LightEngine.a.a(lightLevel, direction) || !((LightEngineStorageBlock)this.f).b(SectionPosition.e(offsetPackedBlockPos = BlockPosition.a(packedPos, direction))) || (storedLevel = ((LightEngineStorageBlock)this.f).e(offsetPackedBlockPos)) == 0) continue;
            if (storedLevel <= fromLevel - 1) {
                IBlockData state = this.c(this.g.f(offsetPackedBlockPos));
                int emission = this.a(offsetPackedBlockPos, state);
                ((LightEngineStorageBlock)this.f).a(offsetPackedBlockPos, 0);
                if (emission < storedLevel) {
                    this.b(offsetPackedBlockPos, LightEngine.a.a(storedLevel, direction.g()));
                }
                if (emission <= 0) continue;
                this.c(offsetPackedBlockPos, LightEngine.a.a(emission, LightEngineBlock.a(state)));
                continue;
            }
            this.c(offsetPackedBlockPos, LightEngine.a.b(storedLevel, false, direction.g()));
        }
    }

    private int a(long packedPos, IBlockData state) {
        int lightEmission = state.k();
        return lightEmission > 0 && ((LightEngineStorageBlock)this.f).j(SectionPosition.e(packedPos)) ? lightEmission : 0;
    }

    @Override
    public void b(ChunkCoordIntPair chunkPos) {
        this.a(chunkPos, true);
        LightChunk chunkForLighting = this.e.c(chunkPos.h, chunkPos.i);
        if (chunkForLighting != null) {
            chunkForLighting.a((BlockPosition blockPos, IBlockData blockState) -> {
                int lightEmission = blockState.k();
                this.c(blockPos.a(), LightEngine.a.a(lightEmission, LightEngineBlock.a(blockState)));
            });
        }
    }
}

