/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;

public class NoiseGenerator3Handler {
    protected static final int[][] a = new int[][]{{1, 1, 0}, {-1, 1, 0}, {1, -1, 0}, {-1, -1, 0}, {1, 0, 1}, {-1, 0, 1}, {1, 0, -1}, {-1, 0, -1}, {0, 1, 1}, {0, -1, 1}, {0, 1, -1}, {0, -1, -1}, {1, 1, 0}, {0, -1, 1}, {-1, 1, 0}, {0, -1, -1}};
    private static final double e = Math.sqrt(3.0);
    private static final double f = 0.5 * (e - 1.0);
    private static final double g = (3.0 - e) / 6.0;
    private final int[] h = new int[512];
    public final double b;
    public final double c;
    public final double d;

    public NoiseGenerator3Handler(RandomSource random) {
        this.b = random.j() * 256.0;
        this.c = random.j() * 256.0;
        this.d = random.j() * 256.0;
        int i2 = 0;
        while (i2 < 256) {
            this.h[i2] = i2++;
        }
        for (int ix = 0; ix < 256; ++ix) {
            int randomInt = random.a(256 - ix);
            int i1 = this.h[ix];
            this.h[ix] = this.h[randomInt + ix];
            this.h[randomInt + ix] = i1;
        }
    }

    private int a(int index) {
        return this.h[index & 0xFF];
    }

    protected static double a(int[] gradient, double x2, double y2, double z2) {
        return (double)gradient[0] * x2 + (double)gradient[1] * y2 + (double)gradient[2] * z2;
    }

    private double a(int gradientIndex, double x2, double y2, double z2, double offset) {
        double d1;
        double d2 = offset - x2 * x2 - y2 * y2 - z2 * z2;
        if (d2 < 0.0) {
            d1 = 0.0;
        } else {
            d2 *= d2;
            d1 = d2 * d2 * NoiseGenerator3Handler.a(a[gradientIndex], x2, y2, z2);
        }
        return d1;
    }

    public double a(double x2, double y2) {
        int i1;
        int i2;
        double d3;
        double d5;
        int floor1;
        double d1;
        double d2 = (x2 + y2) * f;
        int floor = MathHelper.a(x2 + d2);
        double d22 = (double)floor - (d1 = (double)(floor + (floor1 = MathHelper.a(y2 + d2))) * g);
        double d4 = x2 - d22;
        if (d4 > (d5 = y2 - (d3 = (double)floor1 - d1))) {
            i2 = 1;
            i1 = 0;
        } else {
            i2 = 0;
            i1 = 1;
        }
        double d6 = d4 - (double)i2 + g;
        double d7 = d5 - (double)i1 + g;
        double d8 = d4 - 1.0 + 2.0 * g;
        double d9 = d5 - 1.0 + 2.0 * g;
        int i22 = floor & 0xFF;
        int i3 = floor1 & 0xFF;
        int i4 = this.a(i22 + this.a(i3)) % 12;
        int i5 = this.a(i22 + i2 + this.a(i3 + i1)) % 12;
        int i6 = this.a(i22 + 1 + this.a(i3 + 1)) % 12;
        double cornerNoise3D = this.a(i4, d4, d5, 0.0, 0.5);
        double cornerNoise3D1 = this.a(i5, d6, d7, 0.0, 0.5);
        double cornerNoise3D2 = this.a(i6, d8, d9, 0.0, 0.5);
        return 70.0 * (cornerNoise3D + cornerNoise3D1 + cornerNoise3D2);
    }

    public double a(double x2, double y2, double z2) {
        int i5;
        int i4;
        int i3;
        int i2;
        int i1;
        int i6;
        double d2 = 0.3333333333333333;
        double d1 = (x2 + y2 + z2) * 0.3333333333333333;
        int floor = MathHelper.a(x2 + d1);
        int floor1 = MathHelper.a(y2 + d1);
        int floor2 = MathHelper.a(z2 + d1);
        double d22 = 0.16666666666666666;
        double d3 = (double)(floor + floor1 + floor2) * 0.16666666666666666;
        double d4 = (double)floor - d3;
        double d5 = (double)floor1 - d3;
        double d6 = (double)floor2 - d3;
        double d7 = x2 - d4;
        double d8 = y2 - d5;
        double d9 = z2 - d6;
        if (d7 >= d8) {
            if (d8 >= d9) {
                i6 = 1;
                i1 = 0;
                i2 = 0;
                i3 = 1;
                i4 = 1;
                i5 = 0;
            } else if (d7 >= d9) {
                i6 = 1;
                i1 = 0;
                i2 = 0;
                i3 = 1;
                i4 = 0;
                i5 = 1;
            } else {
                i6 = 0;
                i1 = 0;
                i2 = 1;
                i3 = 1;
                i4 = 0;
                i5 = 1;
            }
        } else if (d8 < d9) {
            i6 = 0;
            i1 = 0;
            i2 = 1;
            i3 = 0;
            i4 = 1;
            i5 = 1;
        } else if (d7 < d9) {
            i6 = 0;
            i1 = 1;
            i2 = 0;
            i3 = 0;
            i4 = 1;
            i5 = 1;
        } else {
            i6 = 0;
            i1 = 1;
            i2 = 0;
            i3 = 1;
            i4 = 1;
            i5 = 0;
        }
        double d10 = d7 - (double)i6 + 0.16666666666666666;
        double d11 = d8 - (double)i1 + 0.16666666666666666;
        double d12 = d9 - (double)i2 + 0.16666666666666666;
        double d13 = d7 - (double)i3 + 0.3333333333333333;
        double d14 = d8 - (double)i4 + 0.3333333333333333;
        double d15 = d9 - (double)i5 + 0.3333333333333333;
        double d16 = d7 - 1.0 + 0.5;
        double d17 = d8 - 1.0 + 0.5;
        double d18 = d9 - 1.0 + 0.5;
        int i62 = floor & 0xFF;
        int i7 = floor1 & 0xFF;
        int i8 = floor2 & 0xFF;
        int i9 = this.a(i62 + this.a(i7 + this.a(i8))) % 12;
        int i10 = this.a(i62 + i6 + this.a(i7 + i1 + this.a(i8 + i2))) % 12;
        int i11 = this.a(i62 + i3 + this.a(i7 + i4 + this.a(i8 + i5))) % 12;
        int i12 = this.a(i62 + 1 + this.a(i7 + 1 + this.a(i8 + 1))) % 12;
        double cornerNoise3D = this.a(i9, d7, d8, d9, 0.6);
        double cornerNoise3D1 = this.a(i10, d10, d11, d12, 0.6);
        double cornerNoise3D2 = this.a(i11, d13, d14, d15, 0.6);
        double cornerNoise3D3 = this.a(i12, d16, d17, d18, 0.6);
        return 32.0 * (cornerNoise3D + cornerNoise3D1 + cornerNoise3D2 + cornerNoise3D3);
    }
}

