/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.BlockVine;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.DefinedStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlackstoneReplace;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockAge;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockIgnore;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorLavaSubmergedBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorPredicates;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestRandomBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestTrue;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.slf4j.Logger;

public class RuinedPortalPiece
extends DefinedStructurePiece {
    private static final Logger h = LogUtils.getLogger();
    private static final float i = 0.3f;
    private static final float j = 0.07f;
    private static final float k = 0.2f;
    private final b l;
    private final a m;

    public RuinedPortalPiece(StructureTemplateManager structureTemplateManager, BlockPosition templatePosition, b verticalPlacement, a properties, MinecraftKey location, DefinedStructure template, EnumBlockRotation rotation, EnumBlockMirror mirror, BlockPosition pivotPos) {
        super(WorldGenFeatureStructurePieceType.J, 0, structureTemplateManager, location, location.toString(), RuinedPortalPiece.a(mirror, rotation, verticalPlacement, pivotPos, properties), templatePosition);
        this.l = verticalPlacement;
        this.m = properties;
    }

    public RuinedPortalPiece(StructureTemplateManager structureTemplateManager, NBTTagCompound tag) {
        super(WorldGenFeatureStructurePieceType.J, tag, structureTemplateManager, resourceLocation -> RuinedPortalPiece.a(structureTemplateManager, tag, resourceLocation));
        this.l = net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece$b.a(tag.l("VerticalPlacement"));
        this.m = (a)net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece$a.a.parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, tag.c("Properties"))).getPartialOrThrow();
    }

    @Override
    protected void a(StructurePieceSerializationContext context, NBTTagCompound tag) {
        super.a(context, tag);
        tag.a("Rotation", this.c.d().name());
        tag.a("Mirror", this.c.c().name());
        tag.a("VerticalPlacement", this.l.a());
        net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece$a.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.m).resultOrPartial(arg_0 -> ((Logger)h).error(arg_0)).ifPresent(tag1 -> tag.a("Properties", (NBTBase)tag1));
    }

    private static DefinedStructureInfo a(StructureTemplateManager structureTemplateManager, NBTTagCompound tag, MinecraftKey location) {
        DefinedStructure structureTemplate = structureTemplateManager.a(location);
        BlockPosition blockPos = new BlockPosition(structureTemplate.a().u() / 2, 0, structureTemplate.a().w() / 2);
        return RuinedPortalPiece.a(EnumBlockMirror.valueOf(tag.l("Mirror")), EnumBlockRotation.valueOf(tag.l("Rotation")), net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece$b.a(tag.l("VerticalPlacement")), blockPos, (a)net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece$a.a.parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, tag.c("Properties"))).getPartialOrThrow());
    }

    private static DefinedStructureInfo a(EnumBlockMirror mirror, EnumBlockRotation rotation, b verticalPlacement, BlockPosition pos, a properties) {
        DefinedStructureProcessorBlockIgnore blockIgnoreProcessor = properties.d ? DefinedStructureProcessorBlockIgnore.b : DefinedStructureProcessorBlockIgnore.d;
        ArrayList list = Lists.newArrayList();
        list.add(RuinedPortalPiece.a(Blocks.co, 0.3f, Blocks.a));
        list.add(RuinedPortalPiece.a(verticalPlacement, properties));
        if (!properties.b) {
            list.add(RuinedPortalPiece.a(Blocks.ei, 0.07f, Blocks.ll));
        }
        DefinedStructureInfo structurePlaceSettings = new DefinedStructureInfo().a(rotation).a(mirror).a(pos).a(blockIgnoreProcessor).a(new DefinedStructureProcessorRule(list)).a(new DefinedStructureProcessorBlockAge(properties.c)).a(new ProtectedBlockProcessor(TagsBlock.bQ)).a(new DefinedStructureProcessorLavaSubmergedBlock());
        if (properties.g) {
            structurePlaceSettings.a(DefinedStructureProcessorBlackstoneReplace.b);
        }
        return structurePlaceSettings;
    }

    private static DefinedStructureProcessorPredicates a(b verticalPlacement, a properties) {
        if (verticalPlacement == net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece$b.c) {
            return RuinedPortalPiece.a(Blocks.K, Blocks.ll);
        }
        return properties.b ? RuinedPortalPiece.a(Blocks.K, Blocks.ei) : RuinedPortalPiece.a(Blocks.K, 0.2f, Blocks.ll);
    }

    @Override
    public void a(GeneratorAccessSeed level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, StructureBoundingBox box, ChunkCoordIntPair chunkPos, BlockPosition pos) {
        StructureBoundingBox boundingBox = this.b.b(this.c, this.d);
        if (box.b(boundingBox.g())) {
            box.b(boundingBox);
            super.a(level, structureManager, generator, random, box, chunkPos, pos);
            this.b(random, level);
            this.a(random, level);
            if (this.m.f || this.m.e) {
                BlockPosition.a(this.f()).forEach(blockPos -> {
                    if (this.m.f) {
                        this.a(random, (GeneratorAccess)level, (BlockPosition)blockPos);
                    }
                    if (this.m.e) {
                        this.b(random, level, (BlockPosition)blockPos);
                    }
                });
            }
        }
    }

    @Override
    protected void a(String name, BlockPosition pos, WorldAccess level, RandomSource random, StructureBoundingBox box) {
    }

    private void a(RandomSource random, GeneratorAccess level, BlockPosition pos) {
        EnumDirection randomHorizontalDirection;
        BlockPosition blockPos;
        IBlockData blockState1;
        IBlockData blockState = level.a_(pos);
        if (!blockState.l() && !blockState.a(Blocks.ft) && (blockState1 = level.a_(blockPos = pos.a(randomHorizontalDirection = RuinedPortalPiece.a(random)))).l() && Block.a(blockState.g(level, pos), randomHorizontalDirection)) {
            BlockStateBoolean propertyForFace = BlockVine.a(randomHorizontalDirection.g());
            level.a(blockPos, (IBlockData)Blocks.ft.m().b(propertyForFace, true), 3);
        }
    }

    private void b(RandomSource random, GeneratorAccess level, BlockPosition pos) {
        if (random.i() < 0.5f && level.a_(pos).a(Blocks.ei) && level.a_(pos.d()).l()) {
            level.a(pos.d(), (IBlockData)Blocks.aN.m().b(BlockLeaves.d, true), 3);
        }
    }

    private void a(RandomSource random, GeneratorAccess level) {
        for (int i2 = this.f.h() + 1; i2 < this.f.k(); ++i2) {
            for (int i1 = this.f.j() + 1; i1 < this.f.m(); ++i1) {
                BlockPosition blockPos = new BlockPosition(i2, this.f.i(), i1);
                if (!level.a_(blockPos).a(Blocks.ei)) continue;
                this.c(random, level, blockPos.e());
            }
        }
    }

    private void c(RandomSource random, GeneratorAccess level, BlockPosition pos) {
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
        this.d(random, level, mutableBlockPos);
        for (int i2 = 8; i2 > 0 && random.i() < 0.5f; --i2) {
            mutableBlockPos.c(EnumDirection.a);
            this.d(random, level, mutableBlockPos);
        }
    }

    private void b(RandomSource random, GeneratorAccess level) {
        boolean flag = this.l == net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece$b.a || this.l == net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece$b.c;
        BlockPosition center = this.f.g();
        int x2 = center.u();
        int z2 = center.w();
        float[] floats = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.9f, 0.9f, 0.8f, 0.7f, 0.6f, 0.4f, 0.2f};
        int i2 = floats.length;
        int i1 = (this.f.d() + this.f.f()) / 2;
        int randomInt = random.a(Math.max(1, 8 - i1 / 2));
        int i22 = 3;
        BlockPosition.MutableBlockPosition mutableBlockPos = BlockPosition.c.k();
        for (int i3 = x2 - i2; i3 <= x2 + i2; ++i3) {
            for (int i4 = z2 - i2; i4 <= z2 + i2; ++i4) {
                int i5 = Math.abs(i3 - x2) + Math.abs(i4 - z2);
                int max = Math.max(0, i5 + randomInt);
                if (max >= i2) continue;
                float f2 = floats[max];
                if (!(random.j() < (double)f2)) continue;
                int surfaceY = RuinedPortalPiece.a(level, i3, i4, this.l);
                int i6 = flag ? surfaceY : Math.min(this.f.i(), surfaceY);
                mutableBlockPos.d(i3, i6, i4);
                if (Math.abs(i6 - this.f.i()) > 3 || !this.a(level, mutableBlockPos)) continue;
                this.d(random, level, mutableBlockPos);
                if (this.m.e) {
                    this.b(random, level, mutableBlockPos);
                }
                this.c(random, level, mutableBlockPos.e());
            }
        }
    }

    private boolean a(GeneratorAccess level, BlockPosition pos) {
        IBlockData blockState = level.a_(pos);
        return !blockState.a(Blocks.a) && !blockState.a(Blocks.cv) && !blockState.a(TagsBlock.bQ) && (this.l == net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece$b.f || !blockState.a(Blocks.K));
    }

    private void d(RandomSource random, GeneratorAccess level, BlockPosition pos) {
        if (!this.m.b && random.i() < 0.07f) {
            level.a(pos, Blocks.ll.m(), 3);
        } else {
            level.a(pos, Blocks.ei.m(), 3);
        }
    }

    private static int a(GeneratorAccess level, int x2, int z2, b verticalPlacement) {
        return level.a(RuinedPortalPiece.a(verticalPlacement), x2, z2) - 1;
    }

    public static HeightMap.Type a(b verticalPlacement) {
        return verticalPlacement == net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece$b.c ? HeightMap.Type.c : HeightMap.Type.a;
    }

    private static DefinedStructureProcessorPredicates a(Block block, float probability, Block replaceBlock) {
        return new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(block, probability), DefinedStructureTestTrue.b, replaceBlock.m());
    }

    private static DefinedStructureProcessorPredicates a(Block block, Block replaceBlock) {
        return new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(block), DefinedStructureTestTrue.b, replaceBlock.m());
    }

    public static final class b
    extends Enum<b>
    implements INamable {
        public static final /* enum */ b a = new b("on_land_surface");
        public static final /* enum */ b b = new b("partly_buried");
        public static final /* enum */ b c = new b("on_ocean_floor");
        public static final /* enum */ b d = new b("in_mountain");
        public static final /* enum */ b e = new b("underground");
        public static final /* enum */ b f = new b("in_nether");
        public static final INamable.a<b> g;
        private final String h;
        private static final /* synthetic */ b[] i;

        public static b[] values() {
            return (b[])i.clone();
        }

        public static b valueOf(String name) {
            return Enum.valueOf(b.class, name);
        }

        private b(String name) {
            this.h = name;
        }

        public String a() {
            return this.h;
        }

        public static b a(String name) {
            return g.a(name);
        }

        @Override
        public String c() {
            return this.h;
        }

        private static /* synthetic */ b[] b() {
            return new b[]{a, b, c, d, e, f};
        }

        static {
            i = net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece$b.b();
            g = INamable.a(b::values);
        }
    }

    public static class a {
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("cold").forGetter(properties -> properties.b), (App)Codec.FLOAT.fieldOf("mossiness").forGetter(properties -> Float.valueOf(properties.c)), (App)Codec.BOOL.fieldOf("air_pocket").forGetter(properties -> properties.d), (App)Codec.BOOL.fieldOf("overgrown").forGetter(properties -> properties.e), (App)Codec.BOOL.fieldOf("vines").forGetter(properties -> properties.f), (App)Codec.BOOL.fieldOf("replace_with_blackstone").forGetter(properties -> properties.g)).apply((Applicative)instance, a::new));
        public boolean b;
        public float c;
        public boolean d;
        public boolean e;
        public boolean f;
        public boolean g;

        public a() {
        }

        public a(boolean cold, float mossiness, boolean airPocket, boolean overgrown, boolean vines, boolean replaceWithBlackstone) {
            this.b = cold;
            this.c = mossiness;
            this.d = airPocket;
            this.e = overgrown;
            this.f = vines;
            this.g = replaceWithBlackstone;
        }
    }
}

