/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.structures.NetherFossilPieces;

public class NetherFossilStructure
extends Structure {
    public static final MapCodec<NetherFossilStructure> d = RecordCodecBuilder.mapCodec(instance -> instance.group(NetherFossilStructure.a(instance), (App)HeightProvider.c.fieldOf("height").forGetter(structure -> structure.e)).apply((Applicative)instance, NetherFossilStructure::new));
    public final HeightProvider e;

    public NetherFossilStructure(Structure.c settings, HeightProvider height) {
        super(settings);
        this.e = height;
    }

    @Override
    public Optional<Structure.b> a(Structure.a context) {
        SeededRandom worldgenRandom = context.f();
        int i2 = context.h().d() + worldgenRandom.a(16);
        int i1 = context.h().e() + worldgenRandom.a(16);
        int seaLevel = context.b().f();
        WorldGenerationContext worldGenerationContext = new WorldGenerationContext(context.b(), context.i());
        int i22 = this.e.a(worldgenRandom, worldGenerationContext);
        BlockColumn baseColumn = context.b().a(i2, i1, context.i(), context.d());
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition(i2, i22, i1);
        while (i22 > seaLevel) {
            IBlockData block = baseColumn.a(i22);
            IBlockData block1 = baseColumn.a(--i22);
            if (!block.l() || !block1.a(Blocks.ej) && !block1.c((IBlockAccess)BlockAccessAir.a, (BlockPosition)mutableBlockPos.q(i22), EnumDirection.b)) continue;
            break;
        }
        if (i22 <= seaLevel) {
            return Optional.empty();
        }
        BlockPosition blockPos = new BlockPosition(i2, i22, i1);
        return Optional.of(new Structure.b(blockPos, structurePiecesBuilder -> NetherFossilPieces.a(context.e(), structurePiecesBuilder, worldgenRandom, blockPos)));
    }

    @Override
    public StructureType<?> e() {
        return StructureType.i;
    }
}

