/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolEmpty;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePools;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class WorldGenFeatureDefinedStructurePoolList
extends WorldGenFeatureDefinedStructurePoolStructure {
    public static final MapCodec<WorldGenFeatureDefinedStructurePoolList> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WorldGenFeatureDefinedStructurePoolStructure.f.listOf().fieldOf("elements").forGetter(listPoolElement -> listPoolElement.b), WorldGenFeatureDefinedStructurePoolList.e()).apply((Applicative)instance, WorldGenFeatureDefinedStructurePoolList::new));
    private final List<WorldGenFeatureDefinedStructurePoolStructure> b;

    public WorldGenFeatureDefinedStructurePoolList(List<WorldGenFeatureDefinedStructurePoolStructure> elements, WorldGenFeatureDefinedStructurePoolTemplate.Matching projection) {
        super(projection);
        if (elements.isEmpty()) {
            throw new IllegalArgumentException("Elements are empty");
        }
        this.b = elements;
        this.b(projection);
    }

    @Override
    public BaseBlockPosition a(StructureTemplateManager structureTemplateManager, EnumBlockRotation rotation) {
        int i2 = 0;
        int i1 = 0;
        int i22 = 0;
        for (WorldGenFeatureDefinedStructurePoolStructure structurePoolElement : this.b) {
            BaseBlockPosition size = structurePoolElement.a(structureTemplateManager, rotation);
            i2 = Math.max(i2, size.u());
            i1 = Math.max(i1, size.v());
            i22 = Math.max(i22, size.w());
        }
        return new BaseBlockPosition(i2, i1, i22);
    }

    @Override
    public List<DefinedStructure.a> a(StructureTemplateManager structureTemplateManager, BlockPosition pos, EnumBlockRotation rotation, RandomSource random) {
        return this.b.get(0).a(structureTemplateManager, pos, rotation, random);
    }

    @Override
    public StructureBoundingBox a(StructureTemplateManager structureTemplateManager, BlockPosition pos, EnumBlockRotation rotation) {
        Stream<StructureBoundingBox> stream = this.b.stream().filter(structurePoolElement -> structurePoolElement != WorldGenFeatureDefinedStructurePoolEmpty.b).map(structurePoolElement -> structurePoolElement.a(structureTemplateManager, pos, rotation));
        return StructureBoundingBox.b(stream::iterator).orElseThrow(() -> new IllegalStateException("Unable to calculate boundingbox for ListPoolElement"));
    }

    @Override
    public boolean a(StructureTemplateManager structureTemplateManager, GeneratorAccessSeed level, StructureManager structureManager, ChunkGenerator generator, BlockPosition offset, BlockPosition pos, EnumBlockRotation rotation, StructureBoundingBox box, RandomSource random, LiquidSettings liquidSettings, boolean keepJigsaws) {
        for (WorldGenFeatureDefinedStructurePoolStructure structurePoolElement : this.b) {
            if (structurePoolElement.a(structureTemplateManager, level, structureManager, generator, offset, pos, rotation, box, random, liquidSettings, keepJigsaws)) continue;
            return false;
        }
        return true;
    }

    @Override
    public WorldGenFeatureDefinedStructurePools<?> a() {
        return WorldGenFeatureDefinedStructurePools.b;
    }

    @Override
    public WorldGenFeatureDefinedStructurePoolStructure a(WorldGenFeatureDefinedStructurePoolTemplate.Matching projection) {
        super.a(projection);
        this.b(projection);
        return this;
    }

    public String toString() {
        return "List[" + this.b.stream().map(Object::toString).collect(Collectors.joining(", ")) + "]";
    }

    private void b(WorldGenFeatureDefinedStructurePoolTemplate.Matching projection) {
        this.b.forEach(structurePoolElement -> structurePoolElement.a(projection));
    }
}

