/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.placement;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.annotation.DoNotUse;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import org.jetbrains.annotations.Nullable;

public abstract class StructurePlacement {
    public static final Codec<StructurePlacement> b = BuiltInRegistries.P.q().dispatch(StructurePlacement::e, StructurePlacementType::codec);
    private static final int a = 10387320;
    public final BaseBlockPosition c;
    public final c d;
    public final float e;
    public final int f;
    public final Optional<a> g;

    protected static <S extends StructurePlacement> Products.P5<RecordCodecBuilder.Mu<S>, BaseBlockPosition, c, Float, Integer, Optional<a>> a(RecordCodecBuilder.Instance<S> instance) {
        return instance.group((App)BaseBlockPosition.v(16).optionalFieldOf("locate_offset", (Object)BaseBlockPosition.h).forGetter(StructurePlacement::f), (App)net.minecraft.world.level.levelgen.structure.placement.StructurePlacement$c.e.optionalFieldOf("frequency_reduction_method", (Object)net.minecraft.world.level.levelgen.structure.placement.StructurePlacement$c.a).forGetter(StructurePlacement::g), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(StructurePlacement::h), (App)ExtraCodecs.l.fieldOf("salt").forGetter(StructurePlacement::i), (App)net.minecraft.world.level.levelgen.structure.placement.StructurePlacement$a.a.optionalFieldOf("exclusion_zone").forGetter(StructurePlacement::j));
    }

    protected StructurePlacement(BaseBlockPosition locateOffset, c frequencyReductionMethod, float frequency, int salt, Optional<a> exclusionZone) {
        this.c = locateOffset;
        this.d = frequencyReductionMethod;
        this.e = frequency;
        this.f = salt;
        this.g = exclusionZone;
    }

    protected BaseBlockPosition f() {
        return this.c;
    }

    protected c g() {
        return this.d;
    }

    protected float h() {
        return this.e;
    }

    protected int i() {
        return this.f;
    }

    protected Optional<a> j() {
        return this.g;
    }

    @Deprecated
    @DoNotUse
    public boolean b(ChunkGeneratorStructureState structureState, int x2, int z2) {
        return this.isStructureChunk(structureState, x2, z2, null);
    }

    public boolean isStructureChunk(ChunkGeneratorStructureState structureState, int x2, int z2, @Nullable ResourceKey<StructureSet> structureSetKey) {
        Integer saltOverride = null;
        if (structureSetKey != null) {
            if (structureSetKey == BuiltinStructureSets.j) {
                saltOverride = structureState.conf.mineshaftSeed;
            } else if (structureSetKey == BuiltinStructureSets.i) {
                saltOverride = structureState.conf.buriedTreasureSeed;
            }
        }
        return this.a(structureState, x2, z2) && this.applyAdditionalChunkRestrictions(x2, z2, structureState.d(), saltOverride) && this.c(structureState, x2, z2);
    }

    public boolean applyAdditionalChunkRestrictions(int regionX, int regionZ, long levelSeed, @Nullable Integer saltOverride) {
        return !(this.e < 1.0f) || this.d.shouldGenerate(levelSeed, this.f, regionX, regionZ, this.e, saltOverride);
    }

    public boolean c(ChunkGeneratorStructureState structureState, int x2, int z2) {
        return !this.g.isPresent() || !this.g.get().a(structureState, x2, z2);
    }

    protected abstract boolean a(ChunkGeneratorStructureState var1, int var2, int var3);

    public BlockPosition a(ChunkCoordIntPair chunkPos) {
        return new BlockPosition(chunkPos.d(), 0, chunkPos.e()).a(this.f());
    }

    public abstract StructurePlacementType<?> e();

    private static boolean probabilityReducer(long levelSeed, int regionX, int regionZ, int salt, float probability, @Nullable Integer saltOverride) {
        SeededRandom worldgenRandom = new SeededRandom(new LegacyRandomSource(0L));
        worldgenRandom.a(levelSeed, regionX, regionZ, salt);
        return worldgenRandom.i() < probability;
    }

    private static boolean legacyProbabilityReducerWithDouble(long baseSeed, int salt, int chunkX, int chunkZ, float probability, @Nullable Integer saltOverride) {
        SeededRandom worldgenRandom = new SeededRandom(new LegacyRandomSource(0L));
        if (saltOverride == null) {
            worldgenRandom.c(baseSeed, chunkX, chunkZ);
        } else {
            worldgenRandom.a(baseSeed, chunkX, chunkZ, saltOverride);
        }
        return worldgenRandom.j() < (double)probability;
    }

    private static boolean legacyArbitrarySaltProbabilityReducer(long levelSeed, int salt, int regionX, int regionZ, float probability, @Nullable Integer saltOverride) {
        SeededRandom worldgenRandom = new SeededRandom(new LegacyRandomSource(0L));
        worldgenRandom.a(levelSeed, regionX, regionZ, saltOverride != null ? saltOverride : 10387320);
        return worldgenRandom.i() < probability;
    }

    private static boolean legacyPillagerOutpostReducer(long levelSeed, int salt, int regionX, int regionZ, float probability, @Nullable Integer saltOverride) {
        int i2 = regionX >> 4;
        int i1 = regionZ >> 4;
        SeededRandom worldgenRandom = new SeededRandom(new LegacyRandomSource(0L));
        worldgenRandom.b((long)(i2 ^ i1 << 4) ^ levelSeed);
        worldgenRandom.f();
        return worldgenRandom.a((int)(1.0f / probability)) == 0;
    }

    public static final class c
    extends Enum<c>
    implements INamable {
        public static final /* enum */ c a = new c("default", StructurePlacement::probabilityReducer);
        public static final /* enum */ c b = new c("legacy_type_1", StructurePlacement::legacyPillagerOutpostReducer);
        public static final /* enum */ c c = new c("legacy_type_2", StructurePlacement::legacyArbitrarySaltProbabilityReducer);
        public static final /* enum */ c d = new c("legacy_type_3", StructurePlacement::legacyProbabilityReducerWithDouble);
        public static final Codec<c> e;
        private final String f;
        private final b g;
        private static final /* synthetic */ c[] h;

        public static c[] values() {
            return (c[])h.clone();
        }

        public static c valueOf(String name) {
            return Enum.valueOf(c.class, name);
        }

        private c(String name, b reducer) {
            this.f = name;
            this.g = reducer;
        }

        public boolean shouldGenerate(long levelSeed, int salt, int regionX, int regionZ, float probability, @Nullable Integer saltOverride) {
            return this.g.shouldGenerate(levelSeed, salt, regionX, regionZ, probability, saltOverride);
        }

        @Override
        public String c() {
            return this.f;
        }

        private static /* synthetic */ c[] a() {
            return new c[]{a, b, c, d};
        }

        static {
            h = net.minecraft.world.level.levelgen.structure.placement.StructurePlacement$c.a();
            e = INamable.a(c::values);
        }
    }

    @Deprecated
    public static final class a
    extends Record {
        private final Holder<StructureSet> b;
        private final int c;
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)RegistryFileCodec.a(Registries.aW, StructureSet.a, false).fieldOf("other_set").forGetter(a::a), (App)Codec.intRange((int)1, (int)16).fieldOf("chunk_count").forGetter(a::b)).apply((Applicative)instance, a::new));

        public a(Holder<StructureSet> otherSet, int chunkCount) {
            this.b = otherSet;
            this.c = chunkCount;
        }

        boolean a(ChunkGeneratorStructureState structureState, int x2, int z2) {
            return structureState.a(this.b, x2, z2, this.c);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "otherSet;chunkCount", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "otherSet;chunkCount", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "otherSet;chunkCount", "b", "c"}, this, o2);
        }

        public Holder<StructureSet> a() {
            return this.b;
        }

        public int b() {
            return this.c;
        }
    }

    @FunctionalInterface
    public static interface b {
        public boolean shouldGenerate(long var1, int var3, int var4, int var5, float var6, @Nullable Integer var7);
    }
}

