/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pieces;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import org.slf4j.Logger;

public record PiecesContainer(List<StructurePiece> a) {
    private final List<StructurePiece> a;
    private static final Logger b = LogUtils.getLogger();
    private static final MinecraftKey c = MinecraftKey.b("jigsaw");
    private static final Map<MinecraftKey, MinecraftKey> d = ImmutableMap.builder().put((Object)MinecraftKey.b("nvi"), (Object)c).put((Object)MinecraftKey.b("pcp"), (Object)c).put((Object)MinecraftKey.b("bastionremnant"), (Object)c).put((Object)MinecraftKey.b("runtime"), (Object)c).build();

    public PiecesContainer(List<StructurePiece> pieces) {
        this.a = List.copyOf(pieces);
    }

    public boolean a() {
        return this.a.isEmpty();
    }

    public boolean a(BlockPosition pos) {
        for (StructurePiece structurePiece : this.a) {
            if (!structurePiece.f().b(pos)) continue;
            return true;
        }
        return false;
    }

    public NBTBase a(StructurePieceSerializationContext context) {
        NBTTagList listTag = new NBTTagList();
        for (StructurePiece structurePiece : this.a) {
            listTag.add(structurePiece.a(context));
        }
        return listTag;
    }

    public static PiecesContainer a(NBTTagList tag, StructurePieceSerializationContext context) {
        ArrayList list = Lists.newArrayList();
        for (int i2 = 0; i2 < tag.size(); ++i2) {
            NBTTagCompound compound = tag.a(i2);
            String string = compound.l("id").toLowerCase(Locale.ROOT);
            MinecraftKey resourceLocation = MinecraftKey.a(string);
            MinecraftKey resourceLocation1 = d.getOrDefault(resourceLocation, resourceLocation);
            WorldGenFeatureStructurePieceType structurePieceType = BuiltInRegistries.Q.a(resourceLocation1);
            if (structurePieceType == null) {
                b.error("Unknown structure piece id: {}", (Object)resourceLocation1);
                continue;
            }
            try {
                StructurePiece structurePiece = structurePieceType.load(context, compound);
                list.add(structurePiece);
                continue;
            }
            catch (Exception var10) {
                b.error("Exception loading structure piece with id {}", (Object)resourceLocation1, (Object)var10);
            }
        }
        return new PiecesContainer(list);
    }

    public StructureBoundingBox b() {
        return StructurePiece.a(this.a.stream());
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{PiecesContainer.class, "pieces", "a"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PiecesContainer.class, "pieces", "a"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PiecesContainer.class, "pieces", "a"}, this, o2);
    }

    public List<StructurePiece> c() {
        return this.a;
    }
}

