/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.slf4j.Logger;

public class WorldGenFeaturePillagerOutpostPoolPiece
extends StructurePiece {
    private static final Logger d = LogUtils.getLogger();
    protected final WorldGenFeatureDefinedStructurePoolStructure a;
    protected BlockPosition b;
    private final int h;
    protected final EnumBlockRotation c;
    private final List<WorldGenFeatureDefinedStructureJigsawJunction> i = Lists.newArrayList();
    private final StructureTemplateManager j;
    private final LiquidSettings k;

    public WorldGenFeaturePillagerOutpostPoolPiece(StructureTemplateManager structureTemplateManager, WorldGenFeatureDefinedStructurePoolStructure element, BlockPosition position, int groundLevelDelta, EnumBlockRotation rotation, StructureBoundingBox boundingBox, LiquidSettings liquidSettings) {
        super(WorldGenFeatureStructurePieceType.ad, 0, boundingBox);
        this.j = structureTemplateManager;
        this.a = element;
        this.b = position;
        this.h = groundLevelDelta;
        this.c = rotation;
        this.k = liquidSettings;
    }

    public WorldGenFeaturePillagerOutpostPoolPiece(StructurePieceSerializationContext context, NBTTagCompound tag) {
        super(WorldGenFeatureStructurePieceType.ad, tag);
        this.j = context.c();
        this.b = new BlockPosition(tag.h("PosX"), tag.h("PosY"), tag.h("PosZ"));
        this.h = tag.h("ground_level_delta");
        RegistryOps<NBTBase> dynamicOps = context.b().a(DynamicOpsNBT.a);
        this.a = (WorldGenFeatureDefinedStructurePoolStructure)WorldGenFeatureDefinedStructurePoolStructure.f.parse(dynamicOps, (Object)tag.p("pool_element")).getPartialOrThrow(string -> new IllegalStateException("Invalid pool element found: " + string));
        this.c = EnumBlockRotation.valueOf(tag.l("rotation"));
        this.f = this.a.a(this.j, this.b, this.c);
        NBTTagList list = tag.c("junctions", 10);
        this.i.clear();
        list.forEach(junctionTag -> this.i.add(WorldGenFeatureDefinedStructureJigsawJunction.a(new Dynamic<NBTBase>((DynamicOps<NBTBase>)dynamicOps, (NBTBase)junctionTag))));
        this.k = LiquidSettings.c.parse((DynamicOps)DynamicOpsNBT.a, (Object)tag.c("liquid_settings")).result().orElse(JigsawStructure.e);
    }

    @Override
    protected void a(StructurePieceSerializationContext context, NBTTagCompound tag) {
        tag.a("PosX", this.b.u());
        tag.a("PosY", this.b.v());
        tag.a("PosZ", this.b.w());
        tag.a("ground_level_delta", this.h);
        RegistryOps<NBTBase> dynamicOps = context.b().a(DynamicOpsNBT.a);
        WorldGenFeatureDefinedStructurePoolStructure.f.encodeStart(dynamicOps, (Object)this.a).resultOrPartial(arg_0 -> ((Logger)d).error(arg_0)).ifPresent(elementTag -> tag.a("pool_element", (NBTBase)elementTag));
        tag.a("rotation", this.c.name());
        NBTTagList listTag = new NBTTagList();
        for (WorldGenFeatureDefinedStructureJigsawJunction jigsawJunction : this.i) {
            listTag.add(jigsawJunction.a(dynamicOps).getValue());
        }
        tag.a("junctions", listTag);
        if (this.k != JigsawStructure.e) {
            tag.a("liquid_settings", (NBTBase)LiquidSettings.c.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.k).getOrThrow());
        }
    }

    @Override
    public void a(GeneratorAccessSeed level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, StructureBoundingBox box, ChunkCoordIntPair chunkPos, BlockPosition pos) {
        this.a(level, structureManager, generator, random, box, pos, false);
    }

    public void a(GeneratorAccessSeed level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, StructureBoundingBox box, BlockPosition pos, boolean keepJigsaws) {
        this.a.a(this.j, level, structureManager, generator, this.b, pos, this.c, box, random, this.k, keepJigsaws);
    }

    @Override
    public void a(int x2, int y2, int z2) {
        super.a(x2, y2, z2);
        this.b = this.b.b(x2, y2, z2);
    }

    @Override
    public EnumBlockRotation a() {
        return this.c;
    }

    public String toString() {
        return String.format(Locale.ROOT, "<%s | %s | %s | %s>", this.getClass().getSimpleName(), this.b, this.c, this.a);
    }

    public WorldGenFeatureDefinedStructurePoolStructure b() {
        return this.a;
    }

    public BlockPosition c() {
        return this.b;
    }

    public int d() {
        return this.h;
    }

    public void a(WorldGenFeatureDefinedStructureJigsawJunction junction) {
        this.i.add(junction);
    }

    public List<WorldGenFeatureDefinedStructureJigsawJunction> e() {
        return this.i;
    }
}

