/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.logging.LogUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentStructure;
import org.bukkit.craftbukkit.v1_21_R3.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R3.persistence.DirtyCraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftStructureTransformer;
import org.bukkit.craftbukkit.v1_21_R3.util.TransformerGeneratorAccess;
import org.bukkit.event.world.AsyncStructureGenerateEvent;
import org.slf4j.Logger;

public final class StructureStart {
    public static final String a = "INVALID";
    public static final StructureStart b = new StructureStart(null, new ChunkCoordIntPair(0, 0), 0, new PiecesContainer(List.of()));
    private static final Logger c = LogUtils.getLogger();
    private final Structure d;
    private final PiecesContainer e;
    private final ChunkCoordIntPair f;
    private int g;
    @Nullable
    private volatile StructureBoundingBox h;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public DirtyCraftPersistentDataContainer persistentDataContainer = new DirtyCraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    public AsyncStructureGenerateEvent.Cause generationEventCause = AsyncStructureGenerateEvent.Cause.WORLD_GENERATION;

    public StructureStart(Structure structure, ChunkCoordIntPair chunkPos, int references, PiecesContainer pieceContainer) {
        this.d = structure;
        this.f = chunkPos;
        this.g = references;
        this.e = pieceContainer;
    }

    @Nullable
    public static StructureStart a(StructurePieceSerializationContext context, NBTTagCompound tag, long seed) {
        String string = tag.l("id");
        if (a.equals(string)) {
            return b;
        }
        IRegistry<Structure> registry = context.b().e(Registries.aU);
        Structure structure = registry.a(MinecraftKey.a(string));
        if (structure == null) {
            c.error("Unknown stucture id: {}", (Object)string);
            return null;
        }
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(tag.h("ChunkX"), tag.h("ChunkZ"));
        int _int = tag.h("references");
        NBTTagList list = tag.c("Children", 10);
        try {
            PiecesContainer piecesContainer = PiecesContainer.a(list, context);
            if (structure instanceof OceanMonumentStructure) {
                piecesContainer = OceanMonumentStructure.a(chunkPos, seed, piecesContainer);
            }
            return new StructureStart(structure, chunkPos, _int, piecesContainer);
        }
        catch (Exception var11) {
            c.error("Failed Start with id {}", (Object)string, (Object)var11);
            return null;
        }
    }

    public StructureBoundingBox a() {
        StructureBoundingBox boundingBox = this.h;
        if (boundingBox == null) {
            this.h = boundingBox = this.d.a(this.e.b());
        }
        return boundingBox;
    }

    public void a(GeneratorAccessSeed level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, StructureBoundingBox box, ChunkCoordIntPair chunkPos) {
        List<StructurePiece> list = this.e.c();
        if (!list.isEmpty()) {
            StructureBoundingBox boundingBox = list.get((int)0).f;
            BlockPosition center = boundingBox.g();
            BlockPosition blockPos = new BlockPosition(center.u(), boundingBox.i(), center.w());
            List<StructurePiece> pieces = list.stream().filter(piece -> piece.f().a(box)).toList();
            if (!pieces.isEmpty()) {
                TransformerGeneratorAccess transformerAccess = new TransformerGeneratorAccess();
                transformerAccess.setHandle(level);
                transformerAccess.setStructureTransformer(new CraftStructureTransformer(this.generationEventCause, level, structureManager, this.d, box, chunkPos));
                for (StructurePiece piece2 : pieces) {
                    piece2.a((GeneratorAccessSeed)transformerAccess, structureManager, generator, random, box, chunkPos, blockPos);
                }
                transformerAccess.getStructureTransformer().discard();
            }
            this.d.a(level, structureManager, generator, random, box, chunkPos, this.e);
        }
    }

    public NBTTagCompound a(StructurePieceSerializationContext context, ChunkCoordIntPair chunkPos) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        if (!this.persistentDataContainer.isEmpty()) {
            compoundTag.a("StructureBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        if (this.b()) {
            compoundTag.a("id", context.b().e(Registries.aU).b(this.d).toString());
            compoundTag.a("ChunkX", chunkPos.h);
            compoundTag.a("ChunkZ", chunkPos.i);
            compoundTag.a("references", this.g);
            compoundTag.a("Children", this.e.a(context));
            return compoundTag;
        }
        compoundTag.a("id", a);
        return compoundTag;
    }

    public boolean b() {
        return !this.e.a();
    }

    public ChunkCoordIntPair c() {
        return this.f;
    }

    public boolean d() {
        return this.g < this.g();
    }

    public void e() {
        ++this.g;
    }

    public int f() {
        return this.g;
    }

    protected int g() {
        return 1;
    }

    public Structure h() {
        return this.d;
    }

    public List<StructurePiece> i() {
        return this.e.c();
    }
}

