/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.moonrise.common.map.SynchronisedLong2BooleanMap;
import ca.spottedleaf.moonrise.common.map.SynchronisedLong2ObjectMap;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.visitors.CollectFields;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.structures.BuriedTreasureStructure;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.slf4j.Logger;

public class StructureCheck {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = -1;
    private final ChunkScanAccess c;
    private final IRegistryCustom d;
    private final StructureTemplateManager e;
    private final ResourceKey<WorldDimension> f;
    private final ChunkGenerator g;
    private final RandomState h;
    private final LevelHeightAccessor i;
    private final WorldChunkManager j;
    private final long k;
    private final DataFixer l;
    private static final int CHUNK_TOTAL_LIMIT = 2020050;
    private static final int PER_FEATURE_CHECK_LIMIT = 2020050;
    private final SynchronisedLong2ObjectMap<Object2IntMap<Structure>> loadedChunksSafe = new SynchronisedLong2ObjectMap(2020050);
    private final ConcurrentHashMap<Structure, SynchronisedLong2BooleanMap> featureChecksSafe = new ConcurrentHashMap();

    public StructureCheck(ChunkScanAccess storageAccess, IRegistryCustom registryAccess, StructureTemplateManager structureTemplateManager, ResourceKey<WorldDimension> dimension, ChunkGenerator chunkGenerator, RandomState randomState, LevelHeightAccessor heightAccessor, WorldChunkManager biomeSource, long seed, DataFixer fixerUpper) {
        this.c = storageAccess;
        this.d = registryAccess;
        this.e = structureTemplateManager;
        this.f = dimension;
        this.g = chunkGenerator;
        this.h = randomState;
        this.i = heightAccessor;
        this.j = biomeSource;
        this.k = seed;
        this.l = fixerUpper;
    }

    @Nullable
    private Integer getSaltOverride(Structure type) {
        LevelHeightAccessor levelHeightAccessor = this.i;
        if (levelHeightAccessor instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)levelHeightAccessor;
            if (type instanceof MineshaftStructure) {
                return serverLevel.spigotConfig.mineshaftSeed;
            }
            if (type instanceof BuriedTreasureStructure) {
                return serverLevel.spigotConfig.buriedTreasureSeed;
            }
        }
        return null;
    }

    public StructureCheckResult a(ChunkCoordIntPair chunkPos, Structure structure, StructurePlacement placement, boolean skipKnownStructures) {
        long packedChunkPos = chunkPos.a();
        Object2IntMap<Structure> map = this.loadedChunksSafe.get(packedChunkPos);
        if (map != null) {
            return this.a(map, structure, skipKnownStructures);
        }
        StructureCheckResult structureCheckResult = this.a(chunkPos, structure, skipKnownStructures, packedChunkPos);
        if (structureCheckResult != null) {
            return structureCheckResult;
        }
        if (!placement.applyAdditionalChunkRestrictions(chunkPos.h, chunkPos.i, this.k, this.getSaltOverride(structure))) {
            return StructureCheckResult.b;
        }
        boolean flag = this.featureChecksSafe.computeIfAbsent(structure, structure1 -> new SynchronisedLong2BooleanMap(2020050)).getOrCompute(packedChunkPos, l2 -> this.b(chunkPos, structure));
        return !flag ? StructureCheckResult.b : StructureCheckResult.c;
    }

    private boolean b(ChunkCoordIntPair chunkPos, Structure structure) {
        return structure.b(new Structure.a(this.d, this.g, this.j, this.h, this.e, this.k, chunkPos, this.i, structure.a()::a)).isPresent();
    }

    @Nullable
    private StructureCheckResult a(ChunkCoordIntPair chunkPos, Structure structure, boolean skipKnownStructures, long packedChunkPos) {
        NBTTagCompound compoundTag1;
        CollectFields collectFields = new CollectFields(new FieldSelector(NBTTagInt.a, "DataVersion"), new FieldSelector("Level", "Structures", NBTTagCompound.b, "Starts"), new FieldSelector("structures", NBTTagCompound.b, "starts"));
        try {
            this.c.a(chunkPos, collectFields).join();
        }
        catch (Exception var13) {
            a.warn("Failed to read chunk {}", (Object)chunkPos, (Object)var13);
            return StructureCheckResult.c;
        }
        NBTBase nBTBase = collectFields.d();
        if (!(nBTBase instanceof NBTTagCompound)) {
            return null;
        }
        NBTTagCompound compoundTag = (NBTTagCompound)nBTBase;
        int version = IChunkLoader.a(compoundTag);
        if (version <= 1493) {
            return StructureCheckResult.c;
        }
        IChunkLoader.a(compoundTag, this.f, this.g.c());
        try {
            compoundTag1 = MCDataConverter.convertTag(MCTypeRegistry.CHUNK, compoundTag, version, SharedConstants.b().d().c());
        }
        catch (Exception var12) {
            a.warn("Failed to partially datafix chunk {}", (Object)chunkPos, (Object)var12);
            return StructureCheckResult.c;
        }
        Object2IntMap<Structure> map = this.a(compoundTag1);
        if (map == null) {
            return null;
        }
        this.a(packedChunkPos, map);
        return this.a(map, structure, skipKnownStructures);
    }

    @Nullable
    private Object2IntMap<Structure> a(NBTTagCompound tag) {
        if (!tag.b("structures", 10)) {
            return null;
        }
        NBTTagCompound compound = tag.p("structures");
        if (!compound.b("starts", 10)) {
            return null;
        }
        NBTTagCompound compound1 = compound.p("starts");
        if (compound1.g()) {
            return Object2IntMaps.emptyMap();
        }
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        IRegistry<Structure> registry = this.d.e(Registries.aU);
        for (String string : compound1.e()) {
            String string1;
            NBTTagCompound compound2;
            Structure structure;
            MinecraftKey resourceLocation = MinecraftKey.c(string);
            if (resourceLocation == null || (structure = registry.a(resourceLocation)) == null || (compound2 = compound1.p(string)).g() || "INVALID".equals(string1 = compound2.l("id"))) continue;
            int _int = compound2.h("references");
            map.put((Object)structure, _int);
        }
        return map;
    }

    private static Object2IntMap<Structure> a(Object2IntMap<Structure> map) {
        return map.isEmpty() ? Object2IntMaps.emptyMap() : map;
    }

    private StructureCheckResult a(Object2IntMap<Structure> structureChunks, Structure structure, boolean skipKnownStructures) {
        int orDefault = structureChunks.getOrDefault((Object)structure, -1);
        return orDefault == -1 || skipKnownStructures && orDefault != 0 ? StructureCheckResult.b : StructureCheckResult.a;
    }

    public void a(ChunkCoordIntPair chunkPos, Map<Structure, StructureStart> chunkStarts) {
        long packedChunkPos = chunkPos.a();
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        chunkStarts.forEach((arg_0, arg_1) -> StructureCheck.a((Object2IntMap)map, arg_0, arg_1));
        this.a(packedChunkPos, (Object2IntMap<Structure>)map);
    }

    private void a(long chunkPos, Object2IntMap<Structure> structureChunks) {
        this.loadedChunksSafe.put(chunkPos, StructureCheck.a(structureChunks));
        for (SynchronisedLong2BooleanMap value : this.featureChecksSafe.values()) {
            value.remove(chunkPos);
        }
    }

    public void a(ChunkCoordIntPair pos, Structure structure) {
        this.loadedChunksSafe.compute(pos.a(), (_long, map) -> {
            if (map == null) {
                map = new Object2IntOpenHashMap();
            } else {
                Object2IntOpenHashMap object2IntOpenHashMap;
                if (map instanceof Object2IntOpenHashMap) {
                    Object2IntOpenHashMap fastClone = (Object2IntOpenHashMap)map;
                    object2IntOpenHashMap = fastClone.clone();
                } else {
                    object2IntOpenHashMap = new Object2IntOpenHashMap(map);
                }
                map = object2IntOpenHashMap;
            }
            map.computeInt((Object)structure, (structure1, integer) -> integer == null ? 1 : integer + 1);
            return map;
        });
    }

    private static /* synthetic */ void a(Object2IntMap map, Structure structure, StructureStart structureStart) {
        if (structureStart.b()) {
            map.put((Object)structure, structureStart.f());
        }
    }
}

