/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.structure.PersistentIndexed;
import net.minecraft.world.level.storage.WorldPersistentData;

public class PersistentStructureLegacy {
    private static final Map<String, String> a = SystemUtils.a(Maps.newHashMap(), (? super T map) -> {
        map.put("Village", "Village");
        map.put("Mineshaft", "Mineshaft");
        map.put("Mansion", "Mansion");
        map.put("Igloo", "Temple");
        map.put("Desert_Pyramid", "Temple");
        map.put("Jungle_Pyramid", "Temple");
        map.put("Swamp_Hut", "Temple");
        map.put("Stronghold", "Stronghold");
        map.put("Monument", "Monument");
        map.put("Fortress", "Fortress");
        map.put("EndCity", "EndCity");
    });
    private static final Map<String, String> b = SystemUtils.a(Maps.newHashMap(), (? super T map) -> {
        map.put("Iglu", "Igloo");
        map.put("TeDP", "Desert_Pyramid");
        map.put("TeJP", "Jungle_Pyramid");
        map.put("TeSH", "Swamp_Hut");
    });
    private static final Set<String> c = Set.of("pillager_outpost", "mineshaft", "mansion", "jungle_pyramid", "desert_pyramid", "igloo", "ruined_portal", "shipwreck", "swamp_hut", "stronghold", "monument", "ocean_ruin", "fortress", "endcity", "buried_treasure", "village", "nether_fossil", "bastion_remnant");
    private final boolean d;
    private final Map<String, Long2ObjectMap<NBTTagCompound>> e = Maps.newHashMap();
    private final Map<String, PersistentIndexed> f = Maps.newHashMap();
    private final List<String> g;
    private final List<String> h;

    public PersistentStructureLegacy(@Nullable WorldPersistentData storage, List<String> legacyKeys, List<String> currentKeys) {
        this.g = legacyKeys;
        this.h = currentKeys;
        this.a(storage);
        boolean flag = false;
        for (String string : this.h) {
            flag |= this.e.get(string) != null;
        }
        this.d = flag;
    }

    public void a(long packedChunkPos) {
        for (String string : this.g) {
            PersistentIndexed structureFeatureIndexSavedData = this.f.get(string);
            if (structureFeatureIndexSavedData == null || !structureFeatureIndexSavedData.c(packedChunkPos)) continue;
            structureFeatureIndexSavedData.d(packedChunkPos);
        }
    }

    public NBTTagCompound a(NBTTagCompound tag) {
        NBTTagCompound compound = tag.p("Level");
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(compound.h("xPos"), compound.h("zPos"));
        if (this.a(chunkPos.h, chunkPos.i)) {
            tag = this.a(tag, chunkPos);
        }
        NBTTagCompound compound1 = compound.p("Structures");
        NBTTagCompound compound2 = compound1.p("References");
        for (String string : this.h) {
            boolean flag = c.contains(string.toLowerCase(Locale.ROOT));
            if (compound2.b(string, 12) || !flag) continue;
            int i2 = 8;
            LongArrayList list = new LongArrayList();
            for (int i1 = chunkPos.h - 8; i1 <= chunkPos.h + 8; ++i1) {
                for (int i22 = chunkPos.i - 8; i22 <= chunkPos.i + 8; ++i22) {
                    if (!this.a(i1, i22, string)) continue;
                    list.add(ChunkCoordIntPair.c(i1, i22));
                }
            }
            compound2.c(string, (List<Long>)list);
        }
        compound1.a("References", compound2);
        compound.a("Structures", compound1);
        tag.a("Level", compound);
        return tag;
    }

    private boolean a(int chunkX, int chunkZ, String key) {
        return this.d && this.e.get(key) != null && this.f.get(a.get(key)).b(ChunkCoordIntPair.c(chunkX, chunkZ));
    }

    private boolean a(int chunkX, int chunkZ) {
        if (!this.d) {
            return false;
        }
        for (String string : this.h) {
            if (this.e.get(string) == null || !this.f.get(a.get(string)).c(ChunkCoordIntPair.c(chunkX, chunkZ))) continue;
            return true;
        }
        return false;
    }

    private NBTTagCompound a(NBTTagCompound tag, ChunkCoordIntPair chunkPos) {
        NBTTagCompound compound = tag.p("Level");
        NBTTagCompound compound1 = compound.p("Structures");
        NBTTagCompound compound2 = compound1.p("Starts");
        for (String string : this.h) {
            NBTTagCompound compoundTag;
            Long2ObjectMap<NBTTagCompound> map = this.e.get(string);
            if (map == null) continue;
            long packedChunkPos = chunkPos.a();
            if (!this.f.get(a.get(string)).c(packedChunkPos) || (compoundTag = (NBTTagCompound)map.get(packedChunkPos)) == null) continue;
            compound2.a(string, compoundTag);
        }
        compound1.a("Starts", compound2);
        compound.a("Structures", compound1);
        tag.a("Level", compound);
        return tag;
    }

    private void a(@Nullable WorldPersistentData storage) {
        if (storage != null) {
            for (String string : this.g) {
                NBTTagCompound compoundTag = new NBTTagCompound();
                try {
                    compoundTag = storage.a(string, DataFixTypes.o, 1493).p("data").p("Features");
                    if (compoundTag.g()) {
                        continue;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                for (String string1 : compoundTag.e()) {
                    String string2;
                    String string3;
                    NBTTagCompound compound = compoundTag.p(string1);
                    long packedChunkPos = ChunkCoordIntPair.c(compound.h("ChunkX"), compound.h("ChunkZ"));
                    NBTTagList list = compound.c("Children", 10);
                    if (!list.isEmpty() && (string3 = b.get(string2 = list.a(0).l("id"))) != null) {
                        compound.a("id", string3);
                    }
                    string2 = compound.l("id");
                    this.e.computeIfAbsent(string2, string6 -> new Long2ObjectOpenHashMap()).put(packedChunkPos, (Object)compound);
                }
                String string4 = string + "_index";
                PersistentIndexed structureFeatureIndexSavedData = storage.a(PersistentIndexed.a(), string4);
                if (structureFeatureIndexSavedData.b().isEmpty()) {
                    PersistentIndexed structureFeatureIndexSavedData1 = new PersistentIndexed();
                    this.f.put(string, structureFeatureIndexSavedData1);
                    for (String string5 : compoundTag.e()) {
                        NBTTagCompound compound1 = compoundTag.p(string5);
                        structureFeatureIndexSavedData1.a(ChunkCoordIntPair.c(compound1.h("ChunkX"), compound1.h("ChunkZ")));
                    }
                    continue;
                }
                this.f.put(string, structureFeatureIndexSavedData);
            }
        }
    }

    public static PersistentStructureLegacy a(ResourceKey<WorldDimension> level, @Nullable WorldPersistentData storage) {
        if (level == WorldDimension.b) {
            return new PersistentStructureLegacy(storage, (List<String>)ImmutableList.of((Object)"Monument", (Object)"Stronghold", (Object)"Village", (Object)"Mineshaft", (Object)"Temple", (Object)"Mansion"), (List<String>)ImmutableList.of((Object)"Village", (Object)"Mineshaft", (Object)"Mansion", (Object)"Igloo", (Object)"Desert_Pyramid", (Object)"Jungle_Pyramid", (Object)"Swamp_Hut", (Object)"Stronghold", (Object)"Monument"));
        }
        if (level == WorldDimension.c) {
            ImmutableList list = ImmutableList.of((Object)"Fortress");
            return new PersistentStructureLegacy(storage, (List<String>)list, (List<String>)list);
        }
        if (level == WorldDimension.d) {
            ImmutableList list = ImmutableList.of((Object)"EndCity");
            return new PersistentStructureLegacy(storage, (List<String>)list, (List<String>)list);
        }
        throw new RuntimeException(String.format(Locale.ROOT, "Unknown dimension type : %s", level));
    }
}

