/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.presets;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.WorldDimensions;

public class WorldPreset {
    public static final Codec<WorldPreset> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap(ResourceKey.a(Registries.bf), WorldDimension.a).fieldOf("dimensions").forGetter(worldPreset -> worldPreset.c)).apply((Applicative)instance, WorldPreset::new)).validate(WorldPreset::a);
    public static final Codec<Holder<WorldPreset>> b = RegistryFileCodec.a(Registries.bb, a);
    private final Map<ResourceKey<WorldDimension>, WorldDimension> c;

    public WorldPreset(Map<ResourceKey<WorldDimension>, WorldDimension> dimensions) {
        this.c = dimensions;
    }

    private ImmutableMap<ResourceKey<WorldDimension>, WorldDimension> c() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        WorldDimensions.a(this.c.keySet().stream()).forEach(resourceKey -> {
            WorldDimension levelStem = this.c.get(resourceKey);
            if (levelStem != null) {
                builder.put(resourceKey, (Object)levelStem);
            }
        });
        return builder.build();
    }

    public WorldDimensions a() {
        return new WorldDimensions((Map<ResourceKey<WorldDimension>, WorldDimension>)this.c());
    }

    public Optional<WorldDimension> b() {
        return Optional.ofNullable(this.c.get(WorldDimension.b));
    }

    private static DataResult<WorldPreset> a(WorldPreset preset) {
        return preset.b().isEmpty() ? DataResult.error(() -> "Missing overworld dimension") : DataResult.success((Object)preset, (Lifecycle)Lifecycle.stable());
    }
}

