/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.placement.RepeatingPlacement;

public class NoiseBasedCountPlacement
extends RepeatingPlacement {
    public static final MapCodec<NoiseBasedCountPlacement> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("noise_to_count_ratio").forGetter(placement -> placement.c), (App)Codec.DOUBLE.fieldOf("noise_factor").forGetter(placement -> placement.d), (App)Codec.DOUBLE.fieldOf("noise_offset").orElse((Object)0.0).forGetter(placement -> placement.e)).apply((Applicative)instance, NoiseBasedCountPlacement::new));
    private final int c;
    private final double d;
    private final double e;

    private NoiseBasedCountPlacement(int noiseToCountRatio, double noiseFactor, double noiseOffset) {
        this.c = noiseToCountRatio;
        this.d = noiseFactor;
        this.e = noiseOffset;
    }

    public static NoiseBasedCountPlacement a(int noiseToCountRatio, double noiseFactor, double noiseOffset) {
        return new NoiseBasedCountPlacement(noiseToCountRatio, noiseFactor, noiseOffset);
    }

    @Override
    protected int a(RandomSource random, BlockPosition pos) {
        double value = BiomeBase.e.a((double)pos.u() / this.d, (double)pos.w() / this.d, false);
        return (int)Math.ceil((value + this.e) * (double)this.c);
    }

    @Override
    public PlacementModifierType<?> b() {
        return PlacementModifierType.g;
    }
}

