/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.heightproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import org.slf4j.Logger;

public class TrapezoidHeight
extends HeightProvider {
    public static final MapCodec<TrapezoidHeight> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)VerticalAnchor.a.fieldOf("min_inclusive").forGetter(provider -> provider.d), (App)VerticalAnchor.a.fieldOf("max_inclusive").forGetter(provider -> provider.e), (App)Codec.INT.optionalFieldOf("plateau", (Object)0).forGetter(provider -> provider.f)).apply((Applicative)instance, TrapezoidHeight::new));
    private static final Logger b = LogUtils.getLogger();
    private final VerticalAnchor d;
    private final VerticalAnchor e;
    private final int f;

    private TrapezoidHeight(VerticalAnchor minInclusive, VerticalAnchor maxInclusive, int plateau) {
        this.d = minInclusive;
        this.e = maxInclusive;
        this.f = plateau;
    }

    public static TrapezoidHeight a(VerticalAnchor minInclusive, VerticalAnchor maxInclusive, int plateau) {
        return new TrapezoidHeight(minInclusive, maxInclusive, plateau);
    }

    public static TrapezoidHeight a(VerticalAnchor minInclusive, VerticalAnchor maxInclusive) {
        return TrapezoidHeight.a(minInclusive, maxInclusive, 0);
    }

    @Override
    public int a(RandomSource random, WorldGenerationContext context) {
        int i1;
        int i2 = this.d.a(context);
        if (i2 > (i1 = this.e.a(context))) {
            b.warn("Empty height range: {}", (Object)this);
            return i2;
        }
        int i22 = i1 - i2;
        if (this.f >= i22) {
            return MathHelper.b(random, i2, i1);
        }
        int i3 = (i22 - this.f) / 2;
        int i4 = i22 - i3;
        return i2 + MathHelper.b(random, 0, i4) + MathHelper.b(random, 0, i3);
    }

    @Override
    public HeightProviderType<?> a() {
        return HeightProviderType.e;
    }

    public String toString() {
        return this.f == 0 ? "triangle (" + String.valueOf(this.d) + "-" + String.valueOf(this.e) + ")" : "trapezoid(" + this.f + ") in [" + String.valueOf(this.d) + "-" + String.valueOf(this.e) + "]";
    }
}

