/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.flat;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureFillConfiguration;
import net.minecraft.world.level.levelgen.flat.WorldGenFlatLayerInfo;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.slf4j.Logger;

public class GeneratorSettingsFlat {
    private static final Logger b = LogUtils.getLogger();
    public static final Codec<GeneratorSettingsFlat> a = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.a(Registries.aW).lenientOptionalFieldOf("structure_overrides").forGetter(flatLevelGeneratorSettings -> flatLevelGeneratorSettings.c), (App)WorldGenFlatLayerInfo.a.listOf().fieldOf("layers").forGetter(GeneratorSettingsFlat::e), (App)Codec.BOOL.fieldOf("lakes").orElse((Object)false).forGetter(flatLevelGeneratorSettings -> flatLevelGeneratorSettings.i), (App)Codec.BOOL.fieldOf("features").orElse((Object)false).forGetter(flatLevelGeneratorSettings -> flatLevelGeneratorSettings.h), (App)BiomeBase.c.lenientOptionalFieldOf("biome").orElseGet(Optional::empty).forGetter(flatLevelGeneratorSettings -> Optional.of(flatLevelGeneratorSettings.e)), RegistryOps.d(Biomes.b), RegistryOps.d(MiscOverworldPlacements.g), RegistryOps.d(MiscOverworldPlacements.h)).apply((Applicative)instance, GeneratorSettingsFlat::new)).comapFlatMap(GeneratorSettingsFlat::a, Function.identity()).stable();
    private final Optional<HolderSet<StructureSet>> c;
    private final List<WorldGenFlatLayerInfo> d = Lists.newArrayList();
    private final Holder<BiomeBase> e;
    private final List<IBlockData> f;
    private boolean g;
    private boolean h;
    private boolean i;
    private final List<Holder<PlacedFeature>> j;

    private static DataResult<GeneratorSettingsFlat> a(GeneratorSettingsFlat flatSettings) {
        int i2 = flatSettings.d.stream().mapToInt(WorldGenFlatLayerInfo::a).sum();
        return i2 > 4064 ? DataResult.error(() -> "Sum of layer heights is > 4064", (Object)flatSettings) : DataResult.success((Object)flatSettings);
    }

    private GeneratorSettingsFlat(Optional<HolderSet<StructureSet>> structureOverrides, List<WorldGenFlatLayerInfo> layersInfo, boolean addLakes, boolean decoration, Optional<Holder<BiomeBase>> biome, Holder.c<BiomeBase> defaultBiome, Holder<PlacedFeature> lavaUnderground, Holder<PlacedFeature> lavaSurface) {
        this(structureOverrides, GeneratorSettingsFlat.a(biome, defaultBiome), List.of(lavaUnderground, lavaSurface));
        if (addLakes) {
            this.b();
        }
        if (decoration) {
            this.a();
        }
        this.d.addAll(layersInfo);
        this.g();
    }

    private static Holder<BiomeBase> a(Optional<? extends Holder<BiomeBase>> biome, Holder<BiomeBase> defaultBiome) {
        if (biome.isEmpty()) {
            b.error("Unknown biome, defaulting to plains");
            return defaultBiome;
        }
        return biome.get();
    }

    public GeneratorSettingsFlat(Optional<HolderSet<StructureSet>> structureOverrides, Holder<BiomeBase> biome, List<Holder<PlacedFeature>> lakes) {
        this.c = structureOverrides;
        this.e = biome;
        this.f = Lists.newArrayList();
        this.j = lakes;
    }

    public GeneratorSettingsFlat a(List<WorldGenFlatLayerInfo> layerInfos, Optional<HolderSet<StructureSet>> structureSets, Holder<BiomeBase> biome) {
        GeneratorSettingsFlat flatLevelGeneratorSettings = new GeneratorSettingsFlat(structureSets, biome, this.j);
        for (WorldGenFlatLayerInfo flatLayerInfo : layerInfos) {
            flatLevelGeneratorSettings.d.add(new WorldGenFlatLayerInfo(flatLayerInfo.a(), flatLayerInfo.b().b()));
            flatLevelGeneratorSettings.g();
        }
        if (this.h) {
            flatLevelGeneratorSettings.a();
        }
        if (this.i) {
            flatLevelGeneratorSettings.b();
        }
        return flatLevelGeneratorSettings;
    }

    public void a() {
        this.h = true;
    }

    public void b() {
        this.i = true;
    }

    public BiomeSettingsGeneration a(Holder<BiomeBase> biome) {
        List<Object> list;
        boolean flag;
        if (!biome.equals(this.e)) {
            return biome.a().d();
        }
        BiomeSettingsGeneration generationSettings = this.d().a().d();
        BiomeSettingsGeneration.b plainBuilder = new BiomeSettingsGeneration.b();
        if (this.i) {
            for (Holder<PlacedFeature> holder : this.j) {
                plainBuilder.a(WorldGenStage.Decoration.b, holder);
            }
        }
        boolean bl = flag = (!this.g || biome.a(Biomes.a)) && this.h;
        if (flag) {
            list = generationSettings.c();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (i2 == WorldGenStage.Decoration.d.ordinal() || i2 == WorldGenStage.Decoration.e.ordinal() || this.i && i2 == WorldGenStage.Decoration.b.ordinal()) continue;
                for (Holder holder1 : (HolderSet)list.get(i2)) {
                    plainBuilder.a(i2, (Holder<PlacedFeature>)holder1);
                }
            }
        }
        list = this.f();
        for (int ix = 0; ix < list.size(); ++ix) {
            IBlockData blockState = (IBlockData)list.get(ix);
            if (HeightMap.Type.e.e().test(blockState)) continue;
            list.set(ix, null);
            plainBuilder.a(WorldGenStage.Decoration.k, PlacementUtils.a(WorldGenerator.ac, new WorldGenFeatureFillConfiguration(ix, blockState), new PlacementModifier[0]));
        }
        return plainBuilder.a();
    }

    public Optional<HolderSet<StructureSet>> c() {
        return this.c;
    }

    public Holder<BiomeBase> d() {
        return this.e;
    }

    public List<WorldGenFlatLayerInfo> e() {
        return this.d;
    }

    public List<IBlockData> f() {
        return this.f;
    }

    public void g() {
        this.f.clear();
        for (WorldGenFlatLayerInfo flatLayerInfo : this.d) {
            for (int i2 = 0; i2 < flatLayerInfo.a(); ++i2) {
                this.f.add(flatLayerInfo.b());
            }
        }
        this.g = this.f.stream().allMatch(blockState -> blockState.a(Blocks.a));
    }

    public static GeneratorSettingsFlat a(HolderGetter<BiomeBase> biomes, HolderGetter<StructureSet> structureSetGetter, HolderGetter<PlacedFeature> placedFeatureGetter) {
        HolderSet.a holderSet = HolderSet.a(structureSetGetter.b(BuiltinStructureSets.r), structureSetGetter.b(BuiltinStructureSets.a));
        GeneratorSettingsFlat flatLevelGeneratorSettings = new GeneratorSettingsFlat(Optional.of(holderSet), GeneratorSettingsFlat.a(biomes), GeneratorSettingsFlat.b(placedFeatureGetter));
        flatLevelGeneratorSettings.e().add(new WorldGenFlatLayerInfo(1, Blocks.I));
        flatLevelGeneratorSettings.e().add(new WorldGenFlatLayerInfo(2, Blocks.j));
        flatLevelGeneratorSettings.e().add(new WorldGenFlatLayerInfo(1, Blocks.i));
        flatLevelGeneratorSettings.g();
        return flatLevelGeneratorSettings;
    }

    public static Holder<BiomeBase> a(HolderGetter<BiomeBase> biomes) {
        return biomes.b(Biomes.b);
    }

    public static List<Holder<PlacedFeature>> b(HolderGetter<PlacedFeature> placedFeatureGetter) {
        return List.of(placedFeatureGetter.b(MiscOverworldPlacements.g), placedFeatureGetter.b(MiscOverworldPlacements.h));
    }
}

