/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.trunkplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.BlockRotatable;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacers;

public class CherryTrunkPlacer
extends TrunkPlacer {
    private static final Codec<UniformInt> b = UniformInt.a.codec().validate(uniformInt -> uniformInt.b() - uniformInt.a() < 1 ? DataResult.error(() -> "Need at least 2 blocks variation for the branch starts to fit both branches") : DataResult.success((Object)uniformInt));
    public static final MapCodec<CherryTrunkPlacer> a = RecordCodecBuilder.mapCodec(instance -> CherryTrunkPlacer.a(instance).and(instance.group((App)IntProvider.b(1, 3).fieldOf("branch_count").forGetter(trunkPlacer -> trunkPlacer.h), (App)IntProvider.b(2, 16).fieldOf("branch_horizontal_length").forGetter(trunkPlacer -> trunkPlacer.i), (App)IntProvider.a(-16, 0, b).fieldOf("branch_start_offset_from_top").forGetter(trunkPlacer -> trunkPlacer.j), (App)IntProvider.b(-16, 16).fieldOf("branch_end_offset_from_top").forGetter(trunkPlacer -> trunkPlacer.l))).apply((Applicative)instance, CherryTrunkPlacer::new));
    private final IntProvider h;
    private final IntProvider i;
    private final UniformInt j;
    private final UniformInt k;
    private final IntProvider l;

    public CherryTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, IntProvider branchCount, IntProvider branchHorizontalLength, UniformInt branchStartOffsetFromTop, IntProvider branchEndOffsetFromTop) {
        super(baseHeight, heightRandA, heightRandB);
        this.h = branchCount;
        this.i = branchHorizontalLength;
        this.j = branchStartOffsetFromTop;
        this.k = UniformInt.a(branchStartOffsetFromTop.a(), branchStartOffsetFromTop.b() - 1);
        this.l = branchEndOffsetFromTop;
    }

    @Override
    protected TrunkPlacers<?> a() {
        return TrunkPlacers.i;
    }

    @Override
    public List<WorldGenFoilagePlacer.a> a(VirtualLevelReadable level, BiConsumer<BlockPosition, IBlockData> blockSetter, RandomSource random, int freeTreeHeight, BlockPosition pos, WorldGenFeatureTreeConfiguration config) {
        boolean flag1;
        int i2;
        CherryTrunkPlacer.a(level, blockSetter, random, pos.e(), config);
        int max = Math.max(0, freeTreeHeight - 1 + this.j.a(random));
        int max1 = Math.max(0, freeTreeHeight - 1 + this.k.a(random));
        if (max1 >= max) {
            ++max1;
        }
        boolean flag = (i2 = this.h.a(random)) == 3;
        boolean bl = flag1 = i2 >= 2;
        int i1 = flag ? freeTreeHeight : (flag1 ? Math.max(max, max1) + 1 : max + 1);
        for (int i22 = 0; i22 < i1; ++i22) {
            this.b(level, blockSetter, random, pos.b(i22), config);
        }
        ArrayList<WorldGenFoilagePlacer.a> list = new ArrayList<WorldGenFoilagePlacer.a>();
        if (flag) {
            list.add(new WorldGenFoilagePlacer.a(pos.b(i1), 0, false));
        }
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        EnumDirection randomDirection = EnumDirection.EnumDirectionLimit.a.a(random);
        Function<IBlockData, IBlockData> function = blockState -> (IBlockData)blockState.c(BlockRotatable.i, randomDirection.o());
        list.add(this.a(level, blockSetter, random, freeTreeHeight, pos, config, function, randomDirection, max, max < i1 - 1, mutableBlockPos));
        if (flag1) {
            list.add(this.a(level, blockSetter, random, freeTreeHeight, pos, config, function, randomDirection.g(), max1, max1 < i1 - 1, mutableBlockPos));
        }
        return list;
    }

    private WorldGenFoilagePlacer.a a(VirtualLevelReadable level, BiConsumer<BlockPosition, IBlockData> blockSetter, RandomSource random, int freeTreeHeight, BlockPosition pos, WorldGenFeatureTreeConfiguration config, Function<IBlockData, IBlockData> propertySetter, EnumDirection direction, int secondBranchStartOffsetFromTop, boolean doubleBranch, BlockPosition.MutableBlockPosition currentPos) {
        EnumDirection direction1;
        currentPos.g(pos).c(EnumDirection.b, secondBranchStartOffsetFromTop);
        int i2 = freeTreeHeight - 1 + this.l.a(random);
        boolean flag = doubleBranch || i2 < secondBranchStartOffsetFromTop;
        int i1 = this.i.a(random) + (flag ? 1 : 0);
        BlockPosition blockPos = pos.a(direction, i1).b(i2);
        int i22 = flag ? 2 : 1;
        for (int i3 = 0; i3 < i22; ++i3) {
            this.a(level, blockSetter, random, currentPos.c(direction), config, propertySetter);
        }
        EnumDirection enumDirection = direction1 = blockPos.v() > currentPos.v() ? EnumDirection.b : EnumDirection.a;
        int i4;
        while ((i4 = currentPos.k(blockPos)) != 0) {
            float f2 = (float)Math.abs(blockPos.v() - currentPos.v()) / (float)i4;
            boolean flag1 = random.i() < f2;
            currentPos.c(flag1 ? direction1 : direction);
            this.a(level, blockSetter, random, currentPos, config, flag1 ? Function.identity() : propertySetter);
        }
        return new WorldGenFoilagePlacer.a(blockPos.d(), 0, false);
    }
}

