/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.rootplacers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.levelgen.feature.WorldGenTrees;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.rootplacers.AboveRootPlacement;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProvider;

public abstract class RootPlacer {
    public static final Codec<RootPlacer> d = BuiltInRegistries.W.q().dispatch(RootPlacer::a, RootPlacerType::a);
    protected final IntProvider e;
    protected final WorldGenFeatureStateProvider f;
    protected final Optional<AboveRootPlacement> g;

    protected static <P extends RootPlacer> Products.P3<RecordCodecBuilder.Mu<P>, IntProvider, WorldGenFeatureStateProvider, Optional<AboveRootPlacement>> a(RecordCodecBuilder.Instance<P> instance) {
        return instance.group((App)IntProvider.c.fieldOf("trunk_offset_y").forGetter(placement -> placement.e), (App)WorldGenFeatureStateProvider.a.fieldOf("root_provider").forGetter(placement -> placement.f), (App)AboveRootPlacement.a.optionalFieldOf("above_root_placement").forGetter(placement -> placement.g));
    }

    public RootPlacer(IntProvider trunkOffset, WorldGenFeatureStateProvider rootProvider, Optional<AboveRootPlacement> aboveRootPlacement) {
        this.e = trunkOffset;
        this.f = rootProvider;
        this.g = aboveRootPlacement;
    }

    protected abstract RootPlacerType<?> a();

    public abstract boolean a(VirtualLevelReadable var1, BiConsumer<BlockPosition, IBlockData> var2, RandomSource var3, BlockPosition var4, BlockPosition var5, WorldGenFeatureTreeConfiguration var6);

    protected boolean a(VirtualLevelReadable level, BlockPosition pos) {
        return WorldGenTrees.c(level, pos);
    }

    protected void a(VirtualLevelReadable level, BiConsumer<BlockPosition, IBlockData> blockSetter, RandomSource random, BlockPosition pos, WorldGenFeatureTreeConfiguration treeConfig) {
        if (this.a(level, pos)) {
            blockSetter.accept(pos, this.a(level, pos, this.f.a(random, pos)));
            if (this.g.isPresent()) {
                AboveRootPlacement aboveRootPlacement = this.g.get();
                BlockPosition blockPos = pos.d();
                if (random.i() < aboveRootPlacement.b() && level.a(blockPos, BlockBase.BlockData::l)) {
                    blockSetter.accept(blockPos, this.a(level, blockPos, aboveRootPlacement.a().a(random, blockPos)));
                }
            }
        }
    }

    protected IBlockData a(VirtualLevelReadable level, BlockPosition pos, IBlockData state) {
        if (state.b(BlockProperties.J)) {
            boolean isFluidAtPosition = level.b(pos, fluidState -> fluidState.a(TagsFluid.a));
            return (IBlockData)state.b(BlockProperties.J, isFluidAtPosition);
        }
        return state;
    }

    public BlockPosition a(BlockPosition pos, RandomSource random) {
        return pos.b(this.e.a(random));
    }
}

