/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.foliageplacers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.levelgen.feature.WorldGenTrees;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacers;
import net.minecraft.world.level.material.FluidTypes;

public abstract class WorldGenFoilagePlacer {
    public static final Codec<WorldGenFoilagePlacer> d = BuiltInRegistries.U.q().dispatch(WorldGenFoilagePlacer::a, WorldGenFoilagePlacers::a);
    protected final IntProvider e;
    protected final IntProvider f;

    protected static <P extends WorldGenFoilagePlacer> Products.P2<RecordCodecBuilder.Mu<P>, IntProvider, IntProvider> b(RecordCodecBuilder.Instance<P> instance) {
        return instance.group((App)IntProvider.b(0, 16).fieldOf("radius").forGetter(foliagePlacer -> foliagePlacer.e), (App)IntProvider.b(0, 16).fieldOf("offset").forGetter(foliagePlacer -> foliagePlacer.f));
    }

    public WorldGenFoilagePlacer(IntProvider radius, IntProvider offset) {
        this.e = radius;
        this.f = offset;
    }

    protected abstract WorldGenFoilagePlacers<?> a();

    public void a(VirtualLevelReadable level, b blockSetter, RandomSource random, WorldGenFeatureTreeConfiguration config, int maxFreeTreeHeight, a attachment, int foliageHeight, int foliageRadius) {
        this.a(level, blockSetter, random, config, maxFreeTreeHeight, attachment, foliageHeight, foliageRadius, this.a(random));
    }

    protected abstract void a(VirtualLevelReadable var1, b var2, RandomSource var3, WorldGenFeatureTreeConfiguration var4, int var5, a var6, int var7, int var8, int var9);

    public abstract int a(RandomSource var1, int var2, WorldGenFeatureTreeConfiguration var3);

    public int a(RandomSource random, int radius) {
        return this.e.a(random);
    }

    private int a(RandomSource random) {
        return this.f.a(random);
    }

    protected abstract boolean a(RandomSource var1, int var2, int var3, int var4, int var5, boolean var6);

    protected boolean b(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        int min1;
        int min;
        if (large) {
            min = Math.min(Math.abs(localX), Math.abs(localX - 1));
            min1 = Math.min(Math.abs(localZ), Math.abs(localZ - 1));
        } else {
            min = Math.abs(localX);
            min1 = Math.abs(localZ);
        }
        return this.a(random, min, localY, min1, range, large);
    }

    protected void a(VirtualLevelReadable level, b foliageSetter, RandomSource random, WorldGenFeatureTreeConfiguration treeConfiguration, BlockPosition pos, int range, int localY, boolean large) {
        int i2 = large ? 1 : 0;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i1 = -range; i1 <= range + i2; ++i1) {
            for (int i22 = -range; i22 <= range + i2; ++i22) {
                if (this.b(random, i1, localY, i22, range, large)) continue;
                mutableBlockPos.a(pos, i1, localY, i22);
                WorldGenFoilagePlacer.a(level, foliageSetter, random, treeConfiguration, mutableBlockPos);
            }
        }
    }

    protected final void a(VirtualLevelReadable level, b foliageSetter, RandomSource random, WorldGenFeatureTreeConfiguration treeConfiguration, BlockPosition pos, int range, int localY, boolean large, float hangingLeavesChance, float hangingLeavesExtensionChance) {
        this.a(level, foliageSetter, random, treeConfiguration, pos, range, localY, large);
        int i2 = large ? 1 : 0;
        BlockPosition blockPos = pos.e();
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            EnumDirection clockWise = direction.h();
            int i1 = clockWise.f() == EnumDirection.EnumAxisDirection.a ? range + i2 : range;
            mutableBlockPos.a(pos, 0, localY - 1, 0).c(clockWise, i1).c(direction, -range);
            for (int i22 = -range; i22 < range + i2; ++i22) {
                boolean isSet = foliageSetter.a(mutableBlockPos.c(EnumDirection.b));
                mutableBlockPos.c(EnumDirection.a);
                if (isSet && WorldGenFoilagePlacer.a(level, foliageSetter, random, treeConfiguration, hangingLeavesChance, blockPos, mutableBlockPos)) {
                    mutableBlockPos.c(EnumDirection.a);
                    WorldGenFoilagePlacer.a(level, foliageSetter, random, treeConfiguration, hangingLeavesExtensionChance, blockPos, mutableBlockPos);
                    mutableBlockPos.c(EnumDirection.b);
                }
                mutableBlockPos.c(direction);
            }
        }
    }

    private static boolean a(VirtualLevelReadable level, b foliageSetter, RandomSource random, WorldGenFeatureTreeConfiguration treeConfiguration, float extensionChance, BlockPosition logPos, BlockPosition.MutableBlockPosition pos) {
        return pos.k(logPos) < 7 && !(random.i() > extensionChance) && WorldGenFoilagePlacer.a(level, foliageSetter, random, treeConfiguration, pos);
    }

    protected static boolean a(VirtualLevelReadable level, b foliageSetter, RandomSource random, WorldGenFeatureTreeConfiguration treeConfiguration, BlockPosition pos) {
        boolean isStateAtPosition = level.a(pos, blockState -> blockState.a(BlockProperties.A, false));
        if (!isStateAtPosition && WorldGenTrees.c(level, pos)) {
            IBlockData state = treeConfiguration.e.a(random, pos);
            if (state.b(BlockProperties.J)) {
                state = (IBlockData)state.b(BlockProperties.J, level.b(pos, fluidState -> fluidState.a(FluidTypes.c)));
            }
            foliageSetter.a(pos, state);
            return true;
        }
        return false;
    }

    public static interface b {
        public void a(BlockPosition var1, IBlockData var2);

        public boolean a(BlockPosition var1);
    }

    public static final class a {
        private final BlockPosition a;
        private final int b;
        private final boolean c;

        public a(BlockPosition pos, int radiusOffset, boolean doubleTrunk) {
            this.a = pos;
            this.b = radiusOffset;
            this.c = doubleTrunk;
        }

        public BlockPosition a() {
            return this.a;
        }

        public int b() {
            return this.b;
        }

        public boolean c() {
            return this.c;
        }
    }
}

