/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IWorldWriter;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacer;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTree;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.phys.shapes.VoxelShapeBitSet;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;

public class WorldGenTrees
extends WorldGenerator<WorldGenFeatureTreeConfiguration> {
    private static final int a = 19;

    public WorldGenTrees(Codec<WorldGenFeatureTreeConfiguration> codec) {
        super(codec);
    }

    private static boolean d(VirtualLevelReadable level, BlockPosition pos) {
        return level.a(pos, (IBlockData state) -> state.a(Blocks.ft));
    }

    public static boolean b(VirtualLevelReadable level, BlockPosition pos) {
        return level.a(pos, (IBlockData state) -> state.l() || state.a(TagsBlock.Q));
    }

    private static void b(IWorldWriter level, BlockPosition pos, IBlockData state) {
        level.a(pos, state, 19);
    }

    public static boolean c(VirtualLevelReadable level, BlockPosition pos) {
        return level.a(pos, (IBlockData state) -> state.l() || state.a(TagsBlock.cq));
    }

    private boolean a(GeneratorAccessSeed level, RandomSource random, BlockPosition pos, BiConsumer<BlockPosition, IBlockData> rootBlockSetter, BiConsumer<BlockPosition, IBlockData> trunkBlockSetter, WorldGenFoilagePlacer.b foliageBlockSetter, WorldGenFeatureTreeConfiguration config) {
        int treeHeight = config.d.a(random);
        int i2 = config.f.a(random, treeHeight, config);
        int i1 = treeHeight - i2;
        int i22 = config.f.a(random, i1);
        BlockPosition blockPos = config.g.map(placer -> placer.a(pos, random)).orElse(pos);
        int min = Math.min(pos.v(), blockPos.v());
        int i3 = Math.max(pos.v(), blockPos.v()) + treeHeight + 1;
        if (min >= level.L_() + 1 && i3 <= level.an() + 1) {
            OptionalInt optionalInt = config.h.c();
            int maxFreeTreeHeight = this.a((VirtualLevelReadable)level, treeHeight, blockPos, config);
            if (maxFreeTreeHeight >= treeHeight || !optionalInt.isEmpty() && maxFreeTreeHeight >= optionalInt.getAsInt()) {
                if (config.g.isPresent() && !config.g.get().a(level, rootBlockSetter, random, pos, blockPos, config)) {
                    return false;
                }
                List<WorldGenFoilagePlacer.a> list = config.d.a((VirtualLevelReadable)level, trunkBlockSetter, random, maxFreeTreeHeight, blockPos, config);
                list.forEach(attachment -> config.f.a((VirtualLevelReadable)level, foliageBlockSetter, random, config, maxFreeTreeHeight, (WorldGenFoilagePlacer.a)attachment, i2, i22));
                return true;
            }
            return false;
        }
        return false;
    }

    private int a(VirtualLevelReadable level, int trunkHeight, BlockPosition topPosition, WorldGenFeatureTreeConfiguration config) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i2 = 0; i2 <= trunkHeight + 1; ++i2) {
            int sizeAtHeight = config.h.a(trunkHeight, i2);
            for (int i1 = -sizeAtHeight; i1 <= sizeAtHeight; ++i1) {
                for (int i22 = -sizeAtHeight; i22 <= sizeAtHeight; ++i22) {
                    mutableBlockPos.a(topPosition, i1, i2, i22);
                    if (config.d.b(level, mutableBlockPos) && (config.j || !WorldGenTrees.d(level, mutableBlockPos))) continue;
                    return i2 - 2;
                }
            }
        }
        return trunkHeight;
    }

    @Override
    protected void a(IWorldWriter level, BlockPosition pos, IBlockData state) {
        WorldGenTrees.b(level, pos, state);
    }

    @Override
    public final boolean a(FeaturePlaceContext<WorldGenFeatureTreeConfiguration> context) {
        final GeneratorAccessSeed worldGenLevel = context.b();
        RandomSource randomSource = context.d();
        BlockPosition blockPos = context.e();
        WorldGenFeatureTreeConfiguration treeConfiguration = context.f();
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        final HashSet set2 = Sets.newHashSet();
        HashSet set3 = Sets.newHashSet();
        BiConsumer<BlockPosition, IBlockData> biConsumer = (pos, state) -> {
            set.add(pos.j());
            worldGenLevel.a((BlockPosition)pos, (IBlockData)state, 19);
        };
        BiConsumer<BlockPosition, IBlockData> biConsumer1 = (pos, state) -> {
            set1.add(pos.j());
            worldGenLevel.a((BlockPosition)pos, (IBlockData)state, 19);
        };
        WorldGenFoilagePlacer.b foliageSetter = new WorldGenFoilagePlacer.b(){

            @Override
            public void a(BlockPosition pos, IBlockData state) {
                set2.add(pos.j());
                worldGenLevel.a(pos, state, 19);
            }

            @Override
            public boolean a(BlockPosition pos) {
                return set2.contains(pos);
            }
        };
        BiConsumer<BlockPosition, IBlockData> biConsumer2 = (pos, state) -> {
            set3.add(pos.j());
            worldGenLevel.a((BlockPosition)pos, (IBlockData)state, 19);
        };
        boolean flag = this.a(worldGenLevel, randomSource, blockPos, biConsumer, biConsumer1, foliageSetter, treeConfiguration);
        if (!(!flag || set1.isEmpty() && set2.isEmpty())) {
            if (!treeConfiguration.i.isEmpty()) {
                WorldGenFeatureTree.a context1 = new WorldGenFeatureTree.a(worldGenLevel, biConsumer2, randomSource, set1, set2, set);
                treeConfiguration.i.forEach(decorator -> decorator.a(context1));
            }
            return StructureBoundingBox.a(Iterables.concat((Iterable)set, (Iterable)set1, (Iterable)set2, (Iterable)set3)).map(boundingBox -> {
                VoxelShapeDiscrete discreteVoxelShape = WorldGenTrees.a((GeneratorAccess)worldGenLevel, boundingBox, (Set<BlockPosition>)set1, (Set<BlockPosition>)set3, set);
                DefinedStructure.a(worldGenLevel, 3, discreteVoxelShape, boundingBox.h(), boundingBox.i(), boundingBox.j());
                return true;
            }).orElse(false);
        }
        return false;
    }

    private static VoxelShapeDiscrete a(GeneratorAccess level, StructureBoundingBox box, Set<BlockPosition> rootPositions, Set<BlockPosition> trunkPositions, Set<BlockPosition> foliagePositions) {
        VoxelShapeBitSet discreteVoxelShape = new VoxelShapeBitSet(box.d(), box.e(), box.f());
        int i2 = 7;
        ArrayList list = Lists.newArrayList();
        for (int i1 = 0; i1 < 7; ++i1) {
            list.add(Sets.newHashSet());
        }
        for (BlockPosition blockPos : Lists.newArrayList((Iterable)Sets.union(trunkPositions, foliagePositions))) {
            if (!box.b(blockPos)) continue;
            ((VoxelShapeDiscrete)discreteVoxelShape).c(blockPos.u() - box.h(), blockPos.v() - box.i(), blockPos.w() - box.j());
        }
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        int i22 = 0;
        ((Set)list.get(0)).addAll(rootPositions);
        block2: while (true) {
            if (i22 >= 7 || !((Set)list.get(i22)).isEmpty()) {
                if (i22 >= 7) {
                    return discreteVoxelShape;
                }
                Iterator iterator = ((Set)list.get(i22)).iterator();
                BlockPosition blockPos1 = (BlockPosition)iterator.next();
                iterator.remove();
                if (!box.b(blockPos1)) continue;
                if (i22 != 0) {
                    IBlockData blockState = level.a_(blockPos1);
                    WorldGenTrees.b(level, blockPos1, (IBlockData)blockState.b(BlockProperties.aF, i22));
                }
                ((VoxelShapeDiscrete)discreteVoxelShape).c(blockPos1.u() - box.h(), blockPos1.v() - box.i(), blockPos1.w() - box.j());
                EnumDirection[] enumDirectionArray = EnumDirection.values();
                int n2 = enumDirectionArray.length;
                int n3 = 0;
                while (true) {
                    int min;
                    IBlockData blockState1;
                    OptionalInt optionalDistanceAt;
                    int i5;
                    int i4;
                    int i3;
                    if (n3 >= n2) continue block2;
                    EnumDirection direction = enumDirectionArray[n3];
                    mutableBlockPos.a((BaseBlockPosition)blockPos1, direction);
                    if (box.b(mutableBlockPos) && !((VoxelShapeDiscrete)discreteVoxelShape).b(i3 = mutableBlockPos.u() - box.h(), i4 = mutableBlockPos.v() - box.i(), i5 = mutableBlockPos.w() - box.j()) && !(optionalDistanceAt = BlockLeaves.q(blockState1 = level.a_(mutableBlockPos))).isEmpty() && (min = Math.min(optionalDistanceAt.getAsInt(), i22 + 1)) < 7) {
                        ((Set)list.get(min)).add(mutableBlockPos.j());
                        i22 = Math.min(i22, min);
                    }
                    ++n3;
                }
            }
            ++i22;
        }
    }
}

