/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureHugeFungiConfiguration;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureWeepingVines;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;

public class WorldGenFeatureHugeFungi
extends WorldGenerator<WorldGenFeatureHugeFungiConfiguration> {
    private static final float a = 0.06f;

    public WorldGenFeatureHugeFungi(Codec<WorldGenFeatureHugeFungiConfiguration> codec) {
        super(codec);
    }

    @Override
    public boolean a(FeaturePlaceContext<WorldGenFeatureHugeFungiConfiguration> context) {
        GeneratorAccessSeed worldGenLevel = context.b();
        BlockPosition blockPos = context.e();
        RandomSource randomSource = context.d();
        ChunkGenerator chunkGenerator = context.c();
        WorldGenFeatureHugeFungiConfiguration hugeFungusConfiguration = context.f();
        Block block = hugeFungusConfiguration.b.b();
        BlockPosition blockPos1 = null;
        IBlockData blockState = worldGenLevel.a_(blockPos.e());
        if (blockState.a(block)) {
            blockPos1 = blockPos;
        }
        if (blockPos1 == null) {
            return false;
        }
        int randomInt = MathHelper.a(randomSource, 4, 13);
        if (randomSource.a(12) == 0) {
            randomInt *= 2;
        }
        if (!hugeFungusConfiguration.g) {
            int genDepth = chunkGenerator.e();
            if (blockPos1.v() + randomInt + 1 >= genDepth) {
                return false;
            }
        }
        boolean flag = !hugeFungusConfiguration.g && randomSource.i() < 0.06f;
        worldGenLevel.a(blockPos, Blocks.a.m(), 4);
        this.a(worldGenLevel, randomSource, hugeFungusConfiguration, blockPos1, randomInt, flag);
        this.b(worldGenLevel, randomSource, hugeFungusConfiguration, blockPos1, randomInt, flag);
        return true;
    }

    private static boolean a(GeneratorAccessSeed level, BlockPosition pos, WorldGenFeatureHugeFungiConfiguration config, boolean checkConfig) {
        return level.a(pos, BlockBase.BlockData::v) || checkConfig && config.f.test(level, pos);
    }

    private void a(GeneratorAccessSeed level, RandomSource random, WorldGenFeatureHugeFungiConfiguration config, BlockPosition pos, int height, boolean huge) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        IBlockData blockState = config.c;
        int i2 = huge ? 1 : 0;
        for (int i1 = -i2; i1 <= i2; ++i1) {
            for (int i22 = -i2; i22 <= i2; ++i22) {
                boolean flag = huge && MathHelper.a(i1) == i2 && MathHelper.a(i22) == i2;
                for (int i3 = 0; i3 < height; ++i3) {
                    mutableBlockPos.a(pos, i1, i3, i22);
                    if (!WorldGenFeatureHugeFungi.a(level, mutableBlockPos, config, true)) continue;
                    if (config.g) {
                        if (!level.a_(mutableBlockPos.e()).l()) {
                            level.b((BlockPosition)mutableBlockPos, true);
                        }
                        level.a((BlockPosition)mutableBlockPos, blockState, 3);
                        continue;
                    }
                    if (flag) {
                        if (!(random.i() < 0.1f)) continue;
                        this.a(level, mutableBlockPos, blockState);
                        continue;
                    }
                    this.a(level, mutableBlockPos, blockState);
                }
            }
        }
    }

    private void b(GeneratorAccessSeed level, RandomSource random, WorldGenFeatureHugeFungiConfiguration config, BlockPosition pos, int height, boolean huge) {
        int i2;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        boolean isNetherWartBlock = config.d.a(Blocks.lm);
        int min = Math.min(random.a(1 + height / 3) + 5, height);
        for (int i1 = i2 = height - min; i1 <= height; ++i1) {
            int i22;
            int n2 = i22 = i1 < height - random.a(3) ? 2 : 1;
            if (min > 8 && i1 < i2 + 4) {
                i22 = 3;
            }
            if (huge) {
                ++i22;
            }
            for (int i3 = -i22; i3 <= i22; ++i3) {
                for (int i4 = -i22; i4 <= i22; ++i4) {
                    boolean flag = i3 == -i22 || i3 == i22;
                    boolean flag1 = i4 == -i22 || i4 == i22;
                    boolean flag2 = !flag && !flag1 && i1 != height;
                    boolean flag3 = flag && flag1;
                    boolean flag4 = i1 < i2 + 3;
                    mutableBlockPos.a(pos, i3, i1, i4);
                    if (!WorldGenFeatureHugeFungi.a(level, mutableBlockPos, config, false)) continue;
                    if (config.g && !level.a_(mutableBlockPos.e()).l()) {
                        level.b((BlockPosition)mutableBlockPos, true);
                    }
                    if (flag4) {
                        if (flag2) continue;
                        this.a(level, random, mutableBlockPos, config.d, isNetherWartBlock);
                        continue;
                    }
                    if (flag2) {
                        this.a(level, random, config, mutableBlockPos, 0.1f, 0.2f, isNetherWartBlock ? 0.1f : 0.0f);
                        continue;
                    }
                    if (flag3) {
                        this.a(level, random, config, mutableBlockPos, 0.01f, 0.7f, isNetherWartBlock ? 0.083f : 0.0f);
                        continue;
                    }
                    this.a(level, random, config, mutableBlockPos, 5.0E-4f, 0.98f, isNetherWartBlock ? 0.07f : 0.0f);
                }
            }
        }
    }

    private void a(GeneratorAccess level, RandomSource random, WorldGenFeatureHugeFungiConfiguration config, BlockPosition.MutableBlockPosition pos, float decorationChance, float hatChance, float weepingVineChance) {
        if (random.i() < decorationChance) {
            this.a(level, pos, config.e);
        } else if (random.i() < hatChance) {
            this.a(level, pos, config.d);
            if (random.i() < weepingVineChance) {
                WorldGenFeatureHugeFungi.a(pos, level, random);
            }
        }
    }

    private void a(GeneratorAccess level, RandomSource random, BlockPosition pos, IBlockData state, boolean weepingVines) {
        if (level.a_(pos.e()).a(state.b())) {
            this.a(level, pos, state);
        } else if ((double)random.i() < 0.15) {
            this.a(level, pos, state);
            if (weepingVines && random.a(11) == 0) {
                WorldGenFeatureHugeFungi.a(pos, level, random);
            }
        }
    }

    private static void a(BlockPosition pos, GeneratorAccess level, RandomSource random) {
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k().c(EnumDirection.a);
        if (level.u(mutableBlockPos)) {
            int randomInt = MathHelper.a(random, 1, 5);
            if (random.a(7) == 0) {
                randomInt *= 2;
            }
            int i2 = 23;
            int i1 = 25;
            WorldGenFeatureWeepingVines.a(level, random, mutableBlockPos, randomInt, 23, 25);
        }
    }
}

