/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureBasaltColumnsConfiguration;

public class WorldGenFeatureBasaltColumns
extends WorldGenerator<WorldGenFeatureBasaltColumnsConfiguration> {
    private static final ImmutableList<Block> a = ImmutableList.of((Object)Blocks.K, (Object)Blocks.I, (Object)Blocks.ll, (Object)Blocks.ej, (Object)Blocks.fI, (Object)Blocks.fJ, (Object)Blocks.fK, (Object)Blocks.fL, (Object)Blocks.cD, (Object)Blocks.cA);
    private static final int b = 5;
    private static final int c = 50;
    private static final int d = 8;
    private static final int ao = 15;

    public WorldGenFeatureBasaltColumns(Codec<WorldGenFeatureBasaltColumnsConfiguration> codec) {
        super(codec);
    }

    @Override
    public boolean a(FeaturePlaceContext<WorldGenFeatureBasaltColumnsConfiguration> context) {
        int seaLevel = context.c().f();
        BlockPosition blockPos = context.e();
        GeneratorAccessSeed worldGenLevel = context.b();
        RandomSource randomSource = context.d();
        WorldGenFeatureBasaltColumnsConfiguration columnFeatureConfiguration = context.f();
        if (!WorldGenFeatureBasaltColumns.a((GeneratorAccess)worldGenLevel, seaLevel, blockPos.k())) {
            return false;
        }
        int i2 = columnFeatureConfiguration.b().a(randomSource);
        boolean flag = randomSource.i() < 0.9f;
        int min = Math.min(i2, flag ? 5 : 8);
        int i1 = flag ? 50 : 15;
        boolean flag1 = false;
        for (BlockPosition blockPos1 : BlockPosition.a(randomSource, i1, blockPos.u() - min, blockPos.v(), blockPos.w() - min, blockPos.u() + min, blockPos.v(), blockPos.w() + min)) {
            int i22 = i2 - blockPos1.k(blockPos);
            if (i22 < 0) continue;
            flag1 |= this.a(worldGenLevel, seaLevel, blockPos1, i22, columnFeatureConfiguration.a().a(randomSource));
        }
        return flag1;
    }

    private boolean a(GeneratorAccess level, int seaLevel, BlockPosition pos, int distance, int reach) {
        boolean flag = false;
        block0: for (BlockPosition blockPos : BlockPosition.b(pos.u() - reach, pos.v(), pos.w() - reach, pos.u() + reach, pos.v(), pos.w() + reach)) {
            int i2 = blockPos.k(pos);
            BlockPosition blockPos1 = WorldGenFeatureBasaltColumns.a(level, seaLevel, blockPos) ? WorldGenFeatureBasaltColumns.a(level, seaLevel, blockPos.k(), i2) : WorldGenFeatureBasaltColumns.a(level, blockPos.k(), i2);
            if (blockPos1 == null) continue;
            BlockPosition.MutableBlockPosition mutableBlockPos = blockPos1.k();
            for (int i1 = distance - i2 / 2; i1 >= 0; --i1) {
                if (WorldGenFeatureBasaltColumns.a(level, seaLevel, (BlockPosition)mutableBlockPos)) {
                    this.a(level, mutableBlockPos, Blocks.el.m());
                    mutableBlockPos.c(EnumDirection.b);
                    flag = true;
                    continue;
                }
                if (!level.a_(mutableBlockPos).a(Blocks.el)) continue block0;
                mutableBlockPos.c(EnumDirection.b);
            }
        }
        return flag;
    }

    @Nullable
    private static BlockPosition a(GeneratorAccess level, int seaLevel, BlockPosition.MutableBlockPosition pos, int distance) {
        while (pos.v() > level.L_() + 1 && distance > 0) {
            --distance;
            if (WorldGenFeatureBasaltColumns.a(level, seaLevel, pos)) {
                return pos;
            }
            pos.c(EnumDirection.a);
        }
        return null;
    }

    private static boolean a(GeneratorAccess level, int seaLevel, BlockPosition.MutableBlockPosition pos) {
        if (!WorldGenFeatureBasaltColumns.a(level, seaLevel, (BlockPosition)pos)) {
            return false;
        }
        IBlockData blockState = level.a_(pos.c(EnumDirection.a));
        pos.c(EnumDirection.b);
        return !blockState.l() && !a.contains((Object)blockState.b());
    }

    @Nullable
    private static BlockPosition a(GeneratorAccess level, BlockPosition.MutableBlockPosition pos, int distance) {
        while (pos.v() <= level.an() && distance > 0) {
            --distance;
            IBlockData blockState = level.a_(pos);
            if (a.contains((Object)blockState.b())) {
                return null;
            }
            if (blockState.l()) {
                return pos;
            }
            pos.c(EnumDirection.b);
        }
        return null;
    }

    private static boolean a(GeneratorAccess level, int seaLevel, BlockPosition pos) {
        IBlockData blockState = level.a_(pos);
        return blockState.l() || blockState.a(Blocks.K) && pos.v() <= seaLevel;
    }
}

