/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.LargeDripstoneConfiguration;
import net.minecraft.world.phys.Vec3D;

public class LargeDripstoneFeature
extends WorldGenerator<LargeDripstoneConfiguration> {
    public LargeDripstoneFeature(Codec<LargeDripstoneConfiguration> codec) {
        super(codec);
    }

    @Override
    public boolean a(FeaturePlaceContext<LargeDripstoneConfiguration> context) {
        GeneratorAccessSeed worldGenLevel = context.b();
        BlockPosition blockPos = context.e();
        LargeDripstoneConfiguration largeDripstoneConfiguration = context.f();
        RandomSource randomSource = context.d();
        if (!DripstoneUtils.a(worldGenLevel, blockPos)) {
            return false;
        }
        Optional<Column> optional = Column.a(worldGenLevel, blockPos, largeDripstoneConfiguration.b, DripstoneUtils::c, DripstoneUtils::a);
        if (!optional.isEmpty() && optional.get() instanceof Column.b) {
            Column.b range = (Column.b)optional.get();
            if (range.g() < 4) {
                return false;
            }
            int i2 = (int)((float)range.g() * largeDripstoneConfiguration.e);
            int i1 = MathHelper.a(i2, largeDripstoneConfiguration.c.a(), largeDripstoneConfiguration.c.b());
            int i22 = MathHelper.b(randomSource, largeDripstoneConfiguration.c.a(), i1);
            a largeDripstone = LargeDripstoneFeature.a(blockPos.h(range.e() - 1), false, randomSource, i22, largeDripstoneConfiguration.f, largeDripstoneConfiguration.d);
            a largeDripstone1 = LargeDripstoneFeature.a(blockPos.h(range.f() + 1), true, randomSource, i22, largeDripstoneConfiguration.g, largeDripstoneConfiguration.d);
            b windOffsetter = largeDripstone.a(largeDripstoneConfiguration) && largeDripstone1.a(largeDripstoneConfiguration) ? new b(blockPos.v(), randomSource, largeDripstoneConfiguration.h) : b.a();
            boolean flag = largeDripstone.a(worldGenLevel, windOffsetter);
            boolean flag1 = largeDripstone1.a(worldGenLevel, windOffsetter);
            if (flag) {
                largeDripstone.a(worldGenLevel, randomSource, windOffsetter);
            }
            if (flag1) {
                largeDripstone1.a(worldGenLevel, randomSource, windOffsetter);
            }
            return true;
        }
        return false;
    }

    private static a a(BlockPosition root, boolean pointingUp, RandomSource random, int radius, FloatProvider bluntnessBase, FloatProvider scaleBase) {
        return new a(root, pointingUp, radius, bluntnessBase.a(random), scaleBase.a(random));
    }

    private void a(GeneratorAccessSeed level, BlockPosition pos, Column.b range, b windOffsetter) {
        level.a(windOffsetter.a(pos.h(range.e() - 1)), Blocks.cH.m(), 2);
        level.a(windOffsetter.a(pos.h(range.f() + 1)), Blocks.co.m(), 2);
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.h(range.f() + 2).k();
        while (mutableBlockPos.v() < range.e() - 1) {
            BlockPosition blockPos = windOffsetter.a(mutableBlockPos);
            if (DripstoneUtils.a(level, blockPos) || level.a_(blockPos).a(Blocks.sW)) {
                level.a(blockPos, Blocks.hj.m(), 2);
            }
            mutableBlockPos.c(EnumDirection.b);
        }
    }

    static final class a {
        private BlockPosition a;
        private final boolean b;
        private int c;
        private final double d;
        private final double e;

        a(BlockPosition root, boolean pointingUp, int radius, double bluntness, double scale) {
            this.a = root;
            this.b = pointingUp;
            this.c = radius;
            this.d = bluntness;
            this.e = scale;
        }

        private int a() {
            return this.a(0.0f);
        }

        private int b() {
            return this.b ? this.a.v() : this.a.v() - this.a();
        }

        private int c() {
            return !this.b ? this.a.v() : this.a.v() + this.a();
        }

        boolean a(GeneratorAccessSeed level, b windOffsetter) {
            while (this.c > 1) {
                BlockPosition.MutableBlockPosition mutableBlockPos = this.a.k();
                int min = Math.min(10, this.a());
                for (int i2 = 0; i2 < min; ++i2) {
                    if (level.a_(mutableBlockPos).a(Blocks.K)) {
                        return false;
                    }
                    if (DripstoneUtils.a(level, windOffsetter.a(mutableBlockPos), this.c)) {
                        this.a = mutableBlockPos;
                        return true;
                    }
                    mutableBlockPos.c(this.b ? EnumDirection.a : EnumDirection.b);
                }
                this.c /= 2;
            }
            return false;
        }

        private int a(float radius) {
            return (int)DripstoneUtils.a(radius, (double)this.c, this.e, this.d);
        }

        void a(GeneratorAccessSeed level, RandomSource random, b windOffsetter) {
            for (int i2 = -this.c; i2 <= this.c; ++i2) {
                block1: for (int i1 = -this.c; i1 <= this.c; ++i1) {
                    int heightAtRadius;
                    float squareRoot = MathHelper.c((float)(i2 * i2 + i1 * i1));
                    if (squareRoot > (float)this.c || (heightAtRadius = this.a(squareRoot)) <= 0) continue;
                    if ((double)random.i() < 0.2) {
                        heightAtRadius = (int)((float)heightAtRadius * MathHelper.b(random, 0.8f, 1.0f));
                    }
                    BlockPosition.MutableBlockPosition mutableBlockPos = this.a.b(i2, 0, i1).k();
                    boolean flag = false;
                    int i22 = this.b ? level.a(HeightMap.Type.a, mutableBlockPos.u(), mutableBlockPos.w()) : Integer.MAX_VALUE;
                    for (int i3 = 0; i3 < heightAtRadius && mutableBlockPos.v() < i22; ++i3) {
                        BlockPosition blockPos = windOffsetter.a(mutableBlockPos);
                        if (DripstoneUtils.b(level, blockPos)) {
                            flag = true;
                            Block block = Blocks.sW;
                            level.a(blockPos, block.m(), 2);
                        } else if (flag && level.a_(blockPos).a(TagsBlock.bg)) continue block1;
                        mutableBlockPos.c(this.b ? EnumDirection.b : EnumDirection.a);
                    }
                }
            }
        }

        boolean a(LargeDripstoneConfiguration config) {
            return this.c >= config.i && this.d >= (double)config.j;
        }
    }

    static final class b {
        private final int a;
        @Nullable
        private final Vec3D b;

        b(int originY, RandomSource random, FloatProvider magnitude) {
            this.a = originY;
            float f2 = magnitude.a(random);
            float f1 = MathHelper.b(random, 0.0f, (float)Math.PI);
            this.b = new Vec3D(MathHelper.b(f1) * f2, 0.0, MathHelper.a(f1) * f2);
        }

        private b() {
            this.a = 0;
            this.b = null;
        }

        static b a() {
            return new b();
        }

        BlockPosition a(BlockPosition pos) {
            if (this.b == null) {
                return pos;
            }
            int i2 = this.a - pos.v();
            Vec3D vec3 = this.b.c((double)i2);
            return pos.b(MathHelper.a(vec3.d), 0, MathHelper.a(vec3.f));
        }
    }
}

