/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.levelgen.GeodeBlockSettings;
import net.minecraft.world.level.levelgen.GeodeCrackSettings;
import net.minecraft.world.level.levelgen.GeodeLayerSettings;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import net.minecraft.world.level.material.Fluid;

public class GeodeFeature
extends WorldGenerator<GeodeConfiguration> {
    private static final EnumDirection[] a = EnumDirection.values();

    public GeodeFeature(Codec<GeodeConfiguration> codec) {
        super(codec);
    }

    @Override
    public boolean a(FeaturePlaceContext<GeodeConfiguration> context) {
        IBlockData blockState;
        int i5;
        int i4;
        GeodeConfiguration geodeConfiguration = context.f();
        RandomSource randomSource = context.d();
        BlockPosition blockPos = context.e();
        GeneratorAccessSeed worldGenLevel = context.b();
        int i2 = geodeConfiguration.l;
        int i1 = geodeConfiguration.n;
        LinkedList list = Lists.newLinkedList();
        int i22 = geodeConfiguration.j.a(randomSource);
        SeededRandom worldgenRandom = new SeededRandom(new LegacyRandomSource(worldGenLevel.E()));
        NoiseGeneratorNormal normalNoise = NoiseGeneratorNormal.a(worldgenRandom, -4, 1.0);
        LinkedList list1 = Lists.newLinkedList();
        double d2 = (double)i22 / (double)geodeConfiguration.i.b();
        GeodeLayerSettings geodeLayerSettings = geodeConfiguration.d;
        GeodeBlockSettings geodeBlockSettings = geodeConfiguration.c;
        GeodeCrackSettings geodeCrackSettings = geodeConfiguration.e;
        double d1 = 1.0 / Math.sqrt(geodeLayerSettings.b);
        double d22 = 1.0 / Math.sqrt(geodeLayerSettings.c + d2);
        double d3 = 1.0 / Math.sqrt(geodeLayerSettings.d + d2);
        double d4 = 1.0 / Math.sqrt(geodeLayerSettings.e + d2);
        double d5 = 1.0 / Math.sqrt(geodeCrackSettings.c + randomSource.j() / 2.0 + (i22 > 3 ? d2 : 0.0));
        boolean flag = (double)randomSource.i() < geodeCrackSettings.b;
        int i3 = 0;
        for (i4 = 0; i4 < i22; ++i4) {
            int i7;
            int i6;
            i5 = geodeConfiguration.i.a(randomSource);
            BlockPosition blockPos1 = blockPos.b(i5, i6 = geodeConfiguration.i.a(randomSource), i7 = geodeConfiguration.i.a(randomSource));
            blockState = worldGenLevel.a_(blockPos1);
            if ((blockState.l() || blockState.a(geodeBlockSettings.h)) && ++i3 > geodeConfiguration.p) {
                return false;
            }
            list.add(Pair.of((Object)blockPos1, (Object)geodeConfiguration.k.a(randomSource)));
        }
        if (flag) {
            i4 = randomSource.a(4);
            i5 = i22 * 2 + 1;
            if (i4 == 0) {
                list1.add(blockPos.b(i5, 7, 0));
                list1.add(blockPos.b(i5, 5, 0));
                list1.add(blockPos.b(i5, 1, 0));
            } else if (i4 == 1) {
                list1.add(blockPos.b(0, 7, i5));
                list1.add(blockPos.b(0, 5, i5));
                list1.add(blockPos.b(0, 1, i5));
            } else if (i4 == 2) {
                list1.add(blockPos.b(i5, 7, i5));
                list1.add(blockPos.b(i5, 5, i5));
                list1.add(blockPos.b(i5, 1, i5));
            } else {
                list1.add(blockPos.b(0, 7, 0));
                list1.add(blockPos.b(0, 5, 0));
                list1.add(blockPos.b(0, 1, 0));
            }
        }
        ArrayList list2 = Lists.newArrayList();
        Predicate<IBlockData> predicate = GeodeFeature.a(geodeConfiguration.c.g);
        for (BlockPosition blockPos2 : BlockPosition.c(blockPos.b(i2, i2, i2), blockPos.b(i1, i1, i1))) {
            double d6 = normalNoise.a(blockPos2.u(), blockPos2.v(), blockPos2.w()) * geodeConfiguration.o;
            double d7 = 0.0;
            double d8 = 0.0;
            for (Pair pair : list) {
                d7 += MathHelper.f(blockPos2.j((BaseBlockPosition)pair.getFirst()) + (double)((Integer)pair.getSecond()).intValue()) + d6;
            }
            for (BlockPosition blockPos3 : list1) {
                d8 += MathHelper.f(blockPos2.j(blockPos3) + (double)geodeCrackSettings.d) + d6;
            }
            if (d7 < d4) continue;
            if (flag && d8 >= d5 && d7 < d1) {
                this.a(worldGenLevel, blockPos2, Blocks.a.m(), predicate);
                for (EnumDirection direction : a) {
                    BlockPosition blockPos4 = blockPos2.a(direction);
                    Fluid fluidState = worldGenLevel.b_(blockPos4);
                    if (fluidState.c()) continue;
                    worldGenLevel.a(blockPos4, fluidState.a(), 0);
                }
                continue;
            }
            if (d7 >= d1) {
                this.a(worldGenLevel, blockPos2, geodeBlockSettings.a.a(randomSource, blockPos2), predicate);
                continue;
            }
            if (d7 >= d22) {
                boolean flag1;
                boolean bl = flag1 = (double)randomSource.i() < geodeConfiguration.g;
                if (flag1) {
                    this.a(worldGenLevel, blockPos2, geodeBlockSettings.c.a(randomSource, blockPos2), predicate);
                } else {
                    this.a(worldGenLevel, blockPos2, geodeBlockSettings.b.a(randomSource, blockPos2), predicate);
                }
                if (geodeConfiguration.h && !flag1 || !((double)randomSource.i() < geodeConfiguration.f)) continue;
                list2.add(blockPos2.j());
                continue;
            }
            if (d7 >= d3) {
                this.a(worldGenLevel, blockPos2, geodeBlockSettings.d.a(randomSource, blockPos2), predicate);
                continue;
            }
            if (!(d7 >= d4)) continue;
            this.a(worldGenLevel, blockPos2, geodeBlockSettings.e.a(randomSource, blockPos2), predicate);
        }
        List<IBlockData> list3 = geodeBlockSettings.f;
        block5: for (BlockPosition blockPos1 : list2) {
            blockState = SystemUtils.a(list3, randomSource);
            for (EnumDirection direction1 : a) {
                if (blockState.b(BlockProperties.S)) {
                    blockState = (IBlockData)blockState.b(BlockProperties.S, direction1);
                }
                BlockPosition blockPos5 = blockPos1.a(direction1);
                IBlockData blockState1 = worldGenLevel.a_(blockPos5);
                if (blockState.b(BlockProperties.J)) {
                    blockState = (IBlockData)blockState.b(BlockProperties.J, blockState1.y().b());
                }
                if (!BuddingAmethystBlock.h(blockState1)) continue;
                this.a(worldGenLevel, blockPos5, blockState, predicate);
                continue block5;
            }
        }
        return true;
    }
}

