/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import javax.annotation.Nullable;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.ChunkGenerator;

public class WorldGenerationContext {
    private final int a;
    private final int b;
    @Nullable
    private final World serverLevel;

    public WorldGenerationContext(ChunkGenerator generator, LevelHeightAccessor level) {
        this(generator, level, null);
    }

    public WorldGenerationContext(ChunkGenerator generator, LevelHeightAccessor level, World serverLevel) {
        this.serverLevel = serverLevel;
        this.a = Math.max(level.L_(), generator.g());
        this.b = Math.min(level.M_(), generator.e());
    }

    public int a() {
        return this.a;
    }

    public int b() {
        return this.b;
    }

    public World level() {
        if (this.serverLevel == null) {
            throw new NullPointerException("WorldGenerationContext was initialized without a Level, but WorldGenerationContext#level was called");
        }
        return this.serverLevel;
    }
}

