/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntityMonsterPatrolling;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class MobSpawnerPatrol
implements MobSpawner {
    private int a;

    @Override
    public int a(WorldServer level, boolean spawnEnemies, boolean spawnFriendlies) {
        int patrolSpawnDelay;
        if (level.paperConfig().entities.behavior.pillagerPatrols.disable || level.paperConfig().entities.behavior.pillagerPatrols.spawnChance == 0.0) {
            return 0;
        }
        if (!spawnEnemies) {
            return 0;
        }
        if (!level.O().b(GameRules.L)) {
            return 0;
        }
        RandomSource randomSource = level.A;
        int size = level.z().size();
        if (size < 1) {
            return 0;
        }
        EntityPlayer player = level.z().get(randomSource.a(size));
        if (player.Z_()) {
            return 0;
        }
        if (level.paperConfig().entities.behavior.pillagerPatrols.spawnDelay.perPlayer) {
            --player.patrolSpawnDelay;
            patrolSpawnDelay = player.patrolSpawnDelay;
        } else {
            --this.a;
            patrolSpawnDelay = this.a;
        }
        if (patrolSpawnDelay > 0) {
            return 0;
        }
        long days = level.paperConfig().entities.behavior.pillagerPatrols.start.perPlayer ? (long)player.I().a(StatisticList.i.b(StatisticList.k)) / 24000L : level.ae() / 24000L;
        if (level.paperConfig().entities.behavior.pillagerPatrols.spawnDelay.perPlayer) {
            player.patrolSpawnDelay += level.paperConfig().entities.behavior.pillagerPatrols.spawnDelay.ticks + randomSource.a(1200);
        } else {
            this.a += level.paperConfig().entities.behavior.pillagerPatrols.spawnDelay.ticks + randomSource.a(1200);
        }
        if (days < (long)level.paperConfig().entities.behavior.pillagerPatrols.start.day || !level.V()) {
            return 0;
        }
        if (randomSource.j() >= level.paperConfig().entities.behavior.pillagerPatrols.spawnChance) {
            return 0;
        }
        if (size < 1) {
            return 0;
        }
        if (player.Z_()) {
            return 0;
        }
        if (level.a(player.dv(), 2)) {
            return 0;
        }
        int i2 = (24 + randomSource.a(24)) * (randomSource.h() ? -1 : 1);
        int i1 = (24 + randomSource.a(24)) * (randomSource.h() ? -1 : 1);
        BlockPosition.MutableBlockPosition mutableBlockPos = player.dv().k().e(i2, 0, i1);
        int i22 = 10;
        if (!level.b(mutableBlockPos.u() - 10, mutableBlockPos.w() - 10, mutableBlockPos.u() + 10, mutableBlockPos.w() + 10)) {
            return 0;
        }
        Holder<BiomeBase> biome = level.t(mutableBlockPos);
        if (biome.a(BiomeTags.ag)) {
            return 0;
        }
        int i3 = 0;
        int i4 = (int)Math.ceil(level.d_(mutableBlockPos).b()) + 1;
        for (int i5 = 0; i5 < i4; ++i5) {
            ++i3;
            mutableBlockPos.q(level.a(HeightMap.Type.f, (BlockPosition)mutableBlockPos).v());
            if (i5 == 0) {
                if (!this.a(level, mutableBlockPos, randomSource, true)) {
                    break;
                }
            } else {
                this.a(level, mutableBlockPos, randomSource, false);
            }
            mutableBlockPos.p(mutableBlockPos.u() + randomSource.a(5) - randomSource.a(5));
            mutableBlockPos.r(mutableBlockPos.w() + randomSource.a(5) - randomSource.a(5));
        }
        return i3;
    }

    private boolean a(WorldServer level, BlockPosition pos, RandomSource random, boolean leader) {
        IBlockData blockState = level.a_(pos);
        if (!SpawnerCreature.a(level, pos, blockState, blockState.y(), EntityTypes.aT)) {
            return false;
        }
        if (!EntityMonsterPatrolling.b(EntityTypes.aT, (GeneratorAccess)level, EntitySpawnReason.p, pos, random)) {
            return false;
        }
        EntityMonsterPatrolling patrollingMonster = EntityTypes.aT.a(level, EntitySpawnReason.p);
        if (patrollingMonster != null) {
            if (leader) {
                patrollingMonster.x(true);
                patrollingMonster.gz();
            }
            patrollingMonster.a_(pos.u(), pos.v(), pos.w());
            patrollingMonster.a((WorldAccess)level, level.d_(pos), EntitySpawnReason.p, null);
            level.addFreshEntityWithPassengers(patrollingMonster, CreatureSpawnEvent.SpawnReason.PATROL);
            return true;
        }
        return false;
    }
}

