/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.CubicSpline;
import net.minecraft.util.INamable;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NoiseGenerator3Handler;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import org.slf4j.Logger;

public final class DensityFunctions {
    private static final Codec<DensityFunction> c = BuiltInRegistries.ad.q().dispatch(densityFunction -> densityFunction.c().a(), Function.identity());
    protected static final double a = 1000000.0;
    static final Codec<Double> d = Codec.doubleRange((double)-1000000.0, (double)1000000.0);
    public static final Codec<DensityFunction> b = Codec.either(d, c).xmap(either -> either.map(DensityFunctions::a, Function.identity()), densityFunction -> {
        Either<Object, DensityFunction> either;
        if (densityFunction instanceof h) {
            h constant = (h)densityFunction;
            either = Either.left(constant.j());
        } else {
            either = Either.right(densityFunction);
        }
        return either;
    });

    public static MapCodec<? extends DensityFunction> a(IRegistry<MapCodec<? extends DensityFunction>> registry) {
        DensityFunctions.a(registry, "blend_alpha", net.minecraft.world.level.levelgen.DensityFunctions$d.e);
        DensityFunctions.a(registry, "blend_offset", f.e);
        DensityFunctions.a(registry, "beardifier", net.minecraft.world.level.levelgen.DensityFunctions$b.e);
        DensityFunctions.a(registry, "old_blended_noise", BlendedNoise.a);
        for (l.a a2 : l.a.values()) {
            DensityFunctions.a(registry, a2.c(), a2.g);
        }
        DensityFunctions.a(registry, "noise", o.e);
        DensityFunctions.a(registry, "end_islands", i.a);
        DensityFunctions.a(registry, "weird_scaled_sampler", z.a);
        DensityFunctions.a(registry, "shifted_noise", v.a);
        DensityFunctions.a(registry, "range_choice", q.e);
        DensityFunctions.a(registry, "shift_a", s.e);
        DensityFunctions.a(registry, "shift_b", t.e);
        DensityFunctions.a(registry, "shift", r.e);
        DensityFunctions.a(registry, "blend_density", e.e);
        DensityFunctions.a(registry, "clamp", g.a);
        for (Enum enum_ : k.a.values()) {
            DensityFunctions.a(registry, ((k.a)enum_).c(), ((k.a)enum_).h);
        }
        for (Enum enum_ : y.a.values()) {
            DensityFunctions.a(registry, ((y.a)enum_).c(), ((y.a)enum_).e);
        }
        DensityFunctions.a(registry, "spline", w.a);
        DensityFunctions.a(registry, "constant", h.e);
        return DensityFunctions.a(registry, "y_clamped_gradient", aa.a);
    }

    private static MapCodec<? extends DensityFunction> a(IRegistry<MapCodec<? extends DensityFunction>> registry, String name, KeyDispatchDataCodec<? extends DensityFunction> codec) {
        return IRegistry.a(registry, name, codec.a());
    }

    static <A, O> KeyDispatchDataCodec<O> a(Codec<A> codec, Function<A, O> fromFunction, Function<O, A> toFunction) {
        return KeyDispatchDataCodec.a(codec.fieldOf("argument").xmap(fromFunction, toFunction));
    }

    static <O> KeyDispatchDataCodec<O> a(Function<DensityFunction, O> fromFunction, Function<O, DensityFunction> toFunction) {
        return DensityFunctions.a(DensityFunction.d, fromFunction, toFunction);
    }

    static <O> KeyDispatchDataCodec<O> a(BiFunction<DensityFunction, DensityFunction, O> fromFunction, Function<O, DensityFunction> primary, Function<O, DensityFunction> secondary) {
        return KeyDispatchDataCodec.a(RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.d.fieldOf("argument1").forGetter(primary), (App)DensityFunction.d.fieldOf("argument2").forGetter(secondary)).apply((Applicative)instance, fromFunction)));
    }

    static <O> KeyDispatchDataCodec<O> a(MapCodec<O> mapCodec) {
        return KeyDispatchDataCodec.a(mapCodec);
    }

    private DensityFunctions() {
    }

    public static DensityFunction a(DensityFunction wrapped) {
        return new l(l.a.a, wrapped);
    }

    public static DensityFunction b(DensityFunction wrapped) {
        return new l(l.a.b, wrapped);
    }

    public static DensityFunction c(DensityFunction wrapped) {
        return new l(l.a.c, wrapped);
    }

    public static DensityFunction d(DensityFunction wrapped) {
        return new l(l.a.d, wrapped);
    }

    public static DensityFunction e(DensityFunction wrapped) {
        return new l(l.a.e, wrapped);
    }

    public static DensityFunction a(Holder<NoiseGeneratorNormal.a> noiseData, @Deprecated double xzScale, double yScale, double fromY, double toY) {
        return DensityFunctions.a((DensityFunction)new o(new DensityFunction.c(noiseData), xzScale, yScale), fromY, toY);
    }

    public static DensityFunction a(Holder<NoiseGeneratorNormal.a> noiseData, double yScale, double fromY, double toY) {
        return DensityFunctions.a(noiseData, 1.0, yScale, fromY, toY);
    }

    public static DensityFunction a(Holder<NoiseGeneratorNormal.a> noiseData, double fromY, double toY) {
        return DensityFunctions.a(noiseData, 1.0, 1.0, fromY, toY);
    }

    public static DensityFunction a(DensityFunction shiftX, DensityFunction shiftZ, double xzScale, Holder<NoiseGeneratorNormal.a> noiseData) {
        return new v(shiftX, DensityFunctions.a(), shiftZ, xzScale, 0.0, new DensityFunction.c(noiseData));
    }

    public static DensityFunction a(Holder<NoiseGeneratorNormal.a> noiseData) {
        return DensityFunctions.b(noiseData, 1.0, 1.0);
    }

    public static DensityFunction b(Holder<NoiseGeneratorNormal.a> noiseData, double xzScale, double yScale) {
        return new o(new DensityFunction.c(noiseData), xzScale, yScale);
    }

    public static DensityFunction a(Holder<NoiseGeneratorNormal.a> noiseData, double yScale) {
        return DensityFunctions.b(noiseData, 1.0, yScale);
    }

    public static DensityFunction a(DensityFunction input, double minInclusive, double maxExclusive, DensityFunction whenInRange, DensityFunction whenOutOfRange) {
        return new q(input, minInclusive, maxExclusive, whenInRange, whenOutOfRange);
    }

    public static DensityFunction b(Holder<NoiseGeneratorNormal.a> noiseData) {
        return new s(new DensityFunction.c(noiseData));
    }

    public static DensityFunction c(Holder<NoiseGeneratorNormal.a> noiseData) {
        return new t(new DensityFunction.c(noiseData));
    }

    public static DensityFunction d(Holder<NoiseGeneratorNormal.a> noiseData) {
        return new r(new DensityFunction.c(noiseData));
    }

    public static DensityFunction f(DensityFunction input) {
        return new e(input);
    }

    public static DensityFunction a(long seed) {
        return new i(seed);
    }

    public static DensityFunction a(DensityFunction input, Holder<NoiseGeneratorNormal.a> noiseData, z.a rarityValueMapper) {
        return new z(input, new DensityFunction.c(noiseData), rarityValueMapper);
    }

    public static DensityFunction a(DensityFunction argument1, DensityFunction argument2) {
        return y.a(y.a.a, argument1, argument2);
    }

    public static DensityFunction b(DensityFunction argument1, DensityFunction argument2) {
        return y.a(y.a.b, argument1, argument2);
    }

    public static DensityFunction c(DensityFunction argument1, DensityFunction argument2) {
        return y.a(y.a.c, argument1, argument2);
    }

    public static DensityFunction d(DensityFunction argument1, DensityFunction argument2) {
        return y.a(y.a.d, argument1, argument2);
    }

    public static DensityFunction a(CubicSpline<w.b, w.a> spline) {
        return new w(spline);
    }

    public static DensityFunction a() {
        return h.f;
    }

    public static DensityFunction a(double value) {
        return new h(value);
    }

    public static DensityFunction a(int fromY, int toY, double fromValue, double toValue) {
        return new aa(fromY, toY, fromValue, toValue);
    }

    public static DensityFunction a(DensityFunction input, k.a type) {
        return k.a(type, input);
    }

    private static DensityFunction a(DensityFunction densityFunction, double fromY, double toY) {
        double d2 = (fromY + toY) * 0.5;
        double d1 = (toY - fromY) * 0.5;
        return DensityFunctions.a(DensityFunctions.a(d2), DensityFunctions.b(DensityFunctions.a(d1), densityFunction));
    }

    public static DensityFunction b() {
        return net.minecraft.world.level.levelgen.DensityFunctions$d.a;
    }

    public static DensityFunction c() {
        return f.a;
    }

    public static DensityFunction a(DensityFunction deltaFunction, DensityFunction minFunction, DensityFunction maxFunction) {
        if (minFunction instanceof h) {
            h constant = (h)minFunction;
            return DensityFunctions.a(deltaFunction, constant.a, maxFunction);
        }
        DensityFunction densityFunction = DensityFunctions.d(deltaFunction);
        DensityFunction densityFunction1 = DensityFunctions.a(DensityFunctions.b(densityFunction, DensityFunctions.a(-1.0)), DensityFunctions.a(1.0));
        return DensityFunctions.a(DensityFunctions.b(minFunction, densityFunction1), DensityFunctions.b(maxFunction, densityFunction));
    }

    public static DensityFunction a(DensityFunction deltaFunction, double min, DensityFunction maxFunction) {
        return DensityFunctions.a(DensityFunctions.b(deltaFunction, DensityFunctions.a(maxFunction, DensityFunctions.a(-min))), DensityFunctions.a(min));
    }

    protected static final class d
    extends Enum<d>
    implements DensityFunction.d {
        public static final /* enum */ d a = new d();
        public static final KeyDispatchDataCodec<DensityFunction> e;
        private static final /* synthetic */ d[] f;

        public static d[] values() {
            return (d[])f.clone();
        }

        public static d valueOf(String name) {
            return Enum.valueOf(d.class, name);
        }

        @Override
        public double a(DensityFunction.b context) {
            return 1.0;
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            Arrays.fill(array, 1.0);
        }

        @Override
        public double a() {
            return 1.0;
        }

        @Override
        public double b() {
            return 1.0;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return e;
        }

        private static /* synthetic */ d[] j() {
            return new d[]{a};
        }

        static {
            f = net.minecraft.world.level.levelgen.DensityFunctions$d.j();
            e = KeyDispatchDataCodec.a(MapCodec.unit((Object)a));
        }
    }

    protected static final class f
    extends Enum<f>
    implements DensityFunction.d {
        public static final /* enum */ f a = new f();
        public static final KeyDispatchDataCodec<DensityFunction> e;
        private static final /* synthetic */ f[] f;

        public static f[] values() {
            return (f[])f.clone();
        }

        public static f valueOf(String name) {
            return Enum.valueOf(f.class, name);
        }

        @Override
        public double a(DensityFunction.b context) {
            return 0.0;
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            Arrays.fill(array, 0.0);
        }

        @Override
        public double a() {
            return 0.0;
        }

        @Override
        public double b() {
            return 0.0;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return e;
        }

        private static /* synthetic */ f[] j() {
            return new f[]{a};
        }

        static {
            f = net.minecraft.world.level.levelgen.DensityFunctions$f.j();
            e = KeyDispatchDataCodec.a(MapCodec.unit((Object)a));
        }
    }

    protected static final class b
    extends Enum<b>
    implements c {
        public static final /* enum */ b a = new b();
        private static final /* synthetic */ b[] f;

        public static b[] values() {
            return (b[])f.clone();
        }

        public static b valueOf(String name) {
            return Enum.valueOf(b.class, name);
        }

        @Override
        public double a(DensityFunction.b context) {
            return 0.0;
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            Arrays.fill(array, 0.0);
        }

        @Override
        public double a() {
            return 0.0;
        }

        @Override
        public double b() {
            return 0.0;
        }

        private static /* synthetic */ b[] j() {
            return new b[]{a};
        }

        static {
            f = net.minecraft.world.level.levelgen.DensityFunctions$b.j();
        }
    }

    protected static final class l
    extends Record
    implements m {
        private final a a;
        private final DensityFunction e;

        protected l(a type, DensityFunction wrapped) {
            this.a = type;
            this.e = wrapped;
        }

        @Override
        public double a(DensityFunction.b context) {
            return this.e.a(context);
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            this.e.a(array, contextProvider);
        }

        @Override
        public double a() {
            return this.e.a();
        }

        @Override
        public double b() {
            return this.e.b();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{l.class, "type;wrapped", "a", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{l.class, "type;wrapped", "a", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{l.class, "type;wrapped", "a", "e"}, this, o2);
        }

        @Override
        public a j() {
            return this.a;
        }

        @Override
        public DensityFunction k() {
            return this.e;
        }

        static final class a
        extends Enum<a>
        implements INamable {
            public static final /* enum */ a a = new a("interpolated");
            public static final /* enum */ a b = new a("flat_cache");
            public static final /* enum */ a c = new a("cache_2d");
            public static final /* enum */ a d = new a("cache_once");
            public static final /* enum */ a e = new a("cache_all_in_cell");
            private final String f;
            final KeyDispatchDataCodec<m> g = DensityFunctions.a((DensityFunction function) -> new l(this, (DensityFunction)function), m::k);
            private static final /* synthetic */ a[] h;

            public static a[] values() {
                return (a[])h.clone();
            }

            public static a valueOf(String name) {
                return Enum.valueOf(a.class, name);
            }

            private a(String name) {
                this.f = name;
            }

            @Override
            public String c() {
                return this.f;
            }

            private static /* synthetic */ a[] a() {
                return new a[]{a, b, c, d, e};
            }

            static {
                h = net.minecraft.world.level.levelgen.DensityFunctions$l$a.a();
            }
        }
    }

    protected static final class o
    extends Record
    implements DensityFunction {
        private final DensityFunction.c f;
        @Deprecated
        private final double g;
        private final double h;
        public static final MapCodec<o> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.c.a.fieldOf("noise").forGetter(o::j), (App)Codec.DOUBLE.fieldOf("xz_scale").forGetter(o::k), (App)Codec.DOUBLE.fieldOf("y_scale").forGetter(o::l)).apply((Applicative)instance, o::new));
        public static final KeyDispatchDataCodec<o> e = KeyDispatchDataCodec.a(a);

        protected o(DensityFunction.c noise, @Deprecated double xzScale, double yScale) {
            this.f = noise;
            this.g = xzScale;
            this.h = yScale;
        }

        @Override
        public double a(DensityFunction.b context) {
            return this.f.a((double)context.a() * this.g, (double)context.b() * this.h, (double)context.c() * this.g);
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            contextProvider.a(array, this);
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(new o(visitor.a(this.f), this.g, this.h));
        }

        @Override
        public double a() {
            return -this.b();
        }

        @Override
        public double b() {
            return this.f.a();
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return e;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{o.class, "noise;xzScale;yScale", "f", "g", "h"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{o.class, "noise;xzScale;yScale", "f", "g", "h"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{o.class, "noise;xzScale;yScale", "f", "g", "h"}, this, o2);
        }

        public DensityFunction.c j() {
            return this.f;
        }

        @Deprecated
        public double k() {
            return this.g;
        }

        public double l() {
            return this.h;
        }
    }

    protected static final class i
    implements DensityFunction.d {
        public static final KeyDispatchDataCodec<i> a = KeyDispatchDataCodec.a(MapCodec.unit((Object)new i(0L)));
        private static final float e = -0.9f;
        private final NoiseGenerator3Handler f;
        private static final ThreadLocal<Map<NoiseGenerator3Handler, NoiseCache>> noiseCache = ThreadLocal.withInitial(WeakHashMap::new);

        public i(long seed) {
            LegacyRandomSource randomSource = new LegacyRandomSource(seed);
            randomSource.b(17292);
            this.f = new NoiseGenerator3Handler(randomSource);
        }

        private static float a(NoiseGenerator3Handler noise, int x2, int z2) {
            int i2 = x2 / 2;
            int i1 = z2 / 2;
            int i22 = x2 % 2;
            int i3 = z2 % 2;
            float f2 = 100.0f - MathHelper.c((long)x2 * (long)x2 + (long)z2 * (long)z2) * 8.0f;
            f2 = MathHelper.a(f2, -100.0f, 80.0f);
            NoiseCache cache = noiseCache.get().computeIfAbsent(noise, noiseKey -> new NoiseCache());
            for (int i4 = -12; i4 <= 12; ++i4) {
                for (int i5 = -12; i5 <= 12; ++i5) {
                    long l2 = i2 + i4;
                    int chunkX = (int)l2;
                    long l1 = i1 + i5;
                    int chunkZ = (int)l1;
                    long chunkKey = ChunkCoordIntPair.c(chunkX, chunkZ);
                    int cacheIndex = (int)HashCommon.mix((long)chunkKey) & 0x1FFF;
                    float f1 = Float.MIN_VALUE;
                    if (cache.keys[cacheIndex] == chunkKey) {
                        f1 = cache.values[cacheIndex];
                    } else {
                        if (l2 * l2 + l1 * l1 > 4096L && noise.a(l2, l1) < (double)-0.9f) {
                            f1 = (MathHelper.e(l2) * 3439.0f + MathHelper.e(l1) * 147.0f) % 13.0f + 9.0f;
                        }
                        cache.keys[cacheIndex] = chunkKey;
                        cache.values[cacheIndex] = f1;
                    }
                    if (f1 == Float.MIN_VALUE) continue;
                    float f22 = i22 - i4 * 2;
                    float f3 = i3 - i5 * 2;
                    float f4 = 100.0f - MathHelper.c(f22 * f22 + f3 * f3) * f1;
                    f4 = MathHelper.a(f4, -100.0f, 80.0f);
                    f2 = Math.max(f2, f4);
                }
            }
            return f2;
        }

        @Override
        public double a(DensityFunction.b context) {
            return ((double)i.a(this.f, context.a() / 8, context.c() / 8) - 8.0) / 128.0;
        }

        @Override
        public double a() {
            return -0.84375;
        }

        @Override
        public double b() {
            return 0.5625;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return a;
        }

        private static final class NoiseCache {
            public long[] keys = new long[8192];
            public float[] values = new float[8192];

            public NoiseCache() {
                Arrays.fill(this.keys, Long.MIN_VALUE);
            }
        }
    }

    protected static final class z
    extends Record
    implements x {
        private final DensityFunction e;
        private final DensityFunction.c f;
        private final a g;
        private static final MapCodec<z> h = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.d.fieldOf("input").forGetter(z::j), (App)DensityFunction.c.a.fieldOf("noise").forGetter(z::k), (App)a.c.fieldOf("rarity_value_mapper").forGetter(z::l)).apply((Applicative)instance, z::new));
        public static final KeyDispatchDataCodec<z> a = KeyDispatchDataCodec.a(h);

        protected z(DensityFunction input, DensityFunction.c noise, a rarityValueMapper) {
            this.e = input;
            this.f = noise;
            this.g = rarityValueMapper;
        }

        @Override
        public double a(DensityFunction.b context, double value) {
            double d2 = this.g.e.get(value);
            return d2 * Math.abs(this.f.a((double)context.a() / d2, (double)context.b() / d2, (double)context.c() / d2));
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(new z(this.e.a(visitor), visitor.a(this.f), this.g));
        }

        @Override
        public double a() {
            return 0.0;
        }

        @Override
        public double b() {
            return this.g.f * this.f.a();
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return a;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{z.class, "input;noise;rarityValueMapper", "e", "f", "g"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{z.class, "input;noise;rarityValueMapper", "e", "f", "g"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{z.class, "input;noise;rarityValueMapper", "e", "f", "g"}, this, o2);
        }

        @Override
        public DensityFunction j() {
            return this.e;
        }

        public DensityFunction.c k() {
            return this.f;
        }

        public a l() {
            return this.g;
        }

        public static final class a
        extends Enum<a>
        implements INamable {
            public static final /* enum */ a a = new a("type_1", NoiseRouterData.a::b, 2.0);
            public static final /* enum */ a b = new a("type_2", NoiseRouterData.a::a, 3.0);
            public static final Codec<a> c;
            private final String d;
            final Double2DoubleFunction e;
            final double f;
            private static final /* synthetic */ a[] g;

            public static a[] values() {
                return (a[])g.clone();
            }

            public static a valueOf(String name) {
                return Enum.valueOf(a.class, name);
            }

            private a(String name, Double2DoubleFunction mapper, double maxRarity) {
                this.d = name;
                this.e = mapper;
                this.f = maxRarity;
            }

            @Override
            public String c() {
                return this.d;
            }

            private static /* synthetic */ a[] a() {
                return new a[]{a, b};
            }

            static {
                g = net.minecraft.world.level.levelgen.DensityFunctions$z$a.a();
                c = INamable.a(a::values);
            }
        }
    }

    protected static final class v
    extends Record
    implements DensityFunction {
        private final DensityFunction e;
        private final DensityFunction f;
        private final DensityFunction g;
        private final double h;
        private final double i;
        private final DensityFunction.c j;
        private static final MapCodec<v> k = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.d.fieldOf("shift_x").forGetter(v::j), (App)DensityFunction.d.fieldOf("shift_y").forGetter(v::k), (App)DensityFunction.d.fieldOf("shift_z").forGetter(v::l), (App)Codec.DOUBLE.fieldOf("xz_scale").forGetter(v::m), (App)Codec.DOUBLE.fieldOf("y_scale").forGetter(v::n), (App)DensityFunction.c.a.fieldOf("noise").forGetter(v::o)).apply((Applicative)instance, v::new));
        public static final KeyDispatchDataCodec<v> a = KeyDispatchDataCodec.a(k);

        protected v(DensityFunction shiftX, DensityFunction shiftY, DensityFunction shiftZ, double xzScale, double yScale, DensityFunction.c noise) {
            this.e = shiftX;
            this.f = shiftY;
            this.g = shiftZ;
            this.h = xzScale;
            this.i = yScale;
            this.j = noise;
        }

        @Override
        public double a(DensityFunction.b context) {
            double d2 = (double)context.a() * this.h + this.e.a(context);
            double d1 = (double)context.b() * this.i + this.f.a(context);
            double d22 = (double)context.c() * this.h + this.g.a(context);
            return this.j.a(d2, d1, d22);
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            contextProvider.a(array, this);
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(new v(this.e.a(visitor), this.f.a(visitor), this.g.a(visitor), this.h, this.i, visitor.a(this.j)));
        }

        @Override
        public double a() {
            return -this.b();
        }

        @Override
        public double b() {
            return this.j.a();
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return a;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{v.class, "shiftX;shiftY;shiftZ;xzScale;yScale;noise", "e", "f", "g", "h", "i", "j"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{v.class, "shiftX;shiftY;shiftZ;xzScale;yScale;noise", "e", "f", "g", "h", "i", "j"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{v.class, "shiftX;shiftY;shiftZ;xzScale;yScale;noise", "e", "f", "g", "h", "i", "j"}, this, o2);
        }

        public DensityFunction j() {
            return this.e;
        }

        public DensityFunction k() {
            return this.f;
        }

        public DensityFunction l() {
            return this.g;
        }

        public double m() {
            return this.h;
        }

        public double n() {
            return this.i;
        }

        public DensityFunction.c o() {
            return this.j;
        }
    }

    static final class q
    extends Record
    implements DensityFunction {
        private final DensityFunction f;
        private final double g;
        private final double h;
        private final DensityFunction i;
        private final DensityFunction j;
        public static final MapCodec<q> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.d.fieldOf("input").forGetter(q::j), (App)d.fieldOf("min_inclusive").forGetter(q::k), (App)d.fieldOf("max_exclusive").forGetter(q::l), (App)DensityFunction.d.fieldOf("when_in_range").forGetter(q::m), (App)DensityFunction.d.fieldOf("when_out_of_range").forGetter(q::n)).apply((Applicative)instance, q::new));
        public static final KeyDispatchDataCodec<q> e = KeyDispatchDataCodec.a(a);

        q(DensityFunction input, double minInclusive, double maxExclusive, DensityFunction whenInRange, DensityFunction whenOutOfRange) {
            this.f = input;
            this.g = minInclusive;
            this.h = maxExclusive;
            this.i = whenInRange;
            this.j = whenOutOfRange;
        }

        @Override
        public double a(DensityFunction.b context) {
            double d2 = this.f.a(context);
            return d2 >= this.g && d2 < this.h ? this.i.a(context) : this.j.a(context);
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            this.f.a(array, contextProvider);
            for (int i2 = 0; i2 < array.length; ++i2) {
                double d2 = array[i2];
                array[i2] = d2 >= this.g && d2 < this.h ? this.i.a(contextProvider.a(i2)) : this.j.a(contextProvider.a(i2));
            }
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(new q(this.f.a(visitor), this.g, this.h, this.i.a(visitor), this.j.a(visitor)));
        }

        @Override
        public double a() {
            return Math.min(this.i.a(), this.j.a());
        }

        @Override
        public double b() {
            return Math.max(this.i.b(), this.j.b());
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return e;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{q.class, "input;minInclusive;maxExclusive;whenInRange;whenOutOfRange", "f", "g", "h", "i", "j"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{q.class, "input;minInclusive;maxExclusive;whenInRange;whenOutOfRange", "f", "g", "h", "i", "j"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{q.class, "input;minInclusive;maxExclusive;whenInRange;whenOutOfRange", "f", "g", "h", "i", "j"}, this, o2);
        }

        public DensityFunction j() {
            return this.f;
        }

        public double k() {
            return this.g;
        }

        public double l() {
            return this.h;
        }

        public DensityFunction m() {
            return this.i;
        }

        public DensityFunction n() {
            return this.j;
        }
    }

    protected static final class s
    extends Record
    implements u {
        private final DensityFunction.c a;
        static final KeyDispatchDataCodec<s> e = DensityFunctions.a(DensityFunction.c.a, s::new, s::j);

        protected s(DensityFunction.c offsetNoise) {
            this.a = offsetNoise;
        }

        @Override
        public double a(DensityFunction.b context) {
            return this.a(context.a(), 0.0, context.c());
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(new s(visitor.a(this.a)));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return e;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{s.class, "offsetNoise", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{s.class, "offsetNoise", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{s.class, "offsetNoise", "a"}, this, o2);
        }

        @Override
        public DensityFunction.c j() {
            return this.a;
        }
    }

    protected static final class t
    extends Record
    implements u {
        private final DensityFunction.c a;
        static final KeyDispatchDataCodec<t> e = DensityFunctions.a(DensityFunction.c.a, t::new, t::j);

        protected t(DensityFunction.c offsetNoise) {
            this.a = offsetNoise;
        }

        @Override
        public double a(DensityFunction.b context) {
            return this.a(context.c(), context.a(), 0.0);
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(new t(visitor.a(this.a)));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return e;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{t.class, "offsetNoise", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{t.class, "offsetNoise", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{t.class, "offsetNoise", "a"}, this, o2);
        }

        @Override
        public DensityFunction.c j() {
            return this.a;
        }
    }

    protected static final class r
    extends Record
    implements u {
        private final DensityFunction.c a;
        static final KeyDispatchDataCodec<r> e = DensityFunctions.a(DensityFunction.c.a, r::new, r::j);

        protected r(DensityFunction.c offsetNoise) {
            this.a = offsetNoise;
        }

        @Override
        public double a(DensityFunction.b context) {
            return this.a(context.a(), context.b(), context.c());
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(new r(visitor.a(this.a)));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return e;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{r.class, "offsetNoise", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{r.class, "offsetNoise", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{r.class, "offsetNoise", "a"}, this, o2);
        }

        @Override
        public DensityFunction.c j() {
            return this.a;
        }
    }

    record e(DensityFunction a) implements x
    {
        private final DensityFunction a;
        static final KeyDispatchDataCodec<e> e = DensityFunctions.a(e::new, e::j);

        @Override
        public double a(DensityFunction.b context, double value) {
            return context.d().a(context, value);
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(new e(this.a.a(visitor)));
        }

        @Override
        public double a() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public double b() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return e;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "input", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "input", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "input", "a"}, this, o2);
        }

        @Override
        public DensityFunction j() {
            return this.a;
        }
    }

    protected static final class g
    extends Record
    implements p {
        private final DensityFunction e;
        private final double f;
        private final double g;
        private static final MapCodec<g> h = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.b.fieldOf("input").forGetter(g::aD_), (App)d.fieldOf("min").forGetter(g::a), (App)d.fieldOf("max").forGetter(g::b)).apply((Applicative)instance, g::new));
        public static final KeyDispatchDataCodec<g> a = KeyDispatchDataCodec.a(h);

        protected g(DensityFunction input, double minValue, double maxValue) {
            this.e = input;
            this.f = minValue;
            this.g = maxValue;
        }

        @Override
        public double a(double value) {
            return MathHelper.a(value, this.f, this.g);
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return new g(this.e.a(visitor), this.f, this.g);
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return a;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{g.class, "input;minValue;maxValue", "e", "f", "g"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{g.class, "input;minValue;maxValue", "e", "f", "g"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{g.class, "input;minValue;maxValue", "e", "f", "g"}, this, o2);
        }

        @Override
        public DensityFunction aD_() {
            return this.e;
        }

        @Override
        public double a() {
            return this.f;
        }

        @Override
        public double b() {
            return this.g;
        }
    }

    protected static final class k
    extends Record
    implements p {
        private final a a;
        private final DensityFunction e;
        private final double f;
        private final double g;

        protected k(a type, DensityFunction input, double minValue, double maxValue) {
            this.a = type;
            this.e = input;
            this.f = minValue;
            this.g = maxValue;
        }

        public static k a(a type, DensityFunction input) {
            double d2 = input.a();
            double d1 = k.a(type, d2);
            double d22 = k.a(type, input.b());
            return type != a.a && type != a.b ? new k(type, input, d1, d22) : new k(type, input, Math.max(0.0, d2), Math.max(d1, d22));
        }

        private static double a(a type, double value) {
            return switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Math.abs(value);
                case 1 -> value * value;
                case 2 -> value * value * value;
                case 3 -> {
                    if (value > 0.0) {
                        yield value;
                    }
                    yield value * 0.5;
                }
                case 4 -> {
                    if (value > 0.0) {
                        yield value;
                    }
                    yield value * 0.25;
                }
                case 5 -> {
                    double d = MathHelper.a(value, -1.0, 1.0);
                    yield d / 2.0 - d * d * d / 24.0;
                }
            };
        }

        @Override
        public double a(double value) {
            return k.a(this.a, value);
        }

        public k b(DensityFunction.f visitor) {
            return k.a(this.a, this.e.a(visitor));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return this.a.h;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{k.class, "type;input;minValue;maxValue", "a", "e", "f", "g"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{k.class, "type;input;minValue;maxValue", "a", "e", "f", "g"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{k.class, "type;input;minValue;maxValue", "a", "e", "f", "g"}, this, o2);
        }

        public a k() {
            return this.a;
        }

        @Override
        public DensityFunction aD_() {
            return this.e;
        }

        @Override
        public double a() {
            return this.f;
        }

        @Override
        public double b() {
            return this.g;
        }

        static final class a
        extends Enum<a>
        implements INamable {
            public static final /* enum */ a a = new a("abs");
            public static final /* enum */ a b = new a("square");
            public static final /* enum */ a c = new a("cube");
            public static final /* enum */ a d = new a("half_negative");
            public static final /* enum */ a e = new a("quarter_negative");
            public static final /* enum */ a f = new a("squeeze");
            private final String g;
            final KeyDispatchDataCodec<k> h = DensityFunctions.a((DensityFunction input) -> k.a(this, input), k::aD_);
            private static final /* synthetic */ a[] i;

            public static a[] values() {
                return (a[])i.clone();
            }

            public static a valueOf(String name) {
                return Enum.valueOf(a.class, name);
            }

            private a(String name) {
                this.g = name;
            }

            @Override
            public String c() {
                return this.g;
            }

            private static /* synthetic */ a[] a() {
                return new a[]{a, b, c, d, e, f};
            }

            static {
                i = net.minecraft.world.level.levelgen.DensityFunctions$k$a.a();
            }
        }
    }

    static interface y
    extends DensityFunction {
        public static final Logger a = LogUtils.getLogger();

        public static y a(a type, DensityFunction argument1, DensityFunction argument2) {
            double d5;
            double d2 = argument1.a();
            double d1 = argument2.a();
            double d22 = argument1.b();
            double d3 = argument2.b();
            if (type == a.c || type == a.d) {
                boolean flag1;
                boolean flag = d2 >= d3;
                boolean bl = flag1 = d1 >= d22;
                if (flag || flag1) {
                    a.warn("Creating a " + String.valueOf(type) + " function between two non-overlapping inputs: " + String.valueOf(argument1) + " and " + String.valueOf(argument2));
                }
            }
            double d4 = switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> d2 + d1;
                case 1 -> {
                    if (d2 > 0.0 && d1 > 0.0) {
                        yield d2 * d1;
                    }
                    if (d22 < 0.0 && d3 < 0.0) {
                        yield d22 * d3;
                    }
                    yield Math.min(d2 * d3, d22 * d1);
                }
                case 2 -> Math.min(d2, d1);
                case 3 -> Math.max(d2, d1);
            };
            switch (type.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    double d6 = d22 + d3;
                    break;
                }
                case 1: {
                    double d6;
                    if (d2 > 0.0 && d1 > 0.0) {
                        d6 = d22 * d3;
                        break;
                    }
                    if (d22 < 0.0 && d3 < 0.0) {
                        d6 = d2 * d1;
                        break;
                    }
                    d6 = Math.max(d2 * d1, d22 * d3);
                    break;
                }
                case 2: {
                    double d6 = Math.min(d22, d3);
                    break;
                }
                case 3: {
                    double d6 = d5 = Math.max(d22, d3);
                }
            }
            if (type == a.b || type == a.a) {
                if (argument1 instanceof h) {
                    h constant = (h)argument1;
                    return new n(type == a.a ? n.a.b : n.a.a, argument2, d4, d5, constant.a);
                }
                if (argument2 instanceof h) {
                    h constant = (h)argument2;
                    return new n(type == a.a ? n.a.b : n.a.a, argument1, d4, d5, constant.a);
                }
            }
            return new net.minecraft.world.level.levelgen.DensityFunctions$a(type, argument1, argument2, d4, d5);
        }

        public a j();

        public DensityFunction k();

        public DensityFunction l();

        @Override
        default public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return this.j().e;
        }

        public static final class a
        extends Enum<a>
        implements INamable {
            public static final /* enum */ a a = new a("add");
            public static final /* enum */ a b = new a("mul");
            public static final /* enum */ a c = new a("min");
            public static final /* enum */ a d = new a("max");
            final KeyDispatchDataCodec<y> e = DensityFunctions.a((from, to) -> y.a(this, from, to), y::k, y::l);
            private final String f;
            private static final /* synthetic */ a[] g;

            public static a[] values() {
                return (a[])g.clone();
            }

            public static a valueOf(String name) {
                return Enum.valueOf(a.class, name);
            }

            private a(String name) {
                this.f = name;
            }

            @Override
            public String c() {
                return this.f;
            }

            private static /* synthetic */ a[] a() {
                return new a[]{a, b, c, d};
            }

            static {
                g = net.minecraft.world.level.levelgen.DensityFunctions$y$a.a();
            }
        }
    }

    public static final class w
    extends Record
    implements DensityFunction {
        private final CubicSpline<b, a> e;
        private static final Codec<CubicSpline<b, a>> f = CubicSpline.a(a.b);
        private static final MapCodec<w> g = f.fieldOf("spline").xmap(w::new, w::j);
        public static final KeyDispatchDataCodec<w> a = KeyDispatchDataCodec.a(g);

        public w(CubicSpline<b, a> spline) {
            this.e = spline;
        }

        @Override
        public double a(DensityFunction.b context) {
            return this.e.a(new b(context));
        }

        @Override
        public double a() {
            return this.e.b();
        }

        @Override
        public double b() {
            return this.e.c();
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            contextProvider.a(array, this);
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(new w(this.e.a((I coordinate) -> coordinate.a(visitor))));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return a;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{w.class, "spline", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{w.class, "spline", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{w.class, "spline", "e"}, this, o2);
        }

        public CubicSpline<b, a> j() {
            return this.e;
        }

        public record b(DensityFunction.b a) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "context", "a"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "context", "a"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "context", "a"}, this, o2);
            }
        }

        public record a(Holder<DensityFunction> c) implements ToFloatFunction<b>
        {
            private final Holder<DensityFunction> c;
            public static final Codec<a> b = DensityFunction.c.xmap(a::new, a::a);

            @Override
            public String toString() {
                Optional<ResourceKey<DensityFunction>> optional = this.c.e();
                if (optional.isPresent()) {
                    ResourceKey<DensityFunction> resourceKey = optional.get();
                    if (resourceKey == NoiseRouterData.d) {
                        return "continents";
                    }
                    if (resourceKey == NoiseRouterData.e) {
                        return "erosion";
                    }
                    if (resourceKey == NoiseRouterData.f) {
                        return "weirdness";
                    }
                    if (resourceKey == NoiseRouterData.g) {
                        return "ridges";
                    }
                }
                return "Coordinate[" + String.valueOf(this.c) + "]";
            }

            @Override
            public float a(b object) {
                return (float)this.c.a().a(object.a());
            }

            @Override
            public float b() {
                return this.c.b() ? (float)this.c.a().a() : Float.NEGATIVE_INFINITY;
            }

            @Override
            public float c() {
                return this.c.b() ? (float)this.c.a().b() : Float.POSITIVE_INFINITY;
            }

            public a a(DensityFunction.f visitor) {
                return new a(new Holder.a<DensityFunction>(this.c.a().a(visitor)));
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "function", "c"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "function", "c"}, this, o2);
            }

            public Holder<DensityFunction> a() {
                return this.c;
            }
        }
    }

    record h(double a) implements DensityFunction.d
    {
        static final KeyDispatchDataCodec<h> e = DensityFunctions.a(d, h::new, h::j);
        static final h f = new h(0.0);

        @Override
        public double a(DensityFunction.b context) {
            return this.a;
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            Arrays.fill(array, this.a);
        }

        @Override
        public double b() {
            return this.a;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return e;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{h.class, "value", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{h.class, "value", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{h.class, "value", "a"}, this, o2);
        }

        public double j() {
            return this.a;
        }
    }

    static final class aa
    extends Record
    implements DensityFunction.d {
        private final int e;
        private final int f;
        private final double g;
        private final double h;
        private static final MapCodec<aa> i = RecordCodecBuilder.mapCodec(codec -> codec.group((App)Codec.intRange((int)-4064, (int)4062).fieldOf("from_y").forGetter(aa::j), (App)Codec.intRange((int)-4064, (int)4062).fieldOf("to_y").forGetter(aa::k), (App)d.fieldOf("from_value").forGetter(aa::l), (App)d.fieldOf("to_value").forGetter(aa::m)).apply((Applicative)codec, aa::new));
        public static final KeyDispatchDataCodec<aa> a = KeyDispatchDataCodec.a(i);

        aa(int fromY, int toY, double fromValue, double toValue) {
            this.e = fromY;
            this.f = toY;
            this.g = fromValue;
            this.h = toValue;
        }

        @Override
        public double a(DensityFunction.b context) {
            return MathHelper.a((double)context.b(), (double)this.e, (double)this.f, this.g, this.h);
        }

        @Override
        public double a() {
            return Math.min(this.g, this.h);
        }

        @Override
        public double b() {
            return Math.max(this.g, this.h);
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return a;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{aa.class, "fromY;toY;fromValue;toValue", "e", "f", "g", "h"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{aa.class, "fromY;toY;fromValue;toValue", "e", "f", "g", "h"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{aa.class, "fromY;toY;fromValue;toValue", "e", "f", "g", "h"}, this, o2);
        }

        public int j() {
            return this.e;
        }

        public int k() {
            return this.f;
        }

        public double l() {
            return this.g;
        }

        public double m() {
            return this.h;
        }
    }

    static interface x
    extends DensityFunction {
        public DensityFunction j();

        @Override
        default public double a(DensityFunction.b context) {
            return this.a(context, this.j().a(context));
        }

        @Override
        default public void a(double[] array, DensityFunction.a contextProvider) {
            this.j().a(array, contextProvider);
            for (int i2 = 0; i2 < array.length; ++i2) {
                array[i2] = this.a(contextProvider.a(i2), array[i2]);
            }
        }

        public double a(DensityFunction.b var1, double var2);
    }

    static interface u
    extends DensityFunction {
        public DensityFunction.c j();

        @Override
        default public double a() {
            return -this.b();
        }

        @Override
        default public double b() {
            return this.j().a() * 4.0;
        }

        default public double a(double x2, double y2, double z2) {
            return this.j().a(x2 * 0.25, y2 * 0.25, z2 * 0.25) * 4.0;
        }

        @Override
        default public void a(double[] array, DensityFunction.a contextProvider) {
            contextProvider.a(array, this);
        }
    }

    static interface p
    extends DensityFunction {
        public DensityFunction aD_();

        @Override
        default public double a(DensityFunction.b context) {
            return this.a(this.aD_().a(context));
        }

        @Override
        default public void a(double[] array, DensityFunction.a contextProvider) {
            this.aD_().a(array, contextProvider);
            for (int i2 = 0; i2 < array.length; ++i2) {
                array[i2] = this.a(array[i2]);
            }
        }

        public double a(double var1);
    }

    static final class n
    extends Record
    implements p,
    y {
        private final a e;
        private final DensityFunction f;
        private final double g;
        private final double h;
        private final double i;

        n(a specificType, DensityFunction input, double minValue, double maxValue, double argument) {
            this.e = specificType;
            this.f = input;
            this.g = minValue;
            this.h = maxValue;
            this.i = argument;
        }

        @Override
        public y.a j() {
            return this.e == a.a ? y.a.b : y.a.a;
        }

        @Override
        public DensityFunction k() {
            return DensityFunctions.a(this.i);
        }

        @Override
        public DensityFunction l() {
            return this.f;
        }

        @Override
        public double a(double value) {
            return switch (this.e.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> value * this.i;
                case 1 -> value + this.i;
            };
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            double d3;
            double d2;
            DensityFunction densityFunction = this.f.a(visitor);
            double d4 = densityFunction.a();
            double d1 = densityFunction.b();
            if (this.e == a.b) {
                d2 = d4 + this.i;
                d3 = d1 + this.i;
            } else if (this.i >= 0.0) {
                d2 = d4 * this.i;
                d3 = d1 * this.i;
            } else {
                d2 = d1 * this.i;
                d3 = d4 * this.i;
            }
            return new n(this.e, densityFunction, d2, d3, this.i);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{n.class, "specificType;input;minValue;maxValue;argument", "e", "f", "g", "h", "i"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{n.class, "specificType;input;minValue;maxValue;argument", "e", "f", "g", "h", "i"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{n.class, "specificType;input;minValue;maxValue;argument", "e", "f", "g", "h", "i"}, this, o2);
        }

        public a m() {
            return this.e;
        }

        @Override
        public DensityFunction aD_() {
            return this.f;
        }

        @Override
        public double a() {
            return this.g;
        }

        @Override
        public double b() {
            return this.h;
        }

        public double n() {
            return this.i;
        }

        static final class a
        extends Enum<a> {
            public static final /* enum */ a a = new a();
            public static final /* enum */ a b = new a();
            private static final /* synthetic */ a[] c;

            public static a[] values() {
                return (a[])c.clone();
            }

            public static a valueOf(String name) {
                return Enum.valueOf(a.class, name);
            }

            private static /* synthetic */ a[] a() {
                return new a[]{a, b};
            }

            static {
                c = net.minecraft.world.level.levelgen.DensityFunctions$n$a.a();
            }
        }
    }

    public static interface m
    extends DensityFunction {
        public l.a j();

        public DensityFunction k();

        @Override
        default public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return this.j().g;
        }

        @Override
        default public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(new l(this.j(), this.k().a(visitor)));
        }
    }

    @VisibleForDebug
    public record j(Holder<DensityFunction> a) implements DensityFunction
    {
        private final Holder<DensityFunction> a;

        @Override
        public double a(DensityFunction.b context) {
            return this.a.a().a(context);
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            this.a.a().a(array, contextProvider);
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(new j(new Holder.a<DensityFunction>(this.a.a().a(visitor))));
        }

        @Override
        public double a() {
            return this.a.b() ? this.a.a().a() : Double.NEGATIVE_INFINITY;
        }

        @Override
        public double b() {
            return this.a.b() ? this.a.a().b() : Double.POSITIVE_INFINITY;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            throw new UnsupportedOperationException("Calling .codec() on HolderHolder");
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{j.class, "function", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{j.class, "function", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{j.class, "function", "a"}, this, o2);
        }

        public Holder<DensityFunction> j() {
            return this.a;
        }
    }

    public static interface c
    extends DensityFunction.d {
        public static final KeyDispatchDataCodec<DensityFunction> e = KeyDispatchDataCodec.a(MapCodec.unit((Object)net.minecraft.world.level.levelgen.DensityFunctions$b.a));

        @Override
        default public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return e;
        }
    }

    static final class a
    extends Record
    implements y {
        private final y.a e;
        private final DensityFunction f;
        private final DensityFunction g;
        private final double h;
        private final double i;

        a(y.a type, DensityFunction argument1, DensityFunction argument2, double minValue, double maxValue) {
            this.e = type;
            this.f = argument1;
            this.g = argument2;
            this.h = minValue;
            this.i = maxValue;
        }

        @Override
        public double a(DensityFunction.b context) {
            double d2 = this.f.a(context);
            return switch (this.e.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> d2 + this.g.a(context);
                case 1 -> {
                    if (d2 == 0.0) {
                        yield 0.0;
                    }
                    yield d2 * this.g.a(context);
                }
                case 2 -> {
                    if (d2 < this.g.a()) {
                        yield d2;
                    }
                    yield Math.min(d2, this.g.a(context));
                }
                case 3 -> d2 > this.g.b() ? d2 : Math.max(d2, this.g.a(context));
            };
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            this.f.a(array, contextProvider);
            switch (this.e.ordinal()) {
                case 0: {
                    double[] doubles = new double[array.length];
                    this.g.a(doubles, contextProvider);
                    for (int i2 = 0; i2 < array.length; ++i2) {
                        int n2 = i2;
                        array[n2] = array[n2] + doubles[i2];
                    }
                    break;
                }
                case 1: {
                    for (int i1 = 0; i1 < array.length; ++i1) {
                        double d2 = array[i1];
                        array[i1] = d2 == 0.0 ? 0.0 : d2 * this.g.a(contextProvider.a(i1));
                    }
                    break;
                }
                case 2: {
                    double d1 = this.g.a();
                    for (int i2 = 0; i2 < array.length; ++i2) {
                        double d2 = array[i2];
                        array[i2] = d2 < d1 ? d2 : Math.min(d2, this.g.a(contextProvider.a(i2)));
                    }
                    break;
                }
                case 3: {
                    double d1 = this.g.b();
                    for (int i2 = 0; i2 < array.length; ++i2) {
                        double d2 = array[i2];
                        array[i2] = d2 > d1 ? d2 : Math.max(d2, this.g.a(contextProvider.a(i2)));
                    }
                    break;
                }
            }
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(y.a(this.e, this.f.a(visitor), this.g.a(visitor)));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "type;argument1;argument2;minValue;maxValue", "e", "f", "g", "h", "i"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "type;argument1;argument2;minValue;maxValue", "e", "f", "g", "h", "i"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "type;argument1;argument2;minValue;maxValue", "e", "f", "g", "h", "i"}, this, o2);
        }

        @Override
        public y.a j() {
            return this.e;
        }

        @Override
        public DensityFunction k() {
            return this.f;
        }

        @Override
        public DensityFunction l() {
            return this.g;
        }

        @Override
        public double a() {
            return this.h;
        }

        @Override
        public double b() {
            return this.i;
        }
    }
}

