/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.BitSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public final class BelowZeroRetrogen {
    private static final BitSet c = new BitSet(0);
    private static final Codec<BitSet> d = Codec.LONG_STREAM.xmap(bitset -> BitSet.valueOf(bitset.toArray()), bitset -> LongStream.of(bitset.toLongArray()));
    private static final Codec<ChunkStatus> e = BuiltInRegistries.l.q().comapFlatMap(chunkStatus -> chunkStatus == ChunkStatus.c ? DataResult.error(() -> "target_status cannot be empty") : DataResult.success((Object)chunkStatus), Function.identity());
    public static final Codec<BelowZeroRetrogen> a = RecordCodecBuilder.create(instance -> instance.group((App)e.fieldOf("target_status").forGetter(BelowZeroRetrogen::a), (App)d.lenientOptionalFieldOf("missing_bedrock").forGetter(belowZeroRetrogen -> belowZeroRetrogen.h.isEmpty() ? Optional.empty() : Optional.of(belowZeroRetrogen.h))).apply((Applicative)instance, BelowZeroRetrogen::new));
    private static final Set<ResourceKey<BiomeBase>> f = Set.of(Biomes.ab, Biomes.aa, Biomes.ac);
    public static final LevelHeightAccessor b = new LevelHeightAccessor(){

        @Override
        public int M_() {
            return 64;
        }

        @Override
        public int L_() {
            return -64;
        }
    };
    private final ChunkStatus g;
    private final BitSet h;

    private BelowZeroRetrogen(ChunkStatus targetStatus, Optional<BitSet> missingBedrock) {
        this.g = targetStatus;
        this.h = missingBedrock.orElse(c);
    }

    @Nullable
    public static BelowZeroRetrogen a(NBTTagCompound tag) {
        ChunkStatus chunkStatus = ChunkStatus.a(tag.l("target_status"));
        return chunkStatus == ChunkStatus.c ? null : new BelowZeroRetrogen(chunkStatus, Optional.of(BitSet.valueOf(tag.o("missing_bedrock"))));
    }

    public static void a(ProtoChunk chunk) {
        int i2 = 4;
        BlockPosition.b(0, 0, 0, 15, 4, 15).forEach(blockPos -> {
            if (chunk.a_((BlockPosition)blockPos).a(Blocks.I)) {
                chunk.a((BlockPosition)blockPos, Blocks.tl.m(), false);
            }
        });
    }

    public void b(ProtoChunk chunk) {
        LevelHeightAccessor heightAccessorForGeneration = chunk.B();
        int minY = heightAccessorForGeneration.L_();
        int maxY = heightAccessorForGeneration.an();
        for (int i2 = 0; i2 < 16; ++i2) {
            for (int i1 = 0; i1 < 16; ++i1) {
                if (!this.a(i2, i1)) continue;
                BlockPosition.b(i2, minY, i1, i2, maxY, i1).forEach(blockPos -> chunk.a((BlockPosition)blockPos, Blocks.a.m(), false));
            }
        }
    }

    public ChunkStatus a() {
        return this.g;
    }

    public boolean b() {
        return !this.h.isEmpty();
    }

    public boolean a(int x2, int z2) {
        return this.h.get((z2 & 0xF) * 16 + (x2 & 0xF));
    }

    public static BiomeResolver a(BiomeResolver resolver, IChunkAccess access) {
        if (!access.A()) {
            return resolver;
        }
        Predicate<ResourceKey> predicate = f::contains;
        return (x2, y2, z2, sampler) -> {
            Holder<BiomeBase> noiseBiome = resolver.getNoiseBiome(x2, y2, z2, sampler);
            return noiseBiome.a(predicate) ? noiseBiome : access.getNoiseBiome(x2, 0, z2);
        };
    }
}

