/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent.vibrations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationInfo;
import net.minecraft.world.level.gameevent.vibrations.VibrationSelector;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R3.CraftGameEvent;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockReceiveGameEvent;

public interface VibrationSystem {
    public static final List<ResourceKey<GameEvent>> d_ = List.of(GameEvent.T.h(), GameEvent.U.h(), GameEvent.V.h(), GameEvent.W.h(), GameEvent.X.h(), GameEvent.Y.h(), GameEvent.Z.h(), GameEvent.aa.h(), GameEvent.ab.h(), GameEvent.ac.h(), GameEvent.ad.h(), GameEvent.ae.h(), GameEvent.af.h(), GameEvent.ag.h(), GameEvent.ah.h());
    public static final int e_ = 0;
    public static final ToIntFunction<ResourceKey<GameEvent>> f_ = (ToIntFunction)SystemUtils.a(new Reference2IntOpenHashMap(), map -> {
        map.defaultReturnValue(0);
        map.put(GameEvent.P.h(), 1);
        map.put(GameEvent.Q.h(), 1);
        map.put(GameEvent.x.h(), 1);
        map.put(GameEvent.J.h(), 2);
        map.put(GameEvent.A.h(), 2);
        map.put(GameEvent.O.h(), 2);
        map.put(GameEvent.C.h(), 3);
        map.put(GameEvent.K.h(), 3);
        map.put(GameEvent.B.h(), 3);
        map.put(GameEvent.u.h(), 4);
        map.put(GameEvent.n.h(), 4);
        map.put(GameEvent.S.h(), 4);
        map.put(GameEvent.q.h(), 5);
        map.put(GameEvent.v.h(), 5);
        map.put(GameEvent.r.h(), 6);
        map.put(GameEvent.M.h(), 6);
        map.put(GameEvent.s.h(), 6);
        map.put(GameEvent.o.h(), 7);
        map.put(GameEvent.l.h(), 8);
        map.put(GameEvent.m.h(), 8);
        map.put(GameEvent.j.h(), 9);
        map.put(GameEvent.d.h(), 9);
        map.put(GameEvent.e.h(), 9);
        map.put(GameEvent.g.h(), 9);
        map.put(GameEvent.k.h(), 10);
        map.put(GameEvent.h.h(), 10);
        map.put(GameEvent.a.h(), 10);
        map.put(GameEvent.b.h(), 10);
        map.put(GameEvent.I.h(), 10);
        map.put(GameEvent.H.h(), 10);
        map.put(GameEvent.c.h(), 11);
        map.put(GameEvent.f.h(), 12);
        map.put(GameEvent.y.h(), 12);
        map.put(GameEvent.i.h(), 13);
        map.put(GameEvent.z.h(), 13);
        map.put(GameEvent.t.h(), 14);
        map.put(GameEvent.G.h(), 14);
        map.put(GameEvent.R.h(), 14);
        map.put(GameEvent.p.h(), 15);
        map.put(GameEvent.w.h(), 15);
        for (int i2 = 1; i2 <= 15; ++i2) {
            map.put(VibrationSystem.b(i2), i2);
        }
    });

    public a gt();

    public d gu();

    public static int a_(Holder<GameEvent> gameEvent) {
        return gameEvent.e().map(VibrationSystem::a).orElse(0);
    }

    public static int a(ResourceKey<GameEvent> eventKey) {
        return f_.applyAsInt(eventKey);
    }

    public static ResourceKey<GameEvent> b(int frequency) {
        return d_.get(frequency - 1);
    }

    public static int a_(float distance, int maxDistance) {
        double d2 = 15.0 / (double)maxDistance;
        return Math.max(1, 15 - MathHelper.a(d2 * (double)distance));
    }

    public static interface d {
        public int a();

        public PositionSource b();

        public boolean a(WorldServer var1, BlockPosition var2, Holder<GameEvent> var3, GameEvent.a var4);

        public void a(WorldServer var1, BlockPosition var2, Holder<GameEvent> var3, @Nullable net.minecraft.world.entity.Entity var4, @Nullable net.minecraft.world.entity.Entity var5, float var6);

        default public TagKey<GameEvent> c() {
            return GameEventTags.a;
        }

        default public boolean d() {
            return false;
        }

        default public boolean f() {
            return false;
        }

        default public int a(float distance) {
            return MathHelper.d(distance);
        }

        default public boolean a(Holder<GameEvent> gameEvent, GameEvent.a context) {
            if (!gameEvent.a(this.c())) {
                return false;
            }
            net.minecraft.world.entity.Entity entity = context.a();
            if (entity != null) {
                if (entity.Z_()) {
                    return false;
                }
                if (entity.ce() && gameEvent.a(GameEventTags.d)) {
                    if (this.d() && entity instanceof EntityPlayer) {
                        EntityPlayer serverPlayer = (EntityPlayer)entity;
                        CriterionTriggers.ab.a(serverPlayer);
                    }
                    return false;
                }
                if (entity.bh()) {
                    return false;
                }
            }
            return context.b() == null || !context.b().a(TagsBlock.bt);
        }

        default public void e() {
        }
    }

    public static interface c {
        public static void a(World level, a data, d user) {
            if (level instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)level;
                if (data.c == null) {
                    c.a(serverLevel, data, user);
                }
                if (data.c != null) {
                    boolean flag = data.c() > 0;
                    c.b(serverLevel, data, user);
                    data.d();
                    if (data.c() <= 0) {
                        flag = c.a(serverLevel, data, user, data.c);
                    }
                    if (flag) {
                        user.e();
                    }
                }
            }
        }

        private static void a(WorldServer level, a data, d user) {
            data.a().a(level.ad()).ifPresent(vibrationInfo -> {
                data.a((VibrationInfo)vibrationInfo);
                Vec3D vec3 = vibrationInfo.c();
                data.a(user.a(vibrationInfo.b()));
                level.a(new VibrationParticleOption(user.b(), data.c()), vec3.d, vec3.e, vec3.f, 1, 0.0, 0.0, 0.0, 0.0);
                user.e();
                data.a().a();
            });
        }

        private static void b(WorldServer level, a data, d user) {
            if (data.e()) {
                if (data.c == null) {
                    data.a(false);
                } else {
                    double d3;
                    double d2;
                    int i2;
                    double d4;
                    double d1;
                    boolean flag;
                    Vec3D vec3 = data.c.c();
                    PositionSource positionSource = user.b();
                    Vec3D vec31 = positionSource.a(level).orElse(vec3);
                    int travelTimeInTicks = data.c();
                    boolean bl = flag = level.a(new VibrationParticleOption(positionSource, travelTimeInTicks), d1 = MathHelper.d(d4 = 1.0 - (double)travelTimeInTicks / (double)(i2 = user.a(data.c.b())), vec3.d, vec31.d), d2 = MathHelper.d(d4, vec3.e, vec31.e), d3 = MathHelper.d(d4, vec3.f, vec31.f), 1, 0.0, 0.0, 0.0, 0.0) > 0;
                    if (flag) {
                        data.a(false);
                    }
                }
            }
        }

        private static boolean a(WorldServer level, a data, d user, VibrationInfo vibrationInfo) {
            BlockPosition blockPos = BlockPosition.a(vibrationInfo.c());
            BlockPosition blockPos1 = user.b().a(level).map(BlockPosition::a).orElse(blockPos);
            if (user.f() && !c.a(level, blockPos1)) {
                return false;
            }
            user.a(level, blockPos, vibrationInfo.a(), vibrationInfo.a(level).orElse(null), vibrationInfo.b(level).orElse(null), b.a(blockPos, blockPos1));
            data.a(null);
            return true;
        }

        private static boolean a(World level, BlockPosition pos) {
            ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(pos);
            for (int i2 = chunkPos.h - 1; i2 <= chunkPos.h + 1; ++i2) {
                for (int i1 = chunkPos.i - 1; i1 <= chunkPos.i + 1; ++i1) {
                    if (level.a(ChunkCoordIntPair.c(i2, i1)) && level.S().a(i2, i1) != null) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static class b
    implements GameEventListener {
        private final VibrationSystem a;

        public b(VibrationSystem system) {
            this.a = system;
        }

        @Override
        public PositionSource a() {
            return this.a.gu().b();
        }

        @Override
        public int b() {
            return this.a.gu().a();
        }

        @Override
        public boolean a(WorldServer level, Holder<GameEvent> gameEvent, GameEvent.a context, Vec3D pos) {
            a vibrationData = this.a.gt();
            d vibrationUser = this.a.gu();
            if (vibrationData.b() != null) {
                return false;
            }
            if (!vibrationUser.a(gameEvent, context)) {
                return false;
            }
            Optional<Vec3D> position = vibrationUser.b().a(level);
            if (position.isEmpty()) {
                return false;
            }
            Vec3D vec3 = position.get();
            boolean defaultCancel = !vibrationUser.a(level, BlockPosition.a(pos), gameEvent, context);
            net.minecraft.world.entity.Entity entity = context.a();
            BlockReceiveGameEvent event1 = new BlockReceiveGameEvent(CraftGameEvent.minecraftToBukkit(gameEvent.a()), (Block)CraftBlock.at(level, BlockPosition.a(vec3)), (Entity)(entity == null ? null : entity.getBukkitEntity()));
            event1.setCancelled(defaultCancel);
            level.getCraftServer().getPluginManager().callEvent((Event)event1);
            if (event1.isCancelled()) {
                return false;
            }
            if (b.a(level, pos, vec3)) {
                return false;
            }
            this.a(level, vibrationData, gameEvent, context, pos, vec3);
            return true;
        }

        public void b(WorldServer level, Holder<GameEvent> gameEvent, GameEvent.a context, Vec3D pos) {
            this.a.gu().b().a(level).ifPresent(vec3 -> this.a(level, this.a.gt(), gameEvent, context, pos, (Vec3D)vec3));
        }

        private void a(WorldServer level, a data, Holder<GameEvent> gameEvent, GameEvent.a context, Vec3D pos, Vec3D sensorPos) {
            data.e.a(new VibrationInfo(gameEvent, (float)pos.f(sensorPos), pos, context.a()), level.ad());
        }

        public static float a(BlockPosition pos1, BlockPosition pos2) {
            return (float)Math.sqrt(pos1.j(pos2));
        }

        private static boolean a(World level, Vec3D eventPos, Vec3D vibrationUserPos) {
            Vec3D vec3 = new Vec3D((double)MathHelper.a(eventPos.d) + 0.5, (double)MathHelper.a(eventPos.e) + 0.5, (double)MathHelper.a(eventPos.f) + 0.5);
            Vec3D vec31 = new Vec3D((double)MathHelper.a(vibrationUserPos.d) + 0.5, (double)MathHelper.a(vibrationUserPos.e) + 0.5, (double)MathHelper.a(vibrationUserPos.f) + 0.5);
            for (EnumDirection direction : EnumDirection.values()) {
                Vec3D vec32 = vec3.a(direction, (double)1.0E-5f);
                if (level.a(new ClipBlockStateContext(vec32, vec31, state -> state.a(TagsBlock.bs))).d() == MovingObjectPosition.EnumMovingObjectType.b) continue;
                return false;
            }
            return true;
        }
    }

    public static final class a {
        public static Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)VibrationInfo.a.lenientOptionalFieldOf("event").forGetter(data -> Optional.ofNullable(data.c)), (App)VibrationSelector.a.optionalFieldOf("selector").xmap(o2 -> o2.orElseGet(VibrationSelector::new), Optional::of).forGetter(a::a), (App)ExtraCodecs.l.fieldOf("event_delay").orElse((Object)0).forGetter(a::c)).apply((Applicative)instance, (vibrationInfo, vibrationSelector, eventDelay) -> new a(vibrationInfo.orElse(null), (VibrationSelector)vibrationSelector, (int)eventDelay, true)));
        public static final String b = "listener";
        @Nullable
        VibrationInfo c;
        private int d;
        final VibrationSelector e;
        private boolean f;

        private a(@Nullable VibrationInfo currentVibration, VibrationSelector selectionStrategy, int travelTimeInTicks, boolean reloadVibrationParticle) {
            this.c = currentVibration;
            this.d = travelTimeInTicks;
            this.e = selectionStrategy;
            this.f = reloadVibrationParticle;
        }

        public a() {
            this(null, new VibrationSelector(), 0, false);
        }

        public VibrationSelector a() {
            return this.e;
        }

        @Nullable
        public VibrationInfo b() {
            return this.c;
        }

        public void a(@Nullable VibrationInfo currentVibration) {
            this.c = currentVibration;
        }

        public int c() {
            return this.d;
        }

        public void a(int travelTimeInTicks) {
            this.d = travelTimeInTicks;
        }

        public void d() {
            this.d = Math.max(0, this.d - 1);
        }

        public boolean e() {
            return this.f;
        }

        public void a(boolean reloadVibrationParticle) {
            this.f = reloadVibrationParticle;
        }
    }
}

