/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Path;
import java.util.Optional;
import java.util.OptionalLong;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;

public final class DimensionManager
extends Record {
    private final OptionalLong m;
    private final boolean n;
    private final boolean o;
    private final boolean p;
    private final boolean q;
    private final double r;
    private final boolean s;
    private final boolean t;
    private final int u;
    private final int v;
    private final int w;
    private final TagKey<Block> x;
    private final MinecraftKey y;
    private final float z;
    private final a A;
    public static final int a = 12;
    public static final int b = 16;
    public static final int c = 4064;
    public static final int d = 2031;
    public static final int e = -2032;
    public static final int f = 32496;
    public static final int g = -32512;
    public static final Codec<DimensionManager> h = ExtraCodecs.e(RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.a((MapCodec<Optional<Long>>)Codec.LONG.lenientOptionalFieldOf("fixed_time")).forGetter(DimensionManager::f), (App)Codec.BOOL.fieldOf("has_skylight").forGetter(DimensionManager::g), (App)Codec.BOOL.fieldOf("has_ceiling").forGetter(DimensionManager::h), (App)Codec.BOOL.fieldOf("ultrawarm").forGetter(DimensionManager::i), (App)Codec.BOOL.fieldOf("natural").forGetter(DimensionManager::j), (App)Codec.doubleRange((double)1.0E-5f, (double)3.0E7).fieldOf("coordinate_scale").forGetter(DimensionManager::k), (App)Codec.BOOL.fieldOf("bed_works").forGetter(DimensionManager::l), (App)Codec.BOOL.fieldOf("respawn_anchor_works").forGetter(DimensionManager::m), (App)Codec.intRange((int)-2032, (int)2031).fieldOf("min_y").forGetter(DimensionManager::n), (App)Codec.intRange((int)16, (int)4064).fieldOf("height").forGetter(DimensionManager::o), (App)Codec.intRange((int)0, (int)4064).fieldOf("logical_height").forGetter(DimensionManager::p), (App)TagKey.b(Registries.f).fieldOf("infiniburn").forGetter(DimensionManager::q), (App)MinecraftKey.a.fieldOf("effects").orElse((Object)BuiltinDimensionTypes.e).forGetter(DimensionManager::r), (App)Codec.FLOAT.fieldOf("ambient_light").forGetter(DimensionManager::s), (App)net.minecraft.world.level.dimension.DimensionManager$a.a.forGetter(DimensionManager::t)).apply((Applicative)instance, DimensionManager::new)));
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<DimensionManager>> i = ByteBufCodecs.b(Registries.aN);
    public static final int j = 8;
    public static final float[] k = new float[]{1.0f, 0.75f, 0.5f, 0.25f, 0.0f, 0.25f, 0.5f, 0.75f};
    public static final Codec<Holder<DimensionManager>> l = RegistryFileCodec.a(Registries.aN, h);

    public DimensionManager(OptionalLong fixedTime, boolean hasSkyLight, boolean hasCeiling, boolean ultraWarm, boolean natural, double coordinateScale, boolean bedWorks, boolean respawnAnchorWorks, int minY, int height, int logicalHeight, TagKey<Block> infiniburn, MinecraftKey effectsLocation, float ambientLight, a monsterSettings) {
        if (height < 16) {
            throw new IllegalStateException("height has to be at least 16");
        }
        if (minY + height > 2032) {
            throw new IllegalStateException("min_y + height cannot be higher than: 2032");
        }
        if (logicalHeight > height) {
            throw new IllegalStateException("logical_height cannot be higher than height");
        }
        if (height % 16 != 0) {
            throw new IllegalStateException("height has to be multiple of 16");
        }
        if (minY % 16 != 0) {
            throw new IllegalStateException("min_y has to be a multiple of 16");
        }
        this.m = fixedTime;
        this.n = hasSkyLight;
        this.o = hasCeiling;
        this.p = ultraWarm;
        this.q = natural;
        this.r = coordinateScale;
        this.s = bedWorks;
        this.t = respawnAnchorWorks;
        this.u = minY;
        this.v = height;
        this.w = logicalHeight;
        this.x = infiniburn;
        this.y = effectsLocation;
        this.z = ambientLight;
        this.A = monsterSettings;
    }

    @Deprecated
    public static DataResult<ResourceKey<World>> a(Dynamic<?> dynamic) {
        Optional optional = dynamic.asNumber().result();
        if (optional.isPresent()) {
            int i2 = ((Number)optional.get()).intValue();
            if (i2 == -1) {
                return DataResult.success(World.j);
            }
            if (i2 == 0) {
                return DataResult.success(World.i);
            }
            if (i2 == 1) {
                return DataResult.success(World.k);
            }
        }
        return World.h.parse(dynamic);
    }

    public static double a(DimensionManager firstType, DimensionManager secondType) {
        double coordinateScale = firstType.k();
        double coordinateScale1 = secondType.k();
        return coordinateScale / coordinateScale1;
    }

    public static Path a(ResourceKey<World> dimensionKey, Path levelFolder) {
        if (dimensionKey == World.i) {
            return levelFolder;
        }
        if (dimensionKey == World.k) {
            return levelFolder.resolve("DIM1");
        }
        return dimensionKey == World.j ? levelFolder.resolve("DIM-1") : levelFolder.resolve("dimensions").resolve(dimensionKey.a().b()).resolve(dimensionKey.a().a());
    }

    public boolean a() {
        return this.m.isPresent();
    }

    public float a(long dayTime) {
        double fraction = MathHelper.e((double)this.m.orElse(dayTime) / 24000.0 - 0.25);
        double d2 = 0.5 - Math.cos(fraction * Math.PI) / 2.0;
        return (float)(fraction * 2.0 + d2) / 3.0f;
    }

    public int b(long dayTime) {
        return (int)(dayTime / 24000L % 8L + 8L) % 8;
    }

    public boolean b() {
        return this.A.a();
    }

    public boolean c() {
        return this.A.b();
    }

    public IntProvider d() {
        return this.A.c();
    }

    public int e() {
        return this.A.d();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{DimensionManager.class, "fixedTime;hasSkyLight;hasCeiling;ultraWarm;natural;coordinateScale;bedWorks;respawnAnchorWorks;minY;height;logicalHeight;infiniburn;effectsLocation;ambientLight;monsterSettings", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DimensionManager.class, "fixedTime;hasSkyLight;hasCeiling;ultraWarm;natural;coordinateScale;bedWorks;respawnAnchorWorks;minY;height;logicalHeight;infiniburn;effectsLocation;ambientLight;monsterSettings", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DimensionManager.class, "fixedTime;hasSkyLight;hasCeiling;ultraWarm;natural;coordinateScale;bedWorks;respawnAnchorWorks;minY;height;logicalHeight;infiniburn;effectsLocation;ambientLight;monsterSettings", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A"}, this, o2);
    }

    public OptionalLong f() {
        return this.m;
    }

    public boolean g() {
        return this.n;
    }

    public boolean h() {
        return this.o;
    }

    public boolean i() {
        return this.p;
    }

    public boolean j() {
        return this.q;
    }

    public double k() {
        return this.r;
    }

    public boolean l() {
        return this.s;
    }

    public boolean m() {
        return this.t;
    }

    public int n() {
        return this.u;
    }

    public int o() {
        return this.v;
    }

    public int p() {
        return this.w;
    }

    public TagKey<Block> q() {
        return this.x;
    }

    public MinecraftKey r() {
        return this.y;
    }

    public float s() {
        return this.z;
    }

    public a t() {
        return this.A;
    }

    public static final class a
    extends Record {
        private final boolean b;
        private final boolean c;
        private final IntProvider d;
        private final int e;
        public static final MapCodec<a> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("piglin_safe").forGetter(a::a), (App)Codec.BOOL.fieldOf("has_raids").forGetter(a::b), (App)IntProvider.b(0, 15).fieldOf("monster_spawn_light_level").forGetter(a::c), (App)Codec.intRange((int)0, (int)15).fieldOf("monster_spawn_block_light_limit").forGetter(a::d)).apply((Applicative)instance, a::new));

        public a(boolean piglinSafe, boolean hasRaids, IntProvider monsterSpawnLightTest, int monsterSpawnBlockLightLimit) {
            this.b = piglinSafe;
            this.c = hasRaids;
            this.d = monsterSpawnLightTest;
            this.e = monsterSpawnBlockLightLimit;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "piglinSafe;hasRaids;monsterSpawnLightTest;monsterSpawnBlockLightLimit", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "piglinSafe;hasRaids;monsterSpawnLightTest;monsterSpawnBlockLightLimit", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "piglinSafe;hasRaids;monsterSpawnLightTest;monsterSpawnBlockLightLimit", "b", "c", "d", "e"}, this, o2);
        }

        public boolean a() {
            return this.b;
        }

        public boolean b() {
            return this.c;
        }

        public IntProvider c() {
            return this.d;
        }

        public int d() {
            return this.e;
        }
    }
}

