/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.moonrise.common.util.MixinWorkarounds;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.starlight.light.SWMRNibbleArray;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightEngine;
import ca.spottedleaf.moonrise.patches.starlight.storage.StarlightSectionData;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.Optionull;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NbtException;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTickList;
import net.minecraft.world.ticks.TickListChunk;
import org.slf4j.Logger;

public final class SerializableChunkData
extends Record {
    private final IRegistry<BiomeBase> h;
    private final ChunkCoordIntPair i;
    private final int j;
    private final long k;
    private final long l;
    private final ChunkStatus m;
    @Nullable
    private final BlendingData.d n;
    @Nullable
    private final BelowZeroRetrogen o;
    private final ChunkConverter p;
    @Nullable
    private final long[] q;
    private final Map<HeightMap.Type, long[]> r;
    private final IChunkAccess.a s;
    private final ShortList[] t;
    private final boolean u;
    private final List<b> v;
    private final List<NBTTagCompound> w;
    private final List<NBTTagCompound> x;
    private final NBTTagCompound y;
    @Nullable
    private final NBTBase persistentDataContainer;
    public static final Codec<DataPaletteBlock<IBlockData>> z = DataPaletteBlock.codecRW(Block.q, IBlockData.a, DataPaletteBlock.d.d, Blocks.a.m(), null);
    private static final Logger A = LogUtils.getLogger();
    private static final String B = "UpgradeData";
    private static final String C = "block_ticks";
    private static final String D = "fluid_ticks";
    public static final String a = "xPos";
    public static final String b = "zPos";
    public static final String c = "Heightmaps";
    public static final String d = "isLightOn";
    public static final String e = "sections";
    public static final String f = "BlockLight";
    public static final String g = "SkyLight";
    private static final int CURRENT_DATA_VERSION = SharedConstants.b().d().c();
    private static final boolean JUST_CORRUPT_IT = Boolean.getBoolean("Paper.ignoreWorldDataVersion");

    public SerializableChunkData(IRegistry<BiomeBase> biomeRegistry, ChunkCoordIntPair chunkPos, int minSectionY, long lastUpdateTime, long inhabitedTime, ChunkStatus chunkStatus, @Nullable BlendingData.d blendingData, @Nullable BelowZeroRetrogen belowZeroRetrogen, ChunkConverter upgradeData, @Nullable long[] carvingMask, Map<HeightMap.Type, long[]> heightmaps, IChunkAccess.a packedTicks, ShortList[] postProcessingSections, boolean lightCorrect, List<b> sectionData, List<NBTTagCompound> entities, List<NBTTagCompound> blockEntities, NBTTagCompound structureData, @Nullable NBTBase persistentDataContainer) {
        this.h = biomeRegistry;
        this.i = chunkPos;
        this.j = minSectionY;
        this.k = lastUpdateTime;
        this.l = inhabitedTime;
        this.m = chunkStatus;
        this.n = blendingData;
        this.o = belowZeroRetrogen;
        this.p = upgradeData;
        this.q = carvingMask;
        this.r = heightmaps;
        this.s = packedTicks;
        this.t = postProcessingSections;
        this.u = lightCorrect;
        this.v = sectionData;
        this.w = entities;
        this.x = blockEntities;
        this.y = structureData;
        this.persistentDataContainer = persistentDataContainer;
    }

    public static ChunkCoordIntPair getChunkCoordinate(NBTTagCompound chunkData) {
        int dataVersion = IChunkLoader.a(chunkData);
        if (dataVersion < 2842) {
            NBTTagCompound levelData = chunkData.p("Level");
            return new ChunkCoordIntPair(levelData.h(a), levelData.h(b));
        }
        return new ChunkCoordIntPair(chunkData.h(a), chunkData.h(b));
    }

    public static long getLastWorldSaveTime(NBTTagCompound chunkData) {
        int dataVersion = IChunkLoader.a(chunkData);
        if (dataVersion < 2842) {
            NBTTagCompound levelData = chunkData.p("Level");
            return levelData.i("LastUpdate");
        }
        return chunkData.i("LastUpdate");
    }

    @Nullable
    public static SerializableChunkData a(LevelHeightAccessor levelHeightAccessor, IRegistryCustom registries, NBTTagCompound tag) {
        boolean _boolean;
        WorldServer serverLevel = (WorldServer)levelHeightAccessor;
        if (!tag.b("Status", 8)) {
            return null;
        }
        if (tag.b("DataVersion", 99)) {
            int dataVersion = tag.h("DataVersion");
            if (!JUST_CORRUPT_IT && dataVersion > CURRENT_DATA_VERSION) {
                new RuntimeException("Server attempted to load chunk saved with newer version of minecraft! " + dataVersion + " > " + CURRENT_DATA_VERSION).printStackTrace();
                System.exit(1);
            }
        }
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(tag.h(a), tag.h(b));
        long _long = tag.i("LastUpdate");
        long _long1 = tag.i("InhabitedTime");
        ChunkStatus chunkStatus = ChunkStatus.a(tag.l("Status"));
        ChunkConverter upgradeData = tag.b(B, 10) ? new ChunkConverter(tag.p(B), levelHeightAccessor) : ChunkConverter.a;
        boolean bl = _boolean = chunkStatus.a(ChunkStatus.l) && tag.c(d) != null && tag.h("starlight.light_version") == 9;
        BlendingData.d packed = tag.b("blending_data", 10) ? (BlendingData.d)BlendingData.d.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)tag.p("blending_data")).resultOrPartial(arg_0 -> ((Logger)A).error(arg_0)).orElse(null) : null;
        BelowZeroRetrogen belowZeroRetrogen = tag.b("below_zero_retrogen", 10) ? (BelowZeroRetrogen)BelowZeroRetrogen.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)tag.p("below_zero_retrogen")).resultOrPartial(arg_0 -> ((Logger)A).error(arg_0)).orElse(null) : null;
        long[] longArray = tag.b("carving_mask", 12) ? tag.o("carving_mask") : null;
        NBTTagCompound compound = tag.p(c);
        EnumMap<HeightMap.Type, long[]> map = new EnumMap<HeightMap.Type, long[]>(HeightMap.Type.class);
        for (HeightMap.Type types : chunkStatus.e()) {
            String serializationKey = types.a();
            if (!compound.b(serializationKey, 12)) continue;
            map.put(types, compound.o(serializationKey));
        }
        List<TickListChunk<Block>> list = TickListChunk.a(tag.c(C, 10), (String string) -> BuiltInRegistries.e.b(MinecraftKey.c(string)), chunkPos);
        List<TickListChunk<FluidType>> list1 = TickListChunk.a(tag.c(D, 10), (String string) -> BuiltInRegistries.c.b(MinecraftKey.c(string)), chunkPos);
        IChunkAccess.a packedTicks = new IChunkAccess.a(list, list1);
        NBTTagList list2 = tag.c("PostProcessing", 9);
        ShortList[] lists = new ShortList[list2.size()];
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            NBTTagList list3 = list2.b(i2);
            ShortArrayList list4 = new ShortArrayList(list3.size());
            for (int i1 = 0; i1 < list3.size(); ++i1) {
                list4.add(list3.d(i1));
            }
            lists[i2] = list4;
        }
        List list5 = Lists.transform((List)tag.c("entities", 10), tag1 -> (NBTTagCompound)tag1);
        List list6 = Lists.transform((List)tag.c("block_entities", 10), tag1 -> (NBTTagCompound)tag1);
        NBTTagCompound compound1 = tag.p("structures");
        NBTTagList list7 = tag.c(e, 10);
        ArrayList<b> list8 = new ArrayList<b>(list7.size());
        IRegistry<BiomeBase> registry = registries.e(Registries.aI);
        Codec<DataPaletteBlock<Holder<BiomeBase>>> codec = SerializableChunkData.makeBiomeCodecRW(registry);
        for (int i2 = 0; i2 < list7.size(); ++i2) {
            ChunkSection levelChunkSection;
            NBTTagCompound compound2;
            NBTTagCompound sectionData = compound2 = list7.a(i2);
            byte _byte = compound2.f("Y");
            if (_byte >= levelHeightAccessor.ap() && _byte <= levelHeightAccessor.aq()) {
                DataPaletteBlock palettedContainer;
                IBlockData[] presetBlockStates = serverLevel.chunkPacketBlockController.getPresetBlockStates(serverLevel, chunkPos, _byte);
                if (compound2.b("block_states", 10)) {
                    Codec<DataPaletteBlock<IBlockData>> blockStateCodec = presetBlockStates == null ? z : DataPaletteBlock.codecRW(Block.q, IBlockData.a, DataPaletteBlock.d.d, Blocks.a.m(), presetBlockStates);
                    palettedContainer = (DataPaletteBlock)blockStateCodec.parse((DynamicOps)DynamicOpsNBT.a, (Object)sectionData.p("block_states")).promotePartial(string -> SerializableChunkData.a(chunkPos, _byte, string)).getOrThrow(a::new);
                } else {
                    palettedContainer = new DataPaletteBlock(Block.q, Blocks.a.m(), DataPaletteBlock.d.d, presetBlockStates);
                }
                DataPaletteBlock palettedContainerRo = compound2.b("biomes", 10) ? (DataPaletteBlock)codec.parse((DynamicOps)DynamicOpsNBT.a, (Object)compound2.p("biomes")).promotePartial(string -> SerializableChunkData.a(chunkPos, _byte, string)).getOrThrow(a::new) : new DataPaletteBlock(registry.t(), registry.b(Biomes.b), DataPaletteBlock.d.e, null);
                levelChunkSection = new ChunkSection(palettedContainer, palettedContainerRo);
            } else {
                levelChunkSection = null;
            }
            NibbleArray dataLayer = compound2.b(f, 7) ? new NibbleArray(compound2.m(f)) : null;
            NibbleArray dataLayer1 = compound2.b(g, 7) ? new NibbleArray(compound2.m(g)) : null;
            b serializableChunkData = new b(_byte, levelChunkSection, dataLayer, dataLayer1);
            if (sectionData.b("starlight.blocklight_state", 99)) {
                ((StarlightSectionData)serializableChunkData).starlight$setBlockLightState(sectionData.h("starlight.blocklight_state"));
            }
            if (sectionData.b("starlight.skylight_state", 99)) {
                ((StarlightSectionData)serializableChunkData).starlight$setSkyLightState(sectionData.h("starlight.skylight_state"));
            }
            list8.add(serializableChunkData);
        }
        return new SerializableChunkData(registry, chunkPos, levelHeightAccessor.ap(), _long, _long1, chunkStatus, packed, belowZeroRetrogen, upgradeData, longArray, map, packedTicks, lists, _boolean, list8, list5, list6, compound1, tag.c("ChunkBukkitValues"));
    }

    private ProtoChunk loadStarlightLightData(WorldServer world, ProtoChunk ret) {
        boolean hasSkyLight = world.G_().g();
        int minSection = WorldUtil.getMinLightSection(world);
        SWMRNibbleArray[] blockNibbles = StarLightEngine.getFilledEmptyLight(world);
        SWMRNibbleArray[] skyNibbles = StarLightEngine.getFilledEmptyLight(world);
        if (!this.u) {
            ret.starlight$setBlockNibbles(blockNibbles);
            ret.starlight$setSkyNibbles(skyNibbles);
            return ret;
        }
        try {
            for (b sectionData : this.v) {
                int y2 = sectionData.a();
                NibbleArray blockLight = sectionData.c();
                NibbleArray skyLight = sectionData.d();
                int blockState = ((StarlightSectionData)sectionData).starlight$getBlockLightState();
                int skyState = ((StarlightSectionData)sectionData).starlight$getSkyLightState();
                if (blockState >= 0) {
                    blockNibbles[y2 - minSection] = blockLight != null ? new SWMRNibbleArray(MixinWorkarounds.clone(blockLight.a()), blockState) : new SWMRNibbleArray(null, blockState);
                }
                if (skyState < 0 || !hasSkyLight) continue;
                if (skyLight != null) {
                    skyNibbles[y2 - minSection] = new SWMRNibbleArray(MixinWorkarounds.clone(skyLight.a()), skyState);
                    continue;
                }
                skyNibbles[y2 - minSection] = new SWMRNibbleArray(null, skyState);
            }
            ret.starlight$setBlockNibbles(blockNibbles);
            ret.starlight$setSkyNibbles(skyNibbles);
        }
        catch (Throwable thr) {
            ret.a(false);
            A.error("Failed to parse light data for chunk " + String.valueOf(ret.f()) + " in world '" + WorldUtil.getWorldName(world) + "'", thr);
        }
        return ret;
    }

    public ProtoChunk a(WorldServer level, VillagePlace poiManager, RegionStorageInfo regionStorageInfo, ChunkCoordIntPair pos) {
        Iterator protoChunkTicks1;
        IChunkAccess chunkAccess;
        if (!Objects.equals(pos, this.i)) {
            A.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", new Object[]{pos, pos, this.i});
            level.p().a(this.i, pos, regionStorageInfo);
        }
        int sectionsCount = level.ao();
        ChunkSection[] levelChunkSections = new ChunkSection[sectionsCount];
        boolean hasSkyLight = level.G_().g();
        ChunkProviderServer chunkSource = level.m();
        LevelLightEngine lightEngine = ((IChunkProvider)chunkSource).p();
        IRegistry<BiomeBase> registry = level.K_().e(Registries.aI);
        boolean flag = false;
        for (b sectionData : this.v) {
            boolean flag2;
            SectionPosition sectionPos = SectionPosition.a(pos, sectionData.a);
            if (sectionData.b != null) {
                levelChunkSections[level.g((int)sectionData.a)] = sectionData.b;
            }
            boolean flag1 = sectionData.c != null;
            boolean bl = flag2 = hasSkyLight && sectionData.d != null;
            if (!flag1 && !flag2) continue;
            if (!flag) {
                lightEngine.b(pos, true);
                flag = true;
            }
            if (flag1) {
                lightEngine.a(EnumSkyBlock.b, sectionPos, sectionData.c);
            }
            if (!flag2) continue;
            lightEngine.a(EnumSkyBlock.a, sectionPos, sectionData.d);
        }
        ChunkType chunkType = this.m.d();
        if (chunkType == ChunkType.b) {
            LevelChunkTicks<Block> levelChunkTicks = new LevelChunkTicks<Block>(this.s.a());
            LevelChunkTicks<FluidType> levelChunkTicks1 = new LevelChunkTicks<FluidType>(this.s.b());
            chunkAccess = new Chunk(level.a(), pos, this.p, levelChunkTicks, levelChunkTicks1, this.l, levelChunkSections, SerializableChunkData.a(level, this.w, this.x), BlendingData.a(this.n));
        } else {
            ProtoChunkTickList<Block> protoChunkTicks = ProtoChunkTickList.a(this.s.a());
            protoChunkTicks1 = ProtoChunkTickList.a(this.s.b());
            ProtoChunk protoChunk = new ProtoChunk(pos, this.p, levelChunkSections, protoChunkTicks, (ProtoChunkTickList<FluidType>)((Object)protoChunkTicks1), level, registry, BlendingData.a(this.n));
            chunkAccess = protoChunk;
            protoChunk.c(this.l);
            if (this.o != null) {
                protoChunk.a(this.o);
            }
            protoChunk.a(this.m);
            if (this.m.a(ChunkStatus.k)) {
                protoChunk.a(lightEngine);
            }
        }
        protoChunkTicks1 = this.persistentDataContainer;
        if (protoChunkTicks1 instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)((Object)protoChunkTicks1);
            chunkAccess.persistentDataContainer.putAll(compoundTag);
        }
        chunkAccess.a(this.u);
        EnumSet<HeightMap.Type> set = EnumSet.noneOf(HeightMap.Type.class);
        for (HeightMap.Type types : chunkAccess.n().e()) {
            long[] longs = this.r.get(types);
            if (longs != null) {
                chunkAccess.a(types, longs);
                continue;
            }
            set.add(types);
        }
        HeightMap.a(chunkAccess, set);
        chunkAccess.a(SerializableChunkData.a(StructurePieceSerializationContext.a(level), this.y, level.E()));
        chunkAccess.b(SerializableChunkData.a(level.K_(), pos, this.y));
        for (int i2 = 0; i2 < this.t.length; ++i2) {
            chunkAccess.a(this.t[i2], i2);
        }
        if (chunkType == ChunkType.b) {
            return this.loadStarlightLightData(level, new ProtoChunkExtension((Chunk)chunkAccess, false));
        }
        ProtoChunk protoChunk1 = (ProtoChunk)chunkAccess;
        for (NBTTagCompound compoundTag : this.w) {
            protoChunk1.b(compoundTag);
        }
        for (NBTTagCompound compoundTag : this.x) {
            BlockPosition blockposition = TileEntity.b(compoundTag);
            if (blockposition.u() >> 4 != this.i.h || blockposition.w() >> 4 != this.i.i) {
                A.warn("Tile entity serialized in chunk {} in world '{}' positioned at {} is located outside of the chunk", new Object[]{this.i, level.getWorld().getName(), blockposition});
                continue;
            }
            protoChunk1.a(compoundTag);
        }
        if (this.q != null) {
            protoChunk1.a(new CarvingMask(this.q, chunkAccess.L_()));
        }
        return this.loadStarlightLightData(level, protoChunk1);
    }

    private static void a(ChunkCoordIntPair chunkPos, int sectionY, String error) {
        A.error("Recoverable errors when loading section [{}, {}, {}]: {}", new Object[]{chunkPos.h, sectionY, chunkPos.i, error});
    }

    private static Codec<PalettedContainerRO<Holder<BiomeBase>>> a(IRegistry<BiomeBase> biomeRegistry) {
        return DataPaletteBlock.b(biomeRegistry.t(), biomeRegistry.r(), DataPaletteBlock.d.e, biomeRegistry.b(Biomes.b));
    }

    private static Codec<DataPaletteBlock<Holder<BiomeBase>>> makeBiomeCodecRW(IRegistry<BiomeBase> biomeRegistry) {
        return DataPaletteBlock.codecRW(biomeRegistry.t(), biomeRegistry.r(), DataPaletteBlock.d.e, biomeRegistry.b(Biomes.b), null);
    }

    public static SerializableChunkData a(WorldServer level, IChunkAccess chunk) {
        ArrayList<b> list;
        if (!chunk.s()) {
            throw new IllegalArgumentException("Chunk can't be serialized: " + String.valueOf(chunk));
        }
        ChunkCoordIntPair pos = chunk.f();
        ArrayList<b> sectionsList = list = new ArrayList<b>();
        ChunkSection[] sections = chunk.d();
        LightEngineThreaded lightEngine = level.m().a();
        int minLightSection = WorldUtil.getMinLightSection(level);
        int maxLightSection = WorldUtil.getMaxLightSection(level);
        int minBlockSection = WorldUtil.getMinSection(level);
        ChunkSection[] chunkSections = chunk.d();
        SWMRNibbleArray[] blockNibbles = chunk.starlight$getBlockNibbles();
        SWMRNibbleArray[] skyNibbles = chunk.starlight$getSkyNibbles();
        for (int lightSection = minLightSection; lightSection <= maxLightSection; ++lightSection) {
            int lightSectionIdx = lightSection - minLightSection;
            int blockSectionIdx = lightSection - minBlockSection;
            ChunkSection chunkSection = blockSectionIdx >= 0 && blockSectionIdx < chunkSections.length ? chunkSections[blockSectionIdx].k() : null;
            SWMRNibbleArray.SaveState blockNibble = blockNibbles[lightSectionIdx].getSaveState();
            SWMRNibbleArray.SaveState saveState = skyNibbles[lightSectionIdx].getSaveState();
            if (chunkSection == null && blockNibble == null && saveState == null) continue;
            b sectionData = new b(lightSection, chunkSection, blockNibble == null ? null : (blockNibble.data == null ? null : new NibbleArray(blockNibble.data)), saveState == null ? null : (saveState.data == null ? null : new NibbleArray(saveState.data)));
            if (blockNibble != null) {
                ((StarlightSectionData)sectionData).starlight$setBlockLightState(blockNibble.state);
            }
            if (saveState != null) {
                ((StarlightSectionData)sectionData).starlight$setSkyLightState(saveState.state);
            }
            sectionsList.add(sectionData);
        }
        ArrayList<NBTTagCompound> list1 = new ArrayList<NBTTagCompound>(chunk.c().size());
        for (BlockPosition blockPos : chunk.c()) {
            NBTTagCompound blockEntityNbtForSaving = chunk.a(blockPos, level.K_());
            if (blockEntityNbtForSaving == null) continue;
            list1.add(blockEntityNbtForSaving);
        }
        ArrayList<NBTTagCompound> list2 = new ArrayList<NBTTagCompound>();
        long[] longs = null;
        if (chunk.n().d() == ChunkType.a) {
            ProtoChunk protoChunk = (ProtoChunk)chunk;
            list2.addAll(protoChunk.I());
            CarvingMask carvingMask = protoChunk.E();
            if (carvingMask != null) {
                longs = carvingMask.a();
            }
        }
        EnumMap<HeightMap.Type, long[]> map = new EnumMap<HeightMap.Type, long[]>(HeightMap.Type.class);
        for (Map.Entry entry : chunk.e()) {
            if (!chunk.n().e().contains(entry.getKey())) continue;
            long[] rawData = ((HeightMap)entry.getValue()).a();
            map.put((HeightMap.Type)entry.getKey(), (long[])rawData.clone());
        }
        IChunkAccess.a ticksForSerialization = chunk.a(level.ad());
        ShortList[] shortListArray = (ShortList[])Arrays.stream(chunk.p()).map(list3 -> list3 != null ? new ShortArrayList(list3) : null).toArray(ShortList[]::new);
        NBTTagCompound compoundTag = SerializableChunkData.a(StructurePieceSerializationContext.a(level), pos, chunk.g(), chunk.h());
        NBTTagCompound persistentDataContainer = null;
        if (!chunk.persistentDataContainer.isEmpty()) {
            persistentDataContainer = chunk.persistentDataContainer.toTagCompound();
        }
        return new SerializableChunkData(level.K_().e(Registries.aI), pos, chunk.ap(), level.ad(), chunk.w(), chunk.n(), Optionull.a(chunk.v(), BlendingData::a), chunk.z(), chunk.t().c(), longs, map, ticksForSerialization, shortListArray, chunk.x(), list, list2, list1, compoundTag, persistentDataContainer);
    }

    public NBTTagCompound a() {
        NBTTagCompound compoundTag = GameProfileSerializer.e(new NBTTagCompound());
        compoundTag.a(a, this.i.h);
        compoundTag.a("yPos", this.j);
        compoundTag.a(b, this.i.i);
        compoundTag.a("LastUpdate", this.k);
        compoundTag.a("InhabitedTime", this.l);
        compoundTag.a("Status", BuiltInRegistries.l.b(this.m).toString());
        if (this.n != null) {
            BlendingData.d.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.n).resultOrPartial(arg_0 -> ((Logger)A).error(arg_0)).ifPresent(tag -> compoundTag.a("blending_data", (NBTBase)tag));
        }
        if (this.o != null) {
            BelowZeroRetrogen.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.o).resultOrPartial(arg_0 -> ((Logger)A).error(arg_0)).ifPresent(tag -> compoundTag.a("below_zero_retrogen", (NBTBase)tag));
        }
        if (!this.p.a()) {
            compoundTag.a(B, this.p.b());
        }
        NBTTagList listTag = new NBTTagList();
        Codec<PalettedContainerRO<Holder<BiomeBase>>> codec = SerializableChunkData.a(this.h);
        for (b sectionData : this.v) {
            NBTTagCompound compoundTag1;
            NBTTagCompound sectionNBT = compoundTag1 = new NBTTagCompound();
            ChunkSection levelChunkSection = sectionData.b;
            if (levelChunkSection != null) {
                compoundTag1.a("block_states", (NBTBase)z.encodeStart((DynamicOps)DynamicOpsNBT.a, levelChunkSection.h()).getOrThrow());
                compoundTag1.a("biomes", (NBTBase)codec.encodeStart((DynamicOps)DynamicOpsNBT.a, levelChunkSection.i()).getOrThrow());
            }
            if (sectionData.c != null) {
                compoundTag1.a(f, sectionData.c.a());
            }
            if (sectionData.d != null) {
                compoundTag1.a(g, sectionData.d.a());
            }
            int blockState = ((StarlightSectionData)sectionData).starlight$getBlockLightState();
            int skyState = ((StarlightSectionData)sectionData).starlight$getSkyLightState();
            if (blockState > 0) {
                sectionNBT.a("starlight.blocklight_state", blockState);
            }
            if (skyState > 0) {
                sectionNBT.a("starlight.skylight_state", skyState);
            }
            if (compoundTag1.g()) continue;
            compoundTag1.a("Y", (byte)sectionData.a);
            listTag.add(compoundTag1);
        }
        compoundTag.a(e, listTag);
        if (this.u) {
            compoundTag.a(d, true);
        }
        NBTTagList listTag1 = new NBTTagList();
        listTag1.addAll(this.x);
        compoundTag.a("block_entities", listTag1);
        if (this.m.d() == ChunkType.a) {
            NBTTagList listTag2 = new NBTTagList();
            listTag2.addAll(this.w);
            compoundTag.a("entities", listTag2);
            if (this.q != null) {
                compoundTag.a("carving_mask", this.q);
            }
        }
        SerializableChunkData.a(compoundTag, this.s);
        compoundTag.a("PostProcessing", SerializableChunkData.a(this.t));
        NBTTagCompound compoundTag2 = new NBTTagCompound();
        this.r.forEach((types, longs) -> compoundTag2.a(types.a(), new NBTTagLongArray((long[])longs)));
        compoundTag.a(c, compoundTag2);
        compoundTag.a("structures", this.y);
        if (this.persistentDataContainer != null) {
            compoundTag.a("ChunkBukkitValues", this.persistentDataContainer);
        }
        if (this.u && !this.m.d(ChunkStatus.l)) {
            compoundTag.a(d, false);
            compoundTag.a("starlight.light_version", 9);
        }
        return compoundTag;
    }

    private static void a(NBTTagCompound tag, IChunkAccess.a ticks) {
        NBTTagList listTag = new NBTTagList();
        for (TickListChunk<Block> savedTick : ticks.a()) {
            listTag.add(savedTick.a(block -> BuiltInRegistries.e.b((Block)block).toString()));
        }
        tag.a(C, listTag);
        NBTTagList listTag1 = new NBTTagList();
        for (TickListChunk<FluidType> savedTick1 : ticks.b()) {
            listTag1.add(savedTick1.a(fluid -> BuiltInRegistries.c.b((FluidType)fluid).toString()));
        }
        tag.a(D, listTag1);
    }

    public static ChunkType a(@Nullable NBTTagCompound tag) {
        return tag != null ? ChunkStatus.a(tag.l("Status")).d() : ChunkType.a;
    }

    @Nullable
    private static Chunk.c a(WorldServer level, List<NBTTagCompound> entities, List<NBTTagCompound> blockEntities) {
        return entities.isEmpty() && blockEntities.isEmpty() ? null : chunk -> {
            if (!entities.isEmpty()) {
                level.a(EntityTypes.a(entities, (World)level, EntitySpawnReason.r));
            }
            for (NBTTagCompound compoundTag : blockEntities) {
                boolean _boolean = compoundTag.q("keepPacked");
                if (_boolean) {
                    chunk.a(compoundTag);
                    continue;
                }
                BlockPosition posFromTag = TileEntity.b(compoundTag);
                ChunkCoordIntPair chunkPos = chunk.f();
                if (posFromTag.u() >> 4 != chunkPos.h || posFromTag.w() >> 4 != chunkPos.i) {
                    A.warn("Tile entity serialized in chunk " + String.valueOf(chunkPos) + " in world '" + level.getWorld().getName() + "' positioned at " + String.valueOf(posFromTag) + " is located outside of the chunk");
                    continue;
                }
                TileEntity blockEntity = TileEntity.a(posFromTag, chunk.a_(posFromTag), compoundTag, level.K_());
                if (blockEntity == null) continue;
                chunk.a(blockEntity);
            }
        };
    }

    private static NBTTagCompound a(StructurePieceSerializationContext context, ChunkCoordIntPair pos, Map<Structure, StructureStart> structureStarts, Map<Structure, LongSet> references) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        NBTTagCompound compoundTag1 = new NBTTagCompound();
        IRegistry<Structure> registry = context.b().e(Registries.aU);
        for (Map.Entry<Structure, StructureStart> entry : structureStarts.entrySet()) {
            MinecraftKey key = registry.b(entry.getKey());
            compoundTag1.a(key.toString(), entry.getValue().a(context, pos));
        }
        compoundTag.a("starts", compoundTag1);
        NBTTagCompound compoundTag2 = new NBTTagCompound();
        for (Map.Entry<Structure, LongSet> entry1 : references.entrySet()) {
            if (entry1.getValue().isEmpty()) continue;
            MinecraftKey key1 = registry.b(entry1.getKey());
            compoundTag2.a(key1.toString(), new NBTTagLongArray(entry1.getValue()));
        }
        compoundTag.a("References", compoundTag2);
        return compoundTag;
    }

    private static Map<Structure, StructureStart> a(StructurePieceSerializationContext context, NBTTagCompound tag, long seed) {
        HashMap map = Maps.newHashMap();
        IRegistry<Structure> registry = context.b().e(Registries.aU);
        NBTTagCompound compound = tag.p("starts");
        for (String string : compound.e()) {
            MinecraftKey resourceLocation = MinecraftKey.c(string);
            Structure structure = registry.a(resourceLocation);
            if (structure == null) {
                A.error("Unknown structure start: {}", (Object)resourceLocation);
                continue;
            }
            StructureStart structureStart = StructureStart.a(context, compound.p(string), seed);
            if (structureStart == null) continue;
            NBTBase persistentBase = compound.p(string).c("StructureBukkitValues");
            if (persistentBase instanceof NBTTagCompound) {
                NBTTagCompound compoundTag = (NBTTagCompound)persistentBase;
                structureStart.persistentDataContainer.putAll(compoundTag);
            }
            map.put(structure, structureStart);
        }
        return map;
    }

    private static Map<Structure, LongSet> a(IRegistryCustom registries, ChunkCoordIntPair pos, NBTTagCompound tag) {
        HashMap map = Maps.newHashMap();
        IRegistry<Structure> registry = registries.e(Registries.aU);
        NBTTagCompound compound = tag.p("References");
        for (String string : compound.e()) {
            MinecraftKey resourceLocation = MinecraftKey.c(string);
            Structure structure = registry.a(resourceLocation);
            if (structure == null) {
                A.warn("Found reference to unknown structure '{}' in chunk {}, discarding", (Object)resourceLocation, (Object)pos);
                continue;
            }
            long[] longArray = compound.o(string);
            if (longArray.length == 0) continue;
            map.put(structure, new LongOpenHashSet(Arrays.stream(longArray).filter(l2 -> {
                ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(l2);
                if (chunkPos.a(pos) > 8) {
                    A.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", new Object[]{resourceLocation, chunkPos, pos});
                    return false;
                }
                return true;
            }).toArray()));
        }
        return map;
    }

    private static NBTTagList a(ShortList[] offsets) {
        NBTTagList listTag = new NBTTagList();
        for (ShortList list : offsets) {
            NBTTagList listTag1 = new NBTTagList();
            if (list != null) {
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    listTag1.add(NBTTagShort.a(list.getShort(i2)));
                }
            }
            listTag.add(listTag1);
        }
        return listTag;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SerializableChunkData.class, "biomeRegistry;chunkPos;minSectionY;lastUpdateTime;inhabitedTime;chunkStatus;blendingData;belowZeroRetrogen;upgradeData;carvingMask;heightmaps;packedTicks;postProcessingSections;lightCorrect;sectionData;entities;blockEntities;structureData;persistentDataContainer", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "persistentDataContainer"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SerializableChunkData.class, "biomeRegistry;chunkPos;minSectionY;lastUpdateTime;inhabitedTime;chunkStatus;blendingData;belowZeroRetrogen;upgradeData;carvingMask;heightmaps;packedTicks;postProcessingSections;lightCorrect;sectionData;entities;blockEntities;structureData;persistentDataContainer", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "persistentDataContainer"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SerializableChunkData.class, "biomeRegistry;chunkPos;minSectionY;lastUpdateTime;inhabitedTime;chunkStatus;blendingData;belowZeroRetrogen;upgradeData;carvingMask;heightmaps;packedTicks;postProcessingSections;lightCorrect;sectionData;entities;blockEntities;structureData;persistentDataContainer", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "persistentDataContainer"}, this, o2);
    }

    public IRegistry<BiomeBase> b() {
        return this.h;
    }

    public ChunkCoordIntPair c() {
        return this.i;
    }

    public int d() {
        return this.j;
    }

    public long e() {
        return this.k;
    }

    public long f() {
        return this.l;
    }

    public ChunkStatus g() {
        return this.m;
    }

    @Nullable
    public BlendingData.d h() {
        return this.n;
    }

    @Nullable
    public BelowZeroRetrogen i() {
        return this.o;
    }

    public ChunkConverter j() {
        return this.p;
    }

    @Nullable
    public long[] k() {
        return this.q;
    }

    public Map<HeightMap.Type, long[]> l() {
        return this.r;
    }

    public IChunkAccess.a m() {
        return this.s;
    }

    public ShortList[] n() {
        return this.t;
    }

    public boolean o() {
        return this.u;
    }

    public List<b> p() {
        return this.v;
    }

    public List<NBTTagCompound> q() {
        return this.w;
    }

    public List<NBTTagCompound> r() {
        return this.x;
    }

    public NBTTagCompound s() {
        return this.y;
    }

    @Nullable
    public NBTBase persistentDataContainer() {
        return this.persistentDataContainer;
    }

    public static final class b
    implements StarlightSectionData {
        private final int a;
        @Nullable
        private final ChunkSection b;
        @Nullable
        private final NibbleArray c;
        @Nullable
        private final NibbleArray d;
        private int blockLightState = -1;
        private int skyLightState = -1;

        @Override
        public final int starlight$getBlockLightState() {
            return this.blockLightState;
        }

        @Override
        public final void starlight$setBlockLightState(int state) {
            this.blockLightState = state;
        }

        @Override
        public final int starlight$getSkyLightState() {
            return this.skyLightState;
        }

        @Override
        public final void starlight$setSkyLightState(int state) {
            this.skyLightState = state;
        }

        public b(int y2, @Nullable ChunkSection chunkSection, @Nullable NibbleArray blockLight, @Nullable NibbleArray skyLight) {
            this.a = y2;
            this.b = chunkSection;
            this.c = blockLight;
            this.d = skyLight;
        }

        public int a() {
            return this.a;
        }

        @Nullable
        public ChunkSection b() {
            return this.b;
        }

        @Nullable
        public NibbleArray c() {
            return this.c;
        }

        @Nullable
        public NibbleArray d() {
            return this.d;
        }
    }

    public static class a
    extends NbtException {
        public a(String message) {
            super(message);
        }
    }
}

