/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTickList;
import net.minecraft.world.ticks.TickContainerAccess;

public class ProtoChunk
extends IChunkAccess {
    @Nullable
    private volatile LevelLightEngine n;
    private volatile ChunkStatus o = ChunkStatus.c;
    private final List<NBTTagCompound> p = Lists.newArrayList();
    @Nullable
    private CarvingMask q;
    @Nullable
    private BelowZeroRetrogen r;
    private final ProtoChunkTickList<Block> s;
    private final ProtoChunkTickList<FluidType> t;

    public ProtoChunk(ChunkCoordIntPair chunkPos, ChunkConverter upgradeData, LevelHeightAccessor levelHeightAccessor, IRegistry<BiomeBase> biomeRegistry, @Nullable BlendingData blendingData) {
        this(chunkPos, upgradeData, null, new ProtoChunkTickList<Block>(), new ProtoChunkTickList<FluidType>(), levelHeightAccessor, biomeRegistry, blendingData);
    }

    public ProtoChunk(ChunkCoordIntPair chunkPos, ChunkConverter upgradeData, @Nullable ChunkSection[] sections, ProtoChunkTickList<Block> blockTicks, ProtoChunkTickList<FluidType> liquidTicks, LevelHeightAccessor levelHeightAccessor, IRegistry<BiomeBase> biomeRegistry, @Nullable BlendingData blendingData) {
        super(chunkPos, upgradeData, levelHeightAccessor, biomeRegistry, 0L, sections, blendingData);
        this.s = blockTicks;
        this.t = liquidTicks;
    }

    @Override
    public TickContainerAccess<Block> q() {
        return this.s;
    }

    @Override
    public TickContainerAccess<FluidType> r() {
        return this.t;
    }

    @Override
    public IChunkAccess.a a(long gametime) {
        return new IChunkAccess.a(this.s.a(gametime), this.t.a(gametime));
    }

    @Override
    public final Fluid getFluidIfLoaded(BlockPosition blockposition) {
        return this.b_(blockposition);
    }

    @Override
    public final IBlockData getBlockStateIfLoaded(BlockPosition blockposition) {
        return this.a_(blockposition);
    }

    @Override
    public IBlockData a_(BlockPosition pos) {
        return this.getBlockState(pos.u(), pos.v(), pos.w());
    }

    @Override
    public IBlockData getBlockState(int x2, int y2, int z2) {
        if (this.e(y2)) {
            return Blocks.nD.m();
        }
        ChunkSection section = this.d()[this.f(y2)];
        return section.c() ? Blocks.a.m() : section.a(x2 & 0xF, y2 & 0xF, z2 & 0xF);
    }

    @Override
    public Fluid b_(BlockPosition pos) {
        int y2 = pos.v();
        if (this.e(y2)) {
            return FluidTypes.a.g();
        }
        ChunkSection section = this.b(this.f(y2));
        return section.c() ? FluidTypes.a.g() : section.b(pos.u() & 0xF, y2 & 0xF, pos.w() & 0xF);
    }

    @Override
    @Nullable
    public IBlockData a(BlockPosition pos, IBlockData state, boolean isMoving) {
        int x2 = pos.u();
        int y2 = pos.v();
        int z2 = pos.w();
        if (this.e(y2)) {
            return Blocks.nD.m();
        }
        int sectionIndex = this.f(y2);
        ChunkSection section = this.b(sectionIndex);
        boolean hasOnlyAir = section.c();
        if (hasOnlyAir && state.a(Blocks.a)) {
            return state;
        }
        int relativeBlockPosX = SectionPosition.b(x2);
        int relativeBlockPosY = SectionPosition.b(y2);
        int relativeBlockPosZ = SectionPosition.b(z2);
        IBlockData blockState = section.a(relativeBlockPosX, relativeBlockPosY, relativeBlockPosZ, state);
        if (this.o.a(ChunkStatus.k)) {
            boolean hasOnlyAir1 = section.c();
            if (hasOnlyAir1 != hasOnlyAir) {
                this.n.a(pos, hasOnlyAir1);
            }
            if (LightEngine.a(blockState, state)) {
                this.n.a(pos);
            }
        }
        EnumSet<HeightMap.Type> set = this.n().e();
        EnumSet<HeightMap.Type> set1 = null;
        for (HeightMap.Type types : set) {
            HeightMap heightmap = this.h.get(types);
            if (heightmap != null) continue;
            if (set1 == null) {
                set1 = EnumSet.noneOf(HeightMap.Type.class);
            }
            set1.add(types);
        }
        if (set1 != null) {
            HeightMap.a(this, set1);
        }
        for (HeightMap.Type typesx : set) {
            this.h.get(typesx).a(relativeBlockPosX, y2, relativeBlockPosZ, state);
        }
        return blockState;
    }

    @Override
    public void a(TileEntity blockEntity) {
        this.j.remove(blockEntity.aA_());
        this.k.put(blockEntity.aA_(), blockEntity);
    }

    @Override
    @Nullable
    public TileEntity c_(BlockPosition pos) {
        return this.k.get(pos);
    }

    public Map<BlockPosition, TileEntity> H() {
        return this.k;
    }

    public void b(NBTTagCompound tag) {
        this.p.add(tag);
    }

    @Override
    public void a(Entity entity) {
        if (!entity.bZ()) {
            NBTTagCompound compoundTag = new NBTTagCompound();
            entity.e(compoundTag);
            this.b(compoundTag);
        }
    }

    @Override
    public void a(Structure structure, StructureStart structureStart) {
        BelowZeroRetrogen belowZeroRetrogen = this.z();
        if (belowZeroRetrogen != null && structureStart.b()) {
            StructureBoundingBox boundingBox = structureStart.a();
            LevelHeightAccessor heightAccessorForGeneration = this.B();
            if (boundingBox.i() < heightAccessorForGeneration.L_() || boundingBox.l() > heightAccessorForGeneration.an()) {
                return;
            }
        }
        super.a(structure, structureStart);
    }

    public List<NBTTagCompound> I() {
        return this.p;
    }

    @Override
    public ChunkStatus n() {
        return this.o;
    }

    public void a(ChunkStatus status) {
        this.o = status;
        if (this.r != null && status.a(this.r.a())) {
            this.a((BelowZeroRetrogen)null);
        }
        this.i();
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int x2, int y2, int z2) {
        if (this.o().a(ChunkStatus.f)) {
            return super.getNoiseBiome(x2, y2, z2);
        }
        throw new IllegalStateException("Asking for biomes before we have biomes");
    }

    public static short g(BlockPosition pos) {
        int x2 = pos.u();
        int y2 = pos.v();
        int z2 = pos.w();
        int i2 = x2 & 0xF;
        int i1 = y2 & 0xF;
        int i22 = z2 & 0xF;
        return (short)(i2 | i1 << 4 | i22 << 8);
    }

    public static BlockPosition a(short packedPos, int yOffset, ChunkCoordIntPair chunkPos) {
        int blockPosCoord = SectionPosition.a(chunkPos.h, packedPos & 0xF);
        int blockPosCoord1 = SectionPosition.a(yOffset, packedPos >>> 4 & 0xF);
        int blockPosCoord2 = SectionPosition.a(chunkPos.i, packedPos >>> 8 & 0xF);
        return new BlockPosition(blockPosCoord, blockPosCoord1, blockPosCoord2);
    }

    @Override
    public void e(BlockPosition pos) {
        if (!this.s(pos)) {
            IChunkAccess.a(this.b, this.f(pos.v())).add(ProtoChunk.g(pos));
        }
    }

    @Override
    public void a(ShortList offsets, int index) {
        IChunkAccess.a(this.b, index).addAll(offsets);
    }

    public Map<BlockPosition, NBTTagCompound> J() {
        return Collections.unmodifiableMap(this.j);
    }

    @Override
    @Nullable
    public NBTTagCompound a(BlockPosition pos, HolderLookup.a registries) {
        TileEntity blockEntity = this.c_(pos);
        return blockEntity != null ? blockEntity.b(registries) : this.j.get(pos);
    }

    @Override
    public void d(BlockPosition pos) {
        this.k.remove(pos);
        this.j.remove(pos);
    }

    @Nullable
    public CarvingMask E() {
        return this.q;
    }

    public CarvingMask F() {
        if (this.q == null) {
            this.q = new CarvingMask(this.M_(), this.L_());
        }
        return this.q;
    }

    public void a(CarvingMask carvingMask) {
        this.q = carvingMask;
    }

    public void a(LevelLightEngine lightEngine) {
        this.n = lightEngine;
    }

    public void a(@Nullable BelowZeroRetrogen belowZeroRetrogen) {
        this.r = belowZeroRetrogen;
    }

    @Override
    @Nullable
    public BelowZeroRetrogen z() {
        return this.r;
    }

    private static <T> LevelChunkTicks<T> a(ProtoChunkTickList<T> ticks) {
        return new LevelChunkTicks<T>(ticks.b());
    }

    public LevelChunkTicks<Block> K() {
        return ProtoChunk.a(this.s);
    }

    public LevelChunkTicks<FluidType> L() {
        return ProtoChunk.a(this.t);
    }

    @Override
    public LevelHeightAccessor B() {
        return this.A() ? BelowZeroRetrogen.b : this;
    }
}

